/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountPopup;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExpenseAccountInfoPanel
extends AccountInfoPanel
implements ChangeListener {
    private ExpenseAccount account;
    private JTextField accountNameField;
    private JCheckBox isChildOfCheckbox;
    private AccountPopup parentAccountChoice;
    private MoneydanceGUI moneydanceGUI;
    private CurrencyModel currencyModel;
    private JComboBox currencyChoice;
    private CurrencyTable currencyTable;

    private final void childCheckboxChanged() {
        if (this.isChildOfCheckbox.isSelected()) {
            if (this.parentAccountChoice.getItemCount() <= 0) {
                this.isChildOfCheckbox.setSelected(false);
            } else {
                this.parentAccountChoice.setEnabled(true);
            }
        } else {
            this.parentAccountChoice.setEnabled(false);
        }
    }

    public void setDataFromHashtable(Hashtable hashtable) {
        if (hashtable.containsKey("account_name")) {
            this.accountNameField.setText(String.valueOf(hashtable.get("account_name")));
        }
        if (hashtable.containsKey("currency")) {
            this.currencyChoice.setSelectedItem(hashtable.get("currency"));
        }
        if (hashtable.containsKey("expense_account")) {
            this.parentAccountChoice.setSelectedAccount((Account)hashtable.get("expense_account"));
        }
        if (hashtable.containsKey("expense_parent_selected") && this.parentAccountChoice.getItemCount() > 0) {
            this.isChildOfCheckbox.setSelected("yes".equals(hashtable.get("expense_parent_selected")));
        }
    }

    public void saveDataToHashtable(Hashtable hashtable) {
        hashtable.put("account_name", this.accountNameField.getText());
        hashtable.put("currency", this.currencyChoice.getSelectedItem());
        hashtable.put("expense_account", this.parentAccountChoice.getSelectedAccount());
        hashtable.put("expense_parent_selected", this.isChildOfCheckbox.isSelected() ? "yes" : "no");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEdits() {
        try {
            this.account.setCurrencyType(((CurrencyType)this.currencyChoice.getSelectedItem()).getID());
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("chg_curr_msg1"));
            return false;
        }
        this.account.setAccountName(this.accountNameField.getText());
        if (this.isChildOfCheckbox.isSelected()) {
            this.account.setParentAccount(this.parentAccountChoice.getSelectedAccount());
        } else {
            this.account.setParentAccount(this.account.getRootAccount());
        }
        this.account.getParentAccount().sortAccounts();
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.isChildOfCheckbox) {
            this.childCheckboxChanged();
        }
    }

    public void goneAway() {
        this.parentAccountChoice.goneAway();
    }

    public ExpenseAccountInfoPanel(ExpenseAccount expenseAccount, MoneydanceGUI moneydanceGUI) {
        this.account = expenseAccount;
        this.currencyTable = this.account.getRootAccount().getCurrencyTable();
        this.moneydanceGUI = moneydanceGUI;
        this.setLayout(new GridBagLayout());
        this.accountNameField = new JTextField(this.account.getAccountName(), 15);
        this.parentAccountChoice = new AccountPopup(expenseAccount, this.moneydanceGUI);
        this.parentAccountChoice.setShowAccount(this.account, false);
        this.parentAccountChoice.setShowAccountsOfType(0, true);
        this.parentAccountChoice.setShowAccountsOfType(1, false);
        this.parentAccountChoice.setShowAccountsOfType(2, false);
        this.parentAccountChoice.setShowAccountsOfType(4, true);
        this.parentAccountChoice.setShowAccountsOfType(5, false);
        this.parentAccountChoice.setShowAccountsOfType(3, false);
        this.parentAccountChoice.setShowAccount(expenseAccount, false);
        this.isChildOfCheckbox = new JCheckBox(this.moneydanceGUI.getResources().getString("is_child_of") + ": ", false);
        this.currencyModel = new CurrencyModel(this.currencyTable);
        this.currencyChoice = new JComboBox(this.currencyModel);
        this.currencyModel.setSelectedItem(this.currencyTable.getCurrencyType(this.account.getCurrencyType()));
        if (expenseAccount.getAccountNum() < 0 || this.account.getRootAccount().getTransactionSet().getTransactionsForAccount(this.account).size() <= 0) {
            this.currencyChoice.setEnabled(true);
        } else {
            this.currencyChoice.setEnabled(false);
        }
        if (expenseAccount.getParentAccount().getAccountType() != 0) {
            this.isChildOfCheckbox.setSelected(true);
            this.parentAccountChoice.setSelectedAccount(expenseAccount.getParentAccount());
        } else {
            this.parentAccountChoice.setSelectedAccountIndex(0);
            this.parentAccountChoice.setEnabled(false);
        }
        int n = 0;
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("account_name") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.accountNameField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("currency_type") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.currencyChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.isChildOfCheckbox, AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.parentAccountChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.isChildOfCheckbox.addChangeListener(this);
        this.setSize(this.getPreferredSize());
    }
}

