/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.BasicReminder;
import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.TransactionReminder;
import com.seanreilly.apps.moneydance.view.gui.BasicReminderInfoWindow;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.ReminderListModel;
import com.seanreilly.apps.moneydance.view.gui.TxnReminderInfoWindow;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EditRemindersWindow
extends JDialog
implements ActionListener {
    private ResourceBundle resources;
    private RootAccount rootAccount;
    private MoneydanceGUI moneydanceGUI;
    private JList reminderList;
    private JButton doneButton;
    private JButton addBasicReminderButton;
    private JButton addTxnReminderButton;
    private JButton delReminderButton;
    private JButton editReminderButton;
    private ReminderListModel reminderListModel;

    public void dispose() {
        super.dispose();
        this.goneAway();
    }

    private final void goneAway() {
        this.reminderListModel.goneAway();
    }

    private final void doneButtonPressed() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private final void addBasicReminder() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 12);
        calendar.set(12, 0);
        BasicReminder basicReminder = new BasicReminder(-1L, this.resources.getString("r_new_b"), calendar.getTime().getTime(), 0L, -1L, null, 0, null, 0, false, "");
        BasicReminderInfoWindow basicReminderInfoWindow = new BasicReminderInfoWindow(this.moneydanceGUI, basicReminder, this.rootAccount.getReminderSet());
        ((Component)basicReminderInfoWindow).setVisible(true);
    }

    private final void addTxnReminder() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 12);
        calendar.set(12, 0);
        BankTransaction bankTransaction = new BankTransaction(-1L, -1, -1, 1.0, "", 0L, 0L, 0L, 0L, ' ', ' ', "", null, "");
        TransactionReminder transactionReminder = new TransactionReminder(-1L, this.resources.getString("r_new_t"), calendar.getTime().getTime(), 0L, -1L, null, 0, null, 0, false, bankTransaction);
        TxnReminderInfoWindow txnReminderInfoWindow = new TxnReminderInfoWindow(this.moneydanceGUI, transactionReminder, this.rootAccount);
        ((Component)txnReminderInfoWindow).setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void editReminder() {
        Reminder reminder = (Reminder)this.reminderList.getSelectedValue();
        if (reminder == null) {
            try {
                this.getToolkit().beep();
                return;
            }
            catch (Exception exception) {
            }
            return;
        }
        if (reminder instanceof TransactionReminder) {
            ((Component)new TxnReminderInfoWindow(this.moneydanceGUI, (TransactionReminder)reminder, this.rootAccount)).setVisible(true);
            return;
        }
        if (reminder instanceof BasicReminder) {
            ((Component)new BasicReminderInfoWindow(this.moneydanceGUI, (BasicReminder)reminder, this.rootAccount.getReminderSet())).setVisible(true);
            return;
        }
        try {
            this.getToolkit().beep();
            return;
        }
        catch (Exception exception) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void delReminder() {
        Reminder reminder = (Reminder)this.reminderList.getSelectedValue();
        if (reminder != null) {
            String string;
            String string2 = this.moneydanceGUI.getResources().getString("generic_confirm");
            if (!this.moneydanceGUI.askQuestion(string2, string = this.moneydanceGUI.getResources().getString("confirm_delete_reminder") + " " + reminder)) return;
            this.rootAccount.getReminderSet().removeReminder(reminder);
            return;
        }
        try {
            this.getToolkit().beep();
            return;
        }
        catch (Exception exception) {
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doneButton) {
            this.doneButtonPressed();
        } else if (actionEvent.getSource() == this.addBasicReminderButton) {
            this.addBasicReminder();
        } else if (actionEvent.getSource() == this.addTxnReminderButton) {
            this.addTxnReminder();
        } else if (actionEvent.getSource() == this.delReminderButton) {
            this.delReminder();
        } else if (actionEvent.getSource() == this.editReminderButton) {
            this.editReminder();
        } else if (actionEvent.getSource() == this.reminderList) {
            this.editReminder();
        }
    }

    /* synthetic */ void access$0() {
        this.editReminder();
    }

    public EditRemindersWindow(JFrame jFrame, RootAccount rootAccount, MoneydanceGUI moneydanceGUI) {
        super(jFrame, Main.getMainController().getPreferences().getResources().getString("edit_reminders_win_title"), true);
        this.rootAccount = rootAccount;
        this.moneydanceGUI = moneydanceGUI;
        this.resources = Main.getMainController().getPreferences().getResources();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(0);
        this.reminderListModel = new ReminderListModel(rootAccount.getReminderSet());
        this.reminderList = new JList(this.reminderListModel);
        this.addBasicReminderButton = new JButton(this.resources.getString("r_add_basic"));
        this.addTxnReminderButton = new JButton(this.resources.getString("r_add_txn"));
        this.delReminderButton = new JButton(this.resources.getString("r_remove"));
        this.editReminderButton = new JButton(this.resources.getString("r_edit"));
        this.doneButton = new JButton(this.resources.getString("done"));
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel3, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)new JScrollPane(this.reminderList), AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 10, true, true));
        jPanel3.add((Component)this.addBasicReminderButton, AwtUtil.getConstraints(1, n++, 0.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)this.addTxnReminderButton, AwtUtil.getConstraints(1, n++, 0.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(1, n++, 0.0f, 1.0f, 1, 1, false, false));
        jPanel3.add((Component)this.editReminderButton, AwtUtil.getConstraints(1, n++, 0.0f, 0.0f, 1, 1, true, false));
        jPanel3.add((Component)this.delReminderButton, AwtUtil.getConstraints(1, n++, 0.0f, 0.0f, 1, 1, true, false));
        jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(1, n++, 0.0f, 1.0f, 1, 1, false, false));
        jPanel3.add((Component)this.doneButton, AwtUtil.getConstraints(1, n++, 0.0f, 0.0f, 1, 1, true, false));
        this.doneButton.addActionListener(this);
        this.addBasicReminderButton.addActionListener(this);
        this.addTxnReminderButton.addActionListener(this);
        this.delReminderButton.addActionListener(this);
        this.editReminderButton.addActionListener(this);
        EditRemindersWindow editRemindersWindow = this;
        if (editRemindersWindow == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(editRemindersWindow){
            private final /* synthetic */ EditRemindersWindow this$0;

            public final void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    this.this$0.access$0();
                }
            }
            {
                this.this$0 = editRemindersWindow;
                this.constructor$0(editRemindersWindow);
            }

            public void constructor$0(EditRemindersWindow editRemindersWindow) {
            }
        };
        this.reminderList.addMouseListener(mouseAdapter);
        Dimension dimension = this.getPreferredSize();
        dimension = new Dimension(dimension.width + 60, dimension.height + 40);
        ((Component)this).setSize(dimension);
        Dimension dimension2 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
    }
}

