/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.CurrencyInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class EditCurrencyWindow
extends JDialog
implements ActionListener {
    private CurrencyInfoPanel currencyPanel;
    private ResourceBundle resources;
    private JButton okButton;
    private CurrencyTable currencyTable;
    private MoneydanceGUI moneydanceGUI;

    private final void okButtonPressed() {
        this.currencyPanel.goingAway();
        this.currencyTable.fireCurrencyTableModified();
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonPressed();
        }
    }

    public EditCurrencyWindow(JFrame jFrame, CurrencyTable currencyTable, RootAccount rootAccount, MoneydanceGUI moneydanceGUI) {
        super(jFrame, Main.getMainController().getPreferences().getResources().getString("edit_currency_win_title"), true);
        this.moneydanceGUI = moneydanceGUI;
        this.currencyTable = currencyTable;
        this.resources = Main.getMainController().getPreferences().getResources();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(jPanel);
        this.currencyPanel = new CurrencyInfoPanel(currencyTable, rootAccount, this.moneydanceGUI);
        this.okButton = new JButton(this.resources.getString("ok"));
        jPanel.add((Component)this.currencyPanel, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.okButton, AwtUtil.getConstraints(0, 2, 1.0f, 0.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 40);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation(dimension3.width / 2 - dimension2.width / 2, dimension3.height / 2 - dimension2.height / 2);
    }
}

