/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.IncomeAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.BankAccountInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.ExpenseAccountInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.IncomeAccountInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreateAccountWindow
extends JDialog
implements ActionListener,
ItemListener {
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox accountTypeChoice;
    private Account defaultParentAccount;
    private CurrencyTable currencyTable;
    private AccountInfoPanel accountPanel;
    private int currentAccountType = -1;
    private Hashtable accountData;
    private JPanel containerPanel;
    private MoneydanceGUI moneydanceGUI;
    private boolean wasCancelled = true;

    private final void accountTypeSelected() {
        int n = this.accountTypeChoice.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n == this.currentAccountType) {
            return;
        }
        this.containerPanel.removeAll();
        if (this.accountPanel != null) {
            this.accountPanel.saveDataToHashtable(this.accountData);
            this.accountPanel.goneAway();
        }
        this.accountPanel = null;
        if (n == 0) {
            this.accountPanel = new BankAccountInfoPanel(new BankAccount(this.moneydanceGUI.getResources().getString("new_account_name"), -1, this.currencyTable.getBaseType().getID(), null, null, this.defaultParentAccount.getRootAccount(), 0L), this.moneydanceGUI);
            this.containerPanel.add((Component)this.accountPanel, "Center");
        } else if (n == 1) {
            this.accountPanel = new IncomeAccountInfoPanel(new IncomeAccount(this.moneydanceGUI.getResources().getString("new_account_name"), -1, this.currencyTable.getBaseType().getID(), null, null, this.defaultParentAccount), this.moneydanceGUI);
            this.containerPanel.add((Component)this.accountPanel, "Center");
        } else if (n == 2) {
            this.accountPanel = new ExpenseAccountInfoPanel(new ExpenseAccount(this.moneydanceGUI.getResources().getString("new_account_name"), -1, this.currencyTable.getBaseType().getID(), null, null, this.defaultParentAccount), this.moneydanceGUI);
            this.containerPanel.add((Component)this.accountPanel, "Center");
        } else {
            this.containerPanel.add((Component)new JLabel("????????"), "Center");
        }
        this.accountPanel.setDataFromHashtable(this.accountData);
        this.validate();
        this.containerPanel.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (this.accountPanel != null) {
                this.accountPanel.saveEdits();
                this.accountPanel.goneAway();
            }
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.accountPanel.goneAway();
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.accountTypeChoice) {
            this.accountTypeSelected();
        }
    }

    public CreateAccountWindow(JFrame jFrame, Account account, MoneydanceGUI moneydanceGUI) {
        super((Frame)jFrame, "Create Account");
        this.currencyTable = account.getRootAccount().getCurrencyTable();
        this.moneydanceGUI = moneydanceGUI;
        this.defaultParentAccount = account;
        this.accountData = new Hashtable();
        this.containerPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.containerPanel, "Center");
        jPanel2.add((Component)jPanel3, "South");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.okButton = new JButton(this.moneydanceGUI.getResources().getString("ok"));
        this.cancelButton = new JButton(this.moneydanceGUI.getResources().getString("cancel"));
        this.accountTypeChoice = new JComboBox();
        this.accountTypeChoice.addItem(this.moneydanceGUI.getResources().getString("account_type_bank"));
        this.accountTypeChoice.addItem(this.moneydanceGUI.getResources().getString("account_type_income"));
        this.accountTypeChoice.addItem(this.moneydanceGUI.getResources().getString("account_type_expense"));
        jPanel.add(new JLabel(this.moneydanceGUI.getResources().getString("account_type") + ": "));
        jPanel.add(this.accountTypeChoice);
        jPanel3.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel3.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.accountTypeChoice.setSelectedIndex(0);
        this.accountTypeSelected();
        this.accountTypeChoice.addItemListener(this);
        ((Component)this).setSize(430, 300);
        Dimension dimension = this.getSize();
        Dimension dimension2 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension2.width / 2 - dimension.width / 2, point.y + dimension2.height / 2 - dimension.height / 2);
    }
}

