/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Common;
import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;
import javax.swing.JComponent;

public class CheckPrinter
extends JComponent {
    private static final int ADJ_BOTTOM = 0;
    private static final int ADJ_TOP = 1;
    private static final int ADJ_LEFT = 2;
    private static final int ADJ_RIGHT = 3;
    private static final int ADJ_PAYEE_X = 4;
    private static final int ADJ_PAYEE_Y = 5;
    private static final int ADJ_DATE_X = 6;
    private static final int ADJ_DATE_Y = 7;
    private static final int ADJ_MEMO_X = 8;
    private static final int ADJ_MEMO_Y = 9;
    private static final int ADJ_AMTNUM_X = 10;
    private static final int ADJ_AMTNUM_Y = 11;
    private static final int ADJ_AMTTXT_X = 12;
    private static final int ADJ_AMTTXT_Y = 13;
    private Image bufImg = null;
    private Dimension size = null;
    private MoneydanceGUI mdGUI;
    private UserPreferences prefs;
    private int checksLeftOnPage;
    private int currentCheckOnPage = 0;
    private PrintJob pj = null;
    private Graphics pageGraphics = null;
    private char dec;
    private char com;
    private int decimalPlaces;
    private boolean drawGrid = false;
    private int topMargin;
    private int bottomMargin;
    private int leftMargin;
    private int rightMargin;
    private int dateLocX;
    private int dateLocY;
    private int payeeLocX;
    private int payeeLocY;
    private int memoLocX;
    private int memoLocY;
    private int amountNumLocX;
    private int amountNumLocY;
    private int amountTextLocX;
    private int amountTextLocY;
    private int adjustingCoordinate = -1;

    public void setDrawGrid(boolean bl) {
        this.drawGrid = bl;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.bufImg = null;
        this.render();
    }

    public void setAdjustingCoord(int n) {
        this.adjustingCoordinate = n;
        this.render();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        if (this.bufImg != null) {
            graphics.drawImage(this.bufImg, 0, 0, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render() {
        if (this.bufImg == null) {
            this.size = this.getSize();
            if (this.size == null || this.size.width <= 0 || this.size.height <= 0) {
                return;
            }
            this.bufImg = this.createImage(this.size.width, this.size.height);
            if (this.bufImg == null) {
                return;
            }
        }
        this.setCoordinates();
        int n = this.topMargin * this.size.height / 1000;
        int n2 = this.bottomMargin * this.size.height / 1000;
        int n3 = this.leftMargin * this.size.width / 1000;
        int n4 = this.rightMargin * this.size.width / 1000;
        Graphics graphics = this.bufImg.getGraphics();
        try {
            graphics.setFont(new Font("SansSerif", 0, 6));
        }
        catch (Exception exception) {
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.size.width, this.size.height);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, n, this.size.width, n);
        graphics.drawLine(0, this.size.height - n2, this.size.width, this.size.height - n2);
        graphics.drawLine(n3, 0, n3, this.size.height);
        graphics.drawLine(this.size.width - n4, 0, this.size.width - n4, this.size.height);
        int n5 = this.size.height - n - n2;
        int n6 = this.size.width - n3 - n4;
        if (n5 > 0 && n6 > 0) {
            int n7 = n5 / 3;
            int n8 = n6;
            int n9 = (int)((double)(n8 * this.dateLocX) / 200.0);
            int n10 = (int)((double)(n7 * this.dateLocY) / 100.0);
            int n11 = (int)((double)(n8 * this.payeeLocX) / 200.0);
            int n12 = (int)((double)(n7 * this.payeeLocY) / 100.0);
            int n13 = (int)((double)(n8 * this.memoLocX) / 200.0);
            int n14 = (int)((double)(n7 * this.memoLocY) / 100.0);
            int n15 = (int)((double)(n8 * this.amountNumLocX) / 200.0);
            int n16 = (int)((double)(n7 * this.amountNumLocY) / 100.0);
            int n17 = (int)((double)(n8 * this.amountTextLocX) / 200.0);
            int n18 = (int)((double)(n7 * this.amountTextLocY) / 100.0);
            int n19 = 0;
            while (n19 < 3) {
                int n20 = n + n7 * n19;
                graphics.setClip(n3, n20, n8, n7);
                graphics.setColor(Color.cyan);
                graphics.fillRect(n3, n20, n6, n7);
                graphics.setColor(Color.black);
                graphics.drawRect(n3, n20, n6, n7);
                graphics.drawLine(n3 + n11, n20 + n12, n3 + n11 + 25, n20 + n12);
                graphics.drawLine(n3 + n11, n20 + n12, n3 + n11, n20 + n12 - 5);
                graphics.drawString(this.mdGUI.getResources().getString("txn_payee"), n3 + n11, n20 + n12);
                graphics.drawLine(n3 + n9, n20 + n10, n3 + n9 + 25, n20 + n10);
                graphics.drawLine(n3 + n9, n20 + n10, n3 + n9, n20 + n10 - 5);
                graphics.drawString(this.prefs.getShortDateFormatter().format(new Date()), n3 + n9, n20 + n10);
                graphics.drawLine(n3 + n17, n20 + n18, n3 + n17 + 25, n20 + n18);
                graphics.drawLine(n3 + n17, n20 + n18, n3 + n17, n20 + n18 - 5);
                graphics.drawString(this.mdGUI.getResources().convertNumberToText(1234L, this.decimalPlaces), n3 + n17, n20 + n18);
                graphics.drawLine(n3 + n15, n20 + n16, n3 + n15 + 25, n20 + n16);
                graphics.drawLine(n3 + n15, n20 + n16, n3 + n15, n20 + n16 - 5);
                graphics.drawString("**" + StringUtils.formatCurrency(1234L, false, this.dec, this.com, this.decimalPlaces), n3 + n15, n20 + n16);
                graphics.drawLine(n3 + n13, n20 + n14, n3 + n13 + 25, n20 + n14);
                graphics.drawLine(n3 + n13, n20 + n14, n3 + n13, n20 + n14 - 5);
                graphics.drawString(this.mdGUI.getResources().getString("txn_memo"), n3 + n13, n20 + n14);
                ++n19;
            }
        }
    }

    public void setCoordinates() {
        this.topMargin = this.prefs.getIntSetting("print.top-margin", 0);
        this.bottomMargin = this.prefs.getIntSetting("print.bottom-margin", 50);
        this.leftMargin = this.prefs.getIntSetting("print.left-margin", 0);
        this.rightMargin = this.prefs.getIntSetting("print.right-margin", 0);
        this.dateLocX = this.prefs.getIntSetting("print.dateloc.x", 165);
        this.dateLocY = this.prefs.getIntSetting("print.dateloc.y", 28);
        this.payeeLocX = this.prefs.getIntSetting("print.payeeloc.x", 25);
        this.payeeLocY = this.prefs.getIntSetting("print.payeeloc.y", 42);
        this.memoLocX = this.prefs.getIntSetting("print.memoloc.x", 25);
        this.memoLocY = this.prefs.getIntSetting("print.memoloc.y", 83);
        this.amountNumLocX = this.prefs.getIntSetting("print.amountnumloc.x", 165);
        this.amountNumLocY = this.prefs.getIntSetting("print.amountnumloc.y", 42);
        this.amountTextLocX = this.prefs.getIntSetting("print.amounttextloc.x", 10);
        this.amountTextLocY = this.prefs.getIntSetting("print.amounttextloc.y", 51);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initialize(int n) {
        block12: {
            File file;
            Properties properties;
            block11: {
                if (this.pageGraphics != null) {
                    this.pageGraphics.dispose();
                }
                this.pageGraphics = null;
                this.currentCheckOnPage = 0;
                properties = new Properties();
                file = Common.getDataRootDirectory();
                try {
                    if (file != null) {
                        properties.load(new FileInputStream(new File(file, "chkprnt.prp")));
                    }
                }
                catch (Exception exception) {
                    if (!Main.DEBUG) break block11;
                    exception.printStackTrace();
                }
            }
            Toolkit toolkit = this.mdGUI.getTopLevelFrame().getToolkit();
            if (toolkit == null) {
                if (Main.DEBUG) {
                    System.err.println("Cannot get toolkit!");
                }
                return false;
            }
            this.pj = toolkit.getPrintJob(this.mdGUI.getTopLevelFrame(), this.mdGUI.getResources().getString("printchk_print_hdr"), properties);
            if (this.pj == null) {
                if (Main.DEBUG) {
                    System.err.println("java.awt.PrintJob canceled or unavailable");
                }
                return false;
            }
            try {
                if (file != null) {
                    PrintWriter printWriter = new PrintWriter(new FileWriter(new File(file, "chkprnt.prp")));
                    properties.list(printWriter);
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                if (!Main.DEBUG) break block12;
                exception.printStackTrace(System.err);
            }
        }
        this.checksLeftOnPage = n;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printCheck(BankTransaction bankTransaction) {
        int n;
        Object object;
        block13: {
            if (this.pageGraphics == null) {
                this.pageGraphics = this.pj.getGraphics();
            }
            if (this.checksLeftOnPage <= 0) {
                if (this.pageGraphics != null) {
                    this.pageGraphics.dispose();
                }
                this.pageGraphics = this.pj.getGraphics();
                this.checksLeftOnPage = 3;
                this.currentCheckOnPage = 0;
            }
            try {
                int n2 = this.prefs.getIntSetting("print.default_font_size", 11);
                object = this.prefs.getSetting("print.default_font_name", "Serif");
                this.pageGraphics.setFont(new Font((String)object, 0, n2));
            }
            catch (Exception exception) {
                if (!Main.DEBUG) break block13;
                System.err.println("Warning:  unable to set font for printer");
            }
        }
        Font font = this.pageGraphics.getFont();
        object = this.pageGraphics.getFontMetrics();
        Dimension dimension = this.pj.getPageDimension();
        int n3 = this.topMargin * dimension.height / 1000;
        int n4 = this.bottomMargin * dimension.height / 1000;
        int n5 = this.leftMargin * dimension.width / 1000;
        int n6 = this.rightMargin * dimension.width / 1000;
        Dimension dimension2 = new Dimension(dimension.width - (n5 + n6), dimension.height - (n3 + n4));
        int n7 = dimension2.height / 3;
        int n8 = dimension2.width;
        int n9 = n5;
        int n10 = n3 + n7 * this.currentCheckOnPage;
        if (this.drawGrid) {
            this.pageGraphics.setColor(Color.lightGray);
            int n11 = 0;
            while (n11 < n8) {
                if (n11 > 0) {
                    this.pageGraphics.drawLine(n9 + n11, n10, n9 + n11, n10 + n7);
                }
                n11 += 10 * n8 / 200;
            }
            n = 0;
            while (n < n7) {
                if (n > 0) {
                    this.pageGraphics.drawLine(n9, n10 + n, n9 + n8, n10 + n);
                }
                n += 10 * n7 / 100;
            }
            this.pageGraphics.setColor(Color.black);
            this.pageGraphics.drawRect(n9, n10, n8, n7);
        }
        this.pageGraphics.setColor(Color.black);
        this.pageGraphics.drawString(String.valueOf(bankTransaction.getDescription()), (int)((double)(dimension2.width * this.payeeLocX) / 200.0), n10 + (int)((double)(n7 * this.payeeLocY) / 100.0));
        this.pageGraphics.drawString(this.prefs.getShortDateFormatter().format(new Date(bankTransaction.getDate())), (int)((double)(dimension2.width * this.dateLocX) / 200.0), n10 + (int)((double)(n7 * this.dateLocY) / 100.0));
        this.pageGraphics.drawString(this.mdGUI.getResources().convertNumberToText(Math.abs(bankTransaction.getAmount()), this.decimalPlaces) + "**********", (int)((double)(dimension2.width * this.amountTextLocX) / 200.0), n10 + (int)((double)(n7 * this.amountTextLocY) / 100.0));
        this.pageGraphics.drawString("**" + StringUtils.formatCurrency(Math.abs(bankTransaction.getAmount()), false, this.dec, this.com, this.decimalPlaces), (int)((double)(dimension2.width * this.amountNumLocX) / 200.0), n10 + (int)((double)(n7 * this.amountNumLocY) / 100.0));
        String string = bankTransaction.getMemo().trim();
        n = n10 + (int)((double)(n7 * this.memoLocY) / 100.0);
        int n12 = (int)((double)(dimension2.width * this.memoLocX) / 200.0);
        int n13 = ((FontMetrics)object).getMaxAscent() + ((FontMetrics)object).getMaxDescent();
        do {
            String string2;
            int n14 = string.lastIndexOf(10);
            int n15 = string.lastIndexOf(13);
            if (n14 >= 0 || n15 >= 0) {
                int n16 = n14 >= 0 && n15 >= 0 ? Math.max(n14, n15) : (n14 >= 0 ? n14 : n15);
                string2 = string.substring(n16).trim();
                string = string.substring(0, n16).trim();
            } else {
                string2 = string;
                string = "";
            }
            this.pageGraphics.drawString(string2, n12, n);
            n -= n13;
        } while (string.length() > 0);
        ++this.currentCheckOnPage;
        --this.checksLeftOnPage;
    }

    public void end() {
        if (Main.DEBUG) {
            System.err.println("ending printjob");
        }
        if (this.pageGraphics != null) {
            if (Main.DEBUG) {
                System.err.println("disposing of graphics: " + this.pageGraphics);
            }
            this.pageGraphics.dispose();
        }
        this.pj.end();
    }

    public CheckPrinter(MoneydanceGUI moneydanceGUI, CurrencyType currencyType) {
        this.mdGUI = moneydanceGUI;
        this.decimalPlaces = currencyType.getDecimalPlaces();
        this.prefs = Main.getMainController().getPreferences();
        this.dec = this.prefs.getDecimalChar();
        this.com = (char)(this.dec == '.' ? 44 : 46);
        this.setCoordinates();
        this.setPreferredSize(new Dimension(200, 300));
        this.setMinimumSize(new Dimension(200, 300));
    }
}

