/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.CheckPrinter;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalibratePrinterWindow
extends JDialog
implements ChangeListener,
ActionListener,
ItemListener {
    private JSlider topMarginSlider;
    private JSlider bottomMarginSlider;
    private JSlider leftMarginSlider;
    private JSlider rightMarginSlider;
    private JSlider dateLocXSlider;
    private JSlider dateLocYSlider;
    private JSlider payeeLocXSlider;
    private JSlider payeeLocYSlider;
    private JSlider memoLocXSlider;
    private JSlider memoLocYSlider;
    private JSlider amountNumLocXSlider;
    private JSlider amountNumLocYSlider;
    private JSlider amountTextLocXSlider;
    private JSlider amountTextLocYSlider;
    private JComboBox fontNameChoice;
    private JComboBox fontSizeChoice;
    private CheckPrinter printerPage;
    private JButton printTestButton;
    private JButton doneButton;
    private MoneydanceGUI mdGUI;
    private Account account;
    private UserPreferences prefs;

    private static final JSlider constructSlider(int n, int n2) {
        JSlider jSlider = new JSlider(n, n2);
        jSlider.setPaintTicks(true);
        jSlider.setMinorTickSpacing(10);
        return jSlider;
    }

    private final void printTestPage() {
        if (!this.printerPage.initialize(3)) {
            return;
        }
        BankTransaction bankTransaction = new BankTransaction(-1L, this.account.getAccountNum(), this.account.getAccountNum(), this.mdGUI.getResources().getString("txn_payee"), 1234567L, new Date().getTime(), new Date().getTime(), new Date().getTime(), ' ', ' ', "", null, this.mdGUI.getResources().getString("txn_memo"));
        int n = 0;
        while (n < 3) {
            this.printerPage.printCheck(bankTransaction);
            ++n;
        }
        this.printerPage.end();
    }

    private final void setFromPreferences() {
        this.fontSizeChoice.setSelectedItem(new Integer(this.prefs.getIntSetting("print.default_font_size", 11)));
        this.fontNameChoice.setSelectedItem(this.prefs.getSetting("print.default_font_name", "Serif"));
        this.topMarginSlider.setValue(this.prefs.getIntSetting("print.top-margin", 0));
        this.bottomMarginSlider.setValue(this.prefs.getIntSetting("print.bottom-margin", 50));
        this.leftMarginSlider.setValue(this.prefs.getIntSetting("print.left-margin", 0));
        this.rightMarginSlider.setValue(this.prefs.getIntSetting("print.right-margin", 0));
        this.dateLocXSlider.setValue(this.prefs.getIntSetting("print.dateloc.x", 165));
        this.dateLocYSlider.setValue(this.prefs.getIntSetting("print.dateloc.y", 28));
        this.payeeLocXSlider.setValue(this.prefs.getIntSetting("print.payeeloc.x", 25));
        this.payeeLocYSlider.setValue(this.prefs.getIntSetting("print.payeeloc.y", 42));
        this.memoLocXSlider.setValue(this.prefs.getIntSetting("print.memoloc.x", 25));
        this.memoLocYSlider.setValue(this.prefs.getIntSetting("print.memoloc.y", 83));
        this.amountNumLocXSlider.setValue(this.prefs.getIntSetting("print.amountnumloc.x", 165));
        this.amountNumLocYSlider.setValue(this.prefs.getIntSetting("print.amountnumloc.y", 42));
        this.amountTextLocXSlider.setValue(this.prefs.getIntSetting("print.amounttextloc.x", 10));
        this.amountTextLocYSlider.setValue(this.prefs.getIntSetting("print.amounttextloc.y", 51));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.printTestButton) {
            this.printTestPage();
        } else if (object == this.doneButton) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.fontNameChoice) {
            Object object = this.fontNameChoice.getSelectedItem();
            if (object == null) {
                return;
            }
            this.prefs.setSetting("print.default_font_name", String.valueOf(object));
        } else if (itemEvent.getSource() == this.fontSizeChoice) {
            Object object = this.fontSizeChoice.getSelectedItem();
            if (object == null) {
                return;
            }
            this.prefs.setSetting("print.default_font_size", String.valueOf(object));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        if (object == this.topMarginSlider) {
            userPreferences.setSetting("print.top-margin", this.topMarginSlider.getValue());
        } else if (object == this.bottomMarginSlider) {
            userPreferences.setSetting("print.bottom-margin", this.bottomMarginSlider.getValue());
        } else if (object == this.leftMarginSlider) {
            userPreferences.setSetting("print.left-margin", this.leftMarginSlider.getValue());
        } else if (object == this.rightMarginSlider) {
            userPreferences.setSetting("print.right-margin", this.rightMarginSlider.getValue());
        } else if (object == this.dateLocXSlider) {
            userPreferences.setSetting("print.dateloc.x", this.dateLocXSlider.getValue());
        } else if (object == this.dateLocYSlider) {
            userPreferences.setSetting("print.dateloc.y", this.dateLocYSlider.getValue());
        } else if (object == this.payeeLocXSlider) {
            userPreferences.setSetting("print.payeeloc.x", this.payeeLocXSlider.getValue());
        } else if (object == this.payeeLocYSlider) {
            userPreferences.setSetting("print.payeeloc.y", this.payeeLocYSlider.getValue());
        } else if (object == this.memoLocXSlider) {
            userPreferences.setSetting("print.memoloc.x", this.memoLocXSlider.getValue());
        } else if (object == this.memoLocYSlider) {
            userPreferences.setSetting("print.memoloc.y", this.memoLocYSlider.getValue());
        } else if (object == this.amountNumLocXSlider) {
            userPreferences.setSetting("print.amountnumloc.x", this.amountNumLocXSlider.getValue());
        } else if (object == this.amountNumLocYSlider) {
            userPreferences.setSetting("print.amountnumloc.y", this.amountNumLocYSlider.getValue());
        } else if (object == this.amountTextLocXSlider) {
            userPreferences.setSetting("print.amounttextloc.x", this.amountTextLocXSlider.getValue());
        } else if (object == this.amountTextLocYSlider) {
            userPreferences.setSetting("print.amounttextloc.y", this.amountTextLocYSlider.getValue());
        }
        this.printerPage.render();
        this.printerPage.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CalibratePrinterWindow(MoneydanceGUI moneydanceGUI, Account account, CurrencyType currencyType) {
        block3: {
            super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.getResources().getString("calibrate_printer_title"), true);
            this.account = account;
            this.mdGUI = moneydanceGUI;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.prefs = Main.getMainController().getPreferences();
            this.fontNameChoice = new JComboBox<String>(toolkit.getFontList());
            this.fontSizeChoice = new JComboBox();
            int n = 10;
            while (n < 40) {
                this.fontSizeChoice.addItem(new Integer(n));
                ++n;
            }
            this.printerPage = new CheckPrinter(moneydanceGUI, currencyType);
            this.printerPage.setDrawGrid(true);
            this.topMarginSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.bottomMarginSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.leftMarginSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.rightMarginSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.dateLocXSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.dateLocYSlider = CalibratePrinterWindow.constructSlider(0, 100);
            this.payeeLocXSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.payeeLocYSlider = CalibratePrinterWindow.constructSlider(0, 100);
            this.memoLocXSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.memoLocYSlider = CalibratePrinterWindow.constructSlider(0, 100);
            this.amountNumLocXSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.amountNumLocYSlider = CalibratePrinterWindow.constructSlider(0, 100);
            this.amountTextLocXSlider = CalibratePrinterWindow.constructSlider(0, 200);
            this.amountTextLocYSlider = CalibratePrinterWindow.constructSlider(0, 100);
            this.printTestButton = new JButton(moneydanceGUI.getResources().getString("print_test_check"));
            this.doneButton = new JButton(moneydanceGUI.getResources().getString("done"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            JPanel jPanel2 = new JPanel(gridBagLayout);
            jPanel2.add((Component)new JLabel(moneydanceGUI.getResources().getString("font") + ": ", 4), AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, true));
            jPanel2.add((Component)this.fontNameChoice, AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, true, true));
            jPanel2.add((Component)this.fontSizeChoice, AwtUtil.getConstraints(3, 0, 0.0f, 0.0f, 1, 1, true, true));
            jPanel2.add((Component)new JLabel("   "), AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
            jPanel2.add((Component)new JLabel("   "), AwtUtil.getConstraints(4, 1, 1.0f, 0.0f, 1, 1, true, true));
            jPanel2.add((Component)this.printerPage, AwtUtil.getConstraints(1, 2, 1.0f, 0.0f, 3, 1, true, true));
            jPanel2.add((Component)this.printTestButton, AwtUtil.getConstraints(1, 3, 1.0f, 1.0f, 3, 1, false, false));
            jPanel2.add((Component)this.doneButton, AwtUtil.getConstraints(1, 4, 1.0f, 0.0f, 3, 1, false, false));
            int n2 = 0;
            int n3 = 0;
            jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 20, false, false));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_topmarg"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.topMarginSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_botmarg"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.bottomMarginSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_leftmarg"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.leftMarginSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_rightmarg"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.rightMarginSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_datelocX"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.dateLocXSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_datelocY"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.dateLocYSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_payeelocX"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.payeeLocXSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_payeelocY"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.payeeLocYSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_memolocX"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.memoLocXSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_memolocY"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.memoLocYSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_amtnumlocX"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.amountNumLocXSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_amtnumlocY"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.amountNumLocYSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_amttextlocX"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.amountTextLocXSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(moneydanceGUI.getResources().getString("printadj_amttextlocY"), 4), AwtUtil.getConstraints(n2 + 1, n3, 0.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)this.amountTextLocYSlider, AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 0.0f, 1, 1, true, true));
            jPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(n2 + 2, n3++, 1.0f, 1.0f, 1, 1, true, true));
            this.getContentPane().add(jPanel);
            this.pack();
            Dimension dimension = this.getPreferredSize();
            ((Component)this).setSize(dimension);
            try {
                JFrame jFrame = moneydanceGUI.getTopLevelFrame();
                Dimension dimension2 = jFrame.getSize();
                Point point = jFrame.getLocation();
                ((Component)this).setLocation(point.x + dimension2.width / 2 - dimension.width / 2, point.y + dimension2.height / 2 - dimension.height / 2);
            }
            catch (Exception exception) {
                if (!Main.DEBUG) break block3;
                exception.printStackTrace(System.err);
            }
        }
        this.setFromPreferences();
        this.topMarginSlider.addChangeListener(this);
        this.bottomMarginSlider.addChangeListener(this);
        this.leftMarginSlider.addChangeListener(this);
        this.rightMarginSlider.addChangeListener(this);
        this.dateLocXSlider.addChangeListener(this);
        this.dateLocYSlider.addChangeListener(this);
        this.payeeLocXSlider.addChangeListener(this);
        this.payeeLocYSlider.addChangeListener(this);
        this.memoLocXSlider.addChangeListener(this);
        this.memoLocYSlider.addChangeListener(this);
        this.amountNumLocXSlider.addChangeListener(this);
        this.amountNumLocYSlider.addChangeListener(this);
        this.amountTextLocXSlider.addChangeListener(this);
        this.amountTextLocYSlider.addChangeListener(this);
        this.printTestButton.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.fontNameChoice.addItemListener(this);
        this.fontSizeChoice.addItemListener(this);
    }
}

