/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Calculator
extends JComponent {
    private Image bufferImg = null;
    private int pressedBtn = -1;
    private Rectangle[] buttons = null;
    private int fieldBottom = 0;
    private String currentVal = "0";
    private int numCols = 4;
    private String[] buttonLabels = new String[]{"M+", "MR", null, "C", "7", "8", "9", "X", "4", "5", "6", "/", "1", "2", "3", "+", ".", "0", "=", "-"};
    private BigDecimal lastVal = null;
    private BigDecimal memoryVal = null;
    private String currentOperation = null;
    private boolean startingNewOperation = false;

    public boolean isFocusTraversable() {
        return true;
    }

    private final int getClickedButton(Point point) {
        if (this.buttons == null) {
            return -1;
        }
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n].contains(point)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private final int getTypedButton(char c) {
        if (this.buttons == null) {
            return -1;
        }
        if (c == '*') {
            c = (char)88;
        }
        String string = String.valueOf(c).toUpperCase();
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttonLabels[n] != null && this.buttonLabels[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private final void buttonClicked(int n) {
        String string = this.buttonLabels[n];
        if (string == null) {
            return;
        }
        string = string.toUpperCase();
        char c = string.charAt(0);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.startingNewOperation) {
                    this.lastVal = new BigDecimal(this.currentVal);
                    this.currentVal = "";
                    this.startingNewOperation = false;
                }
                if (this.currentVal.startsWith("0")) {
                    this.currentVal = this.currentVal.substring(1);
                }
                this.currentVal = this.currentVal + string;
                break;
            }
            case '.': {
                if (this.currentVal.indexOf(46) >= 0) break;
                this.currentVal = this.currentVal + '.';
                break;
            }
            case 'C': {
                this.currentVal = "0";
                this.currentOperation = null;
                break;
            }
            case 'M': {
                if (string.equals("M+")) {
                    this.memoryVal = new BigDecimal(this.currentVal);
                    break;
                }
                if (!string.equals("MR")) break;
                if (this.startingNewOperation) {
                    this.lastVal = new BigDecimal(this.currentVal);
                    this.currentVal = "";
                    this.startingNewOperation = false;
                }
                if (this.memoryVal == null) {
                    this.currentVal = "0";
                    break;
                }
                this.currentVal = this.memoryVal.toString();
                break;
            }
            case '=': {
                if (this.currentOperation != null) {
                    this.currentVal = this.compute(this.lastVal, new BigDecimal(this.currentVal), this.currentOperation);
                }
                this.currentOperation = null;
                break;
            }
            default: {
                if (this.currentOperation != null) {
                    this.currentVal = this.compute(this.lastVal, new BigDecimal(this.currentVal), this.currentOperation);
                }
                this.startingNewOperation = true;
                this.currentOperation = string;
            }
        }
    }

    private final String compute(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) {
        if (string.equals("X")) {
            return bigDecimal.multiply(bigDecimal2).toString();
        }
        if (string.equals("/")) {
            return bigDecimal.divide(bigDecimal2, 10, 4).toString();
        }
        if (string.equals("+")) {
            return bigDecimal.add(bigDecimal2).toString();
        }
        if (string.equals("-")) {
            return bigDecimal.subtract(bigDecimal2).toString();
        }
        System.err.println("unknown operation: " + string);
        return "0";
    }

    private final void calcButtons(Dimension dimension) {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        Rectangle[] rectangleArray = new Rectangle[this.buttonLabels.length];
        int n = rectangleArray.length / this.numCols;
        if (rectangleArray.length % this.numCols != 0) {
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        this.fieldBottom = fontMetrics.getAscent() + fontMetrics.getDescent() + 5;
        int n4 = Math.max(10, (dimension.height - this.fieldBottom) / n);
        int n5 = Math.max(10, dimension.width / this.numCols);
        int n6 = 0;
        while (n6 < rectangleArray.length) {
            rectangleArray[n6] = new Rectangle(n3 * n5 + 2, this.fieldBottom + n2 * n4 + 2, n5 - 3, n4 - 3);
            if (++n3 == this.numCols) {
                ++n2;
                n3 = 0;
            }
            ++n6;
        }
        this.buttons = rectangleArray;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.bufferImg = null;
        this.calcButtons(this.getSize());
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.bufferImg == null) {
            Dimension dimension = this.getSize();
            this.bufferImg = this.createImage(dimension.width, dimension.height);
            this.render();
        }
        if (this.bufferImg != null) {
            graphics.drawImage(this.bufferImg, 0, 0, null);
        }
    }

    private final void render() {
        if (this.bufferImg == null) {
            return;
        }
        Graphics graphics = this.bufferImg.getGraphics();
        Dimension dimension = this.getSize();
        graphics.setColor(Color.darkGray);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, dimension.width, this.fieldBottom);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.green);
        graphics.drawString(this.currentVal, dimension.width - fontMetrics.stringWidth(this.currentVal), this.fieldBottom - fontMetrics.getDescent());
        int n = 0;
        while (n < this.buttons.length) {
            if (this.pressedBtn == n) {
                graphics.setColor(Color.blue.darker());
            } else {
                graphics.setColor(Color.blue);
            }
            graphics.fillRect(this.buttons[n].x, this.buttons[n].y, this.buttons[n].width, this.buttons[n].height);
            ++n;
        }
        graphics.setColor(Color.white);
        n = 0;
        while (n < this.buttons.length) {
            if (this.buttonLabels[n] != null) {
                graphics.drawString(String.valueOf(this.buttonLabels[n]), this.buttons[n].x + this.buttons[n].width / 2 - fontMetrics.stringWidth(this.buttonLabels[n]) / 2, this.buttons[n].y + this.buttons[n].height - (this.buttons[n].height / 2 - (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2));
            }
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 180);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 200);
    }

    /* synthetic */ int access$0(char c) {
        return this.getTypedButton(c);
    }

    /* synthetic */ int access$1() {
        return this.pressedBtn;
    }

    /* synthetic */ void access$2(int n) {
        this.pressedBtn = n;
    }

    /* synthetic */ void access$3() {
        this.render();
    }

    /* synthetic */ void access$4(int n) {
        this.buttonClicked(n);
    }

    /* synthetic */ int access$5(Point point) {
        return this.getClickedButton(point);
    }

    public Calculator() {
        Calculator calculator = this;
        if (calculator == null) {
            throw null;
        }
        this.addMouseListener(calculator.new CalcMouseListener());
        Calculator calculator2 = this;
        if (calculator2 == null) {
            throw null;
        }
        this.addKeyListener(calculator2.new CalcKeyListener());
    }

    class CalcKeyListener
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n = Calculator.this.access$0(keyEvent.getKeyChar());
            if (n < 0) {
                return;
            }
            Calculator.this.access$2(n);
            Calculator.this.access$3();
            Calculator.this.repaint();
            Calculator.this.access$4(n);
            CalcKeyListener calcKeyListener = this;
            if (calcKeyListener == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(calcKeyListener){
                private final /* synthetic */ CalcKeyListener this$0;
                private final /* synthetic */ Calculator this$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    this.this$1.access$2(-1);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                    }
                    this.this$1.access$3();
                    this.this$1.repaint();
                }
                {
                    this.this$0 = calcKeyListener;
                    this.this$1 = this.this$0.access$0();
                    this.constructor$0(calcKeyListener);
                }

                public void constructor$0(CalcKeyListener calcKeyListener) {
                }
            });
        }

        /* synthetic */ Calculator access$0() {
            return Calculator.this;
        }

        CalcKeyListener() {
        }
    }

    class CalcMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = Calculator.this.access$1();
            Calculator.this.access$2(Calculator.this.access$5(mouseEvent.getPoint()));
            if (Calculator.this.access$1() != n) {
                Calculator.this.access$3();
                Calculator.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = Calculator.this.access$5(mouseEvent.getPoint());
            if (n >= 0 && n == Calculator.this.access$1()) {
                Calculator.this.access$4(Calculator.this.access$1());
            }
            Calculator.this.access$2(-1);
            Calculator.this.access$3();
            Calculator.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Calculator.this.access$2(-1);
            Calculator.this.access$3();
            Calculator.this.repaint();
        }

        CalcMouseListener() {
        }
    }
}

