/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.COATreePanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.JFrame;

public class COAWindow
extends JFrame {
    protected COATreePanel coaPanel;
    private UserPreferences prefs;
    private boolean activeFlag = true;

    public void saveCOAFrameInfo() {
        if (this.isVisible()) {
            Dimension dimension = this.getSize();
            Point point = this.getLocation();
            if (point.x < 0 || point.y < 0 || dimension.width <= 10 || dimension.height <= 10) {
                return;
            }
            this.prefs.setSetting("gui.coa_window_w", dimension.width);
            this.prefs.setSetting("gui.coa_window_h", dimension.height);
            this.prefs.setSetting("gui.coa_window_x", point.x);
            this.prefs.setSetting("gui.coa_window_y", point.y);
            this.prefs.setSetting("gui.coa_show_all_accounts", this.coaPanel.getShowAllAccounts() ? "y" : "n");
        }
    }

    public void restoreCOAFrameInfo() {
        boolean bl = this.prefs.getSetting("gui.coa_show_all_accounts", "y").equals("y");
        this.coaPanel.setShowAllAccounts(bl);
        int n = this.prefs.getIntSetting("gui.coa_window_w", 400);
        int n2 = this.prefs.getIntSetting("gui.coa_window_h", 500);
        int n3 = this.prefs.getIntSetting("gui.coa_window_x", 10);
        int n4 = this.prefs.getIntSetting("gui.coa_window_y", 10);
        if (n3 < 0 && n4 < 0 || n <= 10 || n2 <= 10) {
            return;
        }
        ((Component)this).setLocation(n3, n4);
        ((Component)this).setSize(n, n2);
    }

    public boolean isActive() {
        return this.activeFlag;
    }

    public void goAway() {
        this.activeFlag = false;
        this.saveCOAFrameInfo();
        ((Component)this).setVisible(false);
        this.coaPanel.removeAllListeners();
        this.coaPanel.goneAway();
        this.dispose();
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.goAway();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public COAWindow(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        super(moneydanceGUI.getResources().getString("coa"));
        try {
            ((Frame)this).setIconImage(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/dollar.gif"));
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
        this.coaPanel = new COATreePanel(moneydanceGUI, rootAccount);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.coaPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.prefs = Main.getMainController().getPreferences();
    }
}

