/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountModel;
import com.seanreilly.apps.moneydance.view.gui.AccountSelectionListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTreeCellRenderer;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class COATreePanel
extends JPanel
implements ChangeListener,
TreeSelectionListener {
    private Vector listeners;
    private RootAccount rootAccount;
    private MoneydanceGUI moneydanceGUI;
    private JTree coaTree;
    private AccountModel treeModel;
    private JPanel controlPanel;
    private JCheckBox showAllAccountsCheckbox;
    private AccountTreeCellRenderer cellRenderer;
    private TreePath lastPath = null;
    private TreeSelectionModel treeSelectionModel;

    public void setSelectedAccount(Account account) {
        if (account != null) {
            this.cellRenderer.setSelectedAccountID(account.getAccountNum());
        } else {
            this.cellRenderer.setSelectedAccountID(-1);
        }
        if (account != null) {
            this.coaTree.makeVisible(new TreePath(account.getPath()));
        }
        this.coaTree.repaint();
    }

    public void goingAway() {
        this.treeModel.goingAway();
    }

    public void goneAway() {
        this.treeSelectionModel.removeTreeSelectionListener(this);
        this.showAllAccountsCheckbox.removeChangeListener(this);
        this.treeModel.goneAway();
    }

    public void addAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.addElement(accountSelectionListener);
    }

    public void removeAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.removeElement(accountSelectionListener);
    }

    public void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    public boolean getShowAllAccounts() {
        return this.showAllAccountsCheckbox.isSelected();
    }

    public void setShowAllAccounts(boolean bl) {
        this.showAllAccountsCheckbox.setSelected(bl);
        this.showAccountsChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireAccountSelected(Account account) {
        this.cellRenderer.setSelectedAccountID(account.getAccountNum());
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).accountSelected(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireEditAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).editAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireCreateAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).createAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireDeleteAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).deleteAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireGraphAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).graphAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireReportOnAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).reportOnAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    private final void showAccountsChanged() {
        TreePath treePath = this.coaTree.getSelectionPath();
        this.treeModel.setShowNonRegisterAccounts(this.showAllAccountsCheckbox.isSelected());
        if (treePath != null) {
            this.coaTree.setSelectionPath(treePath);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.showAllAccountsCheckbox) {
            this.showAccountsChanged();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == this.treeSelectionModel) {
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object == null) {
                return;
            }
            this.lastPath = treePath;
            this.coaTree.setSelectionPath(treePath);
            if (object instanceof Account) {
                this.fireAccountSelected((Account)object);
            }
        }
    }

    private final void singleRightClickOnAccount(Account account, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.moneydanceGUI.getResources().getString("new..."));
        JMenuItem jMenuItem2 = new JMenuItem(this.moneydanceGUI.getResources().getString("edit..."));
        JMenuItem jMenuItem3 = null;
        JMenuItem jMenuItem4 = null;
        JMenuItem jMenuItem5 = null;
        if (account.getAccountType() != 0) {
            jMenuItem3 = new JMenuItem(this.moneydanceGUI.getResources().getString("delete..."));
            jMenuItem4 = new JMenuItem(this.moneydanceGUI.getResources().getString("graph..."));
            jMenuItem5 = new JMenuItem(this.moneydanceGUI.getResources().getString("report..."));
        }
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        if (account.getAccountType() != 0) {
            jPopupMenu.add(jMenuItem3);
            jPopupMenu.add(jMenuItem4);
            jPopupMenu.add(jMenuItem5);
        }
        jPopupMenu.setLightWeightPopupEnabled(false);
        COATreePanel cOATreePanel = this;
        if (cOATreePanel == null) {
            throw null;
        }
        AccountPopupListener accountPopupListener = cOATreePanel.new AccountPopupListener(account, jMenuItem, jMenuItem2, jMenuItem3, jMenuItem4, jMenuItem5);
        jMenuItem2.addActionListener(accountPopupListener);
        jMenuItem.addActionListener(accountPopupListener);
        if (account.getAccountType() != 0) {
            jMenuItem3.addActionListener(accountPopupListener);
            jMenuItem4.addActionListener(accountPopupListener);
            jMenuItem5.addActionListener(accountPopupListener);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        jMenuItem.paintImmediately(jMenuItem.getVisibleRect());
        jMenuItem2.paintImmediately(jMenuItem2.getVisibleRect());
        if (account.getAccountType() != 0) {
            jMenuItem3.paintImmediately(jMenuItem3.getVisibleRect());
            jMenuItem4.paintImmediately(jMenuItem4.getVisibleRect());
            jMenuItem5.paintImmediately(jMenuItem5.getVisibleRect());
        }
        jPopupMenu.paintImmediately(jPopupMenu.getVisibleRect());
    }

    /* synthetic */ JTree access$0() {
        return this.coaTree;
    }

    /* synthetic */ void access$1(Account account, MouseEvent mouseEvent) {
        this.singleRightClickOnAccount(account, mouseEvent);
    }

    /* synthetic */ void access$2(Account account) {
        this.fireCreateAccount(account);
    }

    /* synthetic */ void access$3(Account account) {
        this.fireEditAccount(account);
    }

    /* synthetic */ void access$4(Account account) {
        this.fireDeleteAccount(account);
    }

    /* synthetic */ void access$5(Account account) {
        this.fireGraphAccount(account);
    }

    /* synthetic */ void access$6(Account account) {
        this.fireReportOnAccount(account);
    }

    public COATreePanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.setLayout(new BorderLayout());
        this.listeners = new Vector();
        this.treeModel = new AccountModel(rootAccount);
        this.coaTree = new JTree(this.treeModel);
        this.showAllAccountsCheckbox = new JCheckBox(this.moneydanceGUI.getResources().getString("show_all_accounts"), true);
        this.cellRenderer = new AccountTreeCellRenderer(this.moneydanceGUI);
        this.cellRenderer.setRealBackground(Color.white);
        this.coaTree.setCellRenderer(this.cellRenderer);
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.treeSelectionModel.setSelectionMode(1);
        this.coaTree.setSelectionModel(null);
        this.coaTree.setSelectionModel(this.treeSelectionModel);
        this.treeSelectionModel.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.coaTree, 20, 30);
        this.controlPanel = new JPanel(new FlowLayout());
        this.controlPanel.add(this.showAllAccountsCheckbox);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.controlPanel, "South");
        this.showAllAccountsCheckbox.addChangeListener(this);
        COATreePanel cOATreePanel = this;
        if (cOATreePanel == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(cOATreePanel){
            private final /* synthetic */ COATreePanel this$0;
            private boolean isPopupTrigger;

            public final void mousePressed(MouseEvent mouseEvent) {
                this.isPopupTrigger = (mouseEvent.getModifiers() & 0xC) != 0;
                int n = this.this$0.access$0().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n < 0) {
                    return;
                }
                TreePath treePath = this.this$0.access$0().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                Account account = (Account)treePath.getLastPathComponent();
                if (this.isPopupTrigger && n != -1) {
                    if (mouseEvent.getClickCount() == 1) {
                        this.this$0.access$1(account, mouseEvent);
                    } else if (mouseEvent.getClickCount() == 2) {
                        // empty if block
                    }
                }
            }
            {
                this.this$0 = cOATreePanel;
                this.isPopupTrigger = false;
                this.constructor$0(cOATreePanel);
            }

            public void constructor$0(COATreePanel cOATreePanel) {
            }
        };
        this.coaTree.addMouseListener(mouseAdapter);
        this.coaTree.setSelectionRow(-1);
        this.coaTree.setBackground(Color.white);
    }

    class AccountPopupListener
    implements ActionListener {
        private Account account;
        private JMenuItem newAccountMenuItem;
        private JMenuItem editAccountMenuItem;
        private JMenuItem deleteAccountMenuItem;
        private JMenuItem graphAccountMenuItem;
        private JMenuItem reportAccountMenuItem;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.newAccountMenuItem) {
                COATreePanel.this.access$2(this.account);
            } else if (actionEvent.getSource() == this.editAccountMenuItem) {
                COATreePanel.this.access$3(this.account);
            } else if (actionEvent.getSource() == this.deleteAccountMenuItem) {
                COATreePanel.this.access$4(this.account);
            } else if (actionEvent.getSource() == this.graphAccountMenuItem) {
                COATreePanel.this.access$5(this.account);
            } else if (actionEvent.getSource() == this.reportAccountMenuItem) {
                COATreePanel.this.access$6(this.account);
            }
        }

        public AccountPopupListener(Account account, JMenuItem jMenuItem, JMenuItem jMenuItem2, JMenuItem jMenuItem3, JMenuItem jMenuItem4, JMenuItem jMenuItem5) {
            this.account = account;
            this.newAccountMenuItem = jMenuItem;
            this.editAccountMenuItem = jMenuItem2;
            this.deleteAccountMenuItem = jMenuItem3;
            this.graphAccountMenuItem = jMenuItem4;
            this.reportAccountMenuItem = jMenuItem5;
        }
    }
}

