/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.BasicReminder;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BasicReminderNotificationWindow
extends JDialog
implements ActionListener {
    private BasicReminder reminder;
    private RootAccount rootAccount;
    private MoneydanceGUI moneydanceGUI;
    private boolean recordable = false;
    private Date eventDate;
    private JButton ackButton;
    private JButton deferButton;
    private JTextArea memoField;
    private JPanel detailPanel;

    private final void recordReminder() {
        this.reminder.setAcknowledged(this.eventDate);
        this.rootAccount.getReminderSet().reminderModified(this.reminder);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.deferButton) {
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.ackButton && this.recordable) {
            this.recordReminder();
        }
    }

    public BasicReminderNotificationWindow(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, BasicReminder basicReminder, Date date, boolean bl) {
        super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.getResources().getString("r_not_win"), true);
        this.reminder = basicReminder;
        this.rootAccount = rootAccount;
        this.moneydanceGUI = moneydanceGUI;
        this.recordable = bl;
        this.eventDate = date;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.memoField = new JTextArea(5, 45);
        this.ackButton = new JButton(moneydanceGUI.getResources().getString("r_b_ack"));
        this.deferButton = new JButton(moneydanceGUI.getResources().getString("r_b_defer"));
        if (!bl) {
            this.ackButton.setEnabled(false);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.memoField.setEditable(false);
        this.memoField.setText(this.reminder.getMemo());
        jPanel.add((Component)this.memoField, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.ackButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.deferButton, AwtUtil.getConstraints(3, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.ackButton.addActionListener(this);
        this.deferButton.addActionListener(this);
        JFrame jFrame = moneydanceGUI.getTopLevelFrame();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 20);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension3.width / 2 - dimension2.width / 2, point.y + dimension3.height / 2 - dimension2.height / 2);
    }
}

