/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountPopup;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.EditTransactionListener;
import com.seanreilly.apps.moneydance.view.gui.ExchangeRateEditor;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.SplitEditor;
import com.seanreilly.apps.moneydance.view.gui.TransactionEditor;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import com.seanreilly.awt.JDateField;
import com.seanreilly.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class BankTransactionEditor
extends TransactionEditor
implements ActionListener,
KeyListener,
FocusListener {
    public static final String DELETE_ALL_SPLITS = "delete_all_splits";
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private JDateField dateField;
    private JDateField taxableDateField;
    private AccountPopup accountChoice;
    private JTextField descriptionField;
    private JComboBox clearedStatusChoice;
    private JCurrencyField debitAmountField;
    private JCurrencyField creditAmountField;
    private JComboBox checkNumField;
    private JTextArea memoField;
    private JLabel numSplitsLabel;
    private ExchangeRateEditor rateEditor;
    private JLabel splitsLabel;
    private JLabel dateLabel;
    private JLabel taxDateLabel;
    private JLabel chkNumLabel;
    private JLabel statusLabel;
    private JLabel payeeLabel;
    private JLabel debitLabel;
    private JLabel creditLabel;
    private JLabel accountLabel;
    private JLabel memoLabel;
    private JPanel txnPanel;
    private JButton recordButton;
    private JButton cancelButton;
    private JButton deleteButton;
    private JButton splitsButton;
    private EditTransactionListener listener;
    private Account account;
    private CurrencyType currencyType;
    private CurrencyTable currencyTable;
    private Vector splits = null;
    private Vector removedSplits = null;
    private BankTransaction currentTransaction;
    private boolean inverseAccounts = false;
    private boolean adjustingAccountChoice = false;
    private AccountTransactionSet transactionSet;
    private boolean editingSplits = false;
    private boolean completing = false;
    private boolean descriptionWasCompleted = false;
    private Transaction matchedTransaction = null;

    void setTxnBackground(Color color) {
        this.txnPanel.setBackground(color);
    }

    void setLabels() {
        Object object = this.checkNumField.getSelectedItem();
        this.checkNumField.setModel(new DefaultComboBoxModel<String>(new String[]{this.moneydanceGUI.getResources().getString("chknum_dep"), this.moneydanceGUI.getResources().getString("chknum_transfer"), this.moneydanceGUI.getResources().getString("chknum_atm"), "{" + this.moneydanceGUI.getResources().getString("chknum_print") + "}", "<" + this.moneydanceGUI.getResources().getString("chknum_nextchecknum") + ">"}));
        this.checkNumField.setSelectedItem(object);
        this.clearedStatusChoice.removeAllItems();
        this.clearedStatusChoice.addItem(this.moneydanceGUI.getResources().getString("uncleared"));
        this.clearedStatusChoice.addItem(this.moneydanceGUI.getResources().getString("reconciling"));
        this.clearedStatusChoice.addItem(this.moneydanceGUI.getResources().getString("cleared"));
        this.recordButton.setLabel(this.moneydanceGUI.getResources().getString("record_txn"));
        this.cancelButton.setLabel(this.moneydanceGUI.getResources().getString("cancel_txn"));
        this.deleteButton.setLabel(this.moneydanceGUI.getResources().getString("delete_txn"));
        this.splitsButton.setLabel(this.moneydanceGUI.getResources().getString("split_txn"));
        this.dateLabel.setText(this.moneydanceGUI.getResources().getString("txn_date") + ": ");
        this.taxDateLabel.setText(this.moneydanceGUI.getResources().getString("txn_tax_date") + ": ");
        this.chkNumLabel.setText(this.moneydanceGUI.getResources().getString("txn_checknum") + ": ");
        this.statusLabel.setText(this.moneydanceGUI.getResources().getString("txn_status") + ": ");
        this.payeeLabel.setText(this.moneydanceGUI.getResources().getString("txn_payee") + ": ");
        this.debitLabel.setText(this.moneydanceGUI.getResources().getString("txn_debit") + ": ");
        this.creditLabel.setText(this.moneydanceGUI.getResources().getString("txn_credit") + ": ");
        this.accountLabel.setText(this.moneydanceGUI.getResources().getString("account") + ": ");
        this.memoLabel.setText(this.moneydanceGUI.getResources().getString("txn_memo") + ": ");
        this.splitsLabel.setText("  " + this.moneydanceGUI.getResources().getString("txn_numsplits") + ": ");
        DateFormat dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.dateField.setDateFormat(dateFormat);
        this.taxableDateField.setDateFormat(dateFormat);
        char c = Main.getMainController().getPreferences().getDecimalChar();
        char c2 = c == ',' ? (char)'.' : ',';
        this.rateEditor.setDecimalCharacter(c);
        this.debitAmountField.setDecimalCharacter(c, c2);
        this.creditAmountField.setDecimalCharacter(c, c2);
    }

    private final void synchronizeDates() {
        this.taxableDateField.setDate(this.dateField.getDate());
    }

    private final void setDateToToday(JDateField jDateField) {
        jDateField.setDate(new Date());
    }

    public Transaction getCurrentTransaction() {
        return this.currentTransaction;
    }

    public void setCurrentTransaction(Transaction transaction) {
        this.currentTransaction = (BankTransaction)transaction;
        this.inverseAccounts = this.currentTransaction.getSourceAccountId() == this.account.getAccountNum();
        this.populateFields();
    }

    public void transactionUpdated(Transaction transaction) {
        if (this.currentTransaction != null && this.currentTransaction.getId() == transaction.getId()) {
            this.setCurrentTransaction(transaction);
        }
    }

    public void goingAway() {
        if (this.currentTransaction != null && this.currentTransaction.getId() < 0L && this.descriptionField.getText().trim().length() <= 0 && String.valueOf(this.checkNumField.getSelectedItem()).trim().length() <= 0 && this.getTransactionAmount() == 0L && this.memoField.getText().trim().length() <= 0) {
            return;
        }
        if (this.transactionModified()) {
            if (Main.getMainController().getPreferences().getSetting("confirm_transaction_changes", "y").equals("y")) {
                if (this.askToSaveTransaction()) {
                    this.saveTransaction(false);
                }
            } else {
                this.saveTransaction(false);
            }
        }
    }

    public void goneAway() {
        this.accountChoice.goneAway();
    }

    private final boolean transactionModified() {
        Object object;
        Calendar calendar;
        if (this.currentTransaction == null) {
            return false;
        }
        if (this.dateField.getDate().getTime() != this.currentTransaction.getDate()) {
            calendar = Calendar.getInstance();
            object = Calendar.getInstance();
            ((Calendar)object).setTime(this.dateField.getDate());
            calendar.setTime(new Date(this.currentTransaction.getDate()));
            calendar.set(11, 12);
            calendar.set(12, 0);
            calendar.set(13, 0);
            ((Calendar)object).set(11, 12);
            ((Calendar)object).set(12, 0);
            ((Calendar)object).set(13, 0);
            if (((Calendar)object).get(1) != calendar.get(1) || ((Calendar)object).get(2) != calendar.get(2) || ((Calendar)object).get(5) != calendar.get(5)) {
                return true;
            }
        }
        if (this.taxableDateField.getDate().getTime() != this.currentTransaction.getTaxableDate()) {
            calendar = Calendar.getInstance();
            object = Calendar.getInstance();
            ((Calendar)object).setTime(this.taxableDateField.getDate());
            calendar.setTime(new Date(this.currentTransaction.getTaxableDate()));
            if (((Calendar)object).get(1) != calendar.get(1) || ((Calendar)object).get(2) != calendar.get(2) || ((Calendar)object).get(5) != calendar.get(5)) {
                return true;
            }
        }
        if (this.splits.size() != this.currentTransaction.getSplitCount()) {
            return true;
        }
        int n = 0;
        while (n < this.splits.size()) {
            object = (SplitTransaction)this.splits.elementAt(n);
            if (((Transaction)object).getId() < 0L) {
                return true;
            }
            if (((Transaction)object).isDirty()) {
                return true;
            }
            ++n;
        }
        Account account = this.accountChoice.getSelectedAccount();
        int n2 = this.currentTransaction.getAccountId(this.account.getAccountNum());
        if (account != null && n2 != account.getAccountNum() || account == null && n2 >= 0) {
            return true;
        }
        if (!this.descriptionField.getText().trim().equals(this.currentTransaction.getDescription())) {
            return true;
        }
        long l = this.currentTransaction.getAmount(this.account.getAccountNum());
        long l2 = this.getTransactionAmount();
        if (l2 != l) {
            return true;
        }
        int n3 = this.clearedStatusChoice.getSelectedIndex();
        if (n3 == 2 && this.currentTransaction.getClearedStatus(this.account.getAccountNum()) != 'X') {
            return true;
        }
        if (n3 == 1 && this.currentTransaction.getClearedStatus(this.account.getAccountNum()) != 'x') {
            return true;
        }
        if (n3 != 2 && n3 != 1 && this.currentTransaction.getClearedStatus(this.account.getAccountNum()) != ' ') {
            return true;
        }
        if (!String.valueOf(this.checkNumField.getSelectedItem()).trim().equals(this.currentTransaction.getCheckNumber())) {
            return true;
        }
        return !this.memoField.getText().trim().equals(this.currentTransaction.getMemo());
    }

    public long getTransactionAmount() {
        long l = 0L;
        l -= this.debitAmountField.getValue();
        return l += this.creditAmountField.getValue();
    }

    private final void populateFields() {
        Account account;
        int n;
        if (this.currentTransaction == null) {
            return;
        }
        CurrencyType currencyType = null;
        CurrencyType currencyType2 = this.currencyType;
        this.accountChoice.setEnabled(true);
        if (this.currentTransaction.getSplitCount() > 0) {
            this.accountChoice.setEnabled(false);
            this.accountChoice.setSelectedAccount(null);
        } else if (!this.inverseAccounts) {
            n = this.currentTransaction.getSourceAccountId();
            if (n < 0) {
                if (this.accountChoice.getItemCount() <= 0) {
                    this.account.getRootAccount().addSubAccount(new ExpenseAccount("", -1, this.currencyTable.getBaseType().getID(), null, null, this.account.getRootAccount()));
                }
                this.accountChoice.selectDefaultAccount();
            } else {
                this.accountChoice.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
            }
            account = this.accountChoice.getSelectedAccount();
            if (account != null) {
                currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
            }
        } else if (this.inverseAccounts) {
            n = this.currentTransaction.getDestAccountId();
            if (n < 0) {
                if (this.accountChoice.getItemCount() <= 0) {
                    this.account.getRootAccount().addSubAccount(new ExpenseAccount("", -1, this.currencyTable.getBaseType().getID(), null, null, this.account.getRootAccount()));
                }
                this.accountChoice.setSelectedAccountIndex(0);
            } else {
                this.accountChoice.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
            }
            account = this.accountChoice.getSelectedAccount();
            currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
        }
        if (currencyType != null) {
            this.rateEditor.setOtherCurrencyType(currencyType);
            if (this.inverseAccounts) {
                this.rateEditor.setValue(CurrencyType.getXRelativeRate(currencyType, this.currencyType, this.currentTransaction.getRate()));
            } else {
                this.rateEditor.setValue(1.0 / CurrencyType.getXRelativeRate(this.currencyType, currencyType, this.currentTransaction.getRate()));
            }
        } else {
            this.rateEditor.setOtherCurrencyType(null);
            this.rateEditor.setEnabled(false);
        }
        this.dateField.setDate(new Date(this.currentTransaction.getDate()));
        this.taxableDateField.setDate(new Date(this.currentTransaction.getTaxableDate()));
        this.descriptionField.setText(this.currentTransaction.getDescription());
        this.checkNumField.setSelectedItem(this.currentTransaction.getCheckNumber());
        this.memoField.setText(this.currentTransaction.getMemo());
        long l = this.currentTransaction.getAmount(this.account.getAccountNum());
        if (this.account.getAccountNum() != this.currentTransaction.getDestAccountId()) {
            this.splitsButton.setEnabled(false);
        } else {
            this.splitsButton.setEnabled(true);
        }
        if (l <= 0L) {
            this.debitAmountField.setValue(l * -1L);
            this.creditAmountField.setText("");
        } else {
            this.debitAmountField.setText("");
            this.creditAmountField.setValue(l);
        }
        char c = this.currentTransaction.getClearedStatus(this.account.getAccountNum());
        if (c == 'X') {
            this.clearedStatusChoice.setSelectedIndex(2);
        } else if (c == 'x') {
            this.clearedStatusChoice.setSelectedIndex(1);
        } else {
            this.clearedStatusChoice.setSelectedIndex(0);
        }
        this.clearedStatusChoice.repaint();
        this.splits = new Vector();
        this.removedSplits = new Vector();
        if (this.currentTransaction != null) {
            int n2 = 0;
            while (n2 < this.currentTransaction.getSplitCount()) {
                SplitTransaction splitTransaction = this.currentTransaction.getSplit(n2).duplicate();
                splitTransaction.resetDirty();
                this.splits.addElement(splitTransaction);
                ++n2;
            }
        }
        this.numSplitsLabel.setText("  " + this.splits.size() + "   ");
        if (this.splits.size() > 0) {
            this.debitAmountField.setEnabled(false);
            this.creditAmountField.setEnabled(false);
        } else {
            this.debitAmountField.setEnabled(true);
            this.creditAmountField.setEnabled(true);
        }
        this.accountWasSelected(this.accountChoice.getSelectedAccount(), this.currentTransaction.getId() < 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveTransaction(boolean bl) {
        CurrencyType currencyType;
        Object object;
        long l;
        block24: {
            block23: {
                int n;
                this.currentTransaction.setDate(this.dateField.getDate().getTime());
                this.currentTransaction.setTaxableDate(this.taxableDateField.getDate().getTime());
                this.currentTransaction.setDescription(this.descriptionField.getText());
                l = this.getTransactionAmount();
                int n2 = this.clearedStatusChoice.getSelectedIndex();
                if (n2 == 2) {
                    this.currentTransaction.setClearedStatus('X', this.account.getAccountNum());
                } else if (n2 == 1) {
                    this.currentTransaction.setClearedStatus('x', this.account.getAccountNum());
                } else {
                    this.currentTransaction.setClearedStatus(' ', this.account.getAccountNum());
                }
                this.currentTransaction.setCheckNumber(String.valueOf(this.checkNumField.getSelectedItem()));
                this.currentTransaction.setMemo(this.memoField.getText());
                int n3 = 0;
                while (n3 < this.removedSplits.size()) {
                    object = (SplitTransaction)this.removedSplits.elementAt(n3);
                    n = 0;
                    while (n < this.currentTransaction.getSplitCount()) {
                        if (this.currentTransaction.getSplit(n).getId() == ((Transaction)object).getId()) {
                            this.currentTransaction.removeSplit(n);
                            break;
                        }
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < this.splits.size()) {
                    object = (SplitTransaction)this.splits.elementAt(n3);
                    if (((Transaction)object).getId() < 0L) {
                        this.currentTransaction.addSplit((SplitTransaction)object);
                    } else {
                        n = 0;
                        int n4 = 0;
                        while (n4 < this.currentTransaction.getSplitCount()) {
                            SplitTransaction splitTransaction = this.currentTransaction.getSplit(n4);
                            if (splitTransaction.getId() == ((Transaction)object).getId()) {
                                splitTransaction.takeValuesFrom((SplitTransaction)object);
                                n = 1;
                                break;
                            }
                            ++n4;
                        }
                        if (n == 0) {
                            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("txn_split_error_a") + " - " + ((Transaction)object).getDescription());
                        }
                    }
                    ++n3;
                }
                currencyType = this.currencyType;
                object = null;
                if (this.currentTransaction.getSplitCount() > 0) break block23;
                Account account = this.accountChoice.getSelectedAccount();
                if (account == null) {
                    this.accountChoice.setSelectedAccountIndex(0);
                    this.accountWasSelected(this.accountChoice.getSelectedAccount(), true);
                }
                account = this.accountChoice.getSelectedAccount();
                if (this.inverseAccounts) {
                    this.currentTransaction.setDestAccountId(account.getAccountNum());
                    object = this.currencyTable.getCurrencyType(account.getCurrencyType());
                    break block24;
                } else if (this.currentTransaction.getDestAccountId() == this.account.getAccountNum()) {
                    this.currentTransaction.setSourceAccountId(account.getAccountNum());
                    object = this.currencyTable.getCurrencyType(account.getCurrencyType());
                }
                break block24;
            }
            this.currentTransaction.setSourceAccountId(-1);
            object = null;
        }
        double d = this.rateEditor.getValue();
        if (d == 0.0) {
            d = 1.0;
        }
        if (currencyType == null || object == null) {
            d = 1.0;
            this.rateEditor.setEnabled(false);
        } else {
            d = this.inverseAccounts ? CurrencyType.getXRelativeRate(this.currencyType, (CurrencyType)object, d) : CurrencyType.getXRelativeRate((CurrencyType)object, this.currencyType, 1.0 / d);
            this.rateEditor.setEnabled(true);
        }
        this.currentTransaction.setRate(d);
        this.currentTransaction.setAmount(l, this.account.getAccountNum());
        this.listener.recordTransaction(this.currentTransaction, this, this.removedSplits, bl);
        if (Main.getMainController().getPreferences().getSetting("beep_on_transaction_change", "y").equals("y")) {
            try {
                this.getToolkit().beep();
            }
            catch (Exception exception) {
            }
        }
        this.populateFields();
    }

    private final void cancelTransaction() {
        BankTransaction bankTransaction = this.currentTransaction;
        this.listener.cancelEdits(bankTransaction, this);
        this.currentTransaction = null;
    }

    private final void deleteTransaction() {
        this.listener.deleteTransaction(this.currentTransaction, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void editSplits() {
        if (this.currentTransaction == null) {
            return;
        }
        if (this.editingSplits) {
            return;
        }
        try {
            this.editingSplits = true;
            SplitEditor splitEditor = new SplitEditor(this.moneydanceGUI.getTopLevelFrame(), this.currentTransaction, this.account.getRootAccount(), this.moneydanceGUI, this.account, true);
            Vector vector = new Vector();
            Enumeration enumeration = this.splits.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            splitEditor.setSplits(vector);
            ((Component)splitEditor).setVisible(true);
            if (!splitEditor.wasCancelled()) {
                Object object;
                long l = 0L;
                Vector vector2 = splitEditor.getSplits();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (SplitTransaction)enumeration2.nextElement();
                    l += ((Transaction)object).getAmount();
                    if (this.splits.indexOf(object) >= 0) continue;
                    this.splits.addElement(object);
                }
                int n = 0;
                while (n < this.splits.size()) {
                    object = (SplitTransaction)this.splits.elementAt(n);
                    if (vector2.indexOf(object) < 0) {
                        if (((Transaction)object).getId() >= 0L) {
                            SplitTransaction splitTransaction = this.currentTransaction.getSplitById(((Transaction)object).getId());
                            if (this.removedSplits.indexOf(splitTransaction) < 0) {
                                this.removedSplits.addElement(splitTransaction);
                            }
                            this.splits.removeElement(object);
                            --n;
                        } else {
                            this.splits.removeElement(object);
                            --n;
                        }
                    }
                    ++n;
                }
                if (vector2.size() <= 0) {
                    this.accountChoice.setEnabled(true);
                    this.debitAmountField.setEnabled(true);
                    this.creditAmountField.setEnabled(true);
                    if (this.accountChoice.getSelectedAccount() == null) {
                        if (this.inverseAccounts) {
                            n = this.currentTransaction.getDestAccountId();
                            if (n >= 0) {
                                this.accountChoice.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
                            } else {
                                this.accountChoice.setSelectedAccountIndex(0);
                            }
                        } else {
                            n = this.currentTransaction.getSourceAccountId();
                            if (n >= 0) {
                                this.accountChoice.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
                            } else {
                                this.accountChoice.setSelectedAccountIndex(0);
                            }
                        }
                    }
                    this.debitAmountField.setEnabled(true);
                    this.creditAmountField.setEnabled(true);
                    Account account = this.accountChoice.getSelectedAccount();
                    if (account == null) {
                        this.accountChoice.setSelectedAccountIndex(0);
                        account = this.accountChoice.getSelectedAccount();
                    }
                    object = null;
                    if (account != null) {
                        object = this.currencyTable.getCurrencyType(account.getCurrencyType());
                    }
                    if (object == null || this.currencyType.getID().equals(((CurrencyType)object).getID())) {
                        if (object != null) {
                            this.rateEditor.setOtherCurrencyType((CurrencyType)object);
                        }
                        this.rateEditor.setEnabled(false);
                    } else {
                        this.rateEditor.setOtherCurrencyType((CurrencyType)object);
                        this.rateEditor.setEnabled(true);
                    }
                } else {
                    this.accountChoice.setEnabled(false);
                    this.accountChoice.setSelectedAccount(null);
                    this.creditAmountField.setEnabled(false);
                    this.debitAmountField.setEnabled(false);
                    this.rateEditor.setEnabled(false);
                }
                if (this.account.getAccountNum() == this.currentTransaction.getDestAccountId()) {
                    if (l <= 0L) {
                        this.debitAmountField.setValue(l * -1L);
                        this.creditAmountField.setText("");
                    } else {
                        this.debitAmountField.setText("");
                        this.creditAmountField.setValue(l);
                    }
                } else if ((l *= -1L) <= 0L) {
                    this.debitAmountField.setValue(l * -1L);
                    this.creditAmountField.setText("");
                } else {
                    this.debitAmountField.setText("");
                    this.creditAmountField.setValue(l);
                }
            }
            this.numSplitsLabel.setText("  " + this.splits.size() + "   ");
            Object var2_11 = null;
            this.editingSplits = false;
            return;
        }
        catch (Throwable throwable) {
            Object var2_12 = null;
            this.editingSplits = false;
            throw throwable;
        }
    }

    private final void deleteAllSplits() {
        Object object;
        if (Main.DEBUG) {
            System.err.println("deleting all splits");
        }
        if (this.currentTransaction == null) {
            return;
        }
        if (this.editingSplits) {
            return;
        }
        Object object2 = this.splits.elements();
        while (object2.hasMoreElements()) {
            object = (SplitTransaction)object2.nextElement();
            if (((Transaction)object).getId() < 0L) continue;
            this.removedSplits.addElement(object);
        }
        if (this.splits.size() > 0) {
            this.accountChoice.setEnabled(true);
            if (this.accountChoice.getSelectedAccount() == null) {
                if (this.inverseAccounts) {
                    int n = this.currentTransaction.getDestAccountId();
                    if (n >= 0) {
                        this.accountChoice.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
                    } else {
                        this.accountChoice.setSelectedAccountIndex(0);
                    }
                } else {
                    int n = this.currentTransaction.getSourceAccountId();
                    if (n >= 0) {
                        this.accountChoice.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
                    } else {
                        this.accountChoice.setSelectedAccountIndex(0);
                    }
                }
            }
            this.debitAmountField.setEnabled(true);
            this.creditAmountField.setEnabled(true);
            object2 = this.accountChoice.getSelectedAccount();
            if (object2 == null) {
                this.accountChoice.setSelectedAccountIndex(0);
                object2 = this.accountChoice.getSelectedAccount();
            }
            object = null;
            if (object2 != null) {
                object = this.currencyTable.getCurrencyType(((Account)object2).getCurrencyType());
            }
            if (object == null || this.currencyType.getID().equals(((CurrencyType)object).getID())) {
                if (object != null) {
                    this.rateEditor.setOtherCurrencyType((CurrencyType)object);
                }
                this.rateEditor.setEnabled(false);
            } else {
                this.rateEditor.setOtherCurrencyType((CurrencyType)object);
                this.rateEditor.setEnabled(true);
            }
        }
        this.splits.removeAllElements();
        this.numSplitsLabel.setText("  " + this.splits.size() + "   ");
    }

    private final void accountWasSelected(Account account, boolean bl) {
        Account account2 = this.accountChoice.getSelectedAccount();
        CurrencyType currencyType = null;
        if (account2 == null) {
            this.rateEditor.setEnabled(false);
            return;
        }
        currencyType = this.currencyTable.getCurrencyType(account2.getCurrencyType());
        if (currencyType.getID().equals(this.currencyType.getID())) {
            this.rateEditor.setValue(1.0);
            this.rateEditor.setOtherCurrencyType(currencyType);
            return;
        }
        this.rateEditor.setOtherCurrencyType(currencyType);
        if (bl) {
            double d = this.currencyTable.getRate(currencyType, this.currencyType);
            if (this.inverseAccounts) {
                this.rateEditor.setValue(d);
            } else {
                this.rateEditor.setValue(d);
            }
        }
    }

    private final int getIndexForId(Vector vector, long l) {
        int n = 0;
        while (n < vector.size()) {
            if (((Transaction)vector.elementAt(n)).getId() == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.recordButton) {
            if (this.currentTransaction != null) {
                this.saveTransaction(true);
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            if (this.currentTransaction != null) {
                this.cancelTransaction();
            }
        } else if (actionEvent.getSource() == this.deleteButton) {
            if (this.currentTransaction != null) {
                this.deleteTransaction();
            }
        } else if (actionEvent.getSource() == this.splitsButton) {
            BankTransactionEditor bankTransactionEditor = this;
            if (bankTransactionEditor == null) {
                throw null;
            }
            SwingUtilities.invokeLater(new Runnable(bankTransactionEditor){
                private final /* synthetic */ BankTransactionEditor this$0;

                public final void run() {
                    this.this$0.access$9();
                }
                {
                    this.this$0 = bankTransactionEditor;
                    this.constructor$0(bankTransactionEditor);
                }

                public void constructor$0(BankTransactionEditor bankTransactionEditor) {
                }
            });
        } else if (DELETE_ALL_SPLITS.equals(actionEvent.getActionCommand())) {
            this.deleteAllSplits();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void autoCompleteDescription(KeyEvent keyEvent) {
        JTextField jTextField = this.descriptionField;
        synchronized (jTextField) {
            String string = this.descriptionField.getText();
            if (string.length() < 2) return;
            if (string.length() > 12) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (c == '\t') {
                return;
            }
            this.descriptionWasCompleted = false;
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '\'' || c == '\"' || c == ' ' || c >= '0' && c <= '9' || c == '-')) {
                if (c != '&') return;
            }
            if (this.descriptionField.getCaretPosition() != string.length()) return;
            this.matchedTransaction = this.transactionSet.autoCompleteDescription(string);
            if (this.matchedTransaction == null) return;
            this.descriptionField.setText(this.matchedTransaction.getDescription());
            this.descriptionField.select(string.length(), this.descriptionField.getText().length());
            this.descriptionField.repaint();
            this.descriptionWasCompleted = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyPressed(KeyEvent keyEvent) {
        try {
            while (true) {
                if (!this.completing) {
                    return;
                }
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        Object object = keyEvent.getSource();
        if (object == this.descriptionField) {
            if (!this.completing) {
                this.completing = true;
                this.autoCompleteDescription(keyEvent);
                this.completing = false;
            } else {
                keyEvent.consume();
            }
        } else if (object == this.debitAmountField || object == this.creditAmountField) {
            this.rateEditor.refresh();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyTyped(KeyEvent keyEvent) {
        try {
            while (true) {
                if (!this.completing) {
                    return;
                }
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextComponent) {
            ((JTextComponent)focusEvent.getSource()).selectAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() != this.descriptionField) return;
        if (!this.descriptionWasCompleted) return;
        this.descriptionWasCompleted = false;
        if (this.matchedTransaction == null) return;
        boolean bl = false;
        try {
            bl = this.debitAmountField.getValue() == 0L && this.creditAmountField.getValue() == 0L && this.splits.size() == 0;
        }
        catch (Exception exception) {
        }
        if (!bl) return;
        long l = this.matchedTransaction.getAmount(this.account.getAccountNum());
        Account account = this.account.getRootAccount().getAccountById(this.matchedTransaction.getAccountId(this.account.getAccountNum()));
        this.accountChoice.setSelectedAccount(account);
        if (account != null) {
            this.accountWasSelected(account, true);
        } else {
            this.accountChoice.setEnabled(false);
            this.rateEditor.setEnabled(false);
        }
        if (l <= 0L) {
            this.debitAmountField.setValue(l * -1L);
            this.creditAmountField.setValue(0L);
        } else {
            this.debitAmountField.setValue(0L);
            this.creditAmountField.setValue(l);
        }
        if (this.matchedTransaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = BankTransactionEditor.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            BankTransaction bankTransaction = (BankTransaction)this.matchedTransaction;
            if (String.valueOf(this.checkNumField.getSelectedItem()).trim().length() <= 0) {
                String string = bankTransaction.getCheckNumber();
                if (StringUtils.stripNonNumbers(string).length() > 0) {
                    this.checkNumField.setSelectedItem(this.account.getNextCheckNumber());
                } else if (string.startsWith("{") && string.endsWith("}")) {
                    this.checkNumField.setSelectedIndex(3);
                }
            }
            this.memoField.setText(bankTransaction.getMemo());
            if (this.currentTransaction.getSplitCount() <= 0) {
                int n = 0;
                while (n < bankTransaction.getSplitCount()) {
                    SplitTransaction splitTransaction = bankTransaction.getSplit(n).duplicate();
                    splitTransaction.setId(-1L);
                    this.splits.addElement(splitTransaction);
                    ++n;
                }
            }
        }
        this.numSplitsLabel.setText("  " + this.splits.size() + "   ");
        if (this.splits.size() > 0) {
            this.debitAmountField.setEnabled(false);
            this.creditAmountField.setEnabled(false);
            return;
        }
        this.debitAmountField.setEnabled(true);
        this.creditAmountField.setEnabled(true);
    }

    public void requestFocus() {
        this.dateField.requestFocus();
    }

    /* synthetic */ JDateField access$0() {
        return this.dateField;
    }

    /* synthetic */ JDateField access$1() {
        return this.taxableDateField;
    }

    /* synthetic */ void access$2() {
        this.synchronizeDates();
    }

    /* synthetic */ void access$3(JDateField jDateField) {
        this.setDateToToday(jDateField);
    }

    /* synthetic */ BankTransaction access$4() {
        return this.currentTransaction;
    }

    /* synthetic */ JComboBox access$5() {
        return this.checkNumField;
    }

    /* synthetic */ Account access$6() {
        return this.account;
    }

    /* synthetic */ AccountPopup access$7() {
        return this.accountChoice;
    }

    /* synthetic */ void access$8(Account account, boolean bl) {
        this.accountWasSelected(account, bl);
    }

    /* synthetic */ void access$9() {
        this.editSplits();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BankTransactionEditor(MoneydanceGUI moneydanceGUI, Account account, AccountTransactionSet accountTransactionSet, EditTransactionListener editTransactionListener) {
        this.account = account;
        this.listener = editTransactionListener;
        this.moneydanceGUI = moneydanceGUI;
        this.transactionSet = accountTransactionSet;
        this.currencyTable = this.account.getRootAccount().getCurrencyTable();
        this.currencyType = this.currencyTable.getCurrencyType(this.account.getCurrencyType());
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        char c = userPreferences.getDecimalChar();
        char c2 = c == ',' ? (char)'.' : ',';
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel(gridBagLayout);
        this.txnPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel2.setOpaque(true);
        this.currentTransaction = null;
        this.dateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        this.taxableDateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        BankTransactionEditor bankTransactionEditor = this;
        if (bankTransactionEditor == null) {
            throw null;
        }
        KeyAdapter keyAdapter = new KeyAdapter(bankTransactionEditor){
            private final /* synthetic */ BankTransactionEditor this$0;

            public final void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getSource() == this.this$0.access$0() || keyEvent.getSource() == this.this$0.access$1()) {
                    if (keyEvent.getKeyCode() == 89 && (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown())) {
                        this.this$0.access$2();
                    } else if (keyEvent.getKeyCode() == 84 && (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown())) {
                        this.this$0.access$3((JDateField)keyEvent.getSource());
                    }
                }
            }
            {
                this.this$0 = bankTransactionEditor;
                this.constructor$0(bankTransactionEditor);
            }

            public void constructor$0(BankTransactionEditor bankTransactionEditor) {
            }
        };
        this.dateField.addKeyListener(keyAdapter);
        this.taxableDateField.addKeyListener(keyAdapter);
        this.accountChoice = new AccountPopup(this.account, this.moneydanceGUI, false, false);
        this.descriptionField = new JTextField(25);
        this.clearedStatusChoice = new JComboBox<String>(new String[]{" "});
        this.debitAmountField = new JCurrencyField(this.currencyType, this.currencyTable, c, c2);
        this.creditAmountField = new JCurrencyField(this.currencyType, this.currencyTable, c, c2);
        this.checkNumField = new JComboBox();
        this.checkNumField.setEditable(true);
        this.memoField = new JTextArea(3, 10);
        this.memoField.setLineWrap(true);
        this.numSplitsLabel = new JLabel("0", 2);
        this.numSplitsLabel.setVerticalAlignment(3);
        this.rateEditor = new ExchangeRateEditor(this.moneydanceGUI, this.currencyTable, this.currencyType, this);
        this.recordButton = new JButton(" ");
        this.cancelButton = new JButton(" ");
        this.deleteButton = new JButton(" ");
        this.splitsButton = new JButton(" ");
        this.dateLabel = new JLabel(" ", 4);
        this.taxDateLabel = new JLabel(" ", 4);
        this.chkNumLabel = new JLabel(" ", 4);
        this.statusLabel = new JLabel(" ", 4);
        this.payeeLabel = new JLabel(" ", 2);
        this.debitLabel = new JLabel(" ", 2);
        this.creditLabel = new JLabel(" ", 2);
        this.accountLabel = new JLabel(" ");
        this.memoLabel = new JLabel(" ", 2);
        this.splitsLabel = new JLabel(" ", 4);
        this.add((Component)this.txnPanel, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
        this.add((Component)jPanel, AwtUtil.getConstraints(1, 0, 0.0f, 1.0f, 1, 1, true, true));
        this.txnPanel.add((Component)jPanel4, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)this.dateLabel, AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)this.dateField, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)this.taxDateLabel, AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)this.taxableDateField, AwtUtil.getConstraints(1, 2, 1.0f, 0.0f, 1, 1, true, true));
        this.txnPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        this.txnPanel.add((Component)jPanel3, AwtUtil.getConstraints(2, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)this.chkNumLabel, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)this.checkNumField, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)this.statusLabel, AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)this.clearedStatusChoice, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        this.txnPanel.add((Component)jPanel5, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 3, 1, true, true));
        jPanel5.add((Component)this.payeeLabel, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 2, 1, true, true));
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2));
        jPanel6.setOpaque(false);
        jPanel6.add(this.debitLabel);
        jPanel6.add(this.creditLabel);
        jPanel5.add((Component)jPanel6, AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 2, 1, true, true));
        jPanel5.add((Component)this.descriptionField, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 2, 1, true, true));
        jPanel6 = new JPanel(new GridLayout(1, 2));
        jPanel6.setOpaque(false);
        jPanel6.add(this.debitAmountField);
        jPanel6.add(this.creditAmountField);
        jPanel5.add((Component)jPanel6, AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 2, 1, true, true));
        jPanel5.add((Component)this.accountLabel, AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)this.accountChoice, AwtUtil.getConstraints(1, 2, 1.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)this.rateEditor, AwtUtil.getConstraints(2, 2, 0.0f, 0.0f, 2, 2, true, true));
        jPanel5.add((Component)this.memoLabel, AwtUtil.getConstraints(0, 3, 0.0f, 0.0f, 1, 1, true, true));
        JPanel jPanel7 = new JPanel(gridBagLayout);
        this.txnPanel.add((Component)jPanel7, AwtUtil.getConstraints(0, 4, 1.0f, 1.0f, 3, 1, true, true));
        JScrollPane jScrollPane = new JScrollPane(this.memoField);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel7.add((Component)jScrollPane, AwtUtil.getConstraints(0, 0, 1.0f, 2.0f, 1, 2, true, true));
        this.splitsLabel.setVerticalAlignment(3);
        jPanel7.add((Component)this.splitsLabel, AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel7.add((Component)this.numSplitsLabel, AwtUtil.getConstraints(3, 0, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.recordButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.deleteButton, AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(0, 3, 0.0f, 1.0f, 1, 1, false, false));
        jPanel.add((Component)this.splitsButton, AwtUtil.getConstraints(0, 4, 0.0f, 0.0f, 1, 1, true, true));
        this.txnPanel.setBackground(Color.cyan);
        this.rateEditor.setOpaque(false);
        jPanel3.setOpaque(false);
        jPanel4.setOpaque(false);
        jPanel2.setOpaque(false);
        jPanel5.setOpaque(false);
        jPanel7.setOpaque(false);
        this.recordButton.addActionListener(this);
        this.recordButton.setMnemonic('r');
        this.recordButton.registerKeyboardAction(this, "record_transaction", KeyStroke.getKeyStroke(82, 2), 2);
        this.cancelButton.addActionListener(this);
        this.cancelButton.registerKeyboardAction(this, "cancel_transaction", KeyStroke.getKeyStroke(27, 2), 2);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setMnemonic('d');
        this.deleteButton.registerKeyboardAction(this, "delete_transaction", KeyStroke.getKeyStroke(68, 2), 2);
        this.splitsButton.addActionListener(this);
        this.splitsButton.setMnemonic(76);
        this.splitsButton.registerKeyboardAction(this, "edit_transaction_splits", KeyStroke.getKeyStroke(76, 2), 2);
        this.descriptionField.addKeyListener(this);
        this.descriptionField.addFocusListener(this);
        this.debitAmountField.addKeyListener(this);
        this.creditAmountField.addKeyListener(this);
        this.checkNumField.addFocusListener(this);
        this.memoField.addFocusListener(this);
        BankTransactionEditor bankTransactionEditor2 = this;
        if (bankTransactionEditor2 == null) {
            throw null;
        }
        this.dateField.addFocusListener(new FocusAdapter(bankTransactionEditor2){
            private final /* synthetic */ BankTransactionEditor this$0;

            public final void focusLost(FocusEvent focusEvent) {
                if (this.this$0.access$4() != null && this.this$0.access$4().getId() < 0L) {
                    this.this$0.access$1().setDate(this.this$0.access$0().getDate());
                }
            }
            {
                this.this$0 = bankTransactionEditor;
                this.constructor$0(bankTransactionEditor);
            }

            public void constructor$0(BankTransactionEditor bankTransactionEditor) {
            }
        });
        BankTransactionEditor bankTransactionEditor3 = this;
        if (bankTransactionEditor3 == null) {
            throw null;
        }
        this.checkNumField.addItemListener(new ItemListener(bankTransactionEditor3){
            private final /* synthetic */ BankTransactionEditor this$0;

            public final void itemStateChanged(ItemEvent itemEvent) {
                String string = String.valueOf(this.this$0.access$5().getSelectedItem());
                if (string.startsWith("<") && string.endsWith(">")) {
                    this.this$0.access$5().setSelectedItem(this.this$0.access$6().getNextCheckNumber());
                }
            }
            {
                this.this$0 = bankTransactionEditor;
                this.constructor$0(bankTransactionEditor);
            }

            public void constructor$0(BankTransactionEditor bankTransactionEditor) {
            }
        });
        BankTransactionEditor bankTransactionEditor4 = this;
        if (bankTransactionEditor4 == null) {
            throw null;
        }
        this.accountChoice.addAccountSelectionListener(new ItemListener(bankTransactionEditor4){
            private final /* synthetic */ BankTransactionEditor this$0;

            public final void itemStateChanged(ItemEvent itemEvent) {
                this.this$0.access$8(this.this$0.access$7().getSelectedAccount(), true);
            }
            {
                this.this$0 = bankTransactionEditor;
                this.constructor$0(bankTransactionEditor);
            }

            public void constructor$0(BankTransactionEditor bankTransactionEditor) {
            }
        });
    }
}

