/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountPopup;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BankAccountInfoPanel
extends AccountInfoPanel
implements ChangeListener,
ItemListener {
    private BankAccount account;
    private JTextField accountNameField;
    private JTextField accountNumberField;
    private JTextField accountBankNameField;
    private JCurrencyField startBalanceField;
    private JCheckBox isChildOfCheckbox;
    private AccountPopup parentAccountChoice;
    private JComboBox currencyChoice;
    private CurrencyModel currencyModel;
    private MoneydanceGUI moneydanceGUI;
    private CurrencyTable currencyTable;
    private char dec;
    private char com;

    private final void childCheckboxChanged() {
        if (this.isChildOfCheckbox.isSelected()) {
            if (this.parentAccountChoice.getItemCount() <= 0) {
                this.isChildOfCheckbox.setSelected(false);
            } else {
                this.parentAccountChoice.setEnabled(true);
            }
        } else {
            this.parentAccountChoice.setEnabled(false);
        }
    }

    public void setDataFromHashtable(Hashtable hashtable) {
        if (hashtable.containsKey("account_name")) {
            this.accountNameField.setText(String.valueOf(hashtable.get("account_name")));
        }
        if (hashtable.containsKey("account_num")) {
            this.accountNumberField.setText(String.valueOf(hashtable.get("account_num")));
        }
        if (hashtable.containsKey("bank_name")) {
            this.accountBankNameField.setText(String.valueOf(hashtable.get("bank_name")));
        }
        if (hashtable.containsKey("currency")) {
            this.currencyChoice.setSelectedItem(hashtable.get("currency"));
        }
        if (hashtable.containsKey("start_bal")) {
            this.startBalanceField.setText(String.valueOf(hashtable.get("start_bal")));
        }
        if (hashtable.containsKey("bank_account")) {
            this.parentAccountChoice.setSelectedItem(hashtable.get("bank_account"));
        }
        if (hashtable.containsKey("bank_parent_selected") && this.parentAccountChoice.getItemCount() > 0) {
            this.isChildOfCheckbox.setSelected("yes".equals(hashtable.get("bank_parent_selected")));
        }
        this.updateCurrencySetting();
    }

    public void saveDataToHashtable(Hashtable hashtable) {
        hashtable.put("account_name", this.accountNameField.getText());
        hashtable.put("account_num", this.accountNumberField.getText());
        hashtable.put("bank_name", this.accountBankNameField.getText());
        hashtable.put("currency", this.currencyChoice.getSelectedItem());
        hashtable.put("bank_account", this.parentAccountChoice.getSelectedItem());
        hashtable.put("bank_parent_selected", this.isChildOfCheckbox.isSelected() ? "yes" : "no");
        hashtable.put("start_bal", this.startBalanceField.getText());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEdits() {
        try {
            this.account.setCurrencyType(((CurrencyType)this.currencyChoice.getSelectedItem()).getID());
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("chg_curr_msg1"));
            return false;
        }
        this.account.setAccountName(this.accountNameField.getText());
        this.account.setBankAccountNumber(this.accountNumberField.getText());
        this.account.setBankName(this.accountBankNameField.getText());
        this.account.setStartBalance(this.startBalanceField.getValue());
        if (this.isChildOfCheckbox.isSelected()) {
            this.account.setParentAccount((Account)this.parentAccountChoice.getSelectedItem());
        } else {
            this.account.setParentAccount(this.account.getRootAccount());
        }
        this.account.getParentAccount().sortAccounts();
        return true;
    }

    private final void updateCurrencySetting() {
        this.startBalanceField.setCurrencyType((CurrencyType)this.currencyChoice.getSelectedItem());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.currencyChoice) {
            this.updateCurrencySetting();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.isChildOfCheckbox) {
            this.childCheckboxChanged();
        }
    }

    public void goneAway() {
        this.parentAccountChoice.goneAway();
    }

    public BankAccountInfoPanel(BankAccount bankAccount, MoneydanceGUI moneydanceGUI) {
        this.moneydanceGUI = moneydanceGUI;
        this.account = bankAccount;
        this.currencyTable = this.account.getRootAccount().getCurrencyTable();
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.setLayout(new GridBagLayout());
        this.accountNameField = new JTextField(this.account.getAccountName(), 15);
        this.accountNumberField = new JTextField(this.account.getBankAccountNumber(), 15);
        this.accountBankNameField = new JTextField(this.account.getBankName(), 15);
        this.parentAccountChoice = new AccountPopup(this.account, this.moneydanceGUI);
        this.parentAccountChoice.setShowAccountsOfType(0, true);
        this.parentAccountChoice.setShowAccountsOfType(1, true);
        this.parentAccountChoice.setShowAccountsOfType(2, false);
        this.parentAccountChoice.setShowAccountsOfType(4, false);
        this.parentAccountChoice.setShowAccountsOfType(5, false);
        this.parentAccountChoice.setShowAccountsOfType(3, false);
        this.parentAccountChoice.setShowAccount(bankAccount, false);
        this.isChildOfCheckbox = new JCheckBox(this.moneydanceGUI.getResources().getString("is_child_of") + ": ", false);
        this.currencyModel = new CurrencyModel(this.currencyTable);
        this.currencyChoice = new JComboBox(this.currencyModel);
        this.currencyModel.setSelectedItem(this.currencyTable.getCurrencyType(this.account.getCurrencyType()));
        if (bankAccount.getAccountNum() < 0 || this.account.getRootAccount().getTransactionSet().getTransactionsForAccount(this.account).size() <= 0) {
            this.currencyChoice.setEnabled(true);
        } else {
            this.currencyChoice.setEnabled(false);
        }
        this.startBalanceField = new JCurrencyField((CurrencyType)this.currencyModel.getSelectedItem(), this.currencyTable, this.dec, this.com);
        this.startBalanceField.setValue(this.account.getStartBalance());
        if (bankAccount.getParentAccount().getAccountType() != 0) {
            this.isChildOfCheckbox.setSelected(true);
            this.parentAccountChoice.setSelectedItem(bankAccount.getParentAccount());
        } else {
            if (this.parentAccountChoice.getItemCount() > 0) {
                this.parentAccountChoice.setSelectedIndex(0);
            }
            this.parentAccountChoice.setEnabled(false);
        }
        int n = 0;
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("account_name") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.accountNameField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("bank_name") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.accountBankNameField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("account_number") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.accountNumberField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("start_bal") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.startBalanceField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.getResources().getString("currency_type") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.currencyChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.isChildOfCheckbox, AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.parentAccountChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.isChildOfCheckbox.addChangeListener(this);
        this.currencyChoice.addItemListener(this);
        this.setSize(this.getPreferredSize());
    }
}

