/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.PreferencesListener;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionListener;
import com.seanreilly.apps.moneydance.view.gui.AccountDetailInterface;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.BankTransactionEditor;
import com.seanreilly.apps.moneydance.view.gui.EditTransactionListener;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.PreReconcilerWindow;
import com.seanreilly.apps.moneydance.view.gui.PrintChecksWindow;
import com.seanreilly.apps.moneydance.view.gui.ReconcilerWindow;
import com.seanreilly.apps.moneydance.view.gui.TransactionEditor;
import com.seanreilly.apps.moneydance.view.gui.TransactionRenderer;
import com.seanreilly.apps.moneydance.view.gui.TransactionSortListener;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BankAccountDetailPanel
extends JPanel
implements AccountDetailInterface,
AccountInfoListener,
ItemListener,
ListSelectionListener,
EditTransactionListener,
TransactionListener,
PreferencesListener,
ActionListener,
TransactionSortListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction;
    private Account account;
    private CurrencyType currencyType;
    private MoneydanceGUI moneydanceGUI;
    private JLabel balanceLabel;
    private JLabel clearedBalanceLabel;
    private JLabel sortByLabel;
    private JLabel cBalLabel;
    private JLabel uBalLabel;
    private JComboBox sortByChoice;
    private AccountTransactionSet transactionSet;
    private JList transactionList;
    private JScrollPane listScroll;
    private TransactionRenderer txnRenderer;
    private BankTransactionEditor bankTransactionEditor;
    private TransactionEditor transactionEditor = null;
    private boolean editorIsVisible = false;
    private JPanel editorPanel;
    private JButton newTransactionButton;
    private JButton reconcileButton;
    private JButton printChecksButton;
    private JLabel accountNameLabel;
    private int centMult;
    private int numDecimals;
    private boolean isRightClick = false;
    private ReconcilerWindow reconcilerWindow = null;
    private UserPreferences prefs;
    private JCheckBox twoLineCheckbox;
    private long lastRecordedDate = new Date().getTime();
    private RootAccount rootAccount;
    private Transaction recordingTransaction = null;

    public void preferencesUpdated() {
        this.setLabels();
        this.txnRenderer.setColor1(new Color(this.prefs.getIntSetting("gui.txn_list_color1", 0xFFFFFF)));
        this.txnRenderer.setColor2(new Color(this.prefs.getIntSetting("gui.txn_list_color2", 0x65FFFF)));
        this.bankTransactionEditor.setTxnBackground(new Color(this.prefs.getIntSetting("gui.txn_edit_bg", 0x65FFFF)));
        this.txnRenderer.setShowFullAccountPath(this.prefs.getSetting("show_full_account_path", "n").equals("y"));
        this.transactionList.repaint();
    }

    private final void setLabels() {
        int n = this.sortByChoice.getSelectedIndex();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{this.moneydanceGUI.getResources().getString("sortby_date"), this.moneydanceGUI.getResources().getString("sortby_date_entered"), this.moneydanceGUI.getResources().getString("sortby_description"), this.moneydanceGUI.getResources().getString("sortby_amount"), this.moneydanceGUI.getResources().getString("sortby_status"), this.moneydanceGUI.getResources().getString("sortby_account"), this.moneydanceGUI.getResources().getString("sortby_date_status"), this.moneydanceGUI.getResources().getString("sortby_date_amount"), this.moneydanceGUI.getResources().getString("sortby_date_check#"), this.moneydanceGUI.getResources().getString("sortby_check#")});
        this.sortByChoice.setModel(defaultComboBoxModel);
        this.sortByChoice.setSelectedIndex(Math.max(n, 0));
        String string = this.moneydanceGUI.getResources().getString("acct_type" + this.account.getAccountType());
        this.accountNameLabel.setText(string + "; " + this.moneydanceGUI.getResources().getString("currency") + ": " + this.currencyType.getName());
        this.twoLineCheckbox.setLabel(this.moneydanceGUI.getResources().getString("show_two_lines"));
        this.sortByLabel.setText(this.moneydanceGUI.getResources().getString("sort_by") + ": ");
        this.uBalLabel.setText(this.moneydanceGUI.getResources().getString("balance") + ":   ");
        this.cBalLabel.setText(this.moneydanceGUI.getResources().getString("cleared_balance") + ":   ");
        this.newTransactionButton.setLabel(this.moneydanceGUI.getResources().getString("new_transaction"));
        this.printChecksButton.setLabel(this.moneydanceGUI.getResources().getString("print_checks"));
        this.reconcileButton.setLabel(this.moneydanceGUI.getResources().getString("reconcile"));
        this.bankTransactionEditor.setLabels();
        this.txnRenderer.setLabels();
        this.validate();
        this.transactionList.repaint();
    }

    public Account getAccount() {
        return this.account;
    }

    public void goingAway() {
        if (this.transactionEditor != null) {
            this.transactionEditor.goingAway();
        }
        if (this.transactionEditor != this.bankTransactionEditor) {
            this.bankTransactionEditor.goingAway();
        }
    }

    public void goneAway() {
        this.prefs.setSetting("gui.transaction_sort_order", this.sortByChoice.getSelectedIndex());
        this.transactionSet.removeAccountInfoListener(this);
        this.sortByChoice.removeItemListener(this);
        this.transactionList.removeListSelectionListener(this);
        if (this.reconcilerWindow != null) {
            this.reconcilerWindow.cancelReconciling();
        }
        this.transactionSet.disconnect();
        this.bankTransactionEditor.goneAway();
        this.rootAccount.getTransactionSet().removeTransactionListener(this);
        this.prefs.removeListener(this);
    }

    public void accountInfoUpdated(Object object) {
        if (object == this.transactionSet) {
            char c = this.prefs.getDecimalChar();
            char c2 = c == ',' ? (char)'.' : ',';
            this.balanceLabel.setText(this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.transactionSet.getCurrentBalance(), true, c, c2, this.numDecimals, this.centMult) + ' ' + this.currencyType.getSuffix());
            this.clearedBalanceLabel.setText(this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.transactionSet.getClearedBalance(), true, c, c2, this.numDecimals, this.centMult) + ' ' + this.currencyType.getSuffix());
            this.validate();
        }
    }

    private final void setTwoLineDisplay() {
        boolean bl;
        int n = this.transactionList.getSelectedIndex();
        boolean bl2 = bl = n >= this.transactionList.getFirstVisibleIndex() && n <= this.transactionList.getLastVisibleIndex();
        if (this.twoLineCheckbox.isSelected()) {
            this.txnRenderer.setDisplayTwoLines(true);
            this.prefs.setSetting("gui.two_line_transactions", "y");
            this.transactionList.setPrototypeCellValue(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, this.lastRecordedDate, new Date().getTime(), this.lastRecordedDate, ' ', ' ', "", null, ""));
            if (bl) {
                this.transactionList.ensureIndexIsVisible(n);
            }
        } else {
            this.txnRenderer.setDisplayTwoLines(false);
            this.prefs.setSetting("gui.two_line_transactions", "n");
            this.transactionList.setPrototypeCellValue(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, this.lastRecordedDate, new Date().getTime(), this.lastRecordedDate, ' ', ' ', "", null, ""));
            if (bl) {
                this.transactionList.ensureIndexIsVisible(n);
            }
        }
        this.listScroll.setColumnHeaderView(this.txnRenderer.getHeaderRenderer(this.transactionList));
    }

    public void setSortKey(int n) {
        this.sortTransactions(n);
    }

    private final void sortTransactions(int n) {
        Object e = this.transactionList.getSelectedValue();
        this.transactionSet.sortTransactions(n);
        this.transactionList.setSelectedValue(e, true);
        this.sortByChoice.setSelectedIndex(n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.sortByChoice) {
            if (itemEvent.getStateChange() == 1) {
                int n = this.sortByChoice.getSelectedIndex();
                this.sortTransactions(n);
                this.txnRenderer.setSortField(n);
            }
        } else if (itemEvent.getSource() == this.twoLineCheckbox) {
            this.setTwoLineDisplay();
        }
    }

    public void setCurrentTransaction(Transaction transaction) {
        if (transaction == null) {
            this.editorPanel.removeAll();
            this.transactionEditor = null;
            this.transactionList.setSelectedIndices(new int[0]);
            this.validate();
            this.transactionList.requestFocus();
            return;
        }
        if (this.transactionEditor == null) {
            if (transaction.getClass() != (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
                if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.SplitTransaction")))) {
                    this.moneydanceGUI.showInfoMessage(this.moneydanceGUI.getResources().getString("cant_edit_splits"));
                    return;
                }
                this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("unknown_txn_type") + ": " + transaction.getClass());
                return;
            }
            this.transactionEditor = this.bankTransactionEditor;
            this.transactionEditor.setCurrentTransaction(transaction);
            this.editorPanel.removeAll();
            this.editorPanel.add((Component)this.transactionEditor, "Center");
            this.validate();
            this.transactionList.setSelectedValue(transaction, true);
        } else if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            Transaction transaction2 = this.transactionEditor.getCurrentTransaction();
            if (transaction2 == null || transaction2.getId() != transaction.getId() || transaction.getId() < 0L) {
                this.transactionEditor.goingAway();
            }
            if (this.transactionEditor != this.bankTransactionEditor) {
                this.transactionEditor = this.bankTransactionEditor;
                this.editorPanel.removeAll();
                this.editorPanel.add((Component)this.transactionEditor, "Center");
                this.editorPanel.repaint();
            }
            this.transactionEditor.setCurrentTransaction(transaction);
            this.transactionList.setSelectedValue(transaction, true);
        } else {
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.SplitTransaction")))) {
                this.transactionEditor.goingAway();
                this.transactionEditor = null;
                this.moneydanceGUI.showInfoMessage(this.moneydanceGUI.getResources().getString("cant_edit_splits"));
                this.editorPanel.removeAll();
                this.validate();
                return;
            }
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("unknown_txn_type") + ": " + transaction.getClass());
            return;
        }
    }

    private final void transactionSelected() {
        Transaction transaction = (Transaction)this.transactionList.getSelectedValue();
        this.setCurrentTransaction(transaction);
    }

    public void recordTransaction(Transaction transaction, TransactionEditor transactionEditor, Vector vector, boolean bl) {
        this.lastRecordedDate = transaction.getDate();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.transactionSet.recordDeletedTransaction((SplitTransaction)enumeration.nextElement());
        }
        this.recordingTransaction = transaction;
        this.transactionSet.recordModifiedTransaction(transaction);
        int n = this.transactionSet.getTransactionIndex(transaction);
        this.recordingTransaction = null;
        if (bl) {
            if (this.prefs.getSetting("gui.new_txn_on_record", "y").equals("y")) {
                BankAccountDetailPanel bankAccountDetailPanel = this;
                if (bankAccountDetailPanel == null) {
                    throw null;
                }
                SwingUtilities.invokeLater(new Runnable(bankAccountDetailPanel){
                    private final /* synthetic */ BankAccountDetailPanel this$0;

                    public final void run() {
                        this.this$0.createNewTransaction();
                    }
                    {
                        this.this$0 = bankAccountDetailPanel;
                        this.constructor$0(bankAccountDetailPanel);
                    }

                    public void constructor$0(BankAccountDetailPanel bankAccountDetailPanel) {
                    }
                });
            } else {
                BankAccountDetailPanel bankAccountDetailPanel = this;
                if (bankAccountDetailPanel == null) {
                    throw null;
                }
                SwingUtilities.invokeLater(new Runnable(bankAccountDetailPanel){
                    private final /* synthetic */ BankAccountDetailPanel this$0;

                    public final void run() {
                        this.this$0.setCurrentTransaction(null);
                    }
                    {
                        this.this$0 = bankAccountDetailPanel;
                        this.constructor$0(bankAccountDetailPanel);
                    }

                    public void constructor$0(BankAccountDetailPanel bankAccountDetailPanel) {
                    }
                });
            }
        }
        if (n >= 0 && this.prefs.getSetting("gui.register_follows_txns", "y").equals("y")) {
            BankAccountDetailPanel bankAccountDetailPanel = this;
            if (bankAccountDetailPanel == null) {
                throw null;
            }
            SwingUtilities.invokeLater(bankAccountDetailPanel.new SelIdxRunnable(n));
        }
        this.transactionList.repaint();
    }

    public void deleteTransaction(Transaction transaction, TransactionEditor transactionEditor) {
        if (transaction.getId() >= 0L) {
            this.transactionSet.recordDeletedTransaction(transaction);
        }
        BankAccountDetailPanel bankAccountDetailPanel = this;
        if (bankAccountDetailPanel == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(bankAccountDetailPanel){
            private final /* synthetic */ BankAccountDetailPanel this$0;

            public final void run() {
                this.this$0.setCurrentTransaction(null);
                this.this$0.access$0().setSelectedIndices(new int[0]);
            }
            {
                this.this$0 = bankAccountDetailPanel;
                this.constructor$0(bankAccountDetailPanel);
            }

            public void constructor$0(BankAccountDetailPanel bankAccountDetailPanel) {
            }
        });
    }

    public void cancelEdits(Transaction transaction, TransactionEditor transactionEditor) {
        BankAccountDetailPanel bankAccountDetailPanel = this;
        if (bankAccountDetailPanel == null) {
            throw null;
        }
        SwingUtilities.invokeLater(new Runnable(bankAccountDetailPanel){
            private final /* synthetic */ BankAccountDetailPanel this$0;

            public final void run() {
                this.this$0.setCurrentTransaction(null);
                this.this$0.access$0().setSelectedIndices(new int[0]);
                this.this$0.access$0().requestFocus();
            }
            {
                this.this$0 = bankAccountDetailPanel;
                this.constructor$0(bankAccountDetailPanel);
            }

            public void constructor$0(BankAccountDetailPanel bankAccountDetailPanel) {
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newTransactionButton) {
            this.createNewTransaction();
        } else if (actionEvent.getSource() == this.reconcileButton) {
            this.reconcileAccount();
        } else if (actionEvent.getSource() == this.printChecksButton) {
            this.printChecks();
        }
    }

    public void createNewTransaction() {
        this.transactionList.setSelectedIndices(new int[0]);
        this.setCurrentTransaction(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, this.lastRecordedDate, new Date().getTime(), this.lastRecordedDate, ' ', ' ', "", null, ""));
        this.transactionEditor.requestFocus();
    }

    public void requestFocus() {
        super.requestFocus();
        this.sortByChoice.requestFocus();
    }

    private final void printChecks() {
        this.setCurrentTransaction(null);
        Vector<Transaction> vector = new Vector<Transaction>();
        Object object = this.transactionSet.getAllTransactions();
        while (object.hasMoreElements()) {
            Transaction transaction = (Transaction)object.nextElement();
            if (!transaction.needsToBePrinted()) continue;
            vector.addElement(transaction);
        }
        if (vector.size() <= 0) {
            this.moneydanceGUI.showInfoMessage(this.moneydanceGUI.getResources().getString("no_checks_to_print"));
            return;
        }
        object = new PrintChecksWindow(this.moneydanceGUI, this.account, vector);
        ((Component)object).setVisible(true);
        this.repaint();
    }

    private final void reconcileAccount() {
        if (this.reconcilerWindow != null && this.reconcilerWindow.isActive()) {
            this.reconcilerWindow.toFront();
        } else {
            this.reconcilerWindow = null;
            PreReconcilerWindow preReconcilerWindow = new PreReconcilerWindow(this.moneydanceGUI, this.account, this.transactionSet.getClearedBalance());
            ((Component)preReconcilerWindow).setVisible(true);
            if (preReconcilerWindow.wasCancelled()) {
                return;
            }
            long l = preReconcilerWindow.getEndBalance();
            this.reconcilerWindow = new ReconcilerWindow(this.moneydanceGUI, this.account, l, this);
            ((Component)this.reconcilerWindow).setVisible(true);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.transactionList && !listSelectionEvent.getValueIsAdjusting()) {
            this.transactionSelected();
        }
    }

    public void transactionRemoved(Transaction transaction) {
        if (this.transactionEditor != null) {
            Transaction transaction2 = this.transactionEditor.getCurrentTransaction();
            if (transaction != this.recordingTransaction && transaction2 != null && transaction2.getId() == transaction.getId()) {
                this.setCurrentTransaction(null);
                this.transactionList.setSelectedIndices(new int[0]);
            }
        }
    }

    public void transactionAdded(Transaction transaction) {
        this.transactionModified(transaction);
    }

    public void transactionModified(Transaction transaction) {
        if (this.transactionEditor != null) {
            this.transactionEditor.transactionUpdated(transaction);
        }
    }

    /* synthetic */ JList access$0() {
        return this.transactionList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BankAccountDetailPanel(MoneydanceGUI moneydanceGUI, Account account) {
        this.moneydanceGUI = moneydanceGUI;
        this.account = account;
        this.rootAccount = account.getRootAccount();
        this.currencyType = this.rootAccount.getCurrencyTable().getCurrencyType(account.getCurrencyType());
        this.numDecimals = this.currencyType.getDecimalPlaces();
        this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
        this.prefs = Main.getMainController().getPreferences();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        int n = 2;
        int n2 = 0;
        this.editorPanel = new JPanel(new BorderLayout());
        this.newTransactionButton = new JButton(" ");
        this.newTransactionButton.setMargin(new Insets(n2, n, n2, n));
        this.reconcileButton = new JButton(" ");
        this.reconcileButton.setMargin(new Insets(n2, n, n2, n));
        this.printChecksButton = new JButton(" ");
        this.printChecksButton.setMargin(new Insets(n2, n, n2, n));
        this.balanceLabel = new JLabel("?", 4);
        this.clearedBalanceLabel = new JLabel("?", 4);
        this.sortByLabel = new JLabel(" ", 4);
        this.sortByChoice = new JComboBox();
        int n3 = this.prefs.getIntSetting("gui.transaction_sort_order", 0);
        this.transactionSet = new AccountTransactionSet(account, n3);
        this.setLayout(gridBagLayout);
        this.twoLineCheckbox = new JCheckBox(" ", this.prefs.getSetting("gui.two_line_transactions", "n").equals("y"));
        this.transactionList = new JList(this.transactionSet);
        this.txnRenderer = new TransactionRenderer(account, this.moneydanceGUI, this.twoLineCheckbox.isSelected(), false, "gui.txn_column_widths", this);
        this.transactionList.setCellRenderer(this.txnRenderer);
        this.transactionList.setSelectionMode(0);
        this.accountNameLabel = new JLabel(" ", 2);
        this.uBalLabel = new JLabel(" ", 4);
        this.cBalLabel = new JLabel(" ", 4);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        int n4 = 0;
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.sortByLabel, AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.sortByChoice, AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, false, false));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.accountNameLabel, AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 1.0f, 0.0f, 1, 1, true, true));
        n4 = 0;
        jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel3.add((Component)this.newTransactionButton, AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, false, false));
        jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
        if (account.isRegisterAccount()) {
            jPanel3.add((Component)this.reconcileButton, AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, false, false));
            jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
            jPanel3.add((Component)this.printChecksButton, AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, false, false));
            jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, true, true));
        }
        jPanel3.add((Component)this.twoLineCheckbox, AwtUtil.getConstraints(n4++, 0, 0.0f, 0.0f, 1, 1, false, false));
        jPanel3.add((Component)new JLabel(" "), AwtUtil.getConstraints(n4++, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)jPanel2, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.uBalLabel, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.balanceLabel, AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)jPanel3, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.cBalLabel, AwtUtil.getConstraints(1, 1, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.clearedBalanceLabel, AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 1, 1, true, false));
        this.listScroll = new JScrollPane(this.transactionList);
        this.listScroll.setColumnHeaderView(this.txnRenderer.getHeaderRenderer(this.transactionList));
        this.add((Component)this.listScroll, AwtUtil.getConstraints(0, 4, 1.0f, 1.0f, 12, 1, true, true));
        this.add((Component)this.editorPanel, AwtUtil.getConstraints(0, 5, 1.0f, 0.0f, 12, 1, true, true));
        this.bankTransactionEditor = new BankTransactionEditor(this.moneydanceGUI, account, this.transactionSet, this);
        this.transactionSet.addAccountInfoListener(this);
        this.transactionList.addListSelectionListener(this);
        this.twoLineCheckbox.addItemListener(this);
        this.accountInfoUpdated(this.transactionSet);
        this.newTransactionButton.addActionListener(this);
        this.printChecksButton.addActionListener(this);
        this.newTransactionButton.setMnemonic('n');
        this.newTransactionButton.registerKeyboardAction(this, "new_transaction", KeyStroke.getKeyStroke(78, 2), 2);
        this.reconcileButton.addActionListener(this);
        account.getRootAccount().getTransactionSet().addTransactionListener(this);
        this.preferencesUpdated();
        try {
            this.sortByChoice.setSelectedIndex(n3);
        }
        catch (Exception exception) {
        }
        this.sortByChoice.addItemListener(this);
        this.prefs.addListener(this);
        this.transactionList.ensureIndexIsVisible(this.transactionSet.getSize() - 1);
    }

    private class SelIdxRunnable
    implements Runnable {
        int idx;

        public void run() {
            BankAccountDetailPanel.this.access$0().ensureIndexIsVisible(this.idx);
        }

        SelIdxRunnable(int n) {
            this.idx = n;
        }
    }
}

