/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class AccountTreeCellRenderer
extends JLabel
implements TreeCellRenderer,
ListCellRenderer {
    private static ImageIcon defaultIcon = null;
    private static ImageIcon registerIcon = null;
    private static ImageIcon investmentIcon = null;
    private static int preferredHeight = 5;
    private int selectedAccountID = -1;
    private MoneydanceGUI moneydanceGUI;
    private boolean isListItem = false;
    private boolean isSelected = false;
    private boolean hasFocus = false;
    private Account account = null;
    private String text;
    private Color background = Color.gray;
    private Color foreground = Color.black;

    public void setRealBackground(Color color) {
        this.background = color;
        super.setBackground(color);
    }

    public void setRealForeground(Color color) {
        this.foreground = color;
        super.setForeground(color);
    }

    public void setSelectedAccountID(int n) {
        this.selectedAccountID = n;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, preferredHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, preferredHeight);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        ImageIcon imageIcon = defaultIcon;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.account != null && this.account.isRegisterAccount()) {
            imageIcon = this.account.getAccountType() == 2 ? investmentIcon : registerIcon;
        }
        int n = 0;
        if (this.account != null) {
            n = this.isListItem ? 10 * this.account.getDepth() : 0;
        }
        Image image = imageIcon.getImage();
        Dimension dimension = this.getSize();
        int n2 = (dimension.height - image.getHeight(null)) / 2;
        int n3 = fontMetrics.getMaxAscent();
        int n4 = dimension.height / 2 + n3 / 2;
        if (this.background == null) {
            this.background = this.getBackground();
        }
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.drawImage(image, n, n2, null, null);
        if (this.isSelected) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(this.foreground);
        }
        graphics.drawString(this.text, n + image.getWidth(null) + 5, n4);
        if (this.hasFocus) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.isListItem = true;
        this.account = (Account)object;
        this.isSelected = bl;
        this.text = this.account != null ? this.account.getAccountName() + " (" + this.moneydanceGUI.getResources().getString("acct_type" + this.account.getAccountType() + 's') + ")" : "";
        return this;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.isListItem = false;
        this.account = (Account)object;
        this.isSelected = this.account.getAccountNum() == this.selectedAccountID;
        this.hasFocus = bl4;
        this.text = this.account != null ? this.account.getAccountName() + " (" + this.moneydanceGUI.getResources().getString("acct_type" + this.account.getAccountType() + 's') + ")" : "";
        return this;
    }

    public AccountTreeCellRenderer(MoneydanceGUI moneydanceGUI) {
        this.moneydanceGUI = moneydanceGUI;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            registerIcon = new ImageIcon(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/md_tree_account_icon.gif"));
            investmentIcon = new ImageIcon(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/md_tree_invaccount_icon.gif"));
            defaultIcon = new ImageIcon(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/md_tree_uneditable_account_icon.gif"));
            preferredHeight = registerIcon.getIconHeight();
            if (investmentIcon.getIconHeight() > preferredHeight) {
                preferredHeight = investmentIcon.getIconHeight();
            }
            if (defaultIcon.getIconHeight() <= preferredHeight) return;
            preferredHeight = defaultIcon.getIconHeight();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

