/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.AccountUtil;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionListener;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class AccountTransactionSet
extends AbstractListModel
implements TransactionListener,
AccountListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private Account account;
    private RootAccount rootAccount;
    private int accountID;
    private Vector currentTransactions;
    private Vector accountInfoListeners;
    private Vector tableListeners;
    private int sortedBy = 0;
    private long balance = 0L;
    private long currentBalance = 0L;
    private long clearedBalance = 0L;
    private long reconcilingBalance = 0L;
    private String[] tableColumnNames;
    private boolean showReconciled = true;
    private boolean showDebits = true;
    private boolean showCredits = true;
    private long oldStartBalance = -1L;

    public void disconnect() {
        this.rootAccount.getTransactionSet().removeTransactionListener(this);
        this.account.removeAccountListener(this);
    }

    private final boolean isTransactionVisible(Transaction transaction) {
        if (!this.account.containsTransaction(transaction, false, true)) {
            return false;
        }
        if (!this.showCredits && transaction.getAmount(this.accountID) > 0L) {
            return false;
        }
        if (!this.showDebits && transaction.getAmount(this.accountID) <= 0L) {
            return false;
        }
        return this.showReconciled || transaction.getClearedStatus(this.accountID) != 'X';
    }

    public Enumeration getAllTransactions() {
        return this.currentTransactions.elements();
    }

    public synchronized void sortTransactions(int n) {
        this.sortedBy = n;
        AccountUtil.sortTransactions(this.currentTransactions, this.sortedBy, this.accountID, this.rootAccount);
        this.recalcBalances();
        this.fireContentsChanged(this, 0, this.currentTransactions.size() - 1);
    }

    public int getSize() {
        return this.currentTransactions.size();
    }

    public long getBalance() {
        return this.balance;
    }

    public long getCurrentBalance() {
        return this.currentBalance;
    }

    public long getClearedBalance() {
        return this.clearedBalance;
    }

    public long getReconcilingBalance() {
        return this.reconcilingBalance;
    }

    public int getTransactionCount() {
        return this.currentTransactions.size();
    }

    public void recordModifiedTransaction(Transaction transaction) {
        this.rootAccount.getTransactionSet().transactionModified(transaction);
    }

    public void recordDeletedTransaction(Transaction transaction) {
        this.rootAccount.getTransactionSet().removeTransaction(transaction);
    }

    public void addAccountInfoListener(AccountInfoListener accountInfoListener) {
        this.accountInfoListeners.addElement(accountInfoListener);
    }

    public void removeAccountInfoListener(AccountInfoListener accountInfoListener) {
        this.accountInfoListeners.removeElement(accountInfoListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireInfoUpdated() {
        Enumeration enumeration = this.accountInfoListeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountInfoListener)enumeration.nextElement()).accountInfoUpdated(this);
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void recalcBalances() {
        long l;
        long l2 = l = this.account.getStartBalance();
        long l3 = l;
        long l4 = l;
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 58);
        calendar.set(11, 23);
        long l5 = calendar.getTime().getTime();
        Enumeration enumeration = this.currentTransactions.elements();
        while (enumeration.hasMoreElements()) {
            Transaction transaction = (Transaction)enumeration.nextElement();
            char c = transaction.getClearedStatus(this.accountID);
            long l6 = transaction.getAmount(this.accountID, l);
            if (c == 'x') {
                l4 += l6;
            } else if (c == 'X') {
                l4 += l6;
                l3 += l6;
            }
            if (transaction.getDate() <= l5) {
                l2 += l6;
            }
            l += l6;
        }
        this.balance = l;
        this.currentBalance = l2;
        this.clearedBalance = l3;
        this.reconcilingBalance = l4;
        this.fireInfoUpdated();
    }

    public void accountModified(Account account) {
        if (this.oldStartBalance == -1L || this.account.getStartBalance() != this.oldStartBalance) {
            this.recalcBalances();
        }
        this.oldStartBalance = this.account.getStartBalance();
    }

    public synchronized void transactionRemoved(Transaction transaction) {
        int n = this.currentTransactions.indexOf(transaction);
        if (n >= 0) {
            this.removeTransactionAt(n);
        }
    }

    public synchronized void transactionAdded(Transaction transaction) {
        if (this.isTransactionVisible(transaction)) {
            this.insertTransaction(transaction, -1);
            this.recalcBalances();
        }
    }

    public void transactionModified(Transaction transaction) {
        int n = this.currentTransactions.indexOf(transaction);
        if (!this.isTransactionVisible(transaction)) {
            if (n >= 0) {
                this.removeTransactionAt(n);
            }
        } else {
            this.insertTransaction(transaction, n);
            this.recalcBalances();
        }
    }

    public Transaction autoCompleteDescription(String string) {
        int n = this.currentTransactions.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            Transaction transaction = (Transaction)this.currentTransactions.elementAt(n2);
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : AccountTransactionSet.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && transaction.getDescription().startsWith(string)) {
                return transaction;
            }
            --n2;
        }
        return null;
    }

    private final void insertTransaction(Transaction transaction, int n) {
        if (n < 0) {
            this.insertSortedTransaction(transaction);
            this.fireContentsChanged(this, 0, this.currentTransactions.size());
        } else if (!AccountUtil.isTransactionSorted(n, transaction, this.currentTransactions, this.accountID, this.sortedBy, this.rootAccount)) {
            this.removeTransactionAt(n);
            this.insertSortedTransaction(transaction);
        }
        this.recalcBalances();
    }

    private final synchronized void insertSortedTransaction(Transaction transaction) {
        int n = AccountUtil.insertSortedTransaction(this.currentTransactions, transaction, this.sortedBy, this.accountID, this.rootAccount);
        this.fireIntervalAdded(this, n, n);
    }

    private final void removeTransactionAt(int n) {
        this.currentTransactions.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
        this.recalcBalances();
    }

    private final void dumpTransactions() {
        int n = 0;
        while (n < this.currentTransactions.size()) {
            Transaction transaction = (Transaction)this.currentTransactions.elementAt(n);
            System.err.println(">>> " + transaction.getDescription());
            ++n;
        }
    }

    public int getTransactionIndex(Transaction transaction) {
        return this.currentTransactions.indexOf(transaction);
    }

    public int getRowCount() {
        return this.currentTransactions.size();
    }

    public Object getElementAt(int n) {
        return this.currentTransactions.elementAt(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AccountTransactionSet(Account account, int n) {
        this(account, true, true, true, n);
    }

    public AccountTransactionSet(Account account) {
        this(account, true, true, true);
    }

    public AccountTransactionSet(Account account, boolean bl, boolean bl2, boolean bl3) {
        this(account, bl, bl2, bl3, 0);
    }

    public AccountTransactionSet(Account account, boolean bl, boolean bl2, boolean bl3, int n) {
        this.sortedBy = n;
        this.account = account;
        this.accountID = account.getAccountNum();
        this.showDebits = bl3;
        this.showCredits = bl2;
        this.showReconciled = bl;
        this.rootAccount = account.getRootAccount();
        TransactionSet transactionSet = this.rootAccount.getTransactionSet();
        this.currentTransactions = new Vector();
        this.accountInfoListeners = new Vector();
        this.tableListeners = new Vector();
        Object object = transactionSet.getAllTransactions();
        while (object.hasMoreElements()) {
            Transaction transaction = (Transaction)object.nextElement();
            if (!this.isTransactionVisible(transaction)) continue;
            this.currentTransactions.addElement(transaction);
        }
        transactionSet.addTransactionListener(this);
        object = this;
        synchronized (object) {
            AccountUtil.sortTransactions(this.currentTransactions, n, this.accountID, this.rootAccount);
        }
        this.recalcBalances();
        this.fireContentsChanged(this, 0, this.currentTransactions.size() - 1);
        account.addAccountListener(this);
    }
}

