/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountKeySelectionManager;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.AccountTreeCellRenderer;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class AccountPopup
extends JComboBox {
    private AccountListModel accountListModel = null;
    private MoneydanceGUI moneydanceGUI;
    private AccountTreeCellRenderer cellRenderer;
    private JTextField accountEditor = null;
    private boolean allowKeyEntry = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void init() {
        this.accountListModel = (AccountListModel)this.getModel();
        this.setEditable(this.allowKeyEntry);
        this.cellRenderer = new AccountTreeCellRenderer(this.moneydanceGUI);
        this.cellRenderer.setRealBackground(this.getBackground());
        this.setRenderer(this.cellRenderer);
        this.setKeySelectionManager(new AccountKeySelectionManager(this));
        if (!this.allowKeyEntry) return;
        try {
            this.accountEditor = (JTextField)this.getEditor().getEditorComponent();
            AccountPopup accountPopup = this;
            if (accountPopup == null) {
                throw null;
            }
            this.accountEditor.addKeyListener(accountPopup.new AccountCompleter());
            AccountPopup accountPopup2 = this;
            if (accountPopup2 == null) {
                throw null;
            }
            this.accountEditor.addFocusListener(new FocusListener(accountPopup2){
                private final /* synthetic */ AccountPopup this$0;

                public final void focusGained(FocusEvent focusEvent) {
                    if (this.this$0.access$0() == null) {
                        return;
                    }
                    this.this$0.access$0().select(0, this.this$0.access$0().getText().length());
                }

                public final void focusLost(FocusEvent focusEvent) {
                }
                {
                    this.this$0 = accountPopup;
                    this.constructor$0(accountPopup);
                }

                public void constructor$0(AccountPopup accountPopup) {
                }
            });
            return;
        }
        catch (Exception exception) {
            System.err.println("Exception configuring editor: " + exception);
            exception.printStackTrace(System.err);
            this.accountEditor = null;
            this.allowKeyEntry = false;
        }
    }

    public void selectDefaultAccount() {
        this.accountListModel.selectDefaultAccount();
        if (this.accountEditor != null) {
            this.accountEditor.repaint();
        }
        this.repaint();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.cellRenderer != null) {
            this.cellRenderer.setRealBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.cellRenderer != null) {
            this.cellRenderer.setRealForeground(color);
        }
    }

    public void setSelectedAccount(Account account) {
        this.accountListModel.setSelectedAccount(account);
        this.repaint();
    }

    public void setSelectedAccountIndex(int n) {
        this.accountListModel.setSelectedAccountIndex(n);
        this.repaint();
    }

    public Account getSelectedAccount() {
        return (Account)this.accountListModel.getSelectedItem();
    }

    public Account getAccountAt(int n) {
        return this.accountListModel.getAccountAt(n);
    }

    public void addItemListener(ItemListener itemListener) {
        if (this.accountListModel != null) {
            this.addAccountSelectionListener(itemListener);
        } else {
            super.addItemListener(itemListener);
        }
    }

    public void addAccountSelectionListener(ItemListener itemListener) {
        this.accountListModel.addItemListener(itemListener);
    }

    public void removeAccountSelectionListener(ItemListener itemListener) {
        this.accountListModel.removeItemListener(itemListener);
    }

    public void clearDontShowAccounts() {
        this.accountListModel.clearDontShowAccounts();
    }

    public void setShowAccount(Account account, boolean bl) {
        this.accountListModel.setShowAccount(account, bl);
    }

    public void setShowAccountsOfType(int n, boolean bl) {
        this.accountListModel.setShowAccountsOfType(n, bl);
    }

    public void goneAway() {
        this.accountListModel.goneAway();
    }

    /* synthetic */ JTextField access$0() {
        return this.accountEditor;
    }

    /* synthetic */ AccountListModel access$1() {
        return this.accountListModel;
    }

    public AccountPopup(Account account, MoneydanceGUI moneydanceGUI) {
        this(account, moneydanceGUI, false, false);
    }

    public AccountPopup(Account account, MoneydanceGUI moneydanceGUI, boolean bl, boolean bl2) {
        super(new AccountListModel(account.getRootAccount(), bl));
        this.moneydanceGUI = moneydanceGUI;
        this.allowKeyEntry = bl2;
        this.init();
        if (account != null) {
            this.accountListModel.setContainerAccount(account);
        }
        this.setMaximumRowCount(16);
    }

    public AccountPopup(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        super(new AccountListModel(rootAccount));
        this.moneydanceGUI = moneydanceGUI;
        this.init();
    }

    private class AccountCompleter
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            if (AccountPopup.this.access$0() == null) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '\'' || c == '\"' || c == ' ' || c >= '0' && c <= '9' || c == '-' || c == '&')) {
                return;
            }
            String string = AccountPopup.this.access$0().getText();
            Account account = AccountPopup.this.access$1().matchAccountName(string);
            if (account != null) {
                int n = AccountPopup.this.access$0().getCaretPosition();
                AccountPopup.this.access$0().setText(account.getFullAccountName());
                AccountPopup.this.access$0().select(n, AccountPopup.this.access$0().getText().length());
            }
        }

        AccountCompleter() {
        }
    }
}

