/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import com.seanreilly.apps.moneydance.view.gui.AccountDetailInterface;
import com.seanreilly.apps.moneydance.view.gui.AccountHeaderPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoWindow;
import com.seanreilly.apps.moneydance.view.gui.AccountSelectionListener;
import com.seanreilly.apps.moneydance.view.gui.BankAccountDetailPanel;
import com.seanreilly.apps.moneydance.view.gui.COAWindow;
import com.seanreilly.apps.moneydance.view.gui.CreateAccountWindow;
import com.seanreilly.apps.moneydance.view.gui.InterfacePanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.RootAccountDetailPanel;
import com.seanreilly.apps.moneydance.view.gui.graphtool.GraphTool;
import com.seanreilly.apps.moneydance.view.gui.reporttool.ReportTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class AccountPanel
extends JPanel
implements AccountSelectionListener,
InterfacePanel {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$RootAccount;
    private JSplitPane splitPane;
    private JPanel mainPanel;
    private AccountHeaderPanel headerPanel;
    private AccountDetailInterface detailPanel;
    private RootAccount rootAccount;
    private Vector graphers;
    private Vector reporters;
    private COAWindow coaWin = null;
    private JFrame coaFrame = null;
    private MoneydanceGUI moneydanceGUI;
    private UserPreferences prefs;

    public RootAccount getRootAccount() {
        return this.rootAccount;
    }

    public void accountSelected(Account account) {
        if (this.detailPanel != null && this.detailPanel.getAccount() == account) {
            return;
        }
        if (this.detailPanel != null) {
            this.detailPanel.goingAway();
        }
        if (this.coaIsActive()) {
            this.coaWin.coaPanel.setSelectedAccount(account);
        }
        this.mainPanel.removeAll();
        if (this.detailPanel != null) {
            this.detailPanel.goneAway();
        }
        if (account.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$RootAccount != null ? class$Lcom$seanreilly$apps$moneydance$model$RootAccount : (class$Lcom$seanreilly$apps$moneydance$model$RootAccount = AccountPanel.class$("com.seanreilly.apps.moneydance.model.RootAccount")))) {
            RootAccountDetailPanel rootAccountDetailPanel = new RootAccountDetailPanel(this.moneydanceGUI, (RootAccount)account, this.headerPanel);
            this.detailPanel = rootAccountDetailPanel;
            this.mainPanel.add((Component)rootAccountDetailPanel, "Center");
            this.mainPanel.validate();
        } else {
            BankAccountDetailPanel bankAccountDetailPanel = new BankAccountDetailPanel(this.moneydanceGUI, account);
            this.detailPanel = bankAccountDetailPanel;
            this.mainPanel.add((Component)bankAccountDetailPanel, "Center");
            this.mainPanel.validate();
        }
        if (this.detailPanel != null) {
            this.detailPanel.requestFocus();
        }
        System.gc();
        this.headerPanel.setSelectedAccount(account);
    }

    public void editAccount(Account account) {
        if (account == null) {
            return;
        }
        AccountInfoWindow accountInfoWindow = new AccountInfoWindow(this.moneydanceGUI, account);
        ((Component)accountInfoWindow).setVisible(true);
    }

    public void createAccount(Account account) {
        CreateAccountWindow createAccountWindow = new CreateAccountWindow(this.moneydanceGUI.getTopLevelFrame(), account, this.moneydanceGUI);
        ((Component)createAccountWindow).setVisible(true);
    }

    public void deleteAccount(Account account) {
        if (account.getAccountType() == 0) {
            JOptionPane.showMessageDialog(this, this.moneydanceGUI.getResources().getString("cant_delete_root_acct"), this.moneydanceGUI.getResources().getString("error"), 0);
            return;
        }
        if (this.detailPanel != null && this.detailPanel.getAccount() == account) {
            this.detailPanel.goingAway();
        }
        boolean bl = true;
        TransactionSet transactionSet = account.getRootAccount().getTransactionSet();
        int n = account.getAccountNum();
        Object object = transactionSet.getAllTransactions();
        while (object.hasMoreElements()) {
            Transaction transaction = (Transaction)object.nextElement();
            if (!account.containsTransaction(transaction, true, false)) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.mainPanel.removeAll();
            if (JOptionPane.showConfirmDialog(this, this.moneydanceGUI.getResources().getString("confirm_delete_acct") + account.getAccountName(), this.moneydanceGUI.getResources().getString("generic_confirm"), 0) == 0) {
                if (this.detailPanel != null && this.detailPanel.getAccount() == account) {
                    this.detailPanel.goneAway();
                }
                this.headerPanel.selectPreviousAccount();
                object = this.headerPanel.getSelectedAccount();
                if (object != null) {
                    this.accountSelected((Account)object);
                } else {
                    this.accountSelected(account.getRootAccount());
                }
                account.getParentAccount().removeSubAccount(account, true);
            }
        } else {
            JOptionPane.showMessageDialog(this, this.moneydanceGUI.getResources().getString("cant_delete_nonempty_acct"), this.moneydanceGUI.getResources().getString("error"), 0);
        }
    }

    private final boolean coaIsActive() {
        return this.coaWin != null && this.coaWin.isActive();
    }

    public synchronized void showCOA() {
        if (this.coaIsActive()) {
            this.coaWin.toFront();
            this.coaWin.requestFocus();
        } else {
            this.moneydanceGUI.setWaitCursor();
            this.coaWin = new COAWindow(this.moneydanceGUI, this.rootAccount);
            ((Component)this.coaWin).setVisible(true);
            this.coaWin.restoreCOAFrameInfo();
            this.coaWin.coaPanel.addAccountSelectionListener(this);
            this.coaWin.coaPanel.setSelectedAccount(this.headerPanel.getSelectedAccount());
            this.moneydanceGUI.setDefaultCursor();
        }
    }

    public void graphAccount(Account account) {
        if (this.rootAccount.getSubAccountCount() <= 0) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("nothing_to_graph"));
            return;
        }
        this.moneydanceGUI.setWaitCursor();
        GraphTool graphTool = new GraphTool(this.moneydanceGUI, account, this);
        this.graphers.addElement(graphTool);
        ((Component)graphTool).setVisible(true);
        this.moneydanceGUI.setDefaultCursor();
    }

    public void grapherIsDone(GraphTool graphTool) {
        this.graphers.removeElement(graphTool);
        ((Component)graphTool).setVisible(false);
        graphTool.dispose();
    }

    public void reportOnAccount(Account account) {
        if (this.rootAccount.getSubAccountCount() <= 0) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.getResources().getString("nothing_to_report"));
            return;
        }
        this.moneydanceGUI.setWaitCursor();
        ReportTool reportTool = new ReportTool(this.moneydanceGUI, account, this);
        this.reporters.addElement(reportTool);
        ((Component)reportTool).setVisible(true);
        this.moneydanceGUI.setDefaultCursor();
    }

    public void reporterIsDone(ReportTool reportTool) {
        this.reporters.removeElement(reportTool);
        ((Component)reportTool).setVisible(false);
        reportTool.dispose();
    }

    public void goingAway() {
        if (this.detailPanel != null) {
            this.detailPanel.goingAway();
        }
        if (this.headerPanel != null) {
            this.headerPanel.goingAway();
        }
        if (this.rootAccount.isUnsavedData() && this.moneydanceGUI.askQuestion(this.moneydanceGUI.getResources().getString("save_changes"), this.moneydanceGUI.getResources().getString("save_changes_question"))) {
            this.moneydanceGUI.saveCurrentAccount();
        }
    }

    public void goneAway() {
        JFrame jFrame;
        this.saveWorkspace();
        Enumeration enumeration = this.graphers.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (GraphTool)enumeration.nextElement();
            this.grapherIsDone((GraphTool)jFrame);
        }
        enumeration = this.reporters.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (ReportTool)enumeration.nextElement();
            this.reporterIsDone((ReportTool)jFrame);
        }
        if (this.detailPanel != null) {
            this.detailPanel.goneAway();
        }
        if (this.headerPanel != null) {
            this.headerPanel.goneAway();
        }
        if (this.coaIsActive()) {
            this.coaWin.goAway();
        }
    }

    public void saveWorkspace() {
        if (this.coaIsActive()) {
            this.prefs.setSetting("gui.coa_window_isopen", "y");
        } else {
            this.prefs.setSetting("gui.coa_window_isopen", "n");
        }
    }

    public void loadWorkspace() {
        if (this.prefs.getSetting("gui.coa_window_isopen", "n").equals("y")) {
            this.showCOA();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AccountPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.prefs = Main.getMainController().getPreferences();
        this.setLayout(new BorderLayout());
        this.graphers = new Vector();
        this.reporters = new Vector();
        rootAccount.sortAccounts();
        this.headerPanel = new AccountHeaderPanel(this.moneydanceGUI, rootAccount);
        this.headerPanel.addAccountSelectionListener(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.accountSelected(rootAccount);
    }
}

