/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.PreferencesListener;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountPopup;
import com.seanreilly.apps.moneydance.view.gui.AccountSelectionListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTreeCellRenderer;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AccountHeaderPanel
extends JPanel
implements ActionListener,
PreferencesListener {
    private Vector listeners;
    private RootAccount rootAccount;
    private MoneydanceGUI moneydanceGUI;
    private AccountPopup accountChoice;
    private JButton newAccountButton;
    private JButton editAccountButton;
    private JButton deleteAccountButton;
    private JButton graphAccountButton;
    private JButton reportAccountButton;
    private AccountTreeCellRenderer renderer;
    private JLabel acctLabel;
    private UserPreferences prefs;

    private final void setColors() {
        Color color = new Color(this.prefs.getIntSetting("gui.acct_header_fg", 0xFFFF00));
        Color color2 = new Color(this.prefs.getIntSetting("gui.acct_header_bg", 7931521));
        this.accountChoice.setBackground(color2);
        this.accountChoice.setForeground(color);
        this.newAccountButton.setForeground(color);
        this.newAccountButton.setBackground(color2);
        this.editAccountButton.setForeground(color);
        this.editAccountButton.setBackground(color2);
        this.deleteAccountButton.setForeground(color);
        this.deleteAccountButton.setBackground(color2);
        this.graphAccountButton.setForeground(color);
        this.graphAccountButton.setBackground(color2);
        this.reportAccountButton.setForeground(color);
        this.reportAccountButton.setBackground(color2);
        this.acctLabel.setForeground(color);
        this.setBackground(color2);
        this.setForeground(color);
    }

    private final void setLabels() {
        this.acctLabel.setText("  " + this.moneydanceGUI.getResources().getString("account") + ":  ");
        this.newAccountButton.setText(this.moneydanceGUI.getResources().getString("new"));
        this.editAccountButton.setText(this.moneydanceGUI.getResources().getString("edit"));
        this.deleteAccountButton.setText(this.moneydanceGUI.getResources().getString("delete"));
        this.graphAccountButton.setText(this.moneydanceGUI.getResources().getString("graph"));
        this.reportAccountButton.setText(this.moneydanceGUI.getResources().getString("report"));
        this.doLayout();
    }

    public void preferencesUpdated() {
        this.setColors();
        this.setLabels();
    }

    public void setSelectedAccount(Account account) {
        if (account != this.accountChoice.getSelectedAccount()) {
            this.accountChoice.setSelectedAccount(account);
            this.fireAccountSelected(account);
        }
    }

    public Account getSelectedAccount() {
        return (Account)this.accountChoice.getSelectedItem();
    }

    public void selectPreviousAccount() {
        int n = this.accountChoice.getSelectedIndex() - 1;
        if (n < 0) {
            n = 0;
        }
        this.accountChoice.setSelectedIndex(n);
    }

    public void goingAway() {
    }

    public void goneAway() {
        this.accountChoice.goneAway();
        this.prefs.removeListener(this);
    }

    public void addAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.addElement(accountSelectionListener);
    }

    public void removeAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.removeElement(accountSelectionListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.accountChoice) {
            this.fireAccountSelected((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.newAccountButton) {
            this.fireCreateAccount((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.editAccountButton) {
            this.fireEditAccount((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.deleteAccountButton) {
            this.fireDeleteAccount((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.graphAccountButton) {
            this.fireGraphAccount((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.reportAccountButton) {
            this.fireReportOnAccount((Account)this.accountChoice.getSelectedItem());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireAccountSelected(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).accountSelected(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireEditAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).editAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireCreateAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).createAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireDeleteAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).deleteAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireGraphAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).graphAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireReportOnAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).reportOnAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /* synthetic */ AccountPopup access$0() {
        return this.accountChoice;
    }

    /* synthetic */ void access$1(Account account) {
        this.fireAccountSelected(account);
    }

    public AccountHeaderPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.setLayout(new GridBagLayout());
        this.listeners = new Vector();
        this.prefs = Main.getMainController().getPreferences();
        int n = 2;
        int n2 = 0;
        this.accountChoice = new AccountPopup(this.moneydanceGUI, rootAccount);
        this.accountChoice.setMaximumRowCount(20);
        this.accountChoice.setShowAccountsOfType(0, true);
        this.newAccountButton = new JButton(" ");
        this.newAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.editAccountButton = new JButton(" ");
        this.editAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.deleteAccountButton = new JButton(" ");
        this.deleteAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.graphAccountButton = new JButton(" ");
        this.graphAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.reportAccountButton = new JButton(" ");
        this.reportAccountButton.setMargin(new Insets(n2, n, 0, n));
        int n3 = 0;
        this.acctLabel = new JLabel(" ", 4);
        this.add((Component)this.acctLabel, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.accountChoice, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)new JLabel(""), AwtUtil.getConstraints(n3++, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.newAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.editAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.deleteAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.graphAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.reportAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.newAccountButton.addActionListener(this);
        this.editAccountButton.addActionListener(this);
        this.deleteAccountButton.addActionListener(this);
        this.graphAccountButton.addActionListener(this);
        this.reportAccountButton.addActionListener(this);
        this.accountChoice.setSelectedAccountIndex(0);
        this.prefs.addListener(this);
        AccountHeaderPanel accountHeaderPanel = this;
        if (accountHeaderPanel == null) {
            throw null;
        }
        this.accountChoice.addAccountSelectionListener(new ItemListener(accountHeaderPanel){
            private final /* synthetic */ AccountHeaderPanel this$0;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void itemStateChanged(ItemEvent itemEvent) {
                try {
                    this.this$0.access$1(this.this$0.access$0().getSelectedAccount());
                    return;
                }
                catch (Exception exception) {
                }
            }
            {
                this.this$0 = accountHeaderPanel;
                this.constructor$0(accountHeaderPanel);
            }

            public void constructor$0(AccountHeaderPanel accountHeaderPanel) {
            }
        });
        this.setColors();
        this.setLabels();
    }
}

