/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view;

import com.seanreilly.util.StreamTable;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resources
extends ResourceBundle {
    private static final byte NONE = 0;
    private static final byte THOUSAND = 1;
    private static final byte MILLION = 2;
    private static final byte BILLION = 3;
    private static final byte TRILLION = 4;
    private StreamTable resourceTable;
    private String[] digitText = new String[]{"zero ", "one ", "two ", "three ", "four ", "five ", "six ", "seven ", "eight ", "nine ", "ten ", "eleven ", "twelve ", "thirteen ", "fourteen ", "fifteen ", "sixteen ", "seventeen ", "eighteen ", "nineteen "};
    private String[] tensDigitText = new String[]{"zero", "ten ", "twenty ", "thirty ", "forty ", "fifty ", "sixty ", "seventy ", "eighty ", "ninety "};
    private String[] tensOneDigitText = new String[]{"one ", "eleven ", "twenty one ", "thirty one ", "forty one ", "fifty one ", "sixty one ", "seventy one ", "eighty one ", "ninety one "};
    private String[] hundredsDigitText = new String[]{"zero hundred ", "one hundred ", "two hundred ", "three hundred ", "four hundred ", "five hundred ", "six hundred ", "seven hundred ", "eight hundred ", "nine hundred "};
    private String AND_TEXT = "and ";
    private String[] magnitudes = new String[]{" ", "thousand ", "million ", "billion ", "trillion "};
    private String[] onesMagnitudes = new String[]{"one ", "one thousand ", "one million ", "one billion ", "one trillion"};

    public Enumeration getKeys() {
        return this.resourceTable.keys();
    }

    protected Object handleGetObject(String string) throws MissingResourceException {
        Object object = this.resourceTable.get(string);
        if (object == null) {
            return "??" + string + "??";
        }
        return object;
    }

    public String convertNumberToText(long l, int n) {
        String string;
        long l2 = l % Math.round(Math.pow(10.0, n));
        long l3 = (l - l2) / Math.round(Math.pow(10.0, n));
        if (l3 >= 1000000000000000L) {
            return "";
        }
        String string2 = "";
        if (l2 != 0L) {
            string2 = this.AND_TEXT + l2 + "/" + Math.round(Math.pow(10.0, n));
        }
        if ((string = (this.wholeNumberToText(l3, true) + string2).trim()).length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    private final String wholeNumberToText(long l, boolean bl) {
        if (l >= 1000000000000L) {
            return this.smallNumberToText(true, l / 1000000000000L, (byte)4) + this.wholeNumberToText(l % 1000000000000L, false);
        }
        if (l >= 1000000000L) {
            return this.smallNumberToText(true, l / 1000000000L, (byte)3) + this.wholeNumberToText(l % 1000000000L, false);
        }
        if (l >= 1000000L) {
            return this.smallNumberToText(true, l / 1000000L, (byte)2) + this.wholeNumberToText(l % 1000000L, false);
        }
        if (l >= 1000L) {
            return this.smallNumberToText(true, l / 1000L, (byte)1) + this.wholeNumberToText(l % 1000L, false);
        }
        if (l == 0L) {
            return bl ? "zero" : "";
        }
        return this.smallNumberToText(true, l, (byte)0);
    }

    private final String smallNumberToText(boolean bl, long l, byte by) {
        String string = "";
        if (l == 0L) {
            return "";
        }
        if (l >= 1000L) {
            string = "Way Too Much";
        } else if (l >= 100L) {
            string = this.hundredsDigitText[(int)(l / 100L)] + this.smallNumberToText(false, l % 100L, (byte)0);
        } else if (l >= 20L) {
            boolean bl2;
            boolean bl3 = bl2 = l % 10L == 1L;
            string = bl2 ? this.tensOneDigitText[(int)(l / 10L)] : this.tensDigitText[(int)(l / 10L)] + this.smallNumberToText(false, l % 10L, (byte)0);
        } else {
            if (bl && l == 1L && by != 0) {
                return this.onesMagnitudes[by];
            }
            string = this.digitText[(int)l];
        }
        if (bl) {
            return string + this.magnitudes[by];
        }
        return string;
    }

    public Resources() {
        this("/com/seanreilly/apps/moneydance/view/resources/english.dict");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resources(String string) {
        this.resourceTable = new StreamTable();
        try {
            this.resourceTable.readFrom(this.getClass().getResourceAsStream(string));
            return;
        }
        catch (Exception exception) {
            System.err.println("Error reading resources: " + exception);
            exception.printStackTrace(System.err);
        }
    }
}

