/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model.io;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class TabDelDataWriter {
    private RootAccount rootAccount;
    private CurrencyTable currencyTable;
    private File file;
    private final String[] accountTypes = new String[]{"ROOT", "BANK", "INVESTMENT", "CREDIT CARD", "EXPENSE", "INCOME"};
    private DateFormat shortDateFormat;
    private DateFormat longDateFormat;

    public void writeAllAccounts() throws Exception {
        Object object;
        FileWriter fileWriter = new FileWriter(this.file);
        this.writeCurrencyHeader(fileWriter);
        CurrencyType currencyType = this.currencyTable.getBaseType();
        this.writeCurrencyLine(fileWriter, currencyType, currencyType);
        Enumeration enumeration = this.currencyTable.getAllValues();
        while (enumeration.hasMoreElements()) {
            object = (CurrencyType)enumeration.nextElement();
            if (object == currencyType) continue;
            this.writeCurrencyLine(fileWriter, (CurrencyType)object, currencyType);
        }
        fileWriter.write("\n");
        this.writeAccountHeader(fileWriter);
        this.writeAccount(this.rootAccount, fileWriter);
        fileWriter.write("\n");
        this.writeTransactionHeader(fileWriter);
        enumeration = this.rootAccount.getTransactionSet().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            object = (Transaction)enumeration.nextElement();
            if (object instanceof SplitTransaction) continue;
            this.writeTransaction(fileWriter, (BankTransaction)object);
        }
        fileWriter.close();
    }

    private final void writeCurrencyHeader(Writer writer) throws Exception {
        this.writeField(writer, "#Currency ID");
        this.writeField(writer, "Currency Name");
        this.writeField(writer, "Rate");
        this.writeField(writer, "Decimal Places");
        this.writeField(writer, "Ticker Symbol");
        this.writeField(writer, "Prefix");
        this.writeField(writer, "Suffix");
        writer.write("\n");
    }

    private final void writeAccountHeader(Writer writer) throws Exception {
        this.writeField(writer, "#Account#");
        this.writeField(writer, "Parent Account#");
        this.writeField(writer, "Account Name");
        this.writeField(writer, "Account Type");
        this.writeField(writer, "Currency");
        this.writeField(writer, "Start Balance");
        writer.write("\n");
    }

    private final void writeTransactionHeader(Writer writer) throws Exception {
        writer.write("#");
        this.writeField(writer, "Date");
        this.writeField(writer, "Tax Date");
        this.writeField(writer, "Date Entered");
        this.writeField(writer, "Check Number");
        this.writeField(writer, "Memo");
        this.writeField(writer, "Credit Status");
        this.writeField(writer, "Credit Account");
        this.writeField(writer, "Split Count");
        this.writeField(writer, "Payee/Description");
        this.writeField(writer, "Amount");
        this.writeField(writer, "Rate");
        this.writeField(writer, "Debit Account");
        this.writeField(writer, "Debit Status");
        writer.write("\n");
    }

    private final void writeCurrencyLine(Writer writer, CurrencyType currencyType, CurrencyType currencyType2) throws Exception {
        this.writeField(writer, currencyType.getID());
        this.writeField(writer, currencyType.getName());
        this.writeField(writer, currencyType.getXRelativeRate(currencyType2));
        this.writeField(writer, currencyType.getDecimalPlaces());
        this.writeField(writer, currencyType.getTickerSymbol());
        this.writeField(writer, currencyType.getPrefix());
        this.writeField(writer, currencyType.getSuffix());
        writer.write("\n");
    }

    private final void writeAccount(Account account, FileWriter fileWriter) throws Exception {
        this.writeAccountLine(account, fileWriter);
        int n = 0;
        while (n < account.getSubAccountCount()) {
            this.writeAccount(account.getSubAccount(n), fileWriter);
            ++n;
        }
    }

    private final void writeField(Writer writer, long l, boolean bl) throws Exception {
        if (bl) {
            writer.write(StringUtils.encode(this.longDateFormat.format(new Date(l))) + '\t');
        } else {
            writer.write(StringUtils.encode(this.shortDateFormat.format(new Date(l))) + '\t');
        }
    }

    private final void writeField(Writer writer, int n) throws Exception {
        writer.write(StringUtils.encode(String.valueOf(n)) + '\t');
    }

    private final void writeField(Writer writer, double d) throws Exception {
        writer.write(StringUtils.encode(String.valueOf(d)) + '\t');
    }

    private final void writeField(Writer writer, Object object) throws Exception {
        writer.write(StringUtils.encode(String.valueOf(object)) + '\t');
    }

    private final void writeField(Writer writer, char c) throws Exception {
        writer.write(StringUtils.encode(String.valueOf(c)) + '\t');
    }

    private final void writeAccountLine(Account account, Writer writer) throws Exception {
        this.writeField(writer, account.getAccountNum());
        if (account != this.rootAccount) {
            this.writeField(writer, account.getParentAccount().getAccountNum());
        } else {
            this.writeField(writer, -1);
        }
        this.writeField(writer, account.getAccountName());
        this.writeField(writer, this.accountTypes[account.getAccountType()]);
        this.writeField(writer, account.getCurrencyType());
        CurrencyType currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
        this.writeField(writer, StringUtils.formatCurrency(account.getStartBalance(), false, '.', ',', currencyType.getDecimalPlaces()));
        writer.write("\n");
    }

    private final void writeTransaction(Writer writer, BankTransaction bankTransaction) throws Exception {
        this.writeField(writer, bankTransaction.getDate(), false);
        this.writeField(writer, bankTransaction.getTaxableDate(), false);
        this.writeField(writer, bankTransaction.getDateEntered(), false);
        this.writeField(writer, bankTransaction.getCheckNumber());
        this.writeField(writer, bankTransaction.getMemo());
        this.writeField(writer, bankTransaction.getDestClearedStatus());
        this.writeField(writer, bankTransaction.getDestAccountId());
        this.writeField(writer, bankTransaction.getSplitCount());
        this.writeField(writer, bankTransaction.getDescription());
        Account account = this.rootAccount.getAccountById(bankTransaction.getDestAccountId());
        CurrencyType currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
        this.writeField(writer, StringUtils.formatCurrency(bankTransaction.getAmount(), false, '.', ',', currencyType.getDecimalPlaces()));
        if (bankTransaction.getSplitCount() <= 0) {
            Account account2 = this.rootAccount.getAccountById(bankTransaction.getSourceAccountId());
            CurrencyType currencyType2 = this.currencyTable.getCurrencyType(account2.getCurrencyType());
            this.writeField(writer, this.currencyTable.getRate(currencyType, currencyType2));
            this.writeField(writer, account2.getAccountNum());
            this.writeField(writer, bankTransaction.getSourceClearedStatus());
            writer.write("\n");
        } else {
            writer.write("\n");
            int n = 0;
            while (n < bankTransaction.getSplitCount()) {
                SplitTransaction splitTransaction = bankTransaction.getSplit(n);
                Account account3 = this.rootAccount.getAccountById(splitTransaction.getSourceAccountId());
                CurrencyType currencyType3 = this.currencyTable.getCurrencyType(account3.getCurrencyType());
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, "-");
                this.writeField(writer, StringUtils.formatCurrency(splitTransaction.getAmount(), false, '.', ',', currencyType.getDecimalPlaces()));
                this.writeField(writer, this.currencyTable.getRate(currencyType, currencyType3));
                this.writeField(writer, account3.getAccountNum());
                this.writeField(writer, splitTransaction.getSourceClearedStatus());
                writer.write("\n");
                ++n;
            }
        }
    }

    public TabDelDataWriter(RootAccount rootAccount, File file) {
        this.file = file;
        this.rootAccount = rootAccount;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.shortDateFormat = new SimpleDateFormat("MM/dd/yyyy");
        this.longDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss:SSS");
    }
}

