/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model.io;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QIFDataWriter {
    private RootAccount rootAccount;
    private File qifFile;
    private CurrencyType currency = null;
    private CurrencyTable currencyTable = null;
    private DateFormat shortDateFormat;
    private DateFormat longDateFormat;

    public void writeAllAccounts() throws Exception {
        Account account;
        FileWriter fileWriter = new FileWriter(this.qifFile);
        fileWriter.write("!Type:Class\n");
        fileWriter.write("N" + this.rootAccount.getAccountName() + "\n");
        fileWriter.write("D" + this.rootAccount.getAccountName() + "\n");
        fileWriter.write("^\n");
        fileWriter.write("!Type:Cat\n");
        int n = 0;
        while (n < this.rootAccount.getSubAccountCount()) {
            account = this.rootAccount.getSubAccount(n);
            if (!account.isRegisterAccount()) {
                this.writeAccountInfo(fileWriter, account, false, true);
            }
            ++n;
        }
        fileWriter.write("!Option:AutoSwitch\n");
        n = 0;
        while (n < this.rootAccount.getSubAccountCount()) {
            account = this.rootAccount.getSubAccount(n);
            if (account.isRegisterAccount()) {
                this.writeAccountInfo(fileWriter, account, false, false);
            }
            ++n;
        }
        fileWriter.write("!Clear:AutoSwitch\n");
        n = 0;
        while (n < this.rootAccount.getSubAccountCount()) {
            account = this.rootAccount.getSubAccount(n);
            if (account.isRegisterAccount()) {
                this.writeAccountInfo(fileWriter, account, true, false);
            }
            ++n;
        }
        fileWriter.close();
    }

    private final void writeAccountInfo(Writer writer, Account account, boolean bl, boolean bl2) throws Exception {
        int n;
        if (!bl2) {
            writer.write("!Account\n");
        }
        writer.write("N" + account.getFullAccountName() + "\n");
        if (account instanceof BankAccount) {
            writer.write("D" + ((BankAccount)account).getBankName() + "\n");
        } else {
            writer.write("D" + account.getFullAccountName() + "\n");
        }
        int n2 = account.getAccountType();
        String string = "";
        switch (n2) {
            case 4: {
                writer.write("E\n");
                string = "Expense";
                break;
            }
            case 5: {
                writer.write("I\n");
                string = "Income";
                break;
            }
            case 2: {
                writer.write("TInvst\n");
                string = "Invst";
                break;
            }
            case 1: {
                writer.write("TBank\n");
                string = "Bank";
                break;
            }
            default: {
                writer.write("TBank\n");
                string = "Bank";
                break;
            }
        }
        writer.write("^\n");
        if (bl) {
            Object object;
            n = account.getAccountNum();
            writer.write("!Type:" + string + "\n");
            if (account.getStartBalance() != 0L) {
                writer.write("D" + this.shortDateFormat.format(new Date(0L)) + "\n");
                object = this.currencyTable.getCurrencyType(account.getCurrencyType());
                writer.write("T" + StringUtils.formatCurrency(this.currencyTable.convertValue(account.getStartBalance(), (CurrencyType)object, this.currency), false, '.', ',', this.currency.getDecimalPlaces()) + "\n");
                writer.write("CX\n");
                writer.write("N\n");
                writer.write("POpening Balance\n");
                writer.write("M\n");
                writer.write("L[Start Balance]\n");
                writer.write("^\n");
            }
            object = this.rootAccount.getTransactionSet().getAllTransactions();
            while (object.hasMoreElements()) {
                Transaction transaction = (Transaction)object.nextElement();
                if (!account.containsTransaction(transaction, false, true)) continue;
                if (transaction instanceof BankTransaction) {
                    this.writeBankTransaction(writer, (BankTransaction)transaction, account);
                    continue;
                }
                if (transaction instanceof SplitTransaction) {
                    this.writeBankTransaction(writer, (SplitTransaction)transaction, account);
                    continue;
                }
                System.err.println("unknown transaction type: " + transaction.getClass());
            }
        }
        n = 0;
        while (n < account.getSubAccountCount()) {
            this.writeAccountInfo(writer, account.getSubAccount(n), bl, bl2);
            ++n;
        }
    }

    private final void writeBankTransaction(Writer writer, BankTransaction bankTransaction, Account account) throws Exception {
        CurrencyType currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
        writer.write("D" + this.shortDateFormat.format(new Date(bankTransaction.getDate())) + "\n");
        writer.write("T" + StringUtils.formatCurrency(this.currencyTable.convertValue(bankTransaction.getAmount(account.getAccountNum()), currencyType, this.currency), false, '.', ',', this.currency.getDecimalPlaces()) + "\n");
        writer.write("C" + bankTransaction.getClearedStatus(account.getAccountNum()) + "\n");
        writer.write("N" + bankTransaction.getCheckNumber() + "\n");
        writer.write("P" + bankTransaction.getDescription() + "\n");
        writer.write("M" + StringUtils.encode(bankTransaction.getMemo()) + "\n");
        int n = bankTransaction.getAccountId(account.getAccountNum());
        if (n >= 0) {
            Account account2 = this.rootAccount.getAccountById(n);
            String string = account2.getFullAccountName();
            if (account2.isRegisterAccount()) {
                string = "[" + string + "]";
            }
            writer.write("L" + string + "\n");
        } else {
            int n2 = 0;
            while (n2 < bankTransaction.getSplitCount()) {
                SplitTransaction splitTransaction = bankTransaction.getSplit(n2);
                Account account3 = this.rootAccount.getAccountById(splitTransaction.getSourceAccountId());
                String string = account3.getFullAccountName();
                if (account3.isRegisterAccount()) {
                    string = "[" + string + "]";
                }
                writer.write("S" + account3.getFullAccountName() + "\n");
                writer.write("E" + splitTransaction.getDescription() + "\n");
                writer.write("$" + StringUtils.formatCurrency(splitTransaction.getAmount(), false, '.', ',', currencyType.getDecimalPlaces()) + "\n");
                ++n2;
            }
        }
        writer.write("^\n");
    }

    private final void writeBankTransaction(Writer writer, SplitTransaction splitTransaction, Account account) throws Exception {
        CurrencyType currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
        writer.write("D" + this.shortDateFormat.format(new Date(splitTransaction.getDate())) + "\n");
        writer.write("T" + StringUtils.formatCurrency(this.currencyTable.convertValue(splitTransaction.getAmount(account.getAccountNum()), currencyType, this.currency), false, '.', ',', this.currency.getDecimalPlaces()) + "\n");
        writer.write("C" + splitTransaction.getClearedStatus(account.getAccountNum()) + "\n");
        writer.write("P" + splitTransaction.getDescription() + "\n");
        int n = splitTransaction.getDestAccountId();
        if (n >= 0) {
            Account account2 = this.rootAccount.getAccountById(n);
            String string = account2.getFullAccountName();
            if (account2.isRegisterAccount()) {
                string = "[" + string + "]";
            }
            writer.write("L" + string + "\n");
        }
        writer.write("^\n");
    }

    public QIFDataWriter(RootAccount rootAccount, File file, CurrencyType currencyType) {
        this.qifFile = file;
        this.rootAccount = rootAccount;
        this.currency = currencyType;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.shortDateFormat = new SimpleDateFormat("MM/dd/yyyy");
        this.longDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss:SSS");
    }
}

