/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model.io;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.StatusMonitor;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountUtil;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.IncomeAccount;
import com.seanreilly.apps.moneydance.model.InvestmentAccount;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class QIFDataReader {
    private RootAccount rootAccount;
    private File qifFile;
    private ExpenseAccount defaultExpenseCategory = null;
    private IncomeAccount defaultIncomeCategory = null;
    private boolean autoSwitch = false;
    private boolean matchTransactions = false;
    private boolean accountsOnly = false;
    private Account lastAccountRead = null;
    private Account accountToImportTo = null;
    private CurrencyType currency = null;
    private CurrencyTable currencyTable = null;
    private byte dateFormat;

    public static String getAccountType(String string) {
        if ((string = string.trim().toUpperCase()).equals("BANK") || string.equals("BANCARIO")) {
            return "BANK";
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readTransactions(StatusMonitor statusMonitor) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.qifFile)));
        this.autoSwitch = false;
        this.lastAccountRead = null;
        String string = this.readUpToSectionStart(bufferedReader);
        try {
            while (true) {
                if (string == null) {
                    Object var5_6 = null;
                    this.rootAccount.sortAccounts();
                    return;
                }
                if (string.length() <= 0) {
                    throw new Exception("Invalid section start: " + string);
                }
                if (string.toUpperCase().startsWith("!TYPE:") || string.toUpperCase().startsWith("TYPE:")) {
                    String string2 = string.substring(string.indexOf(58) + 1).trim();
                    String string3 = QIFDataReader.getAccountType(string2);
                    if (string3.equals("CLASS")) {
                        string = this.readUpToSectionStart(bufferedReader);
                        continue;
                    }
                    if (string3.equals("BANK")) {
                        string = this.readBankRegister("Imported Bank Account", bufferedReader);
                        continue;
                    }
                    if (string3.equals("INVST")) {
                        string = this.readInvstRegister("Imported Investment Account", bufferedReader);
                        continue;
                    }
                    if (string3.equals("MUTUAL")) {
                        string = this.readInvstRegister("Imported Mutual Account", bufferedReader);
                        continue;
                    }
                    if (string3.equals("CCARD")) {
                        string = this.readBankRegister("Imported Credit Card Account", bufferedReader);
                        continue;
                    }
                    if (string3.equals("CASH")) {
                        string = this.readBankRegister("Imported Cash Account", bufferedReader);
                        continue;
                    }
                    if (string3.equals("OTH A")) {
                        string = this.readBankRegister("Imported Asset", bufferedReader);
                        continue;
                    }
                    if (string3.equals("OTH L")) {
                        string = this.readBankRegister("Imported Liability", bufferedReader);
                        continue;
                    }
                    if (string3.equals("CAT")) {
                        string = this.readCategoryDefinitions(bufferedReader);
                        continue;
                    }
                    System.err.println("QIF: ignoring unknown account type: " + string2);
                    string = this.readUpToSectionStart(bufferedReader);
                    continue;
                }
                if (string.toUpperCase().startsWith("!ACCOUNT")) {
                    string = this.readAccountDefinitions(bufferedReader);
                    continue;
                }
                if (string.toUpperCase().startsWith("!OPTION:")) {
                    if (string.substring(8).trim().toUpperCase().equals("AUTOSWITCH")) {
                        this.autoSwitch = true;
                    }
                    string = bufferedReader.readLine();
                    continue;
                }
                if (string.toUpperCase().startsWith("!CLEAR:")) {
                    if (string.substring(7).trim().toUpperCase().equals("AUTOSWITCH")) {
                        this.autoSwitch = false;
                        this.lastAccountRead = null;
                    }
                    string = bufferedReader.readLine();
                    continue;
                }
                System.err.println("Unknown section type: " + string);
                string = this.readUpToSectionStart(bufferedReader);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.rootAccount.sortAccounts();
            throw throwable;
        }
    }

    private final String readCategoryDefinitions(BufferedReader bufferedReader) throws Exception {
        String string;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("^") || string.startsWith("!")) {
                if (string2.length() > 0 || string3.length() > 0 || string4.length() > 0) {
                    Account account = null;
                    if (string3.equals("E")) {
                        account = this.rootAccount.getAccountByName(string2, 4);
                        if (account == null) {
                            account = this.addNewAccount(string2, this.currency.getID(), this.rootAccount, string4, 4, false, -1);
                        }
                    } else if (string3.equals("I")) {
                        account = this.rootAccount.getAccountByName(string2, 5);
                        if (account == null) {
                            account = this.addNewAccount(string2, this.currency.getID(), this.rootAccount, string4, 5, false, -1);
                        }
                    } else {
                        System.err.println("QIF Import: Unrecognized category type: " + string3);
                    }
                    if (account != null) {
                        if (account instanceof IncomeAccount) {
                            ((IncomeAccount)account).setTaxable(string5.length() > 0);
                        } else if (account instanceof ExpenseAccount) {
                            ((ExpenseAccount)account).setDeductible(string5.length() > 0);
                        }
                    }
                }
                string2 = "";
                string3 = "";
                string4 = "";
                string5 = "";
                string6 = "";
                if (!string.startsWith("!")) continue;
                break;
            }
            if (string.startsWith("D")) {
                string4 = string.substring(1).trim();
                continue;
            }
            if (string.startsWith("N")) {
                string2 = string.substring(1).trim();
                continue;
            }
            if (string.startsWith("R")) {
                string6 = string.substring(1).trim();
                continue;
            }
            if (string.startsWith("I")) {
                string3 = string.trim().toUpperCase();
                continue;
            }
            if (string.startsWith("E")) {
                string3 = string.trim().toUpperCase();
                continue;
            }
            if (!string.startsWith("T")) continue;
            string5 = string.trim().toUpperCase();
        }
        return string;
    }

    private final String readAccountDefinitions(BufferedReader bufferedReader) throws Exception {
        TxnEntry txnEntry = null;
        String string = bufferedReader.readLine();
        while ((txnEntry = this.readBasicTxn(bufferedReader, string)) != null) {
            String string2 = txnEntry.getRecord("T").toUpperCase();
            String string3 = txnEntry.getRecord("N");
            String string4 = txnEntry.getRecord("D");
            Account account = null;
            if (string2.equals("BANK")) {
                account = this.rootAccount.getAccountByName(string3, 1);
                if (account == null) {
                    account = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, string4, 1, false, -1);
                }
            } else if (string2.equals("INVST")) {
                account = this.rootAccount.getAccountByName(string3, 2);
                if (account == null) {
                    account = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, string4, 2, false, -1);
                }
            } else if (string2.equals("MUTUAL")) {
                account = this.rootAccount.getAccountByName(string3, 2);
                if (account == null) {
                    account = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, string4, 2, false, -1);
                }
            } else if (string2.equals("CASH")) {
                account = this.rootAccount.getAccountByName(string3, 1);
                if (account == null) {
                    account = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, string4, 1, false, -1);
                }
            } else if (string2.equals("OTH A")) {
                account = this.rootAccount.getAccountByName(string3, 1);
                if (account == null) {
                    account = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, string4, 1, false, -1);
                }
            } else if (string2.equals("CCARD")) {
                account = this.rootAccount.getAccountByName(string3, 1);
                if (account == null) {
                    account = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, string4, 1, false, -1);
                }
            } else if (string2.equals("OTH L")) {
                account = this.rootAccount.getAccountByName(string3, 1);
                if (account == null) {
                    account = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, string4, 1, false, -1);
                }
            } else {
                System.err.println("QIF Import: Unrecognized account type: " + string2);
            }
            if (account != null && account.getAccountNum() < 0) {
                this.rootAccount.addSubAccount(account);
            }
            this.lastAccountRead = account;
            string = bufferedReader.readLine();
        }
        return string;
    }

    private final String readBankRegister(String string, BufferedReader bufferedReader) throws Exception {
        Account account = null;
        CurrencyType currencyType = this.currency;
        if (this.accountToImportTo != null) {
            account = this.accountToImportTo;
            currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
            this.accountToImportTo = null;
        } else if (this.lastAccountRead != null && this.lastAccountRead.isRegisterAccount()) {
            account = this.lastAccountRead;
            currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
            this.lastAccountRead = null;
        }
        if (account == null) {
            account = new BankAccount(string, -1, currencyType.getID(), null, null, this.rootAccount, 0L);
            this.rootAccount.addSubAccount(account);
        }
        Vector vector = null;
        if (this.matchTransactions) {
            vector = this.rootAccount.getTransactionSet().getTransactionsForAccount(account);
            AccountUtil.sortTransactions(vector, 0, account.getAccountNum(), this.rootAccount);
        }
        BankTxnEntry bankTxnEntry = null;
        String string2 = bufferedReader.readLine();
        while ((bankTxnEntry = this.readBankTxn(bufferedReader, string2)) != null) {
            Object object;
            string2 = null;
            boolean bl = false;
            long l = bankTxnEntry.getAmount("T", currencyType);
            long l2 = bankTxnEntry.getDate("D");
            char c = bankTxnEntry.getStatus("C");
            String string3 = bankTxnEntry.getRecord("L");
            int n = -1;
            double d = 1.0;
            if (bankTxnEntry.getNumSplits() <= 0) {
                boolean bl2 = false;
                if (string3.startsWith("[") && string3.endsWith("]")) {
                    string3 = string3.substring(1, string3.length() - 1).trim();
                    bl = true;
                    bl2 = true;
                }
                Account account2 = this.addNewAccount(string3, currencyType.getID(), this.rootAccount, "", bl2 ? 1 : (l < 0L ? 4 : 5), true, account.getAccountNum());
                object = this.currencyTable.getCurrencyType(account2.getCurrencyType());
                n = account2.getAccountNum();
                d = CurrencyType.getXRelativeRate((CurrencyType)object, currencyType, d);
            }
            BankTransaction bankTransaction = new BankTransaction(-1L, n, account.getAccountNum(), bankTxnEntry.getRecord("P"), l, l2, l2, l2, bankTxnEntry.getStatus("C"), bankTxnEntry.getStatus("C"), bankTxnEntry.getRecord("N"), null, bankTxnEntry.getRecord("M"));
            int n2 = 0;
            while (n2 < bankTxnEntry.getNumSplits()) {
                object = bankTxnEntry.getSplit(n2);
                long l3 = ((TxnEntry)object).getAmount("$", currencyType);
                boolean bl3 = false;
                String string4 = ((TxnEntry)object).getRecord("S");
                if (string4.startsWith("[") && string4.endsWith("]")) {
                    string4 = string4.substring(1, string4.length() - 1).trim();
                    bl3 = true;
                    bl = true;
                }
                Account account3 = this.addNewAccount(string4, currencyType.getID(), this.rootAccount, "", bl3 ? 1 : (l3 < 0L ? 4 : 5), true, account.getAccountNum());
                int n3 = account3.getAccountNum();
                CurrencyType currencyType2 = this.currencyTable.getCurrencyType(account3.getCurrencyType());
                double d2 = CurrencyType.getXRelativeRate(currencyType2, currencyType, d);
                bankTransaction.addSplit(new SplitTransaction(-1L, n3, d2, ((TxnEntry)object).getRecord("E"), l3, l2, c, bankTransaction));
                ++n2;
            }
            if (!this.accountsOnly) {
                Object object2;
                n2 = 0;
                if (bl) {
                    int n4 = account.getAccountNum();
                    int n5 = bankTransaction.getAccountId(n4);
                    object2 = this.rootAccount.getTransactionSet().getTransactionsForAccount(account).elements();
                    while (object2.hasMoreElements()) {
                        Transaction transaction = (Transaction)object2.nextElement();
                        int n6 = transaction.getAccountId(n4);
                        if (n6 != n5 || l != transaction.getAmount(n4) || Math.abs(l2 - transaction.getDate()) > 46400000L || !transaction.getDescription().equals(bankTransaction.getDescription())) continue;
                        n2 = 1;
                        break;
                    }
                }
                if (n2 == 0) {
                    Transaction transaction = null;
                    if (this.matchTransactions) {
                        transaction = this.matchTransaction(vector, bankTransaction, account.getAccountNum());
                    }
                    if (transaction == null) {
                        this.rootAccount.getTransactionSet().addNewTransaction(bankTransaction);
                    } else if (transaction instanceof BankTransaction) {
                        object2 = (BankTransaction)transaction;
                        int n7 = account.getAccountNum();
                        char c2 = ((Transaction)object2).getClearedStatus(n7);
                        if (c2 == ' ') {
                            ((Transaction)object2).setClearedStatus(bankTransaction.getClearedStatus(n7), n7);
                        }
                        this.rootAccount.getTransactionSet().transactionModified((Transaction)object2);
                    }
                }
            }
            string2 = bufferedReader.readLine();
        }
        return string2;
    }

    private final String readInvstRegister(String string, BufferedReader bufferedReader) throws Exception {
        Account account = null;
        if (this.accountToImportTo != null) {
            account = this.accountToImportTo;
            this.currency = this.currencyTable.getCurrencyType(account.getCurrencyType());
            this.accountToImportTo = null;
        } else if (this.lastAccountRead != null && this.lastAccountRead.isRegisterAccount()) {
            account = this.lastAccountRead;
            this.lastAccountRead = null;
        }
        if (account == null) {
            account = new InvestmentAccount(string, -1, this.currency.getID(), null, null, this.rootAccount, 0L);
            this.rootAccount.addSubAccount(account);
        }
        Vector vector = null;
        if (this.matchTransactions) {
            vector = this.rootAccount.getTransactionSet().getTransactionsForAccount(account);
            AccountUtil.sortTransactions(vector, 0, account.getAccountNum(), this.rootAccount);
        }
        TxnEntry txnEntry = null;
        String string2 = bufferedReader.readLine();
        while ((txnEntry = this.readBasicTxn(bufferedReader, string2)) != null) {
            Object object;
            int n;
            long l = txnEntry.getDate("D");
            double d = txnEntry.getRate("I");
            double d2 = txnEntry.getRate("Q");
            long l2 = txnEntry.getAmount("O", this.currency);
            String string3 = txnEntry.getRecord("L");
            String string4 = txnEntry.getRecord("N");
            String string5 = txnEntry.getRecord("P");
            String string6 = txnEntry.getRecord("Y");
            String string7 = txnEntry.getRecord("M");
            long l3 = txnEntry.getAmount("$", this.currency);
            if (l3 == 0L) {
                l3 = txnEntry.getAmount("T", this.currency);
            }
            char c = txnEntry.getStatus("C");
            boolean bl = false;
            boolean bl2 = false;
            if (string3.startsWith("[") && string3.endsWith("]")) {
                string3 = string3.substring(1, string3.length() - 1).trim();
                bl2 = true;
            }
            Account account2 = this.addNewAccount(string3, this.currency.getID(), this.rootAccount, "", bl ? 1 : (l3 < 0L ? 4 : 5), true, account.getAccountNum());
            int n2 = account2.getAccountNum();
            CurrencyType currencyType = this.currencyTable.getCurrencyType(account2.getCurrencyType());
            String string8 = "";
            if (d != 1.0 && d2 > 0.0) {
                string8 = "Purchase " + d2 + " shares";
            } else if (d != 1.0 && d2 < 0.0) {
                string8 = "Sell " + d2 + " shares";
            }
            d = CurrencyType.getXRelativeRate(currencyType, this.currency, 1.0);
            if (string4.toUpperCase().equals("SELLX")) {
                l3 *= -1L;
            }
            BankTransaction bankTransaction = new BankTransaction(-1L, n2, account.getAccountNum(), d, string6, l3, l, l, l, c, c, string4, null, ((string5 + "\n" + string7).trim() + '\n' + string8).trim());
            boolean bl3 = false;
            if (bl2) {
                int n3 = account.getAccountNum();
                n = bankTransaction.getAccountId(n3);
                object = this.rootAccount.getTransactionSet().getTransactionsForAccount(account).elements();
                while (object.hasMoreElements()) {
                    Transaction transaction = (Transaction)object.nextElement();
                    int n4 = transaction.getAccountId(n3);
                    if (n4 != n || l3 != transaction.getAmount(n3) || Math.abs(l - transaction.getDate()) > 46400000L || !transaction.getDescription().equals(bankTransaction.getDescription())) continue;
                    bl3 = true;
                    break;
                }
            }
            if (!bl3) {
                Transaction transaction = null;
                if (this.matchTransactions) {
                    transaction = this.matchTransaction(vector, bankTransaction, account.getAccountNum());
                }
                if (transaction == null) {
                    this.rootAccount.getTransactionSet().addNewTransaction(bankTransaction);
                } else if (transaction instanceof BankTransaction) {
                    object = (BankTransaction)transaction;
                    n = account.getAccountNum();
                    char c2 = ((Transaction)object).getClearedStatus(n);
                    if (c2 == ' ') {
                        ((Transaction)object).setClearedStatus(bankTransaction.getClearedStatus(n), n);
                    }
                    this.rootAccount.getTransactionSet().transactionModified((Transaction)object);
                }
            }
            string2 = bufferedReader.readLine();
        }
        return string2;
    }

    private final Transaction matchTransaction(Vector vector, BankTransaction bankTransaction, int n) {
        Transaction transaction;
        int n2;
        long l = bankTransaction.getDate();
        long l2 = bankTransaction.getAmount(n);
        String string = bankTransaction.getCheckNumber().trim();
        boolean bl = string.length() > 0;
        int n3 = 0;
        while (n3 < string.length()) {
            n2 = string.charAt(n3);
            if (n2 < 48 || n2 > 57) {
                bl = false;
                break;
            }
            ++n3;
        }
        Vector<Transaction> vector2 = new Vector<Transaction>();
        n2 = 0;
        while (n2 < vector.size()) {
            block14: {
                block16: {
                    block15: {
                        transaction = (Transaction)vector.elementAt(n2);
                        if (transaction.getDate() < l - 7776000000L || transaction.getDate() > l + 172800000L || transaction.getClearedStatus(n) != ' ') break block14;
                        if (!bl) break block15;
                        if (transaction instanceof BankTransaction && ((BankTransaction)transaction).getCheckNumber().trim().equals(string)) {
                            vector.removeElement(transaction);
                            return transaction;
                        }
                        break block14;
                    }
                    if (!(transaction instanceof BankTransaction)) break block16;
                    String string2 = ((BankTransaction)transaction).getCheckNumber().trim();
                    boolean bl2 = string2.length() > 0;
                    int n4 = 0;
                    while (n4 < string2.length()) {
                        char c = string2.charAt(n4);
                        if (c < '0' || c > '9') {
                            bl2 = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl2) break block14;
                }
                vector2.addElement(transaction);
            }
            ++n2;
        }
        if (bl) {
            return null;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            transaction = (Transaction)vector2.elementAt(n2);
            if (transaction.getAmount(n) != bankTransaction.getAmount(n)) {
                vector2.removeElementAt(n2);
                --n2;
            }
            ++n2;
        }
        if (vector2.size() > 0) {
            Transaction transaction2 = (Transaction)vector2.elementAt(0);
            vector.removeElement(transaction2);
            return transaction2;
        }
        return null;
    }

    private final Account addNewAccount(String string, String string2, Account account, String string3, int n, boolean bl, int n2) {
        String string4;
        String string5;
        int n3;
        if (string.indexOf(58) == 0 && account.getAccountType() == 0) {
            string = string.substring(1);
        }
        if ((n3 = string.indexOf(58)) >= 0) {
            string5 = string.substring(n3 + 1);
            string4 = string.substring(0, n3);
        } else {
            string5 = null;
            string4 = string;
        }
        Account account2 = null;
        int n4 = 0;
        while (n4 < account.getSubAccountCount()) {
            Account account3 = account.getSubAccount(n4);
            if (bl && account3.getAccountName().equals(string4) || account3.getAccountType() == n && account3.getAccountName().equals(string4)) {
                account2 = account3;
                break;
            }
            ++n4;
        }
        if (account2 == null) {
            if (n == 4) {
                account2 = new ExpenseAccount(string4, -1, string2, null, null, account);
            } else if (n == 5) {
                account2 = new IncomeAccount(string4, -1, string2, null, null, account);
            } else if (n == 1) {
                account2 = new BankAccount(string4, -1, string2, null, null, account, 0L);
                ((BankAccount)account2).setBankName(string3);
            } else if (n == 2) {
                account2 = new InvestmentAccount(string4, -1, string2, null, null, account, 0L);
                ((InvestmentAccount)account2).setAccountDescription(string3);
            }
            account.addSubAccount(account2);
        }
        if (string5 != null) {
            return this.addNewAccount(string5, string2, account2, string3, n, bl, n2);
        }
        if (account2.getAccountNum() == n2) {
            if (n == 4) {
                account2 = new ExpenseAccount(string4 + "X", -1, string2, null, null, account);
                account.addSubAccount(account2);
            } else if (n == 5) {
                account2 = new IncomeAccount(string4 + "X", -1, string2, null, null, account);
                account.addSubAccount(account2);
            } else if (n == 1) {
                if (account == this.rootAccount) {
                    account2 = new IncomeAccount(string4 + "X", -1, string2, null, null, account);
                } else {
                    account2 = new BankAccount(string4 + "X", -1, string2, null, null, account, 0L);
                    ((BankAccount)account2).setBankName(string3);
                }
                account.addSubAccount(account2);
            }
        }
        return account2;
    }

    private final String getValueForKey(String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string2.startsWith(string)) {
                stringBuffer.append("\n");
                stringBuffer.append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String readUpToSectionStart(BufferedReader bufferedReader) throws Exception {
        String string = "";
        while (string != null) {
            string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            if (!string.startsWith("!") && !string.toUpperCase().startsWith("TYPE:") && !string.toUpperCase().startsWith("ACCOUNT") && !string.toUpperCase().startsWith("OPTION:") && !string.toUpperCase().startsWith("AUTOSWITCH") && !string.toUpperCase().startsWith("CLEAR:")) continue;
            return string;
        }
        return string;
    }

    BankTxnEntry readBankTxn(BufferedReader bufferedReader, String string) throws Exception {
        if (string != null && (string.startsWith("^") || string.startsWith("!"))) {
            return null;
        }
        BankTxnEntry bankTxnEntry = null;
        while (string != null && !string.startsWith("^")) {
            if (bankTxnEntry == null) {
                QIFDataReader qIFDataReader = this;
                if (qIFDataReader == null) {
                    throw null;
                }
                bankTxnEntry = qIFDataReader.new BankTxnEntry();
            }
            bankTxnEntry.takeLine(string);
            string = bufferedReader.readLine();
        }
        return bankTxnEntry;
    }

    TxnEntry readBasicTxn(BufferedReader bufferedReader, String string) throws Exception {
        if (string != null && (string.startsWith("^") || string.startsWith("!"))) {
            return null;
        }
        TxnEntry txnEntry = null;
        while (string != null && !string.startsWith("^")) {
            if (txnEntry == null) {
                QIFDataReader qIFDataReader = this;
                if (qIFDataReader == null) {
                    throw null;
                }
                txnEntry = qIFDataReader.new TxnEntry();
            }
            txnEntry.takeLine(string);
            string = bufferedReader.readLine();
        }
        return txnEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long parseQuickenDate(String string, byte by) {
        string = string.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        char c = '/';
        block3 : switch (by) {
            case 1: 
            case 4: 
            case 7: {
                c = '/';
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                c = '-';
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                c = '.';
                break;
            }
            default: {
                int n = 0;
                while (n < string.length()) {
                    char c2 = string.charAt(n);
                    if (c2 < '0' || c2 > '9') {
                        c = c2;
                        if (c == '.') {
                            by = (byte)5;
                            break block3;
                        }
                        if (c == '-') {
                            by = (byte)3;
                            break block3;
                        }
                        by = 1;
                        break block3;
                    }
                    ++n;
                }
                break block3;
            }
        }
        if (by == 0 && Main.DEBUG) {
            System.err.println("had a hard time guessing date format for: " + string + " using default: MM" + c + "DD" + c + "YY");
        }
        switch (by) {
            case 4: 
            case 5: 
            case 6: {
                string3 = StringUtils.fieldIndex(string, c, 0).trim();
                string2 = StringUtils.fieldIndex(string, c, 1).trim();
                string4 = StringUtils.fieldIndex(string, c, 2).trim();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string4 = StringUtils.fieldIndex(string, c, 0).trim();
                string2 = StringUtils.fieldIndex(string, c, 1).trim();
                string3 = StringUtils.fieldIndex(string, c, 2).trim();
                break;
            }
            default: {
                string2 = StringUtils.fieldIndex(string, c, 0).trim();
                string3 = StringUtils.fieldIndex(string, c, 1).trim();
                string4 = StringUtils.fieldIndex(string, c, 2).trim();
                break;
            }
        }
        try {
            calendar.set(2, Integer.parseInt(string2) - 1);
        }
        catch (Exception exception) {
        }
        try {
            calendar.set(5, Integer.parseInt(string3));
        }
        catch (Exception exception) {
        }
        try {
            int n = Integer.parseInt(string4);
            if (n > 1800) {
                calendar.set(1, n);
                return calendar.getTime().getTime();
            }
            if (n < 50) {
                calendar.set(1, n + 2000);
                return calendar.getTime().getTime();
            }
            calendar.set(1, n + 1900);
            return calendar.getTime().getTime();
        }
        catch (Exception exception) {
        }
        return calendar.getTime().getTime();
    }

    /* synthetic */ byte access$0() {
        return this.dateFormat;
    }

    public QIFDataReader(RootAccount rootAccount, File file, CurrencyType currencyType, boolean bl, byte by) {
        this(rootAccount, file, currencyType, null, false, bl, by);
    }

    public QIFDataReader(RootAccount rootAccount, File file, CurrencyType currencyType, Account account, boolean bl, boolean bl2, byte by) {
        this.qifFile = file;
        this.rootAccount = rootAccount;
        this.currency = currencyType;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.accountToImportTo = account;
        this.matchTransactions = bl;
        this.accountsOnly = bl2;
        this.dateFormat = by;
    }

    class TxnEntry {
        private Hashtable records = new Hashtable();

        void setRecord(String string, String string2) {
            this.records.put(string, string2);
        }

        String getRecord(String string) {
            String string2 = (String)this.records.get(string);
            return string2 == null ? "" : string2;
        }

        long getAmount(String string, CurrencyType currencyType) {
            String string2 = this.getRecord(string);
            char c = StringUtils.guessDecimalType(string2);
            return StringUtils.parseCurrency(string2, c, currencyType.getDecimalPlaces());
        }

        double getRate(String string) {
            String string2 = this.getRecord(string);
            char c = StringUtils.guessDecimalType(string2);
            return StringUtils.parseRate(string2, c);
        }

        char getStatus(String string) {
            String string2 = this.getRecord(string).trim();
            if (string2.startsWith("x") || string2.startsWith("X")) {
                return 'X';
            }
            if (string2.startsWith("*")) {
                return 'x';
            }
            return ' ';
        }

        long getDate(String string) {
            return QIFDataReader.parseQuickenDate(this.getRecord(string), QIFDataReader.this.access$0());
        }

        void takeLine(String string) {
            if (string == null) {
                return;
            }
            if ((string = string.trim()).length() <= 0) {
                return;
            }
            this.setRecord(string.toUpperCase().substring(0, 1), string.substring(1));
        }

        TxnEntry() {
        }
    }

    class BankTxnEntry
    extends TxnEntry {
        private Vector splits = new Vector();

        int getNumSplits() {
            return this.splits.size();
        }

        TxnEntry getSplit(int n) {
            return (TxnEntry)this.splits.elementAt(n);
        }

        void takeLine(String string) {
            char c = '?';
            if ((string = string.trim()).length() <= 0) {
                return;
            }
            c = string.toUpperCase().charAt(0);
            switch (c) {
                case 'S': {
                    QIFDataReader qIFDataReader = QIFDataReader.this;
                    if (qIFDataReader == null) {
                        throw null;
                    }
                    TxnEntry txnEntry = qIFDataReader.new TxnEntry();
                    this.splits.addElement(txnEntry);
                    txnEntry.setRecord("S", string.substring(1).trim());
                    break;
                }
                case 'E': {
                    if (this.splits.size() > 0) {
                        ((TxnEntry)this.splits.elementAt(this.splits.size() - 1)).setRecord("E", string.substring(1).trim());
                        break;
                    }
                    System.err.println("QIF Import Error: record out of context: \"" + string + "\"");
                    break;
                }
                case '$': {
                    if (this.splits.size() > 0) {
                        ((TxnEntry)this.splits.elementAt(this.splits.size() - 1)).setRecord("$", string.substring(1).trim());
                        break;
                    }
                    System.err.println("QIF Import Error: record out of context: \"" + string + "\"");
                    break;
                }
                default: {
                    this.setRecord(String.valueOf(c), string.substring(1));
                    break;
                }
            }
        }

        BankTxnEntry() {
        }
    }
}

