/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model.io;

import com.seanreilly.apps.moneydance.controller.StatusMonitor;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.IncomeAccount;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.io.DataReader;
import com.seanreilly.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class OldDataReader
implements DataReader {
    private File rootDir;
    private Hashtable categories;
    private Hashtable incomeCategories;
    private boolean separateCategories = false;
    private ExpenseAccount defaultExpenseCategory = null;
    private IncomeAccount defaultIncomeCategory = null;
    private CurrencyType currency;
    private CurrencyTable currencyTable;
    private CurrencyType oldCurrency;
    private double decimalMult = 1.0;

    public RootAccount readAccountsFromFile(StatusMonitor statusMonitor) throws Exception {
        RootAccount rootAccount = new RootAccount(this.currency.getID(), this.currencyTable);
        this.readCategories(rootAccount, statusMonitor);
        String[] stringArray = this.rootDir.list();
        Vector<File> vector = new Vector<File>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toUpperCase().trim().endsWith(".REG")) {
                vector.addElement(new File(this.rootDir, stringArray[n]));
            }
            ++n;
        }
        n = 0;
        while (n < vector.size()) {
            this.loadAccountFromFile((File)vector.elementAt(n), statusMonitor, rootAccount);
            ++n;
        }
        return rootAccount;
    }

    private final void readCategories(RootAccount rootAccount, StatusMonitor statusMonitor) throws Exception {
        String string;
        this.categories = new Hashtable();
        this.incomeCategories = new Hashtable();
        File file = new File(this.rootDir, "category.tab");
        if (!file.exists()) {
            this.separateCategories = false;
            return;
        }
        this.separateCategories = true;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = bufferedReader.readLine();
        while ((string = bufferedReader.readLine()) != null) {
            Account account;
            int n = Integer.parseInt(StringUtils.fieldIndex(string, '\t', 0));
            String string3 = StringUtils.fieldIndex(string, '\t', 1);
            String string4 = StringUtils.fieldIndex(string, '\t', 2);
            boolean bl = false;
            boolean bl2 = false;
            bl = StringUtils.fieldIndex(string, '\t', 3).trim().equals("t");
            bl2 = StringUtils.fieldIndex(string, '\t', 4).trim().equals("d");
            Account account2 = rootAccount.getAccountByName(string3 = string3.trim(), 4);
            if (account2 == null) {
                account2 = new ExpenseAccount(string3, -1, this.currency.getID(), null, null, rootAccount);
                rootAccount.addSubAccount(account2);
            }
            int n2 = account2.getAccountNum();
            if ((string4 = string4.trim()).length() > 0) {
                account = account2.getAccountByName(string4, 4);
                if (account == null) {
                    account = new ExpenseAccount(string4, -1, this.currency.getID(), null, null, account2);
                    account2.addSubAccount(account);
                }
                n2 = account.getAccountNum();
            } else if (account2 instanceof ExpenseAccount) {
                account = (ExpenseAccount)account2;
                ((ExpenseAccount)account).setTaxable(bl);
                ((ExpenseAccount)account).setDeductible(bl2);
            }
            this.categories.put(new Integer(n), new Integer(n2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void loadAccountFromFile(File file, StatusMonitor statusMonitor, RootAccount rootAccount) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        String string = null;
        BankAccount bankAccount = new BankAccount(file.getName().substring(0, file.getName().length() - 4), -1, this.currency.getID(), new Hashtable(), new Vector(), rootAccount, 0L);
        rootAccount.addSubAccount(bankAccount);
        string = dataInputStream.readLine();
        if (string == null) return;
        if (StringUtils.fieldIndex(string, ' ', 0).equals("mdv1")) {
            String string2 = StringUtils.fieldIndex(string, ' ', 1);
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
            }
            this.readMDV1File(dataInputStream, n, rootAccount, statusMonitor, bankAccount);
            return;
        }
        if (!StringUtils.fieldIndex(string, ' ', 0).equals("mdv2")) throw new Exception(" Unknown file type: " + string + ", reading file \"" + file + "\"");
        String string3 = StringUtils.fieldIndex(string, ' ', 1);
        int n = -1;
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
        }
        this.readMDV2File(dataInputStream, n, rootAccount, statusMonitor, bankAccount);
    }

    private final void readMDV2File(DataInputStream dataInputStream, int n, RootAccount rootAccount, StatusMonitor statusMonitor, Account account) throws Exception {
        String string = null;
        while ((string = dataInputStream.readLine()) != null) {
            String string2;
            Object object;
            long l = Long.parseLong(StringUtils.fieldIndex(string, '\t', 0));
            long l2 = Long.valueOf(StringUtils.fieldIndex(string, '\t', 1));
            String string3 = StringUtils.fieldIndex(string, '\t', 2);
            String string4 = StringUtils.fieldIndex(string, '\t', 3);
            int n2 = Integer.parseInt(StringUtils.fieldIndex(string, '\t', 4));
            long l3 = Math.round(this.decimalMult * (double)Long.parseLong(StringUtils.fieldIndex(string, '\t', 5)));
            if (this.categories.containsKey(new Integer(n2))) {
                n2 = (Integer)this.categories.get(new Integer(n2));
                object = rootAccount.getAccountById(n2);
                if (l3 > 0L) {
                    Account account2;
                    Account account3 = ((Account)object).getParentAccount();
                    if (account3.getAccountNum() == rootAccount.getAccountNum()) {
                        account2 = rootAccount.getAccountByName(((Account)object).getAccountName(), 5);
                        if (account2 == null) {
                            account2 = new IncomeAccount(((Account)object).getAccountName(), -1, this.currency.getID(), null, null, rootAccount);
                            rootAccount.addSubAccount(account2);
                        }
                        object = account2;
                    } else {
                        Account account4;
                        account2 = rootAccount.getAccountByName(account3.getAccountName(), 5);
                        if (account2 == null) {
                            account2 = new IncomeAccount(account3.getAccountName(), -1, this.currency.getID(), null, null, rootAccount);
                            rootAccount.addSubAccount(account2);
                        }
                        if ((account4 = account2.getAccountByName(((Account)object).getAccountName(), 5)) == null) {
                            account4 = new IncomeAccount(((Account)object).getAccountName(), -1, this.currency.getID(), null, null, account2);
                            account2.addSubAccount(account4);
                        }
                        object = account4;
                    }
                    n2 = ((Account)object).getAccountNum();
                }
            } else if (l3 > 0L) {
                if (this.defaultIncomeCategory == null) {
                    this.defaultIncomeCategory = new IncomeAccount("???", -1, this.currency.getID(), null, null, rootAccount);
                    rootAccount.addSubAccount(this.defaultIncomeCategory);
                }
                n2 = this.defaultIncomeCategory.getAccountNum();
            } else {
                if (this.defaultExpenseCategory == null) {
                    this.defaultExpenseCategory = new ExpenseAccount("???", -1, this.currency.getID(), null, null, rootAccount);
                    rootAccount.addSubAccount(this.defaultExpenseCategory);
                }
                n2 = this.defaultExpenseCategory.getAccountNum();
            }
            object = StringUtils.fieldIndex(string, '\t', 6);
            char c = ' ';
            if (((String)object).length() > 0) {
                char c2 = ((String)object).charAt(0);
                if (c2 == 'X') {
                    c = 'X';
                } else if (c2 == 'x') {
                    c = 'x';
                }
            }
            long l4 = (string2 = StringUtils.fieldIndex(string, '\t', 7).trim()).trim().length() <= 0 ? l2 : Long.parseLong(string2);
            String string5 = StringUtils.decode(StringUtils.fieldIndex(string, '\t', 8));
            BankTransaction bankTransaction = new BankTransaction(-1L, n2, account.getAccountNum(), string4, l3, l2, l2, l4, c, c, string3, null, string5);
            this.readSplits(StringUtils.decode(StringUtils.fieldIndex(string, '\t', 9)), bankTransaction, account, rootAccount);
            if (bankTransaction.getSplitCount() > 0) {
                bankTransaction.setSourceAccountId(-1);
            }
            rootAccount.getTransactionSet().addNewTransaction(bankTransaction);
        }
    }

    private final void readSplits(String string, BankTransaction bankTransaction, Account account, RootAccount rootAccount) throws Exception {
        if (string == null || string.trim().length() <= 0) {
            return;
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector vector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().length() <= 0) continue;
            int n = Integer.parseInt(StringUtils.fieldIndex(string2, '\t', 0));
            String string3 = StringUtils.fieldIndex(string2, '\t', 1);
            int n2 = Integer.parseInt(StringUtils.fieldIndex(string2, '\t', 2));
            long l = Math.round(this.decimalMult * (double)Long.parseLong(StringUtils.fieldIndex(string2, '\t', 3)));
            if (this.categories.containsKey(new Integer(n2))) {
                n2 = (Integer)this.categories.get(new Integer(n2));
                object = rootAccount.getAccountById(n2);
                if (l > 0L) {
                    Account account2;
                    Account account3 = ((Account)object).getParentAccount();
                    if (account3.getAccountNum() == rootAccount.getAccountNum()) {
                        account2 = rootAccount.getAccountByName(((Account)object).getAccountName(), 5);
                        if (account2 == null) {
                            account2 = new IncomeAccount(((Account)object).getAccountName(), -1, this.currency.getID(), null, null, rootAccount);
                            rootAccount.addSubAccount(account2);
                        }
                        object = account2;
                    } else {
                        Account account4;
                        account2 = rootAccount.getAccountByName(account3.getAccountName(), 5);
                        if (account2 == null) {
                            account2 = new IncomeAccount(account3.getAccountName(), -1, this.currency.getID(), null, null, rootAccount);
                            rootAccount.addSubAccount(account2);
                        }
                        if ((account4 = account2.getAccountByName(((Account)object).getAccountName(), 5)) == null) {
                            account4 = new IncomeAccount(((Account)object).getAccountName(), -1, this.currency.getID(), null, null, account2);
                            account2.addSubAccount(account4);
                        }
                        object = account4;
                    }
                    n2 = ((Account)object).getAccountNum();
                }
            } else if (l > 0L) {
                if (this.defaultIncomeCategory == null) {
                    this.defaultIncomeCategory = new IncomeAccount("???", -1, this.currency.getID(), null, null, rootAccount);
                    rootAccount.addSubAccount(this.defaultIncomeCategory);
                }
                n2 = this.defaultIncomeCategory.getAccountNum();
            } else {
                if (this.defaultExpenseCategory == null) {
                    this.defaultExpenseCategory = new ExpenseAccount("???", -1, this.currency.getID(), null, null, rootAccount);
                    rootAccount.addSubAccount(this.defaultExpenseCategory);
                }
                n2 = this.defaultExpenseCategory.getAccountNum();
            }
            object = new SplitTransaction(-1L, n2, string3, l, bankTransaction.getDate(), bankTransaction.getDestClearedStatus(), bankTransaction);
            bankTransaction.addSplit((SplitTransaction)object);
            ((Transaction)object).resetDirty();
        }
    }

    private final void readMDV1File(DataInputStream dataInputStream, long l, RootAccount rootAccount, StatusMonitor statusMonitor, Account account) throws Exception {
        String string;
        while ((string = dataInputStream.readLine()) != null) {
            String string2;
            Object object;
            Account account2;
            if (string.trim().length() <= 0) continue;
            int n = Integer.parseInt(StringUtils.fieldIndex(string, '\t', 0));
            long l2 = Long.parseLong(StringUtils.fieldIndex(string, '\t', 1));
            String string3 = StringUtils.fieldIndex(string, '\t', 2);
            String string4 = StringUtils.fieldIndex(string, '\t', 3);
            String string5 = StringUtils.fieldIndex(string, '\t', 4);
            long l3 = Math.round(this.decimalMult * (double)Long.parseLong(StringUtils.fieldIndex(string, '\t', 5)));
            int n2 = string5.indexOf(58);
            String string6 = "";
            String string7 = "";
            if (n2 >= 0) {
                string6 = string5.substring(0, n2).trim();
                string7 = string5.substring(n2 + 1).trim();
            } else {
                string6 = string5;
            }
            if (l3 > 0L) {
                account2 = rootAccount.getAccountByName(string6, 5);
                if (account2 == null) {
                    account2 = new IncomeAccount(string6, -1, this.currency.getID(), null, null, rootAccount);
                    rootAccount.addSubAccount(account2);
                }
            } else {
                account2 = rootAccount.getAccountByName(string6, 4);
                if (account2 == null) {
                    account2 = new ExpenseAccount(string6, -1, this.currency.getID(), null, null, rootAccount);
                    rootAccount.addSubAccount(account2);
                }
            }
            int n3 = account2.getAccountNum();
            string7 = string7.trim();
            if (string7.length() > 0) {
                if (l3 > 0L) {
                    object = account2.getAccountByName(string7, 5);
                    if (object == null) {
                        object = new IncomeAccount(string7, -1, this.currency.getID(), null, null, account2);
                        account2.addSubAccount((Account)object);
                    }
                } else {
                    object = account2.getAccountByName(string7, 4);
                    if (object == null) {
                        object = new ExpenseAccount(string7, -1, this.currency.getID(), null, null, account2);
                        account2.addSubAccount((Account)object);
                    }
                }
                n3 = ((Account)object).getAccountNum();
            }
            object = StringUtils.fieldIndex(string, '\t', 6);
            char c = ' ';
            if (((String)object).length() > 0) {
                char c2 = ((String)object).charAt(0);
                if (c2 == 'X') {
                    c = 'X';
                } else if (c2 == 'x') {
                    c = 'x';
                }
            }
            long l4 = (string2 = StringUtils.fieldIndex(string, '\t', 7)).trim().length() <= 0 ? l2 : Math.round(this.decimalMult * (double)Long.parseLong(string2));
            BankTransaction bankTransaction = new BankTransaction(-1L, n3, account.getAccountNum(), string4, l3, l2, l2, l4, c, c, string3, null, "");
            rootAccount.getTransactionSet().addNewTransaction(bankTransaction);
        }
    }

    public OldDataReader(File file, CurrencyType currencyType, CurrencyTable currencyTable) {
        this.currency = currencyType;
        this.currencyTable = currencyTable;
        this.rootDir = file;
        this.decimalMult = Math.pow(10.0, currencyType.getDecimalPlaces() - 2);
    }
}

