/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model.io;

import com.seanreilly.apps.moneydance.controller.StatusMonitor;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.BasicReminder;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderSet;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionReminder;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import com.seanreilly.apps.moneydance.model.io.DataWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;

public class MDV5DataWriter
implements DataWriter {
    public static final int VERSION = 5;
    private File accountFile;

    public void writeAccountsToFile(RootAccount rootAccount, StatusMonitor statusMonitor) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.accountFile));
        dataOutputStream.writeUTF("MoNeYdAnCe DaTaStReAm");
        dataOutputStream.writeInt(5);
        statusMonitor.setStatus("Writing account info...");
        RootAccount rootAccount2 = rootAccount;
        synchronized (rootAccount2) {
            this.writeCurrencies(rootAccount, dataOutputStream);
            this.writeAccount(rootAccount, dataOutputStream);
            statusMonitor.setStatus("Writing transaction info...");
            this.writeTransactions(rootAccount, dataOutputStream);
            statusMonitor.setStatus("Writing reminders");
            this.writeReminders(rootAccount, dataOutputStream);
        }
        dataOutputStream.close();
    }

    private final void writeCurrencies(RootAccount rootAccount, DataOutputStream dataOutputStream) throws Exception {
        CurrencyTable currencyTable;
        CurrencyTable currencyTable2 = currencyTable = rootAccount.getCurrencyTable();
        synchronized (currencyTable2) {
            long l = currencyTable.getCurrencyCount();
            dataOutputStream.writeLong(l);
            long l2 = 0L;
            CurrencyType currencyType = currencyTable.getBaseType();
            this.writeCurrency(currencyType, dataOutputStream);
            ++l2;
            Enumeration enumeration = currencyTable.getAllValues();
            while (enumeration.hasMoreElements()) {
                CurrencyType currencyType2 = (CurrencyType)enumeration.nextElement();
                if (!currencyType2.getID().equals(currencyType.getID())) {
                    this.writeCurrency(currencyType2, dataOutputStream);
                }
                ++l2;
            }
            while (l2++ < l) {
                this.writeCurrency(new CurrencyType("???", "???", 1.0, 0, "", "", ""), dataOutputStream);
            }
        }
    }

    private final void writeCurrency(CurrencyType currencyType, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeUTF(currencyType.getID());
        dataOutputStream.writeUTF(currencyType.getName());
        dataOutputStream.writeDouble(currencyType.getRawRate());
        dataOutputStream.writeInt(currencyType.getDecimalPlaces());
        dataOutputStream.writeUTF(currencyType.getPrefix());
        dataOutputStream.writeUTF(currencyType.getSuffix());
        dataOutputStream.writeUTF(currencyType.getTickerSymbol());
    }

    private final void writeAccount(Account account, DataOutputStream dataOutputStream) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            if (account.getAccountType() == 0) {
                dataOutputStream.writeChar(114);
            } else if (account.getAccountType() == 4) {
                dataOutputStream.writeChar(101);
            } else if (account.getAccountType() == 5) {
                dataOutputStream.writeChar(105);
            } else if (account.getAccountType() == 3) {
                dataOutputStream.writeChar(99);
            } else if (account.getAccountType() == 1) {
                dataOutputStream.writeChar(98);
            } else if (account.getAccountType() == 2) {
                dataOutputStream.writeChar(118);
            } else {
                System.err.println("Got unidentified account: " + account + " acct type=" + account.getAccountType());
                dataOutputStream.writeChar(63);
            }
            dataOutputStream.writeUTF(account.getAccountName());
            dataOutputStream.writeInt(account.getAccountNum());
            dataOutputStream.writeUTF(account.getCurrencyType());
            dataOutputStream.writeLong(account.getStartBalance());
            int n = account.getParameterCount();
            dataOutputStream.writeInt(n);
            int n2 = 0;
            Enumeration enumeration = account.getParameterKeys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF(account.getParameter(string));
                ++n2;
            }
            while (n2 < n) {
                dataOutputStream.writeUTF("");
                dataOutputStream.writeUTF("");
                ++n2;
            }
            int n3 = account.getSubAccountCount();
            dataOutputStream.writeInt(n3);
            int n4 = 0;
            while (n4 < n3) {
                this.writeAccount(account.getSubAccount(n4), dataOutputStream);
                ++n4;
            }
        }
    }

    private final void writeReminders(RootAccount rootAccount, DataOutputStream dataOutputStream) throws Exception {
        ReminderSet reminderSet;
        ReminderSet reminderSet2 = reminderSet = rootAccount.getReminderSet();
        synchronized (reminderSet2) {
            dataOutputStream.writeLong(reminderSet.getReminderCount());
            Enumeration enumeration = reminderSet.getAllReminders();
            while (enumeration.hasMoreElements()) {
                this.writeReminder((Reminder)enumeration.nextElement(), dataOutputStream);
            }
        }
    }

    private final void writeReminder(Reminder reminder, DataOutputStream dataOutputStream) throws Exception {
        Reminder reminder2 = reminder;
        synchronized (reminder2) {
            int n = reminder.getReminderType();
            dataOutputStream.writeInt(n);
            dataOutputStream.writeLong(reminder.getId());
            dataOutputStream.writeUTF(reminder.getDescription());
            dataOutputStream.writeLong(reminder.getInitialDate());
            dataOutputStream.writeLong(reminder.getDateAcknowledged());
            dataOutputStream.writeLong(reminder.getLastDate());
            int[] nArray = reminder.getRepeatWeeklyDays();
            if (nArray == null) {
                nArray = new int[]{};
            }
            dataOutputStream.writeInt(nArray.length);
            int n2 = 0;
            while (n2 < nArray.length) {
                dataOutputStream.writeInt(nArray[n2]);
                ++n2;
            }
            dataOutputStream.writeInt(reminder.getRepeatWeeklyModifier());
            nArray = reminder.getRepeatMonthly();
            if (nArray == null) {
                nArray = new int[]{};
            }
            dataOutputStream.writeInt(nArray.length);
            n2 = 0;
            while (n2 < nArray.length) {
                dataOutputStream.writeInt(nArray[n2]);
                ++n2;
            }
            dataOutputStream.writeInt(reminder.getRepeatDaily());
            dataOutputStream.writeBoolean(reminder.getRepeatYearly());
            if (n == 0) {
                this.writeTransaction(((TransactionReminder)reminder).getTransaction(), dataOutputStream);
            } else if (n == 1) {
                dataOutputStream.writeUTF(((BasicReminder)reminder).getMemo());
            } else {
                throw new Exception("Invalid reminder type: " + n);
            }
        }
    }

    private final void writeTransactions(RootAccount rootAccount, DataOutputStream dataOutputStream) throws Exception {
        TransactionSet transactionSet;
        TransactionSet transactionSet2 = transactionSet = rootAccount.getTransactionSet();
        synchronized (transactionSet2) {
            dataOutputStream.writeLong(transactionSet.getTransactionCount());
            Enumeration enumeration = transactionSet.getAllTransactions();
            while (enumeration.hasMoreElements()) {
                this.writeTransaction((Transaction)enumeration.nextElement(), dataOutputStream);
            }
        }
    }

    private final void writeTransaction(Transaction transaction, DataOutputStream dataOutputStream) throws Exception {
        if (transaction instanceof BankTransaction) {
            dataOutputStream.writeInt(0);
            this.writeBankTransaction((BankTransaction)transaction, dataOutputStream);
        } else {
            dataOutputStream.writeInt(1);
        }
    }

    private final void writeBankTransaction(BankTransaction bankTransaction, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeLong(bankTransaction.getId());
        dataOutputStream.writeInt(bankTransaction.getSourceAccountId());
        dataOutputStream.writeInt(bankTransaction.getDestAccountId());
        dataOutputStream.writeUTF(bankTransaction.getDescription());
        dataOutputStream.writeChar(bankTransaction.getDestClearedStatus());
        dataOutputStream.writeChar(bankTransaction.getSourceClearedStatus());
        dataOutputStream.writeLong(bankTransaction.getAmount());
        dataOutputStream.writeLong(bankTransaction.getDate());
        dataOutputStream.writeLong(bankTransaction.getDateEntered());
        dataOutputStream.writeLong(bankTransaction.getTaxableDate());
        dataOutputStream.writeUTF(bankTransaction.getCheckNumber());
        dataOutputStream.writeUTF(bankTransaction.getMemo());
        dataOutputStream.writeDouble(bankTransaction.getRate());
        BankTransaction bankTransaction2 = bankTransaction;
        synchronized (bankTransaction2) {
            int n = bankTransaction.getSplitCount();
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                this.writeSplitTransaction(bankTransaction.getSplit(n2), dataOutputStream);
                ++n2;
            }
        }
    }

    private final void writeSplitTransaction(SplitTransaction splitTransaction, DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeLong(splitTransaction.getId());
        dataOutputStream.writeInt(splitTransaction.getSourceAccountId());
        dataOutputStream.writeDouble(splitTransaction.getRate());
        dataOutputStream.writeUTF(splitTransaction.getDescription());
        dataOutputStream.writeLong(splitTransaction.getAmount());
        dataOutputStream.writeChar(splitTransaction.getSourceClearedStatus());
    }

    public MDV5DataWriter(File file) {
        this.accountFile = file;
    }
}

