/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import java.util.Date;

public abstract class Transaction {
    public static final int BANK_TRANSACTION_TYPE = 0;
    public static final int SPLIT_TRANSACTION_TYPE = 1;
    protected long id;
    protected int sourceAccountId;
    protected double rate;
    protected int destAccountId;
    protected String description;
    protected long amount;
    protected char destClearedStatus;
    protected char sourceClearedStatus;
    protected long date;
    protected long dateEntered;
    protected boolean dirty;
    protected long destBalance = 0L;
    protected long srcBalance = 0L;

    public void resetDirty() {
        this.dirty = false;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long getDateEntered() {
        return this.dateEntered;
    }

    public long getId() {
        return this.id;
    }

    public synchronized void setId(long l) {
        if (this.id != l) {
            this.dirty = true;
        }
        this.id = l;
    }

    public boolean isInAccountRegister(int n) {
        return this.sourceAccountId == n || this.destAccountId == n;
    }

    public boolean affectsAccount(int n) {
        return this.isInAccountRegister(n);
    }

    public int getSourceAccountId() {
        return this.sourceAccountId;
    }

    public synchronized void setSourceAccountId(int n) {
        if (this.sourceAccountId != n) {
            this.dirty = true;
        }
        this.sourceAccountId = n;
    }

    public int getDestAccountId() {
        return this.destAccountId;
    }

    public synchronized void setDestAccountId(int n) {
        if (this.destAccountId != n) {
            this.dirty = true;
        }
        this.destAccountId = n;
    }

    public int getAccountId(int n) {
        if (this.destAccountId == n) {
            return this.sourceAccountId;
        }
        return this.destAccountId;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String string) {
        if (!this.description.equals(string)) {
            this.dirty = true;
        }
        this.description = string;
    }

    public double getRate() {
        return this.rate;
    }

    public double getRate(int n) {
        if (n == this.destAccountId) {
            return this.rate;
        }
        return 1.0 / this.rate;
    }

    public synchronized void setRate(double d) {
        if (this.rate != d) {
            this.dirty = true;
        }
        this.rate = d;
    }

    public long getAmount() {
        return this.amount;
    }

    public synchronized void setAmount(long l) {
        if (this.amount != l) {
            this.dirty = true;
        }
        this.amount = l;
    }

    public long getAmount(int n) {
        if (n != this.sourceAccountId) {
            return this.amount;
        }
        return Math.round((double)this.amount * this.rate * -1.0);
    }

    public long getAmount(int n, long l) {
        if (n != this.sourceAccountId) {
            this.destBalance = l + this.amount;
            return this.amount;
        }
        this.srcBalance = l + Math.round((double)this.amount * this.rate * -1.0);
        return Math.round((double)this.amount * this.rate * -1.0);
    }

    public long getBalance(int n) {
        if (n != this.sourceAccountId) {
            return this.destBalance;
        }
        return this.srcBalance;
    }

    public synchronized void setAmount(long l, int n) {
        if (n == this.destAccountId) {
            this.setAmount(l);
        } else {
            this.setAmount(Math.round((double)l / this.rate) * -1L);
        }
    }

    public long getDate() {
        return this.date;
    }

    public synchronized void setDate(long l) {
        if (this.date != l) {
            this.dirty = true;
        }
        this.date = l;
    }

    public char getDestClearedStatus() {
        return this.destClearedStatus;
    }

    public char getSourceClearedStatus() {
        return this.sourceClearedStatus;
    }

    public char getClearedStatus(int n) {
        if (n == this.destAccountId) {
            return this.destClearedStatus;
        }
        return this.sourceClearedStatus;
    }

    public synchronized void setClearedStatus(char c, int n) {
        if (n == this.destAccountId) {
            this.setDestClearedStatus(c);
        } else {
            this.setSourceClearedStatus(c);
        }
    }

    public synchronized void setDestClearedStatus(char c) {
        if (c != this.destClearedStatus) {
            this.dirty = true;
        }
        this.destClearedStatus = c;
    }

    public synchronized void setSourceClearedStatus(char c) {
        if (c != this.sourceClearedStatus) {
            this.dirty = true;
        }
        this.sourceClearedStatus = c;
    }

    public boolean needsToBePrinted() {
        return false;
    }

    public void takeValuesFrom(Transaction transaction) {
        this.setSourceAccountId(transaction.getSourceAccountId());
        this.setDestAccountId(transaction.getDestAccountId());
        this.setRate(transaction.getRate());
        this.setDescription(transaction.getDescription());
        this.setAmount(transaction.getAmount());
        this.setDate(transaction.getDate());
        this.setDestClearedStatus(transaction.getDestClearedStatus());
        this.setSourceClearedStatus(transaction.getSourceClearedStatus());
    }

    public String toString() {
        return "" + this.id + ' ' + this.description + ' ' + this.amount + ' ' + new Date(this.date);
    }

    public Transaction(long l, int n, int n2, String string, long l2, long l3, long l4, char c, char c2) {
        this(l, n, n2, 1.0, string, l2, l3, l4, c, c2);
    }

    public Transaction(long l, int n, int n2, double d, String string, long l2, long l3, long l4, char c, char c2) {
        this.id = l;
        this.sourceAccountId = n;
        this.destAccountId = n2;
        this.description = string;
        this.amount = l2;
        this.date = l3;
        this.dateEntered = l4;
        this.destClearedStatus = c;
        this.sourceClearedStatus = c2;
        this.rate = d;
        this.dirty = false;
    }
}

