/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;

public class SplitTransaction
extends Transaction {
    private BankTransaction parent;

    public void setDirty() {
        if (this.parent != null) {
            this.parent.setDirty();
        }
        super.setDirty();
    }

    public long getTaxableDate() {
        return this.parent.getTaxableDate();
    }

    public long getDate() {
        return this.parent.getDate();
    }

    public BankTransaction getParent() {
        return this.parent;
    }

    public void setParent(BankTransaction bankTransaction) {
        if (this.parent != bankTransaction) {
            this.setDirty();
        }
        this.parent = bankTransaction;
    }

    public void takeValuesFrom(SplitTransaction splitTransaction) {
        super.takeValuesFrom(splitTransaction);
        this.setParent(splitTransaction.getParent());
    }

    public int getAccountId(int n) {
        if (n == this.sourceAccountId) {
            return this.parent.getDestAccountId();
        }
        return this.sourceAccountId;
    }

    public boolean isInAccountRegister(int n) {
        return this.sourceAccountId == n;
    }

    public boolean affectsAccount(int n) {
        return this.sourceAccountId == n || this.parent.getDestAccountId() == n;
    }

    public SplitTransaction duplicate() {
        return new SplitTransaction(this.id, this.sourceAccountId, this.rate, this.description, this.amount, this.date, this.sourceClearedStatus, this.parent);
    }

    public SplitTransaction(long l, int n, String string, long l2, long l3, char c, BankTransaction bankTransaction) {
        this(l, n, 1.0, string, l2, l3, c, bankTransaction);
    }

    public SplitTransaction(long l, int n, double d, String string, long l2, long l3, char c, BankTransaction bankTransaction) {
        super(l, n, -1, d, string, l2, l3, bankTransaction.getDateEntered(), bankTransaction.getDestClearedStatus(), c);
        this.parent = bankTransaction;
    }
}

