/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

public class CurrencyType {
    private String id;
    private double rate;
    private int decimalPlaces;
    private String name;
    private String prefix;
    private String suffix;
    private String tickerSymbol;
    private boolean dirty = false;

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public double getRawRate() {
        return this.rate;
    }

    public void setTickerSymbol(String string) {
        if (!this.tickerSymbol.equals(string)) {
            this.tickerSymbol = string;
            this.dirty = true;
        }
    }

    public void setName(String string) {
        if (!string.equals(this.name)) {
            this.name = string;
            this.dirty = true;
        }
    }

    private final void setRawRate(double d) {
        if (d != this.rate) {
            this.rate = d;
            this.dirty = true;
        }
    }

    public double getXRelativeRate(CurrencyType currencyType) {
        return this.getXRelativeRate(currencyType.getDecimalPlaces());
    }

    public double getXRelativeRate(int n) {
        return this.rate * Math.pow(10.0, n - this.decimalPlaces);
    }

    public void setXRelativeRate(double d, CurrencyType currencyType) {
        this.setRawRate(d / Math.pow(10.0, currencyType.getDecimalPlaces() - this.decimalPlaces));
    }

    public static double getXRelativeRate(CurrencyType currencyType, CurrencyType currencyType2, double d) {
        return d * Math.pow(10.0, currencyType.getDecimalPlaces() - currencyType2.getDecimalPlaces());
    }

    public void setPrefix(String string) {
        if (!this.prefix.equals(string)) {
            this.prefix = string;
            this.dirty = true;
        }
    }

    public void setSuffix(String string) {
        if (!string.equals(this.suffix)) {
            this.suffix = string;
            this.dirty = true;
        }
    }

    public long convertValue(long l) {
        return Math.round((double)l * this.rate);
    }

    public long invertValue(long l) {
        return Math.round((double)l / this.rate);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirtyFlags() {
        this.dirty = false;
    }

    void convertToNewBase(CurrencyType currencyType) {
        this.setRawRate(this.rate / currencyType.getRawRate());
    }

    public String toString() {
        return this.id + ' ' + this.name;
    }

    public CurrencyType(String string, String string2, double d, int n, String string3, String string4, String string5) {
        this.id = string;
        this.name = string2;
        this.rate = d;
        this.decimalPlaces = n;
        this.prefix = string3;
        this.suffix = string4;
        this.tickerSymbol = string5;
    }
}

