/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import java.util.Vector;

public abstract class AccountUtil {
    public static final int DATE = 0;
    public static final int DATE_ENTERED = 1;
    public static final int DESCRIPTION = 2;
    public static final int AMOUNT = 3;
    public static final int STATUS = 4;
    public static final int ACCOUNT = 5;
    public static final int DATE_THEN_STATUS = 6;
    public static final int DATE_THEN_AMOUNT = 7;
    public static final int DATE_THEN_CHECKNUM = 8;
    public static final int CHECKNUM = 9;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;

    public static int insertSortedTransaction(Vector vector, Transaction transaction, int n, int n2, RootAccount rootAccount) {
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            Transaction transaction2 = (Transaction)vector.elementAt(n3);
            if (n == 0) {
                if (AccountUtil.compDateDateEntered(transaction2, transaction) <= 0) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 1) {
                if (AccountUtil.compDateEntered(transaction2, transaction) <= 0) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 2) {
                if (AccountUtil.compDescriptionDateEntered(transaction2, transaction) <= 0) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 5) {
                if (AccountUtil.compAccountDateEntered(transaction2, transaction, rootAccount, n2) <= 0) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 3) {
                if (AccountUtil.compAmount(transaction2, transaction, n2) <= 0L) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 7) {
                if (AccountUtil.compDateThenAmount(transaction2, transaction, n2) <= 0L) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 6) {
                if (AccountUtil.compDateThenStatus(transaction2, transaction, n2) <= 0) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 8) {
                if (AccountUtil.compDateCheckNum(transaction2, transaction) <= 0) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (n == 9) {
                if (AccountUtil.compCheckNumId(transaction2, transaction) <= 0) {
                    vector.insertElementAt(transaction, n3 + 1);
                    return n3 + 1;
                }
            } else if (AccountUtil.compStatus(transaction2, transaction, n2) <= 0) {
                vector.insertElementAt(transaction, n3 + 1);
                return n3 + 1;
            }
            --n3;
        }
        vector.insertElementAt(transaction, 0);
        if (Main.DEBUG) {
            AccountUtil.validateSort(vector, n, n2, rootAccount);
        }
        return 0;
    }

    public static long compAmount(Transaction transaction, Transaction transaction2, int n) {
        long l = transaction2.getAmount(n) - transaction.getAmount(n);
        return l == 0L ? (long)AccountUtil.compDateEntered(transaction, transaction2) : l;
    }

    public static long compDateThenAmount(Transaction transaction, Transaction transaction2, int n) {
        int n2 = AccountUtil.compDate(transaction, transaction2);
        return (int)(n2 == 0 ? AccountUtil.compAmount(transaction, transaction2, n) : (long)n2);
    }

    public static int compDateThenStatus(Transaction transaction, Transaction transaction2, int n) {
        int n2 = AccountUtil.compDate(transaction, transaction2);
        return n2 == 0 ? AccountUtil.compStatus(transaction, transaction2, n) : n2;
    }

    public static int compStatus(Transaction transaction, Transaction transaction2, int n) {
        int n2 = transaction.getClearedStatus(n) - transaction2.getClearedStatus(n);
        return n2 == 0 ? AccountUtil.compDateEntered(transaction, transaction2) : n2;
    }

    public static int compDescriptionDateEntered(Transaction transaction, Transaction transaction2) {
        int n = AccountUtil.compDescription(transaction, transaction2);
        return n == 0 ? AccountUtil.compDateEntered(transaction, transaction2) : n;
    }

    public static int compDescription(Transaction transaction, Transaction transaction2) {
        return transaction.getDescription().compareTo(transaction2.getDescription());
    }

    public static int compDateCheckNum(Transaction transaction, Transaction transaction2) {
        int n = AccountUtil.compDate(transaction, transaction2);
        return n == 0 ? AccountUtil.compCheckNumId(transaction, transaction2) : n;
    }

    public static int compDate(Transaction transaction, Transaction transaction2) {
        long l = transaction2.getDate() - transaction.getDate();
        if (l > 33200000L) {
            return -1;
        }
        if (l < -33200000L) {
            return 1;
        }
        return 0;
    }

    public static int compDateDateEntered(Transaction transaction, Transaction transaction2) {
        int n = AccountUtil.compDate(transaction, transaction2);
        if (n == 0) {
            return AccountUtil.compDateEntered(transaction, transaction2);
        }
        return n;
    }

    public static int compAccountDateEntered(Transaction transaction, Transaction transaction2, RootAccount rootAccount, int n) {
        String string = AccountUtil.getFullAccountName(rootAccount, transaction.getAccountId(n));
        return AccountUtil.compAccountDateEntered(string, transaction, transaction2, rootAccount, n);
    }

    public static int compAccountDateEntered(String string, Transaction transaction, Transaction transaction2, RootAccount rootAccount, int n) {
        String string2 = AccountUtil.getFullAccountName(rootAccount, transaction2.getAccountId(n));
        int n2 = string.compareTo(string2);
        return n2 == 0 ? AccountUtil.compDateEntered(transaction, transaction2) : n2;
    }

    public static int compDateEntered(Transaction transaction, Transaction transaction2) {
        long l;
        long l2 = transaction.getDateEntered();
        if (l2 < (l = transaction2.getDateEntered())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return (int)(transaction.getId() - transaction2.getId());
    }

    public static int compCheckNumId(Transaction transaction, Transaction transaction2) {
        int n;
        String string = "";
        String string2 = "";
        if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = AccountUtil.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            string = ((BankTransaction)transaction).getCheckNumber();
        }
        if (transaction2.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = AccountUtil.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            string2 = ((BankTransaction)transaction2).getCheckNumber();
        }
        return (n = string.compareTo(string2)) == 0 ? AccountUtil.compDateDateEntered(transaction, transaction2) : n;
    }

    public static int compId(Transaction transaction, Transaction transaction2) {
        long l;
        long l2 = transaction.getId();
        if (l2 < (l = transaction2.getId())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    public static boolean isTransactionSorted(int n, Transaction transaction, Vector vector, int n2, int n3, RootAccount rootAccount) {
        Transaction transaction2;
        boolean bl = true;
        if (n > 0) {
            transaction2 = (Transaction)vector.elementAt(n - 1);
            if (n3 == 0 ? AccountUtil.compDateDateEntered(transaction2, transaction) > 0 : (n3 == 1 ? AccountUtil.compDateEntered(transaction2, transaction) > 0 : (n3 == 2 ? AccountUtil.compDescriptionDateEntered(transaction2, transaction) > 0 : (n3 == 5 ? AccountUtil.compAccountDateEntered(transaction2, transaction, rootAccount, n2) > 0 : (n3 == 7 ? AccountUtil.compDateThenAmount(transaction2, transaction, n2) > 0L : (n3 == 6 ? AccountUtil.compDateThenStatus(transaction2, transaction, n2) > 0 : (n3 == 3 ? AccountUtil.compAmount(transaction2, transaction, n2) > 0L : (n3 == 8 ? AccountUtil.compDateCheckNum(transaction2, transaction) > 0 : (n3 == 9 ? AccountUtil.compCheckNumId(transaction2, transaction) > 0 : AccountUtil.compStatus(transaction2, transaction, n2) > 0))))))))) {
                return false;
            }
        }
        if (n < vector.size() - 1) {
            transaction2 = (Transaction)vector.elementAt(n + 1);
            if (n3 == 0 ? AccountUtil.compDateDateEntered(transaction2, transaction) < 0 : (n3 == 1 ? AccountUtil.compDateEntered(transaction2, transaction) < 0 : (n3 == 2 ? AccountUtil.compDescriptionDateEntered(transaction2, transaction) < 0 : (n3 == 5 ? AccountUtil.compAccountDateEntered(transaction2, transaction, rootAccount, n2) < 0 : (n3 == 7 ? AccountUtil.compDateThenAmount(transaction2, transaction, n2) < 0L : (n3 == 6 ? AccountUtil.compDateThenStatus(transaction2, transaction, n2) < 0 : (n3 == 3 ? AccountUtil.compAmount(transaction2, transaction, n2) < 0L : (n3 == 8 ? AccountUtil.compDateCheckNum(transaction2, transaction) < 0 : (n3 == 9 ? AccountUtil.compCheckNumId(transaction2, transaction) < 0 : AccountUtil.compStatus(transaction2, transaction, n2) < 0))))))))) {
                return false;
            }
        }
        return true;
    }

    private static final String getFullAccountName(RootAccount rootAccount, int n) {
        Account account = rootAccount.getAccountById(n);
        return account != null ? account.getFullAccountName() : "";
    }

    private static final Transaction getTxnAt(Vector vector, int n) {
        return (Transaction)vector.elementAt(n);
    }

    public static void sortTransactions(Vector vector, int n, int n2, RootAccount rootAccount) {
        AccountUtil.quicksortAscending(vector, n, n2, 0, vector.size() - 1, rootAccount);
        if (Main.DEBUG) {
            AccountUtil.validateSort(vector, n, n2, rootAccount);
        }
    }

    private static final void validateSort(Vector vector, int n, int n2, RootAccount rootAccount) {
        System.err.print("validating...");
        int n3 = 0;
        if (vector.size() <= 0) {
            return;
        }
        Transaction transaction = AccountUtil.getTxnAt(vector, 0);
        int n4 = 1;
        while (n4 < vector.size()) {
            boolean bl;
            Transaction transaction2 = AccountUtil.getTxnAt(vector, n4);
            switch (n) {
                case 0: {
                    bl = AccountUtil.compDateDateEntered(transaction, transaction2) <= 0;
                    break;
                }
                case 1: {
                    bl = AccountUtil.compDateEntered(transaction, transaction2) <= 0;
                    break;
                }
                case 2: {
                    bl = AccountUtil.compDescriptionDateEntered(transaction, transaction2) <= 0;
                    break;
                }
                case 5: {
                    bl = AccountUtil.compAccountDateEntered(transaction, transaction2, rootAccount, n2) <= 0;
                    break;
                }
                case 7: {
                    bl = AccountUtil.compDateThenAmount(transaction, transaction2, n2) <= 0L;
                    break;
                }
                case 6: {
                    bl = AccountUtil.compDateThenStatus(transaction, transaction2, n2) <= 0;
                    break;
                }
                case 3: {
                    bl = AccountUtil.compAmount(transaction, transaction2, n2) <= 0L;
                    break;
                }
                case 8: {
                    bl = AccountUtil.compDateCheckNum(transaction, transaction2) <= 0;
                    break;
                }
                case 9: {
                    bl = AccountUtil.compCheckNumId(transaction, transaction2) <= 0;
                    break;
                }
                default: {
                    boolean bl2 = bl = AccountUtil.compStatus(transaction, transaction2, n2) <= 0;
                }
            }
            if (!bl) {
                System.err.println("OUT OF ORDER: " + transaction + "         and: " + transaction2);
                ++n3;
            }
            transaction = transaction2;
            ++n4;
        }
        System.err.println(" " + n3 + " errors");
    }

    private static final void quicksortAscending(Vector vector, int n, int n2, int n3, int n4, RootAccount rootAccount) {
        if (n3 < n4) {
            int n5 = AccountUtil.partitionAscending(vector, n, n2, n3, n4, rootAccount);
            if (n5 - 1 - n3 > 1) {
                AccountUtil.quicksortAscending(vector, n, n2, n3, n5 - 1, rootAccount);
            }
            if (n4 - n5 > 1) {
                AccountUtil.quicksortAscending(vector, n, n2, n5, n4, rootAccount);
            }
        }
    }

    private static final int partitionAscending(Vector vector, int n, int n2, int n3, int n4, RootAccount rootAccount) {
        int n5 = (n4 - n3) / 2 + n3;
        Transaction transaction = AccountUtil.getTxnAt(vector, n5);
        int n6 = n3;
        int n7 = n4;
        while (true) {
            switch (n) {
                case 0: {
                    while (n7 >= n3 && AccountUtil.compDateDateEntered(AccountUtil.getTxnAt(vector, n7), transaction) > 0) {
                        --n7;
                    }
                    break;
                }
                case 1: {
                    while (n7 >= n3 && AccountUtil.compDateEntered(AccountUtil.getTxnAt(vector, n7), transaction) > 0) {
                        --n7;
                    }
                    break;
                }
                case 2: {
                    while (n7 >= n3 && AccountUtil.compDescriptionDateEntered(AccountUtil.getTxnAt(vector, n7), transaction) > 0) {
                        --n7;
                    }
                    break;
                }
                case 5: {
                    while (n7 >= n3 && AccountUtil.compAccountDateEntered(AccountUtil.getTxnAt(vector, n7), transaction, rootAccount, n2) > 0) {
                        --n7;
                    }
                    break;
                }
                case 7: {
                    while (n7 >= n3 && AccountUtil.compDateThenAmount(AccountUtil.getTxnAt(vector, n7), transaction, n2) > 0L) {
                        --n7;
                    }
                    break;
                }
                case 6: {
                    while (n7 >= n3 && AccountUtil.compDateThenStatus(AccountUtil.getTxnAt(vector, n7), transaction, n2) > 0) {
                        --n7;
                    }
                    break;
                }
                case 3: {
                    while (n7 >= n3 && AccountUtil.compAmount(AccountUtil.getTxnAt(vector, n7), transaction, n2) > 0L) {
                        --n7;
                    }
                    break;
                }
                case 8: {
                    while (n7 >= n3 && AccountUtil.compDateCheckNum(AccountUtil.getTxnAt(vector, n7), transaction) > 0) {
                        --n7;
                    }
                    break;
                }
                case 9: {
                    while (n7 >= n3 && AccountUtil.compCheckNumId(AccountUtil.getTxnAt(vector, n7), transaction) > 0) {
                        --n7;
                    }
                    break;
                }
                default: {
                    while (n7 >= n3 && AccountUtil.compStatus(AccountUtil.getTxnAt(vector, n7), transaction, n2) > 0) {
                        --n7;
                    }
                    break block0;
                }
            }
            switch (n) {
                case 0: {
                    while (n6 <= n4 && AccountUtil.compDateDateEntered(AccountUtil.getTxnAt(vector, n6), transaction) < 0) {
                        ++n6;
                    }
                    break;
                }
                case 1: {
                    while (n6 <= n4 && AccountUtil.compDateEntered(AccountUtil.getTxnAt(vector, n6), transaction) < 0) {
                        ++n6;
                    }
                    break;
                }
                case 2: {
                    while (n6 <= n4 && AccountUtil.compDescriptionDateEntered(AccountUtil.getTxnAt(vector, n6), transaction) < 0) {
                        ++n6;
                    }
                    break;
                }
                case 5: {
                    while (n6 <= n4 && AccountUtil.compAccountDateEntered(AccountUtil.getTxnAt(vector, n6), transaction, rootAccount, n2) < 0) {
                        ++n6;
                    }
                    break;
                }
                case 7: {
                    while (n6 <= n4 && AccountUtil.compDateThenAmount(AccountUtil.getTxnAt(vector, n6), transaction, n2) < 0L) {
                        ++n6;
                    }
                    break;
                }
                case 6: {
                    while (n6 <= n4 && AccountUtil.compDateThenStatus(AccountUtil.getTxnAt(vector, n6), transaction, n2) < 0) {
                        ++n6;
                    }
                    break;
                }
                case 3: {
                    while (n6 <= n4 && AccountUtil.compAmount(AccountUtil.getTxnAt(vector, n6), transaction, n2) < 0L) {
                        ++n6;
                    }
                    break;
                }
                case 8: {
                    while (n6 <= n4 && AccountUtil.compDateCheckNum(AccountUtil.getTxnAt(vector, n6), transaction) < 0) {
                        ++n6;
                    }
                    break;
                }
                case 9: {
                    while (n6 <= n4 && AccountUtil.compCheckNumId(AccountUtil.getTxnAt(vector, n6), transaction) < 0) {
                        ++n6;
                    }
                    break;
                }
                default: {
                    while (n6 <= n4 && AccountUtil.compStatus(AccountUtil.getTxnAt(vector, n6), transaction, n2) < 0) {
                        ++n6;
                    }
                    break block11;
                }
            }
            if (n6 >= n7) break;
            Object e = vector.elementAt(n6);
            vector.setElementAt(vector.elementAt(n7), n6);
            vector.setElementAt(e, n7);
        }
        return n7;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

