/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.AccountUtil;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import com.seanreilly.util.StringUtils;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Account {
    public static final int SPLIT_ACCOUNT_ID = -1;
    public static final int ACCOUNT_TYPE_ROOT = 0;
    public static final int ACCOUNT_TYPE_BANK = 1;
    public static final int ACCOUNT_TYPE_INVESTMENT = 2;
    public static final int ACCOUNT_TYPE_CREDIT_CARD = 3;
    public static final int ACCOUNT_TYPE_EXPENSE = 4;
    public static final int ACCOUNT_TYPE_INCOME = 5;
    public static final String INDENT_LEVEL = "   ";
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$RootAccount;
    private String accountName = null;
    private int accountNum = -1;
    private int accountType = 0;
    private Hashtable parameters = null;
    private Vector subAccounts = null;
    private Vector listeners = null;
    private Account parentAccount = null;
    private String currency = null;
    private long startBalance;
    private boolean dirty = false;

    public String[] getAllAccountNames() {
        String[] stringArray = new String[this.getDepth()];
        Account account = this;
        int n = stringArray.length - 1;
        while (n >= 0) {
            stringArray[n] = account.getAccountName();
            account = account.getParentAccount();
            --n;
        }
        return stringArray;
    }

    public String getFullAccountName() {
        String string = this.accountName;
        Account account = this.getParentAccount();
        if (account.getAccountType() == 0) {
            return string;
        }
        return this.getParentAccount().getFullAccountName() + ':' + string;
    }

    public long getStartBalance() {
        return this.startBalance;
    }

    public void setStartBalance(long l) {
        long l2 = this.startBalance;
        this.startBalance = l;
        if (l2 != this.startBalance) {
            this.dirty = true;
            this.notifyAccountModified(this);
        }
    }

    public String getCurrencyType() {
        return this.currency;
    }

    public void setCurrencyType(String string) {
        if (string == null || string.equals(this.currency)) {
            return;
        }
        if (this.accountNum >= 0 && this.getRootAccount().getTransactionSet().getTransactionsForAccount(this).size() > 0) {
            throw new IllegalStateException("cannot change the currency of non-empty account");
        }
        this.currency = string;
        this.dirty = true;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String string) {
        this.accountName = string;
        this.notifyAccountModified(this);
        this.dirty = true;
    }

    public int getAccountNum() {
        return this.accountNum;
    }

    void setAccountNum(int n) {
        this.accountNum = n;
        this.notifyAccountModified(this);
        this.dirty = true;
    }

    public int getAccountType() {
        return this.accountType;
    }

    public String getParameter(String string) {
        if (this.parameters != null) {
            return (String)this.parameters.get(string);
        }
        return null;
    }

    public String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public synchronized void setParameter(String string, String string2) {
        if (this.parameters == null) {
            this.parameters = new Hashtable();
        }
        this.parameters.put(string, string2);
        this.notifyAccountModified(this);
        this.dirty = true;
    }

    public int getParameterCount() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public Enumeration getParameterKeys() {
        if (this.parameters == null) {
            return new Hashtable().keys();
        }
        return this.parameters.keys();
    }

    public int getDepth() {
        int n = 0;
        Account account = this;
        while (account.getAccountType() != 0) {
            account = account.getParentAccount();
            ++n;
        }
        return n;
    }

    public Account[] getPath() {
        Vector<Account> vector = new Vector<Account>();
        vector.addElement(this);
        Account account = this;
        while (account.getAccountType() != 0) {
            vector.addElement(account);
            account = account.getParentAccount();
        }
        Account[] accountArray = new Account[vector.size()];
        int n = 0;
        while (n < accountArray.length) {
            accountArray[n] = (Account)vector.elementAt(n);
            ++n;
        }
        return accountArray;
    }

    public int getSubAccountCount() {
        if (this.subAccounts != null) {
            return this.subAccounts.size();
        }
        return 0;
    }

    public Account getSubAccount(int n) {
        return (Account)this.subAccounts.elementAt(n);
    }

    public int indexOf(Account account) {
        if (this.subAccounts == null) {
            return -1;
        }
        return this.subAccounts.indexOf(account);
    }

    public Enumeration getSubAccounts() {
        if (this.subAccounts == null) {
            return new Vector().elements();
        }
        return this.subAccounts.elements();
    }

    public Account getAccountByName(String string) {
        String string2 = null;
        String string3 = null;
        int n = -1;
        n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        if (string3.length() <= 0) {
            if (this.accountName.equals(string2) || this.accountType == 0 && string2.length() == 0) {
                return this;
            }
        } else {
            int n2 = 0;
            while (n2 < this.getSubAccountCount()) {
                Account account = this.getSubAccount(n2);
                Account account2 = account.getAccountByName(string3);
                if (account2 != null) {
                    return account2;
                }
                ++n2;
            }
        }
        return null;
    }

    public Account getAccountByName(String string, int n) {
        String string2 = null;
        String string3 = null;
        int n2 = -1;
        if (string.equals(this.accountName) && this.accountType != 0 && n == this.accountType) {
            return this;
        }
        if (this.accountType == 0) {
            string2 = "";
            string3 = string.startsWith(":") ? string.substring(1) : string;
        } else {
            n2 = string.indexOf(58);
            if (n2 >= 0) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
            } else {
                string3 = "";
                string2 = string;
            }
        }
        if (string3.length() <= 0) {
            if (this.accountName.equals(string2) && this.accountType == n || this.accountType == 0 && string2.length() == 0 && n == 0) {
                return this;
            }
        } else {
            Enumeration enumeration = this.getSubAccounts();
            while (enumeration.hasMoreElements()) {
                Account account = (Account)enumeration.nextElement();
                Account account2 = account.getAccountByName(string3, n);
                if (account2 == null) continue;
                return account2;
            }
        }
        return null;
    }

    public Account getParentAccount() {
        return this.parentAccount;
    }

    public void setParentAccount(Account account) {
        if (this.parentAccount != account || this.accountNum < 0) {
            Account account2 = this.parentAccount;
            if (account2 != null) {
                account2._removeSubAccount(this);
            }
            this.parentAccount = account;
            this.parentAccount.ensureHasSubAccount(this);
            this.notifyAccountModified(this);
            this.dirty = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNextCheckNumber() {
        TransactionSet transactionSet = this.getRootAccount().getTransactionSet();
        boolean bl = true;
        Vector<BankTransaction> vector = new Vector<BankTransaction>();
        long l = new Date().getTime() - 7776000000L;
        Object object = transactionSet.getAllTransactions();
        while (object.hasMoreElements()) {
            BankTransaction bankTransaction;
            String string;
            Transaction transaction = (Transaction)object.nextElement();
            if (transaction.getClass() != (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : Account.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) || !transaction.isInAccountRegister(this.accountNum) || !StringUtils.isInteger(string = (bankTransaction = (BankTransaction)transaction).getCheckNumber().trim()) || bankTransaction.getDate() <= l) continue;
            vector.addElement(bankTransaction);
        }
        if (vector.size() <= 0) {
            return "1";
        }
        AccountUtil.sortTransactions(vector, 0, this.accountNum, this.getRootAccount());
        object = (BankTransaction)vector.elementAt(vector.size() - 1);
        try {
            int n = Integer.parseInt(((BankTransaction)object).getCheckNumber().trim());
            int n2 = 0;
            while (true) {
                if (n2 >= vector.size()) {
                    return String.valueOf(n + 1);
                }
                try {
                    int n3 = Integer.parseInt(((BankTransaction)vector.elementAt(n2)).getCheckNumber());
                    if (n3 > n) {
                        n = n3;
                    }
                }
                catch (Exception exception) {
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return "1";
        }
    }

    public RootAccount getRootAccount() {
        Account account = this;
        while (account != null && account.getClass() != (class$Lcom$seanreilly$apps$moneydance$model$RootAccount != null ? class$Lcom$seanreilly$apps$moneydance$model$RootAccount : Account.class$("com.seanreilly.apps.moneydance.model.RootAccount"))) {
            account = account.getParentAccount();
        }
        return (RootAccount)account;
    }

    public String toString() {
        int n = this.getDepth();
        if (n <= 0) {
            return this.accountName;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(INDENT_LEVEL);
            ++n2;
        }
        return stringBuffer.toString() + this.accountName;
    }

    public boolean isRegisterAccount() {
        return this.accountType == 1 || this.accountType == 3 || this.accountType == 2;
    }

    protected void resetDirtyFlags() {
        this.dirty = false;
        Enumeration enumeration = this.getSubAccounts();
        while (enumeration.hasMoreElements()) {
            ((Account)enumeration.nextElement()).resetDirtyFlags();
        }
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        if (this.subAccounts != null) {
            Enumeration enumeration = this.subAccounts.elements();
            while (enumeration.hasMoreElements()) {
                if (!((Account)enumeration.nextElement()).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    protected synchronized void _removeSubAccount(Account account) {
        if (this.subAccounts == null) {
            return;
        }
        int n = 0;
        while (n < this.subAccounts.size()) {
            Account account2 = (Account)this.subAccounts.elementAt(n);
            if (account2.getAccountNum() == account.getAccountNum()) {
                this.subAccounts.removeElement(account2);
                break;
            }
            ++n;
        }
    }

    public synchronized void removeSubAccount(Account account, boolean bl) {
        if (this.subAccounts == null) {
            return;
        }
        int n = 0;
        while (n < this.subAccounts.size()) {
            Account account2 = (Account)this.subAccounts.elementAt(n);
            if (account2.getAccountNum() == account.getAccountNum()) {
                if (bl) {
                    account2.removeAllSubAccounts();
                }
                this.subAccounts.removeElement(account2);
                this.getRootAccount().deregisterAccount(account2);
                break;
            }
            ++n;
        }
        this.notifyAccountModified(this);
        this.getRootAccount().notifyAccountModified(this);
    }

    void removeAllSubAccounts() {
        while (this.subAccounts != null && this.subAccounts.size() > 0) {
            this.removeSubAccount((Account)this.subAccounts.elementAt(0), true);
        }
    }

    public synchronized void addSubAccount(Account account) {
        if (this.subAccounts == null) {
            this.subAccounts = new Vector();
        }
        RootAccount rootAccount = this.getRootAccount();
        if (this.subAccounts.contains(account)) {
            return;
        }
        if (account.getAccountNum() <= 0) {
            int n = rootAccount.getHighestAccountNum() + 1;
            if (n < 1) {
                n = 1;
            }
            account.setAccountNum(n);
        }
        rootAccount.registerAccount(account);
        this.subAccounts.addElement(account);
        account.setParentAccount(this);
        this.getRootAccount().notifyAccountModified(this);
        this.dirty = true;
    }

    public synchronized void ensureHasSubAccount(Account account) {
        if (this.subAccounts == null) {
            this.addSubAccount(account);
            return;
        }
        boolean bl = false;
        Enumeration enumeration = this.subAccounts.elements();
        while (enumeration.hasMoreElements()) {
            Account account2 = (Account)enumeration.nextElement();
            if (account2.getAccountNum() != account.getAccountNum()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.addSubAccount(account);
        }
        this.getRootAccount().registerAccount(account);
    }

    public synchronized int getHighestAccountNum() {
        int n = this.accountNum;
        if (this.subAccounts != null) {
            Enumeration enumeration = this.subAccounts.elements();
            while (enumeration.hasMoreElements()) {
                int n2 = ((Account)enumeration.nextElement()).getHighestAccountNum();
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public void addAccountListener(AccountListener accountListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(accountListener);
    }

    public void removeAccountListener(AccountListener accountListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(accountListener);
    }

    private final void notifyAccountModified() {
        this.notifyAccountModified(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyAccountModified(Account account) {
        if (this.listeners == null) {
            return;
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountListener)enumeration.nextElement()).accountModified(account);
            }
            catch (Exception exception) {
            }
        }
    }

    public synchronized void sortAccounts() {
        if (this.subAccounts == null || this.subAccounts.size() <= 0) {
            return;
        }
        this.quicksortAscending(0, this.subAccounts.size() - 1);
        this.notifyAccountModified();
    }

    public boolean containsTransaction(Transaction transaction, boolean bl, boolean bl2) {
        if (bl2 ? transaction.isInAccountRegister(this.accountNum) : transaction.affectsAccount(this.accountNum)) {
            return true;
        }
        if (bl) {
            Enumeration enumeration = this.getSubAccounts();
            while (enumeration.hasMoreElements()) {
                if (!((Account)enumeration.nextElement()).containsTransaction(transaction, bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }

    private final void quicksortAscending(int n, int n2) {
        if (n < n2) {
            int n3 = this.partitionAscending(n, n2);
            this.quicksortAscending(n, n3 - 1);
            this.quicksortAscending(n3, n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int partitionAscending(int var1_1, int var2_2) {
        var3_3 = (Account)this.subAccounts.elementAt((var1_1 + var2_2) / 2);
        ** GOTO lbl15
        {
            ++var1_1;
            do {
                if (((Account)this.subAccounts.elementAt(var1_1)).getAccountType() < var3_3.getAccountType() || ((Account)this.subAccounts.elementAt(var1_1)).getAccountType() == var3_3.getAccountType() && ((Account)this.subAccounts.elementAt(var1_1)).getAccountName().compareTo(var3_3.getAccountName()) < 0) continue block0;
                while (((Account)this.subAccounts.elementAt(var2_2)).getAccountType() > var3_3.getAccountType() || ((Account)this.subAccounts.elementAt(var2_2)).getAccountType() == var3_3.getAccountType() && ((Account)this.subAccounts.elementAt(var2_2)).getAccountName().compareTo(var3_3.getAccountName()) > 0) {
                    --var2_2;
                }
                if (var1_1 > var2_2) continue;
                var4_4 = (Account)this.subAccounts.elementAt(var1_1);
                this.subAccounts.setElementAt(this.subAccounts.elementAt(var2_2), var1_1);
                this.subAccounts.setElementAt(var4_4, var2_2);
                ++var1_1;
                --var2_2;
lbl15:
                // 3 sources

            } while (var1_1 <= var2_2);
        }
        return var1_1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Account(String string, int n, int n2, String string2, Hashtable hashtable, Vector vector, Account account, long l) {
        this.accountName = string;
        this.accountNum = n;
        this.accountType = n2;
        this.parameters = hashtable;
        this.currency = string2;
        this.parentAccount = account;
        this.startBalance = l;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.addSubAccount((Account)enumeration.nextElement());
            }
        }
        this.dirty = false;
    }
}

