/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.controller;

import com.seanreilly.apps.moneydance.controller.PreferencesListener;
import com.seanreilly.apps.moneydance.view.Resources;
import com.seanreilly.util.StreamTable;
import com.seanreilly.util.StreamVector;
import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserPreferences {
    public static final String GUI_ACCT_HEADER_FG = "gui.acct_header_fg";
    public static final String GUI_ACCT_HEADER_BG = "gui.acct_header_bg";
    public static final String GUI_TXN_LIST_C1 = "gui.txn_list_color1";
    public static final String GUI_TXN_LIST_C2 = "gui.txn_list_color2";
    public static final String GUI_TXN_EDIT_BG = "gui.txn_edit_bg";
    public static final String GUI_HOMEPG_BG = "gui.homepage_bg";
    public static final String GUI_TWO_LINE_TXNS = "gui.two_line_transactions";
    public static final String CONFIRM_TXN_CHANGES = "confirm_transaction_changes";
    public static final String CHECK_VERSION_AT_START = "check_version_at_startup";
    public static final String BEEP_ON_TXN_CHANGE = "beep_on_transaction_change";
    public static final String RESTORE_DESKTOP_AT_START = "restore_desktop_on_startup";
    public static final String DATE_FORMAT = "date_format";
    public static final String TIME_FORMAT = "time_format";
    public static final String LOCALE_COUNTRY = "locale.country";
    public static final String LOCALE_LANGUAGE = "locale.language";
    public static final String GUI_LOOK_AND_FEEL = "look_and_feel";
    public static final String DECIMAL_CHAR = "decimal_character";
    public static final String GUI_WINDOW_LOC = "gui.screen_location";
    public static final String GUI_WINDOW_SIZE = "gui.screen_size";
    public static final String SHOW_FULL_ACCT_PATH = "show_full_account_path";
    public static final String GUI_TXN_COL_WIDTHS = "gui.txn_column_widths";
    public static final String GUI_TXN_REC_COL_WIDTHS = "gui.reconciler_column_widths";
    public static final String GUI_GRAPH_SDATE = "gui.graph_start_date";
    public static final String GUI_GRAPH_EDATE = "gui.graph_end_date";
    public static final String GUI_GRAPH_SEL_ACCT = "gui.graph_selected_acct";
    public static final String GUI_GRAPH_TYPE = "gui.graph_type";
    public static final String GUI_GRAPH_STYLE = "gui.graph_style";
    public static final String GUI_GRAPH_DIMENSION = "gui.graph_dimension";
    public static final String GUI_GRAPH_DETAILEDKEY = "gui.graph_detailed_key";
    public static final String GUI_GRAPH_GROUP = "gui.graph_group";
    public static final String GUI_GRAPH_TOP_INCOME_SEL = "gui.graph_top_income_num";
    public static final String GUI_GRAPH_TOP_ACCTS_SEL = "gui.graph_top_accts_sel";
    public static final String GUI_REPORT_TYPE = "gui.report_type";
    public static final String GUI_TXNRPT_SDATE = "gui.txn_report_start_date";
    public static final String GUI_TXNRPT_EDATE = "gui.txn_report_end_date";
    public static final String GUI_TXNRPT_SUBT = "gui.txn_report_subtotal_by";
    public static final String GUI_TXNRPT_SEL_ACCT = "gui.txn_report_account";
    public static final String GUI_BALRPT_EDATE = "gui.bal_report_end_date";
    public static final String GUI_BALRPT_CURR = "gui.bal_report_currency";
    public static final String GUI_BALRPT_SHOWALL = "gui.bal_report_showall";
    public static final String GUI_COA_WIN_X = "gui.coa_window_x";
    public static final String GUI_COA_WIN_Y = "gui.coa_window_y";
    public static final String GUI_COA_WIN_W = "gui.coa_window_w";
    public static final String GUI_COA_WIN_H = "gui.coa_window_h";
    public static final String GUI_COA_WIN_ACTIVE = "gui.coa_window_isopen";
    public static final String GUI_SCREEN_SZ = "gui.screen_size";
    public static final String GUI_SCREEN_LOC = "gui.screen_location";
    public static final String GUI_SORT_ORDER = "gui.transaction_sort_order";
    public static final String GUI_COA_SHOW_ALL = "gui.coa_show_all_accounts";
    public static final String GUI_NEW_TRANSACTION_ON_RECORD = "gui.new_txn_on_record";
    public static final String SPLASH_DELAY = "splash_delay";
    public static final String GUI_EXPENSERPT_SDATE = "gui.expense_report_start_date";
    public static final String GUI_EXPENSERPT_EDATE = "gui.expense_report_end_date";
    public static final String GUI_SEEK_TXN_ON_RECORD = "gui.seek_txn_on_record";
    public static final String PRINT_DATELOC_X = "print.dateloc.x";
    public static final String PRINT_DATELOC_Y = "print.dateloc.y";
    public static final String PRINT_PAYEELOC_X = "print.payeeloc.x";
    public static final String PRINT_PAYEELOC_Y = "print.payeeloc.y";
    public static final String PRINT_MEMOLOC_X = "print.memoloc.x";
    public static final String PRINT_MEMOLOC_Y = "print.memoloc.y";
    public static final String PRINT_AMOUNTNUMLOC_X = "print.amountnumloc.x";
    public static final String PRINT_AMOUNTNUMLOC_Y = "print.amountnumloc.y";
    public static final String PRINT_AMOUNTTEXTLOC_X = "print.amounttextloc.x";
    public static final String PRINT_AMOUNTTEXTLOC_Y = "print.amounttextloc.y";
    public static final String PRINT_TOP_MARGIN = "print.top-margin";
    public static final String PRINT_BOTTOM_MARGIN = "print.bottom-margin";
    public static final String PRINT_LEFT_MARGIN = "print.left-margin";
    public static final String PRINT_RIGHT_MARGIN = "print.right-margin";
    public static final String SEEK_RECORDED_TXNS = "gui.register_follows_txns";
    public static final String PRINT_DEFAULT_FONT_SZ = "print.default_font_size";
    public static final String PRINT_DEFAULT_FONT_NM = "print.default_font_name";
    private Vector listeners;
    private StreamTable prefTable;
    private DateFormat shortDateFormatter = DateFormat.getDateInstance(3);
    private DateFormat longDateFormatter = DateFormat.getDateInstance(1);
    private NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
    private Resources myResources = null;

    public void addListener(PreferencesListener preferencesListener) {
        this.listeners.addElement(preferencesListener);
    }

    public void removeListener(PreferencesListener preferencesListener) {
        this.listeners.removeElement(preferencesListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void firePreferencesUpdated() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((PreferencesListener)enumeration.nextElement()).preferencesUpdated();
            }
            catch (Exception exception) {
                System.err.println("Exception notifying preference listeners: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public char getDecimalChar() {
        String string = this.getSetting(DECIMAL_CHAR, ".");
        if (string.length() > 0) {
            return string.charAt(0);
        }
        return '.';
    }

    public DateFormat getTimeFormatter() {
        return new SimpleDateFormat(this.getSetting(TIME_FORMAT, "h:mm a"));
    }

    public DateFormat getShortDateFormatter() {
        return new SimpleDateFormat(this.getSetting(DATE_FORMAT, "MM/dd/yyyy"));
    }

    public DateFormat getLongDateFormatter() {
        return this.shortDateFormatter;
    }

    public NumberFormat getCurrencyFormatter() {
        return this.currencyFormat;
    }

    public Vector getAvailableLocales() {
        Vector<Locale> vector = new Vector<Locale>();
        vector.addElement(Locale.US);
        vector.addElement(Locale.GERMANY);
        return vector;
    }

    public Locale getLocale() {
        return new Locale(this.getSetting(LOCALE_COUNTRY, "us"), this.getSetting(LOCALE_LANGUAGE, "EN"));
    }

    public Resources getResources() {
        return (Resources)ResourceBundle.getBundle("com.seanreilly.apps.moneydance." + "view.Resources", this.getLocale());
    }

    public void readSettings(File file) throws Exception {
        this.prefTable = new StreamTable();
        this.prefTable.readFromFile(file);
    }

    public void writeSettings(File file) throws Exception {
        this.prefTable.writeToFile(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIntSetting(String string, int n) {
        try {
            return Integer.parseInt(this.getSetting(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLongSetting(String string, long l) {
        try {
            return Long.parseLong(this.getSetting(string));
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String getSetting(String string, String string2) {
        Object object = this.prefTable.get(string);
        if (object == null || !(object instanceof String)) {
            return string2;
        }
        return (String)object;
    }

    public String getSetting(String string) {
        return this.getSetting(string, null);
    }

    public void setSetting(String string, String string2) {
        this.prefTable.put(string, string2);
    }

    public void setSetting(String string, long l) {
        this.prefTable.put(string, String.valueOf(l));
    }

    public void setSetting(String string, StreamTable streamTable) {
        this.prefTable.put(string, streamTable);
    }

    public void setSetting(String string, StreamVector streamVector) {
        this.prefTable.put(string, streamVector);
    }

    protected void initialize() {
        this.prefTable = new StreamTable();
        this.listeners = new Vector();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserPreferences(File file) {
        this.initialize();
        try {
            this.readSettings(file);
            return;
        }
        catch (Exception exception) {
        }
    }
}

