/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.controller;

import com.seanreilly.apps.moneydance.controller.Common;
import com.seanreilly.apps.moneydance.controller.LicenseInfo;
import com.seanreilly.apps.moneydance.controller.StatusMonitor;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.io.AccountUpgrader;
import com.seanreilly.apps.moneydance.model.io.FileUtils;
import com.seanreilly.apps.moneydance.model.io.QIFDataReader;
import com.seanreilly.apps.moneydance.model.io.QIFDataWriter;
import com.seanreilly.apps.moneydance.model.io.TabDelDataWriter;
import com.seanreilly.apps.moneydance.view.MoneydanceUI;
import com.seanreilly.apps.moneydance.view.Resources;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.SplashWindow;
import com.seanreilly.util.VersionVerifier;
import com.seanreilly.util.VersionVerifierCallback;
import java.io.File;
import javax.swing.JFrame;

public class Main
implements StatusMonitor,
VersionVerifierCallback {
    private static Main mainController = null;
    public static final String FILE_EXTENSION = "md";
    public static final String APPLICATION_NAME = "moneydance";
    public static final String DESCRIPTIVE_NAME = "Moneydance 2.0.3 (26)";
    public static final String CURRENT_VERSION = "2.0.3";
    public static final byte[] k1 = new byte[]{101, 99, 98, 99, 98, 100, 109, 103, 119, 110, 111, 109, 115};
    private static final double CURRENT_VERSION_NUM = 2.002;
    public static boolean DEBUG = false;
    private static String initialFile = null;
    private MoneydanceUI ui;
    private RootAccount currentAccount = null;
    private File currentAccountFile = null;
    private UserPreferences preferences = null;
    private SplashWindow splashWindow;
    private boolean silentlyCheckVersion = true;
    private LicenseInfo licenseInfo;

    public static Main getMainController() {
        return mainController;
    }

    public UserPreferences getPreferences() {
        return this.preferences;
    }

    public Resources getResources() {
        return this.getPreferences().getResources();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].trim();
            if (string.length() > 0) {
                if (string.startsWith("-")) {
                    if (string.equals("-d")) {
                        DEBUG = true;
                    } else if (string.equals("-v") || string.equals("-V") || string.equals("--version")) {
                        System.out.println(DESCRIPTIVE_NAME);
                        return;
                    }
                } else if (initialFile == null) {
                    initialFile = string;
                } else {
                    System.err.println("ignoring argument: " + string);
                }
            }
            ++n;
        }
        try {
            mainController = new Main();
            mainController.initialize();
            mainController.startApplication();
            mainController.checkVersion(true);
            return;
        }
        catch (Exception exception) {
            System.err.println("Unable to start moneydance: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() throws Exception {
        File file;
        this.licenseInfo = new LicenseInfo();
        if (!this.licenseInfo.isRegistered()) {
            System.err.println("This is an unregistered version of Moneydance.");
            System.err.println("To register please visit the following URL:");
            System.err.println("  http://seanreilly.com/java/moneydance/");
        }
        if (!(file = Common.getDataRootDirectory()).exists()) {
            if (!file.mkdirs()) {
                Common.setDataRootDirectory(null);
            }
            Common.setNewInstallation(true);
        }
        this.preferences = new UserPreferences(Common.getPreferencesFile());
        this.splashWindow = new SplashWindow(new JFrame(), "/com/seanreilly/apps/moneydance/images/splash.gif", -1);
        this.splashWindow.setVisible(true);
        this.setStatus(this.getResources().getString("loading..."));
        try {
            Thread.sleep(this.getPreferences().getIntSetting("splash_delay", 1000));
        }
        catch (Exception exception) {
        }
        String string = this.preferences.getSetting("current_version");
        if (string == null && !Common.isNewInstallation()) {
            RootAccount rootAccount;
            this.setStatus(this.getResources().getString("upgrading_data..."));
            AccountUpgrader accountUpgrader = new AccountUpgrader();
            this.currentAccount = rootAccount = accountUpgrader.getAccountInfo(this);
        }
        this.preferences.setSetting("current_version", CURRENT_VERSION);
    }

    public void checkVersion(boolean bl) {
        this.silentlyCheckVersion = bl;
        if (this.preferences.getSetting("check_version_at_startup", "n").equals("y")) {
            VersionVerifier versionVerifier = new VersionVerifier("seanreilly.com", APPLICATION_NAME, this, 2.002);
        }
    }

    public void userHasOldVersion(String string, String string2, String[] stringArray) {
        this.ui.showNeedToUpgradeAlert(string, string2, stringArray);
    }

    public void userHasCurrentVersion() {
        if (!this.silentlyCheckVersion) {
            this.ui.showInfoMessage(this.getResources().getString("have_most_recent_version"));
        }
    }

    public void errorCheckingVersion(String string) {
        if (!this.silentlyCheckVersion) {
            this.ui.showErrorMessage(this.getResources().getString("error_checking_version") + ": " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startApplication() {
        String string;
        this.ui = new MoneydanceGUI();
        if (this.currentAccount == null && this.currentAccountFile == null && initialFile != null) {
            try {
                this.currentAccountFile = new File(initialFile);
                this.currentAccount = FileUtils.readAccountsFromFile(this.currentAccountFile, this);
            }
            catch (Exception exception) {
                this.currentAccountFile = null;
                this.currentAccount = null;
            }
        } else if (this.currentAccount == null && this.currentAccountFile == null && this.preferences.getSetting("restore_desktop_on_startup", "y").equals("y") && (string = this.preferences.getSetting("current_account_file")) != null) {
            try {
                this.currentAccountFile = new File(string);
                this.currentAccount = FileUtils.readAccountsFromFile(this.currentAccountFile, this);
            }
            catch (Exception exception) {
                this.currentAccountFile = null;
                this.currentAccount = null;
            }
        }
        if (this.currentAccount != null) {
            this.ui.setCurrentAccount(this.currentAccount, this.currentAccountFile);
        }
        this.splashWindow.setVisible(false);
        this.splashWindow.dispose();
        this.splashWindow = null;
        this.ui.go();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCurrentAccount() {
        File file = this.currentAccountFile;
        if (file == null) {
            file = this.ui.askForAccountFileToSave();
        }
        if (file == null) {
            return;
        }
        try {
            FileUtils.writeAccountsToFile(this.currentAccount, file, this);
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace(System.err);
            }
            this.ui.showErrorMessage(this.getResources().getString("error_saving_file") + ": " + exception);
            return;
        }
        this.currentAccountFile = file;
    }

    public void setCurrentAccount(RootAccount rootAccount, File file) {
        this.currentAccount = rootAccount;
        this.currentAccountFile = file;
        if (this.ui != null) {
            this.ui.setCurrentAccount(this.currentAccount, this.currentAccountFile);
        }
    }

    public RootAccount getCurrentAccount() {
        return this.currentAccount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCurrentAccountAs() {
        File file = this.ui.askForAccountFileToSave();
        if (file == null) {
            return;
        }
        try {
            FileUtils.writeAccountsToFile(this.currentAccount, file, this);
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace(System.err);
            }
            this.ui.showErrorMessage(this.getResources().getString("error_saving_file") + ": " + exception);
            return;
        }
        this.currentAccountFile = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openAccountFile(File file) {
        try {
            this.currentAccount = FileUtils.readAccountsFromFile(file, this);
            this.currentAccountFile = file;
            this.setCurrentAccount(this.currentAccount, file);
            return;
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace(System.err);
            }
            this.ui.showErrorMessage(this.getResources().getString("error_opening_file") + ": " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        block3: {
            boolean bl = this.preferences.getSetting("save_workspace_on_exit", "yes").equals("yes");
            if (this.ui != null) {
                this.ui.shutdown(bl);
            }
            this.saveWorkSpace();
            try {
                this.preferences.writeSettings(Common.getPreferencesFile());
            }
            catch (Exception exception) {
                if (!DEBUG) break block3;
                System.err.println("Error saving settings: " + exception);
            }
        }
        System.exit(0);
    }

    public void saveWorkSpace() {
        if (this.currentAccountFile != null) {
            this.preferences.setSetting("current_account_file", this.currentAccountFile.getAbsolutePath());
        }
    }

    public void setPercentComplete(float f) {
        if (this.splashWindow != null) {
            this.splashWindow.setProgressValue((int)(f * 100.0f));
        }
    }

    public void setStatus(String string) {
        if (this.splashWindow != null) {
            this.splashWindow.setStatusText(string);
        }
    }

    public void importQIFIntoAccount(RootAccount rootAccount, File file, byte by, CurrencyType currencyType, Account account, boolean bl, boolean bl2) throws Exception {
        QIFDataReader qIFDataReader = new QIFDataReader(rootAccount, file, currencyType, account, bl, bl2, by);
        qIFDataReader.readTransactions(this);
    }

    public void importQIFIntoNewAccount(RootAccount rootAccount, File file, byte by, CurrencyType currencyType, boolean bl) throws Exception {
        QIFDataReader qIFDataReader = new QIFDataReader(rootAccount, file, currencyType, bl, by);
        qIFDataReader.readTransactions(this);
    }

    public void exportAllAccountsIntoQIF(RootAccount rootAccount, File file, CurrencyType currencyType) throws Exception {
        QIFDataWriter qIFDataWriter = new QIFDataWriter(rootAccount, file, currencyType);
        qIFDataWriter.writeAllAccounts();
    }

    public void exportAllAccountsIntoTD(RootAccount rootAccount, File file) throws Exception {
        TabDelDataWriter tabDelDataWriter = new TabDelDataWriter(rootAccount, file);
        tabDelDataWriter.writeAllAccounts();
    }
}

