package de.hawlitzek.util.text;
import java.util.*;

/**
 * This is a helper class for decoding String esp. URLs
 * 
 * @author Florian Hawlitzek, Hawlitzek IT-Consulting GmbH 
 */
public class StringDecoder {
	
	/**
	 * decode a URL with German umlauts
	 */
	public static String decodeUrl(String url) {
		String result = new String(url);
		// correct umlauts
		int index1 = result.indexOf("%C3%");
		while (index1>=0)
		{
			StringBuffer sb = new StringBuffer(result);
			sb.delete(index1+1, index1+4);
			char c = sb.charAt(index1+1);
			switch (c) {
				case 'A':
					c='E';
					break;
				case 'B':
					c='F';
					break;
				case '8':
					c='C';
					break;
				case '9':
					c='D';
					break;
			}
			sb.setCharAt(index1+1, c);
			result = sb.toString();
			index1 = result.indexOf("%C3%");
		}
		// decode url
		return java.net.URLDecoder.decode(result);
	}

	/**
	 * separation of a String into parts with delimiters plus and blank or enclosing quotes.
	 * parts within quotes are be left as found, others are lowercased.
	 * This method is used for identifying keywords in search string.
	 */
	public static String[] seperate(String searchString) {
		ArrayList results = new ArrayList();
		String tempToken = "";
		boolean startFlag = false;
		String grDelim = "\"";
		String blDelim = " ";		
		String trDelim = "+";			
		StringTokenizer tok = new StringTokenizer(searchString, grDelim + blDelim + trDelim, true);
		while (tok.hasMoreTokens())
		{
			String token = tok.nextToken();
			if (token.equals(grDelim)) {
				// ending quote
				if (startFlag) {
					startFlag = false;
					results.add(tempToken);
				}
				// starting quote				
				else {
					startFlag = true;
					tempToken = "";
				}
			}
			else if (token.equals(blDelim) || token.equals(trDelim)) {
				// blank or plus is only part of the part if quoted
				if (startFlag)
					tempToken = tempToken + blDelim;
			}
			else {
				if (startFlag)
					tempToken = tempToken + token;
				else
					results.add(token.trim().toLowerCase());
			}				
		}		
		String[] result	= new String[results.size()];
		result = (String[])results.toArray(result);
		return result;
	}	
}

