package de.hawlitzek.util.text;
/**
 * This class represents counted and named entries in a collection.
 * It provides base statistic functionality.  
 * 
 * @author Florian Hawlitzek, Hawlitzek IT-Consulting GmbH
 */
public class CountedEntry {
	protected String id;
	protected int nrOccurencesAbsolute;
	protected double nrOccurencesRelative;	

	/**
	 * Constructor
	 */
	 public CountedEntry(String id) {
	 	this.id = id;
	 	nrOccurencesAbsolute = 1;
	 }
	 
	 
	/**
	 * Gets the relative number of occurences (percentage)
	 * @return Returns a double
	 */
	public double getNrOccurencesRelative() {
		return nrOccurencesRelative;
	}
	/**
	 * Gets the relative number of occurences (percentage) as String
	 * @return Returns a double
	 */
	public String getNrOccurencesRelativeAsString() {
		java.math.BigDecimal rel = new java.math.BigDecimal(nrOccurencesRelative*100);
		rel = rel.setScale(2, java.math.BigDecimal.ROUND_HALF_UP);
		return rel.toString() + "%";
	}
	/**
	 * sets the relative number of occurences (percentage)
	 * @param nrOccurencesRelative The nrOccurencesRelative to set
	 */
	public void setNrOccurencesRelative(double nrOccurencesRelative) {
		this.nrOccurencesRelative = nrOccurencesRelative;
	}

	/**
	 * calculates the relative number of occurences (percentage)
	 * @param totalOccurences int
	 */
	public void calcNrOccurencesRelative(int totalOccurences) {
		this.nrOccurencesRelative = ((double)nrOccurencesAbsolute)/totalOccurences;
	}

	/**
	 * Gets the absolute number of occurences
	 * @return Returns a int
	 */
	public int getNrOccurencesAbsolute() {
		return nrOccurencesAbsolute;
	}
	/**
	 * Sets the absolute number of occurences
	 * @param nrOccurencesAbsolute The nrOccurencesAbsolute to set
	 */
	public void setNrOccurencesAbsolute(int nrOccurencesAbsolute) {
		this.nrOccurencesAbsolute = nrOccurencesAbsolute;
	}

	/**
	 * Adds one occurence to nrOccurencesAbsolute
	 */
	public void addAnzVorkommen() {
		this.nrOccurencesAbsolute++;
	}

	/**
	 * Gets the id
	 * @return Returns a String
	 */
	public String getId() {
		return id;
	}
	/**
	 * Sets the id
	 * @param id The id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

    public String toString()
    {
    	return id + " , Occurences: " + nrOccurencesAbsolute +
    		((nrOccurencesRelative>0.0)?(" (" + getNrOccurencesRelativeAsString() + ")"):"");
    }
}

