package de.hawlitzek.logparser.test;

import de.hawlitzek.logparser.*;
import de.hawlitzek.util.text.*;
import junit.framework.*;

public class BrowserEntryComparatorTest extends TestCase
{
	public static final String VERSION = "1.0";
	private BrowserEntry be1  	= new BrowserEntry("Testbrowser");
	private BrowserEntry be1a 	= new BrowserEntry("YYY");	
	private BrowserEntry be2 	= new BrowserEntry("ZZZ");	
	private CountedEntryComparator c = new 	CountedEntryComparator();
	
    public BrowserEntryComparatorTest(String test) 
    {
    	super(test);
    }
    
    public static Test suite()
    {
    	return new TestSuite(BrowserEntryComparatorTest.class);
    }
    
	protected void setUp()
	{
		be1.setNrOccurencesAbsolute(20);
		be1a.setNrOccurencesAbsolute(20);		
		be2.setNrOccurencesAbsolute(30);		
	}
	
	public void testEquals() 
	{
		int v = c.compare(be1, be1);
		assertTrue("Gleichheit", v==0);
	}
	
	public void testSameOcc() 
	{
		int v = c.compare(be1, be1a);
		int w = c.compare(be1a, be1);		
		assertTrue("Gleichheit", v==0);
		assertTrue("Symmetrie", v==-w);
	}

	public void testMore() 
	{
		int v = c.compare(be1, be2);
		int w = c.compare(be2, be1);		
		assertTrue("Grer: " + v, v>0);
		assertTrue("Symmetrie", v==-w);
	}

	public void testLess() 
	{
		int v = c.compare(be2, be1);
		int w = c.compare(be1, be2);		
		assertTrue("Kleiner: " + v, v<0);
		assertTrue("Symmetrie", v==-w);
	}
	
}

