package de.hawlitzek.logparser.gui;

import java.awt.*;
import javax.swing.*;
import de.hawlitzek.logparser.*;
/**
 * This is a simple frontend for the log analyzer.<br>
 * It is generated with IBM VisualAge for Java.
 * Please do not manually change this, but write me an email (java@hawlitzek-consulting.de).
 * 
 * @author Florian Hawlitzek, Hawlitzek IT-Consulting GmbH
 */
public class LogParser extends JFrame {

	/**
	 * thread class for starting the parser and updating the output fields and the status line
	 */
	class ParserThread implements Runnable {
        public void run() {
            try {
	            de.hawlitzek.logparser.FHDetailHttpLogParser parser = LogParser.this.getlogParserEngine();
	            if (parser != null)
	            {
		            java.io.File file = getFile();
		            if (file!=null)
		            {
			            // parse
			 			parser.readFile(file, getFilterType(), 
							de.hawlitzek.util.text.StringDecoder.seperate(getKeyWordsEntry().getText()));

			 			// which filter type?
			 			if (FHDetailHttpLogParser.isSearchEngineStats(getFilterType())) {
				 			// search engine stats
				 			getResultTextArea().setText(parser.getSearchEngineStats());
				 			getNotebookPanel().setTitleAt(NOTEBOOK_INDEX_RESULTSTATS, reslogparsergui.getString("GUI_Search_Engine_Results"));
			 			}
 			 			else {
			 				// page stats
				 			getResultTextArea().setText(parser.getPageStats());
				 			getNotebookPanel().setTitleAt(NOTEBOOK_INDEX_RESULTSTATS, reslogparsergui.getString("GUI_Page_Results"));				 			
 			 			}
 			 			// browser stats
			 			getAlphabeticBrowserTextArea().setText(parser.getBrowserStats(true));
			 			getFrequencyBrowserTextArea().setText(parser.getBrowserStats(false));			 			
		                getStatusMsg2().setText("Total access count: " + parser.getTotalOccurences() +
			                ", filtered: " + parser.getFilteredOccurences());			 			
		 				getNotebookPanel().setSelectedIndex(NOTEBOOK_INDEX_BROWSERSTATS);
			 			// client ip stats
				 		getClientIpResultTextArea().setText(parser.getIPStats());		 				
			 			// date stats
				 		getDateResultTextArea().setText(parser.getDateStats());		 				
		            }	
	            }
            } catch (Exception e) {
                getStatusMsg2().setText(e.getMessage());
            }
        }
    }
	private static final int NOTEBOOK_INDEX_BROWSERSTATS = 1;
	private static final int NOTEBOOK_INDEX_RESULTSTATS = 2;
	private ButtonGroup filterButtonGroup = new ButtonGroup();
	private JMenuItem ivjAbout_BoxMenuItem = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private JMenuItem ivjExitMenuItem = null;
	private JMenu ivjFileMenu = null;
	private JMenuItem ivjHelp_TopicsMenuItem = null;
	private JMenu ivjHelpMenu = null;
	private JPanel ivjJFrameContentPane = null;
	private JSeparator ivjJSeparator1 = null;
	private JMenuBar ivjLogParserJMenuBar = null;
	private JPanel ivjLogParserPane = null;
	private JMenuItem ivjOpenMenuItem = null;
	private JMenuItem ivjSaveMenuItem = null;
	private JPanel ivjStatusBarPane = null;
	private JLabel ivjStatusMsg2 = null;
	private JRadioButton ivjFilterHtmlMainRadioButton = null;
	private JRadioButton ivjFilterHtmlRadioButton = null;
	private JRadioButton ivjFilterImagesRadioButton = null;
	private JRadioButton ivjFilterReferrerRadioButton = null;
	private JTextField ivjKeyWordsEntry = null;
	private JLabel ivjKeyWordsLabel = null;
	private JButton ivjLogFileBrowseButton = null;
	private JTextField ivjLogFileEntry = null;
	private JLabel ivjLogFileLabel = null;
	private JTabbedPane ivjNotebookPanel = null;
	private JButton ivjParseButton = null;
	private JPanel ivjSettingPanel = null;
	private static java.util.ResourceBundle reslogparsergui = java.util.ResourceBundle.getBundle("logparsergui"); //$NON-NLS-1$;
	private JPanel ivjFilterPanel = null;
	private JRadioButton ivjFilterAllRadioButton = null;
	private FileDialog ivjFileOpenDialog = null;
	private FileDialog ivjFileSaveDialog = null;
	private InfoDialog ivjInfoDialog = null;
	private JPanel ivjResultPanel = null;
	private FHDetailHttpLogParser ivjlogParserEngine = null;
	private JTextArea ivjResultTextArea = null;
	private JLabel ivjAlphabeticBrowserLabel = null;
	private JPanel ivjAlphabeticBrowserPanel = null;
	private JTextArea ivjAlphabeticBrowserTextArea = null;
	private JPanel ivjBrowserResultPanel = null;
	private JSplitPane ivjBrowserStatsSplitPane = null;
	private JLabel ivjFrequencyBrowserLabel = null;
	private JPanel ivjFrequencyBrowserPanel = null;
	private JTextArea ivjFrequencyBrowserTextArea = null;
	private JScrollPane ivjJScrollPane2 = null;
	private JScrollPane ivjJScrollPane3 = null;

class IvjEventHandler implements java.awt.event.ActionListener {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (e.getSource() == LogParser.this.getExitMenuItem()) 
				connEtoM1(e);
			if (e.getSource() == LogParser.this.getLogFileBrowseButton()) 
				connEtoM2(e);
			if (e.getSource() == LogParser.this.getOpenMenuItem()) 
				connEtoM3(e);
			if (e.getSource() == LogParser.this.getSaveMenuItem()) 
				connEtoM4(e);
			if (e.getSource() == LogParser.this.getAbout_BoxMenuItem()) 
				connEtoM5(e);
			if (e.getSource() == LogParser.this.getParseButton()) 
				connEtoM6(e);
		};
	};
	private JPanel ivjClientIpResultPanel = null;
	private JTextArea ivjClientIpResultTextArea = null;
	private JScrollPane ivjClientIpScrollPane = null;
	private JPanel ivjDateResultPanel = null;
	private JTextArea ivjDateResultTextArea = null;
	private JScrollPane ivjDateScrollPane = null;
	private JScrollPane ivjResultScrollPane = null;
/**
 * LogParser constructor comment.
 */
public LogParser() {
	super();
	initialize();
}
/**
 * LogParser constructor comment.
 * @param title java.lang.String
 */
public LogParser(String title) {
	super(title);
}
/**
 * connEtoC1:  ( (LogFileBrowseButton,action.actionPerformed(java.awt.event.ActionEvent) --> FileOpenDialog,show()V).normalResult --> LogParser.setSelectedFile()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1() {
	try {
		// user code begin {1}
		// user code end
		this.setSelectedFile();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC2:  ( (ParseButton,action.actionPerformed(java.awt.event.ActionEvent) --> logParserEngine,FHDetailHttpLogParser()).normalResult --> LogParser.startParser(Lde.hawlitzek.logparser.FHDetailHttpLogParser;)V)
 * @param result de.hawlitzek.logparser.FHDetailHttpLogParser
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(de.hawlitzek.logparser.FHDetailHttpLogParser result) {
	try {
		// user code begin {1}
		// user code end
		this.startParser(result);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC3:  ( (OpenMenuItem,action.actionPerformed(java.awt.event.ActionEvent) --> FileOpenDialog,show()V).normalResult --> LogParser.setSelectedFile()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC3() {
	try {
		// user code begin {1}
		// user code end
		this.setSelectedFile();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM1:  (ExitMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> LogParser.dispose()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM1(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM2:  (LogFileBrowseButton.action.actionPerformed(java.awt.event.ActionEvent) --> FileDialog1.show()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM2(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getFileOpenDialog().show();
		connEtoC1();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM3:  (OpenMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> FileOpenDialog.show()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM3(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getFileOpenDialog().show();
		connEtoC3();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM4:  (SaveMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> FileSaveDialog.show()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM4(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getFileSaveDialog().show();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM5:  (About_BoxMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> InfoDialog.show()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM5(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getInfoDialog().show();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM6:  (ParseButton.action.actionPerformed(java.awt.event.ActionEvent) --> logParserEngine.FHDetailHttpLogParser())
 * @return de.hawlitzek.logparser.FHDetailHttpLogParser
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private de.hawlitzek.logparser.FHDetailHttpLogParser connEtoM6(java.awt.event.ActionEvent arg1) {
	de.hawlitzek.logparser.FHDetailHttpLogParser connEtoM6Result = null;
	try {
		// user code begin {1}
		// user code end
		connEtoM6Result = new de.hawlitzek.logparser.FHDetailHttpLogParser();
		setlogParserEngine(connEtoM6Result);
		connEtoC2(connEtoM6Result);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
	return connEtoM6Result;
}
/**
 * Return the About_BoxMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getAbout_BoxMenuItem() {
	if (ivjAbout_BoxMenuItem == null) {
		try {
			ivjAbout_BoxMenuItem = new javax.swing.JMenuItem();
			ivjAbout_BoxMenuItem.setName("About_BoxMenuItem");
			ivjAbout_BoxMenuItem.setText(reslogparsergui.getString("GUI_Help_About_Menuitem"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAbout_BoxMenuItem;
}
/**
 * Return the AlphabeticBrowserLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getAlphabeticBrowserLabel() {
	if (ivjAlphabeticBrowserLabel == null) {
		try {
			ivjAlphabeticBrowserLabel = new javax.swing.JLabel();
			ivjAlphabeticBrowserLabel.setName("AlphabeticBrowserLabel");
			ivjAlphabeticBrowserLabel.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjAlphabeticBrowserLabel.setText(reslogparsergui.getString("GUI_alphabetic"));
			ivjAlphabeticBrowserLabel.setForeground(java.awt.Color.black);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAlphabeticBrowserLabel;
}
/**
 * Return the AlphabeticBrowserPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getAlphabeticBrowserPanel() {
	if (ivjAlphabeticBrowserPanel == null) {
		try {
			ivjAlphabeticBrowserPanel = new javax.swing.JPanel();
			ivjAlphabeticBrowserPanel.setName("AlphabeticBrowserPanel");
			ivjAlphabeticBrowserPanel.setPreferredSize(new java.awt.Dimension(350, 231));
			ivjAlphabeticBrowserPanel.setLayout(new java.awt.GridBagLayout());
			ivjAlphabeticBrowserPanel.setMinimumSize(new java.awt.Dimension(1, 1));

			java.awt.GridBagConstraints constraintsAlphabeticBrowserLabel = new java.awt.GridBagConstraints();
			constraintsAlphabeticBrowserLabel.gridx = 0; constraintsAlphabeticBrowserLabel.gridy = 0;
			constraintsAlphabeticBrowserLabel.weightx = 0.01;
			constraintsAlphabeticBrowserLabel.weighty = 0.01;
			constraintsAlphabeticBrowserLabel.insets = new java.awt.Insets(4, 4, 4, 4);
			getAlphabeticBrowserPanel().add(getAlphabeticBrowserLabel(), constraintsAlphabeticBrowserLabel);

			java.awt.GridBagConstraints constraintsJScrollPane2 = new java.awt.GridBagConstraints();
			constraintsJScrollPane2.gridx = 0; constraintsJScrollPane2.gridy = 1;
			constraintsJScrollPane2.fill = java.awt.GridBagConstraints.BOTH;
			constraintsJScrollPane2.weightx = 1.0;
			constraintsJScrollPane2.weighty = 1.0;
			constraintsJScrollPane2.insets = new java.awt.Insets(4, 4, 4, 4);
			getAlphabeticBrowserPanel().add(getJScrollPane2(), constraintsJScrollPane2);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAlphabeticBrowserPanel;
}
/**
 * Return the AlphabeticBrowserTextArea property value.
 * @return javax.swing.JTextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextArea getAlphabeticBrowserTextArea() {
	if (ivjAlphabeticBrowserTextArea == null) {
		try {
			ivjAlphabeticBrowserTextArea = new javax.swing.JTextArea();
			ivjAlphabeticBrowserTextArea.setName("AlphabeticBrowserTextArea");
			ivjAlphabeticBrowserTextArea.setBounds(0, 0, 444, 186);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAlphabeticBrowserTextArea;
}
/**
 * Return the BrowserResultPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getBrowserResultPanel() {
	if (ivjBrowserResultPanel == null) {
		try {
			ivjBrowserResultPanel = new javax.swing.JPanel();
			ivjBrowserResultPanel.setName("BrowserResultPanel");
			ivjBrowserResultPanel.setPreferredSize(new java.awt.Dimension(420, 231));
			ivjBrowserResultPanel.setLayout(new java.awt.BorderLayout());
			getBrowserResultPanel().add(getBrowserStatsSplitPane(), "Center");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBrowserResultPanel;
}
/**
 * Return the BrowserStatsSplitPane property value.
 * @return javax.swing.JSplitPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JSplitPane getBrowserStatsSplitPane() {
	if (ivjBrowserStatsSplitPane == null) {
		try {
			ivjBrowserStatsSplitPane = new javax.swing.JSplitPane(javax.swing.JSplitPane.HORIZONTAL_SPLIT);
			ivjBrowserStatsSplitPane.setName("BrowserStatsSplitPane");
			ivjBrowserStatsSplitPane.setPreferredSize(new java.awt.Dimension(420, 231));
			ivjBrowserStatsSplitPane.setDividerLocation(350);
			getBrowserStatsSplitPane().add(getAlphabeticBrowserPanel(), "left");
			getBrowserStatsSplitPane().add(getFrequencyBrowserPanel(), "right");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBrowserStatsSplitPane;
}
/**
 * Return the ClientIpResultPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getClientIpResultPanel() {
	if (ivjClientIpResultPanel == null) {
		try {
			ivjClientIpResultPanel = new javax.swing.JPanel();
			ivjClientIpResultPanel.setName("ClientIpResultPanel");
			ivjClientIpResultPanel.setLayout(new java.awt.BorderLayout());
			getClientIpResultPanel().add(getClientIpScrollPane(), "Center");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjClientIpResultPanel;
}
/**
 * Return the ClientIpResultTextArea property value.
 * @return javax.swing.JTextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextArea getClientIpResultTextArea() {
	if (ivjClientIpResultTextArea == null) {
		try {
			ivjClientIpResultTextArea = new javax.swing.JTextArea();
			ivjClientIpResultTextArea.setName("ClientIpResultTextArea");
			ivjClientIpResultTextArea.setBounds(0, 0, 160, 120);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjClientIpResultTextArea;
}
/**
 * Return the ClientIpScrollPane property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getClientIpScrollPane() {
	if (ivjClientIpScrollPane == null) {
		try {
			ivjClientIpScrollPane = new javax.swing.JScrollPane();
			ivjClientIpScrollPane.setName("ClientIpScrollPane");
			getClientIpScrollPane().setViewportView(getClientIpResultTextArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjClientIpScrollPane;
}
/**
 * Return the DateResultPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getDateResultPanel() {
	if (ivjDateResultPanel == null) {
		try {
			ivjDateResultPanel = new javax.swing.JPanel();
			ivjDateResultPanel.setName("DateResultPanel");
			ivjDateResultPanel.setLayout(new java.awt.BorderLayout());
			getDateResultPanel().add(getDateScrollPane(), "Center");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjDateResultPanel;
}
/**
 * Return the DateResultTextArea property value.
 * @return javax.swing.JTextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextArea getDateResultTextArea() {
	if (ivjDateResultTextArea == null) {
		try {
			ivjDateResultTextArea = new javax.swing.JTextArea();
			ivjDateResultTextArea.setName("DateResultTextArea");
			ivjDateResultTextArea.setBounds(0, 0, 160, 120);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjDateResultTextArea;
}
/**
 * Return the DateScrollPane property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getDateScrollPane() {
	if (ivjDateScrollPane == null) {
		try {
			ivjDateScrollPane = new javax.swing.JScrollPane();
			ivjDateScrollPane.setName("DateScrollPane");
			getDateScrollPane().setViewportView(getDateResultTextArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjDateScrollPane;
}
/**
 * Return the ExitMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getExitMenuItem() {
	if (ivjExitMenuItem == null) {
		try {
			ivjExitMenuItem = new javax.swing.JMenuItem();
			ivjExitMenuItem.setName("ExitMenuItem");
			ivjExitMenuItem.setText(reslogparsergui.getString("GUI_File_Exit_MenuItem"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjExitMenuItem;
}
/**
 * Comment
 */
private java.io.File getFile() {
	// is http log file available?
	String filename = getLogFileEntry().getText();
	java.io.File file = new java.io.File(filename);
	if (file == null || !file.exists() || !file.canRead())
	{
		getStatusMsg2().setText(reslogparsergui.getString("GUI_Error_File_Access") + filename);
		return null;
	}
	return file;
}
/**
 * Return the FileMenu property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getFileMenu() {
	if (ivjFileMenu == null) {
		try {
			ivjFileMenu = new javax.swing.JMenu();
			ivjFileMenu.setName("FileMenu");
			ivjFileMenu.setText(reslogparsergui.getString("GUI_File_Menu"));
			ivjFileMenu.add(getOpenMenuItem());
			ivjFileMenu.add(getSaveMenuItem());
			ivjFileMenu.add(getJSeparator1());
			ivjFileMenu.add(getExitMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFileMenu;
}
/**
 * Return the FileDialog1 property value.
 * @return java.awt.FileDialog
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.FileDialog getFileOpenDialog() {
	if (ivjFileOpenDialog == null) {
		try {
			ivjFileOpenDialog = new java.awt.FileDialog(this);
			ivjFileOpenDialog.setName("FileOpenDialog");
			ivjFileOpenDialog.setLayout(null);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFileOpenDialog;
}
/**
 * Return the FileSaveDialog property value.
 * @return java.awt.FileDialog
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.FileDialog getFileSaveDialog() {
	if (ivjFileSaveDialog == null) {
		try {
			ivjFileSaveDialog = new java.awt.FileDialog(this);
			ivjFileSaveDialog.setName("FileSaveDialog");
			ivjFileSaveDialog.setLayout(null);
			ivjFileSaveDialog.setMode(java.awt.FileDialog.SAVE);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFileSaveDialog;
}
/**
 * Return the FilterNoneRadioButton property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getFilterAllRadioButton() {
	if (ivjFilterAllRadioButton == null) {
		try {
			ivjFilterAllRadioButton = new javax.swing.JRadioButton();
			ivjFilterAllRadioButton.setName("FilterAllRadioButton");
			ivjFilterAllRadioButton.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjFilterAllRadioButton.setText(reslogparsergui.getString("GUI_FilterAllRadioButton"));
			// user code begin {1}
			ivjFilterAllRadioButton.setActionCommand(LogEntryFilterTypes.ALL);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFilterAllRadioButton;
}
/**
 * Return the FilterHtmlMainRadioButton property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getFilterHtmlMainRadioButton() {
	if (ivjFilterHtmlMainRadioButton == null) {
		try {
			ivjFilterHtmlMainRadioButton = new javax.swing.JRadioButton();
			ivjFilterHtmlMainRadioButton.setName("FilterHtmlMainRadioButton");
			ivjFilterHtmlMainRadioButton.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjFilterHtmlMainRadioButton.setText(reslogparsergui.getString("GUI_FilterMainRadioButton"));
			// user code begin {1}
			ivjFilterHtmlMainRadioButton.setActionCommand(LogEntryFilterTypes.MAIN);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFilterHtmlMainRadioButton;
}
/**
 * Return the FilterHtmlRadioButton property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getFilterHtmlRadioButton() {
	if (ivjFilterHtmlRadioButton == null) {
		try {
			ivjFilterHtmlRadioButton = new javax.swing.JRadioButton();
			ivjFilterHtmlRadioButton.setName("FilterHtmlRadioButton");
			ivjFilterHtmlRadioButton.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjFilterHtmlRadioButton.setText(reslogparsergui.getString("GUI_FilterHtmlRadioButton"));
			// user code begin {1}
			ivjFilterHtmlRadioButton.setActionCommand(LogEntryFilterTypes.HTML);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFilterHtmlRadioButton;
}
/**
 * Return the FilterImagesRadioButton property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getFilterImagesRadioButton() {
	if (ivjFilterImagesRadioButton == null) {
		try {
			ivjFilterImagesRadioButton = new javax.swing.JRadioButton();
			ivjFilterImagesRadioButton.setName("FilterImagesRadioButton");
			ivjFilterImagesRadioButton.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjFilterImagesRadioButton.setText(reslogparsergui.getString("GUI_FilterImagesRadioButton"));
			// user code begin {1}
			ivjFilterImagesRadioButton.setActionCommand(LogEntryFilterTypes.IMG);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFilterImagesRadioButton;
}
/**
 * Return the JPanel1 property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getFilterPanel() {
	if (ivjFilterPanel == null) {
		try {
			ivjFilterPanel = new javax.swing.JPanel();
			ivjFilterPanel.setName("FilterPanel");
			ivjFilterPanel.setLayout(new java.awt.GridBagLayout());

			java.awt.GridBagConstraints constraintsFilterAllRadioButton = new java.awt.GridBagConstraints();
			constraintsFilterAllRadioButton.gridx = 0; constraintsFilterAllRadioButton.gridy = 0;
			constraintsFilterAllRadioButton.anchor = java.awt.GridBagConstraints.WEST;
			constraintsFilterAllRadioButton.insets = new java.awt.Insets(4, 4, 0, 4);
			getFilterPanel().add(getFilterAllRadioButton(), constraintsFilterAllRadioButton);

			java.awt.GridBagConstraints constraintsFilterHtmlRadioButton = new java.awt.GridBagConstraints();
			constraintsFilterHtmlRadioButton.gridx = 0; constraintsFilterHtmlRadioButton.gridy = 1;
			constraintsFilterHtmlRadioButton.anchor = java.awt.GridBagConstraints.WEST;
			constraintsFilterHtmlRadioButton.insets = new java.awt.Insets(4, 4, 0, 4);
			getFilterPanel().add(getFilterHtmlRadioButton(), constraintsFilterHtmlRadioButton);

			java.awt.GridBagConstraints constraintsFilterHtmlMainRadioButton = new java.awt.GridBagConstraints();
			constraintsFilterHtmlMainRadioButton.gridx = 1; constraintsFilterHtmlMainRadioButton.gridy = 1;
			constraintsFilterHtmlMainRadioButton.anchor = java.awt.GridBagConstraints.WEST;
			constraintsFilterHtmlMainRadioButton.insets = new java.awt.Insets(4, 4, 0, 4);
			getFilterPanel().add(getFilterHtmlMainRadioButton(), constraintsFilterHtmlMainRadioButton);

			java.awt.GridBagConstraints constraintsFilterImagesRadioButton = new java.awt.GridBagConstraints();
			constraintsFilterImagesRadioButton.gridx = 0; constraintsFilterImagesRadioButton.gridy = 2;
			constraintsFilterImagesRadioButton.anchor = java.awt.GridBagConstraints.WEST;
			constraintsFilterImagesRadioButton.insets = new java.awt.Insets(4, 4, 0, 4);
			getFilterPanel().add(getFilterImagesRadioButton(), constraintsFilterImagesRadioButton);

			java.awt.GridBagConstraints constraintsFilterReferrerRadioButton = new java.awt.GridBagConstraints();
			constraintsFilterReferrerRadioButton.gridx = 0; constraintsFilterReferrerRadioButton.gridy = 3;
			constraintsFilterReferrerRadioButton.gridwidth = 2;
			constraintsFilterReferrerRadioButton.anchor = java.awt.GridBagConstraints.WEST;
			constraintsFilterReferrerRadioButton.insets = new java.awt.Insets(4, 4, 0, 4);
			getFilterPanel().add(getFilterReferrerRadioButton(), constraintsFilterReferrerRadioButton);

			java.awt.GridBagConstraints constraintsKeyWordsLabel = new java.awt.GridBagConstraints();
			constraintsKeyWordsLabel.gridx = 0; constraintsKeyWordsLabel.gridy = 4;
			constraintsKeyWordsLabel.anchor = java.awt.GridBagConstraints.WEST;
			constraintsKeyWordsLabel.insets = new java.awt.Insets(15, 5, 5, 5);
			getFilterPanel().add(getKeyWordsLabel(), constraintsKeyWordsLabel);

			java.awt.GridBagConstraints constraintsKeyWordsEntry = new java.awt.GridBagConstraints();
			constraintsKeyWordsEntry.gridx = 1; constraintsKeyWordsEntry.gridy = 4;
			constraintsKeyWordsEntry.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsKeyWordsEntry.weightx = 1.0;
			constraintsKeyWordsEntry.insets = new java.awt.Insets(15, 4, 4, 4);
			getFilterPanel().add(getKeyWordsEntry(), constraintsKeyWordsEntry);
			// user code begin {1}
			ivjFilterPanel.setBorder(BorderFactory.createTitledBorder(
				null, reslogparsergui.getString("GUI_Filter"), 0, 2,  //$NON-NLS-1$
				new java.awt.Font("Dialog", 0, 13)));//$NON-NLS-1$
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFilterPanel;
}
/**
 * Return the FilterReferrerRadioButton property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getFilterReferrerRadioButton() {
	if (ivjFilterReferrerRadioButton == null) {
		try {
			ivjFilterReferrerRadioButton = new javax.swing.JRadioButton();
			ivjFilterReferrerRadioButton.setName("FilterReferrerRadioButton");
			ivjFilterReferrerRadioButton.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjFilterReferrerRadioButton.setText(reslogparsergui.getString("GUI_FilterReferrerRadioButton"));
			// user code begin {1}
			ivjFilterReferrerRadioButton.setActionCommand(LogEntryFilterTypes.REF);
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFilterReferrerRadioButton;
}
/**
 * Comment
 */
private String getFilterType() {
	ButtonModel bm = filterButtonGroup.getSelection();
	return bm.getActionCommand();
}
/**
 * Return the FrequencyBrowserLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getFrequencyBrowserLabel() {
	if (ivjFrequencyBrowserLabel == null) {
		try {
			ivjFrequencyBrowserLabel = new javax.swing.JLabel();
			ivjFrequencyBrowserLabel.setName("FrequencyBrowserLabel");
			ivjFrequencyBrowserLabel.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjFrequencyBrowserLabel.setText(reslogparsergui.getString("GUI_frequency"));
			ivjFrequencyBrowserLabel.setForeground(java.awt.Color.black);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFrequencyBrowserLabel;
}
/**
 * Return the FrequencyBrowserPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getFrequencyBrowserPanel() {
	if (ivjFrequencyBrowserPanel == null) {
		try {
			ivjFrequencyBrowserPanel = new javax.swing.JPanel();
			ivjFrequencyBrowserPanel.setName("FrequencyBrowserPanel");
			ivjFrequencyBrowserPanel.setPreferredSize(new java.awt.Dimension(350, 231));
			ivjFrequencyBrowserPanel.setLayout(new java.awt.GridBagLayout());
			ivjFrequencyBrowserPanel.setMinimumSize(new java.awt.Dimension(1, 1));

			java.awt.GridBagConstraints constraintsFrequencyBrowserLabel = new java.awt.GridBagConstraints();
			constraintsFrequencyBrowserLabel.gridx = 0; constraintsFrequencyBrowserLabel.gridy = 0;
			constraintsFrequencyBrowserLabel.weightx = 0.01;
			constraintsFrequencyBrowserLabel.weighty = 0.01;
			constraintsFrequencyBrowserLabel.insets = new java.awt.Insets(4, 4, 4, 4);
			getFrequencyBrowserPanel().add(getFrequencyBrowserLabel(), constraintsFrequencyBrowserLabel);

			java.awt.GridBagConstraints constraintsJScrollPane3 = new java.awt.GridBagConstraints();
			constraintsJScrollPane3.gridx = 0; constraintsJScrollPane3.gridy = 1;
			constraintsJScrollPane3.fill = java.awt.GridBagConstraints.BOTH;
			constraintsJScrollPane3.weightx = 1.0;
			constraintsJScrollPane3.weighty = 1.0;
			constraintsJScrollPane3.insets = new java.awt.Insets(4, 4, 4, 4);
			getFrequencyBrowserPanel().add(getJScrollPane3(), constraintsJScrollPane3);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFrequencyBrowserPanel;
}
/**
 * Return the FrequencyBrowserTextArea property value.
 * @return javax.swing.JTextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextArea getFrequencyBrowserTextArea() {
	if (ivjFrequencyBrowserTextArea == null) {
		try {
			ivjFrequencyBrowserTextArea = new javax.swing.JTextArea();
			ivjFrequencyBrowserTextArea.setName("FrequencyBrowserTextArea");
			ivjFrequencyBrowserTextArea.setBounds(0, 0, 444, 186);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFrequencyBrowserTextArea;
}
/**
 * Return the Help_TopicsMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getHelp_TopicsMenuItem() {
	if (ivjHelp_TopicsMenuItem == null) {
		try {
			ivjHelp_TopicsMenuItem = new javax.swing.JMenuItem();
			ivjHelp_TopicsMenuItem.setName("Help_TopicsMenuItem");
			ivjHelp_TopicsMenuItem.setText(reslogparsergui.getString("GUI_Help_Topis_MenuItem"));
			ivjHelp_TopicsMenuItem.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjHelp_TopicsMenuItem;
}
/**
 * Return the HelpMenu property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getHelpMenu() {
	if (ivjHelpMenu == null) {
		try {
			ivjHelpMenu = new javax.swing.JMenu();
			ivjHelpMenu.setName("HelpMenu");
			ivjHelpMenu.setText(reslogparsergui.getString("GUI_File_Help"));
			ivjHelpMenu.add(getHelp_TopicsMenuItem());
			ivjHelpMenu.add(getAbout_BoxMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjHelpMenu;
}
/**
 * Return the InfoDialog property value.
 * @return de.hawlitzek.logparser.gui.InfoDialog
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private InfoDialog getInfoDialog() {
	// user code begin {1}
	// user code end
	return ivjInfoDialog;
}
/**
 * Return the JFrameContentPane property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getJFrameContentPane() {
	if (ivjJFrameContentPane == null) {
		try {
			ivjJFrameContentPane = new javax.swing.JPanel();
			ivjJFrameContentPane.setName("JFrameContentPane");
			ivjJFrameContentPane.setLayout(new java.awt.BorderLayout());
			getJFrameContentPane().add(getStatusBarPane(), "South");
			getJFrameContentPane().add(getLogParserPane(), "Center");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJFrameContentPane;
}
/**
 * Return the JScrollPane2 property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getJScrollPane2() {
	if (ivjJScrollPane2 == null) {
		try {
			ivjJScrollPane2 = new javax.swing.JScrollPane();
			ivjJScrollPane2.setName("JScrollPane2");
			ivjJScrollPane2.setPreferredSize(new java.awt.Dimension(1000, 1000));
			getJScrollPane2().setViewportView(getAlphabeticBrowserTextArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJScrollPane2;
}
/**
 * Return the JScrollPane3 property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getJScrollPane3() {
	if (ivjJScrollPane3 == null) {
		try {
			ivjJScrollPane3 = new javax.swing.JScrollPane();
			ivjJScrollPane3.setName("JScrollPane3");
			ivjJScrollPane3.setPreferredSize(new java.awt.Dimension(1000, 1000));
			getJScrollPane3().setViewportView(getFrequencyBrowserTextArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJScrollPane3;
}
/**
 * Return the JSeparator1 property value.
 * @return javax.swing.JSeparator
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JSeparator getJSeparator1() {
	if (ivjJSeparator1 == null) {
		try {
			ivjJSeparator1 = new javax.swing.JSeparator();
			ivjJSeparator1.setName("JSeparator1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJSeparator1;
}
/**
 * Return the KeyWordsEntry property value.
 * @return javax.swing.JTextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextField getKeyWordsEntry() {
	if (ivjKeyWordsEntry == null) {
		try {
			ivjKeyWordsEntry = new javax.swing.JTextField();
			ivjKeyWordsEntry.setName("KeyWordsEntry");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyWordsEntry;
}
/**
 * Return the KeyWordsLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getKeyWordsLabel() {
	if (ivjKeyWordsLabel == null) {
		try {
			ivjKeyWordsLabel = new javax.swing.JLabel();
			ivjKeyWordsLabel.setName("KeyWordsLabel");
			ivjKeyWordsLabel.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjKeyWordsLabel.setText(reslogparsergui.getString("GUI_KeyWordsLabel"));
			ivjKeyWordsLabel.setForeground(java.awt.Color.black);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyWordsLabel;
}
/**
 * Return the LogFileBrowseButton property value.
 * @return javax.swing.JButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JButton getLogFileBrowseButton() {
	if (ivjLogFileBrowseButton == null) {
		try {
			ivjLogFileBrowseButton = new javax.swing.JButton();
			ivjLogFileBrowseButton.setName("LogFileBrowseButton");
			ivjLogFileBrowseButton.setText(reslogparsergui.getString("GUI_LogFileBrowseButton"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLogFileBrowseButton;
}
/**
 * Return the LogFileEntry property value.
 * @return javax.swing.JTextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextField getLogFileEntry() {
	if (ivjLogFileEntry == null) {
		try {
			ivjLogFileEntry = new javax.swing.JTextField();
			ivjLogFileEntry.setName("LogFileEntry");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLogFileEntry;
}
/**
 * Return the LogFileLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getLogFileLabel() {
	if (ivjLogFileLabel == null) {
		try {
			ivjLogFileLabel = new javax.swing.JLabel();
			ivjLogFileLabel.setName("LogFileLabel");
			ivjLogFileLabel.setFont(new java.awt.Font("sansserif", 0, 12));
			ivjLogFileLabel.setText(reslogparsergui.getString("GUI_log_file"));
			ivjLogFileLabel.setForeground(java.awt.Color.black);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLogFileLabel;
}
/**
 * Return the logParserEngine property value.
 * @return de.hawlitzek.logparser.FHDetailHttpLogParser
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private de.hawlitzek.logparser.FHDetailHttpLogParser getlogParserEngine() {
	// user code begin {1}
	// user code end
	return ivjlogParserEngine;
}
/**
 * Return the LogParserJMenuBar property value.
 * @return javax.swing.JMenuBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuBar getLogParserJMenuBar() {
	if (ivjLogParserJMenuBar == null) {
		try {
			ivjLogParserJMenuBar = new javax.swing.JMenuBar();
			ivjLogParserJMenuBar.setName("LogParserJMenuBar");
			ivjLogParserJMenuBar.add(getFileMenu());
			ivjLogParserJMenuBar.add(getHelpMenu());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLogParserJMenuBar;
}
/**
 * Return the LogParserPane property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getLogParserPane() {
	if (ivjLogParserPane == null) {
		try {
			ivjLogParserPane = new javax.swing.JPanel();
			ivjLogParserPane.setName("LogParserPane");
			ivjLogParserPane.setPreferredSize(new java.awt.Dimension(730, 480));
			ivjLogParserPane.setLayout(new java.awt.BorderLayout());
			getLogParserPane().add(getNotebookPanel(), "Center");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLogParserPane;
}
/**
 * Return the NotebookPanel property value.
 * @return javax.swing.JTabbedPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTabbedPane getNotebookPanel() {
	if (ivjNotebookPanel == null) {
		try {
			ivjNotebookPanel = new javax.swing.JTabbedPane();
			ivjNotebookPanel.setName("NotebookPanel");
			ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_Settings"), null, getSettingPanel(), null, 0);
			ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_BrowserResult"), null, getBrowserResultPanel(), null, 1);
			ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_Results"), null, getResultPanel(), null, 2);
			ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_IP_Results"), null, getClientIpResultPanel(), null, 3);
			ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_Date_Results"), null, getDateResultPanel(), null, 4);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNotebookPanel;
}
/**
 * Return the OpenMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getOpenMenuItem() {
	if (ivjOpenMenuItem == null) {
		try {
			ivjOpenMenuItem = new javax.swing.JMenuItem();
			ivjOpenMenuItem.setName("OpenMenuItem");
			ivjOpenMenuItem.setText(reslogparsergui.getString("GUI_File_Open_Menuitem"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjOpenMenuItem;
}
/**
 * Return the ParseButton property value.
 * @return javax.swing.JButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JButton getParseButton() {
	if (ivjParseButton == null) {
		try {
			ivjParseButton = new javax.swing.JButton();
			ivjParseButton.setName("ParseButton");
			ivjParseButton.setText(reslogparsergui.getString("GUI_ParseButton"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjParseButton;
}
/**
 * Return the ResultPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getResultPanel() {
	if (ivjResultPanel == null) {
		try {
			ivjResultPanel = new javax.swing.JPanel();
			ivjResultPanel.setName("ResultPanel");
			ivjResultPanel.setLayout(new java.awt.BorderLayout());
			getResultPanel().add(getResultScrollPane(), "Center");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjResultPanel;
}
/**
 * Return the JScrollPane1 property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getResultScrollPane() {
	if (ivjResultScrollPane == null) {
		try {
			ivjResultScrollPane = new javax.swing.JScrollPane();
			ivjResultScrollPane.setName("ResultScrollPane");
			getResultScrollPane().setViewportView(getResultTextArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjResultScrollPane;
}
/**
 * Return the JTextArea1 property value.
 * @return javax.swing.JTextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextArea getResultTextArea() {
	if (ivjResultTextArea == null) {
		try {
			ivjResultTextArea = new javax.swing.JTextArea();
			ivjResultTextArea.setName("ResultTextArea");
			ivjResultTextArea.setBounds(0, 0, 160, 120);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjResultTextArea;
}
/**
 * Return the SaveMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getSaveMenuItem() {
	if (ivjSaveMenuItem == null) {
		try {
			ivjSaveMenuItem = new javax.swing.JMenuItem();
			ivjSaveMenuItem.setName("SaveMenuItem");
			ivjSaveMenuItem.setText(reslogparsergui.getString("GUI_File_Save_Menuitem"));
			ivjSaveMenuItem.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSaveMenuItem;
}
/**
 * Return the SettingPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getSettingPanel() {
	if (ivjSettingPanel == null) {
		try {
			ivjSettingPanel = new javax.swing.JPanel();
			ivjSettingPanel.setName("SettingPanel");
			ivjSettingPanel.setLayout(new java.awt.GridBagLayout());

			java.awt.GridBagConstraints constraintsLogFileLabel = new java.awt.GridBagConstraints();
			constraintsLogFileLabel.gridx = 0; constraintsLogFileLabel.gridy = 0;
			constraintsLogFileLabel.anchor = java.awt.GridBagConstraints.WEST;
			constraintsLogFileLabel.insets = new java.awt.Insets(10, 5, 5, 5);
			getSettingPanel().add(getLogFileLabel(), constraintsLogFileLabel);

			java.awt.GridBagConstraints constraintsLogFileEntry = new java.awt.GridBagConstraints();
			constraintsLogFileEntry.gridx = 1; constraintsLogFileEntry.gridy = 0;
			constraintsLogFileEntry.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsLogFileEntry.anchor = java.awt.GridBagConstraints.WEST;
			constraintsLogFileEntry.weightx = 1.0;
			constraintsLogFileEntry.insets = new java.awt.Insets(10, 4, 4, 4);
			getSettingPanel().add(getLogFileEntry(), constraintsLogFileEntry);

			java.awt.GridBagConstraints constraintsLogFileBrowseButton = new java.awt.GridBagConstraints();
			constraintsLogFileBrowseButton.gridx = 2; constraintsLogFileBrowseButton.gridy = 0;
			constraintsLogFileBrowseButton.insets = new java.awt.Insets(10, 4, 4, 4);
			getSettingPanel().add(getLogFileBrowseButton(), constraintsLogFileBrowseButton);

			java.awt.GridBagConstraints constraintsFilterPanel = new java.awt.GridBagConstraints();
			constraintsFilterPanel.gridx = 0; constraintsFilterPanel.gridy = 1;
			constraintsFilterPanel.gridwidth = 3;
			constraintsFilterPanel.fill = java.awt.GridBagConstraints.BOTH;
			constraintsFilterPanel.weightx = 1.0;
			constraintsFilterPanel.weighty = 0.01;
			constraintsFilterPanel.insets = new java.awt.Insets(4, 4, 4, 4);
			getSettingPanel().add(getFilterPanel(), constraintsFilterPanel);

			java.awt.GridBagConstraints constraintsParseButton = new java.awt.GridBagConstraints();
			constraintsParseButton.gridx = 0; constraintsParseButton.gridy = 2;
			constraintsParseButton.gridwidth = 2;
			constraintsParseButton.anchor = java.awt.GridBagConstraints.NORTHWEST;
			constraintsParseButton.weighty = 1.0;
			constraintsParseButton.insets = new java.awt.Insets(4, 4, 4, 4);
			getSettingPanel().add(getParseButton(), constraintsParseButton);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSettingPanel;
}
/**
 * Return the StatusBarPane property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getStatusBarPane() {
	if (ivjStatusBarPane == null) {
		try {
			ivjStatusBarPane = new javax.swing.JPanel();
			ivjStatusBarPane.setName("StatusBarPane");
			ivjStatusBarPane.setLayout(new java.awt.BorderLayout());
			getStatusBarPane().add(getStatusMsg2(), "Center");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStatusBarPane;
}
/**
 * Return the StatusMsg2 property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getStatusMsg2() {
	if (ivjStatusMsg2 == null) {
		try {
			ivjStatusMsg2 = new javax.swing.JLabel();
			ivjStatusMsg2.setName("StatusMsg2");
			ivjStatusMsg2.setBorder(new javax.swing.border.EtchedBorder());
			ivjStatusMsg2.setText(" ");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStatusMsg2;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	setInfoDialog(new InfoDialog(this, de.hawlitzek.logparser.FHDetailHttpLogParser.VERSION));
	filterButtonGroup.add(getFilterAllRadioButton());
	filterButtonGroup.add(getFilterHtmlMainRadioButton());
	filterButtonGroup.add(getFilterHtmlRadioButton());
	filterButtonGroup.add(getFilterImagesRadioButton());
	filterButtonGroup.add(getFilterReferrerRadioButton());	
	getFilterAllRadioButton().setSelected(true);
	// user code end
	getExitMenuItem().addActionListener(ivjEventHandler);
	getLogFileBrowseButton().addActionListener(ivjEventHandler);
	getOpenMenuItem().addActionListener(ivjEventHandler);
	getSaveMenuItem().addActionListener(ivjEventHandler);
	getAbout_BoxMenuItem().addActionListener(ivjEventHandler);
	getParseButton().addActionListener(ivjEventHandler);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		setName("LogParser");
		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		setJMenuBar(getLogParserJMenuBar());
		setSize(750, 500);
		setTitle("LogParser");
		setContentPane(getJFrameContentPane());
		initConnections();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {2}
	// user code end
}
/**
 * Starts the application.
 * @param args an array of command-line arguments
 */
public static void main(java.lang.String[] args) {
	try {
		/* Set native look and feel */
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		/* Create the frame */
		LogParser aLogParser = new LogParser();

		/* Calculate the screen size */
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

		/* Pack frame on the screen */
		aLogParser.pack();

		/* Center frame on the screen */
		Dimension frameSize = aLogParser.getSize();
		if (frameSize.height > screenSize.height)
				frameSize.height = screenSize.height;
		if (frameSize.width > screenSize.width)
				frameSize.width = screenSize.width;
		aLogParser.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);

		/* Add a windowListener for the windowClosedEvent */
		aLogParser.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosed(java.awt.event.WindowEvent e) {
				System.exit(0);
			};
		});
		aLogParser.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of LogParser");
		exception.printStackTrace(System.out);
	}
}
/**
 * Set the InfoDialog to a new value.
 * @param newValue de.hawlitzek.logparser.gui.InfoDialog
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void setInfoDialog(InfoDialog newValue) {
	if (ivjInfoDialog != newValue) {
		try {
			ivjInfoDialog = newValue;
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	// user code begin {3}
	// user code end
}
/**
 * Set the logParserEngine to a new value.
 * @param newValue de.hawlitzek.logparser.FHDetailHttpLogParser
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void setlogParserEngine(de.hawlitzek.logparser.FHDetailHttpLogParser newValue) {
	if (ivjlogParserEngine != newValue) {
		try {
			ivjlogParserEngine = newValue;
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	// user code begin {3}
	// user code end
}
/**
 * sets the log file by reading the selected dile and directory
 */
public void setSelectedFile() {
	String dir = getFileOpenDialog().getDirectory();
	if (dir!=null)
	{
		String file = getFileOpenDialog().getFile();
		if (file != null)
		{
			file = dir + file;
			getLogFileEntry().setText(file);
		}
	}
}
/**
 * starts the parser in a new thread
 */
public void startParser(de.hawlitzek.logparser.FHDetailHttpLogParser parser) {
	// reset status
	getStatusMsg2().setText("Parsing...");
	
	Thread parserThread = new Thread(new ParserThread());
	parserThread.start();

	
}
public void viewStatusBar() {
	/* Hide or show the statusbar */
	getStatusBarPane().setVisible(!(getStatusBarPane().isVisible()));
}
}
