package de.hawlitzek.logparser;

/**
 * This exceptions represents an invalid format for a log file.
 * E.g. it could occur, if the file you are parsing is no log file or
 * a log file of a unsupported format.
 * 
 * @author Florian Hawlitzek, Hawlitzek IT-Consulting GmbH
 */
public class InvalidLogEntryException extends Exception {
/**
 * InvalidLogEntryException constructor comment.
 */
public InvalidLogEntryException() {
	super();
}
/**
 * InvalidLogEntryException constructor comment.
 * @param s java.lang.String
 */
public InvalidLogEntryException(String s) {
	super(s);
}
/**
 * returns the error message
 * @return java.lang.String
 */
public String getMessage() {
	String msg = super.getMessage();
	if (msg == null)
		return "This file is no log file or has an unsupported format";
	else return msg;
}
}
