package de.hawlitzek.logparser;
import de.hawlitzek.util.text.*;
/**
 * This class represents the entries of a collection of browser infos in the http log.
 * It also contains a method to identify the browser type out of the browser info.
 * It is derived from CountedEntry provides statistic base functionality.  
 * 
 * @author Florian Hawlitzek, Hawlitzek IT-Consulting GmbH
 */
public class BrowserEntry extends CountedEntry {
	/**
	 * Constructor
	 */
	 public BrowserEntry(String browser) {
	 	super(browser);
	 }
	 
	/**
	 * provides the browser type for the given browser info in the http log.
	 * Subtypes like MSIE 5.5.1 und 5.5.3 are being summarized.
	 */
	public static String getBrowserType(String browserInfo) {
		String browser = new String(browserInfo);
		int posO = browser.indexOf("Opera");
		if (posO >= 0)	{
			browser = "Opera";
		}
		posO = browser.indexOf("Konqueror");
		if (posO >= 0)	{
			browser = "Konqueror";
		}
			
		int pos = browser.indexOf("compatible;") ;
		if (pos >=0 && browser.startsWith("Mozilla/4.0"))
		{
			java.util.StringTokenizer tok = new java.util.StringTokenizer(browser, ";)");
			String typ = tok.nextToken();
			if (tok.hasMoreTokens())
			browser = tok.nextToken().trim();
				
			// Internet Explorer
			int posIE = browser.indexOf("MSIE");
			if (posIE >= 0)
			{
				if (browser.indexOf("5.0")>=0 || browser.indexOf("5.1")>=0 || browser.indexOf("5.2")>=0)
					browser = "MSIE 5.0/1/2";
				else if (browser.indexOf("5.5")>=0)
					browser = "MSIE 5.5";
				else if (browser.indexOf("6.0")>=0)
					browser = "MSIE 6.0";
				else if (browser.indexOf("4.")>=0)
					browser = "MSIE 4.x";
				else if (browser.indexOf("3.")>=0)
					browser = "MSIE 3.x";
			}
		}
		else if (browser.indexOf("Mozilla/4.") >=0)
			browser = "Netscape 4.x";
		else if (browser.indexOf("Mozilla/5.") >=0)
		{
			int posN = browser.indexOf("Netscape");
			if (posN >= 0)
			{
				if (browser.charAt(posN+8)=='6')
					browser = "Netscape 6.x";
				else if (browser.charAt(posN+9)=='7')
					browser = "Netscape 7.x";
				else if (browser.charAt(posN+9)=='7')
					browser = "Netscape 7.x";
			}
			else
				browser = "Mozilla/5";
		}	
		else if (browser.indexOf("Mozilla/3.") >=0 && browser.indexOf("compatible;")==-1)
			browser = "Netscape 3.x";
		else if (browser.indexOf("Mozilla/6.") >=0)
			browser = "Netscape 6.x";;
		
		return browser;
	}
	 

	/**
	 * Gets the browser
	 * @return Returns a String
	 */
	public String getBrowser() {
		return getId();
	}
	/**
	 * Sets the browser
	 * @param browser The browser to set
	 */
	public void setBrowser(String browser) {
		setId(browser);
	}

    public String toString()
    {
    	return id + " , Access count: " + nrOccurencesAbsolute +
    		((nrOccurencesRelative>0.0)?(" (" + getNrOccurencesRelativeAsString() + ")"):"");
    }
}

