/*
 * Decompiled with CFR 0.152.
 */
package de.hawlitzek.util.text;

import java.math.BigDecimal;

public class CountedEntry {
    protected String id;
    protected int nrOccurencesAbsolute;
    protected double nrOccurencesRelative;

    public CountedEntry(String id) {
        this.id = id;
        this.nrOccurencesAbsolute = 1;
    }

    public double getNrOccurencesRelative() {
        return this.nrOccurencesRelative;
    }

    public String getNrOccurencesRelativeAsString() {
        BigDecimal rel = new BigDecimal(this.nrOccurencesRelative * 100.0);
        rel = rel.setScale(2, 4);
        return String.valueOf(rel.toString()) + "%";
    }

    public void setNrOccurencesRelative(double nrOccurencesRelative) {
        this.nrOccurencesRelative = nrOccurencesRelative;
    }

    public void calcNrOccurencesRelative(int totalOccurences) {
        this.nrOccurencesRelative = (double)this.nrOccurencesAbsolute / (double)totalOccurences;
    }

    public int getNrOccurencesAbsolute() {
        return this.nrOccurencesAbsolute;
    }

    public void setNrOccurencesAbsolute(int nrOccurencesAbsolute) {
        this.nrOccurencesAbsolute = nrOccurencesAbsolute;
    }

    public void addAnzVorkommen() {
        ++this.nrOccurencesAbsolute;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return String.valueOf(this.id) + " , Occurences: " + this.nrOccurencesAbsolute + (this.nrOccurencesRelative > 0.0 ? " (" + this.getNrOccurencesRelativeAsString() + ")" : "");
    }
}

