/*
 * Decompiled with CFR 0.152.
 */
package de.hawlitzek.logparser.gui;

import de.hawlitzek.logparser.FHDetailHttpLogParser;
import de.hawlitzek.logparser.gui.InfoDialog;
import de.hawlitzek.util.text.StringDecoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;

public class LogParser
extends JFrame {
    private static final int NOTEBOOK_INDEX_BROWSERSTATS = 1;
    private static final int NOTEBOOK_INDEX_RESULTSTATS = 2;
    private ButtonGroup filterButtonGroup = new ButtonGroup();
    private JMenuItem ivjAbout_BoxMenuItem = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JMenuItem ivjExitMenuItem = null;
    private JMenu ivjFileMenu = null;
    private JMenuItem ivjHelp_TopicsMenuItem = null;
    private JMenu ivjHelpMenu = null;
    private JPanel ivjJFrameContentPane = null;
    private JSeparator ivjJSeparator1 = null;
    private JMenuBar ivjLogParserJMenuBar = null;
    private JPanel ivjLogParserPane = null;
    private JMenuItem ivjOpenMenuItem = null;
    private JMenuItem ivjSaveMenuItem = null;
    private JPanel ivjStatusBarPane = null;
    private JLabel ivjStatusMsg2 = null;
    private JRadioButton ivjFilterHtmlMainRadioButton = null;
    private JRadioButton ivjFilterHtmlRadioButton = null;
    private JRadioButton ivjFilterImagesRadioButton = null;
    private JRadioButton ivjFilterReferrerRadioButton = null;
    private JTextField ivjKeyWordsEntry = null;
    private JLabel ivjKeyWordsLabel = null;
    private JButton ivjLogFileBrowseButton = null;
    private JTextField ivjLogFileEntry = null;
    private JLabel ivjLogFileLabel = null;
    private JTabbedPane ivjNotebookPanel = null;
    private JButton ivjParseButton = null;
    private JPanel ivjSettingPanel = null;
    private static ResourceBundle reslogparsergui = ResourceBundle.getBundle("logparsergui");
    private JPanel ivjFilterPanel = null;
    private JRadioButton ivjFilterAllRadioButton = null;
    private FileDialog ivjFileOpenDialog = null;
    private FileDialog ivjFileSaveDialog = null;
    private InfoDialog ivjInfoDialog = null;
    private JPanel ivjResultPanel = null;
    private FHDetailHttpLogParser ivjlogParserEngine = null;
    private JTextArea ivjResultTextArea = null;
    private JLabel ivjAlphabeticBrowserLabel = null;
    private JPanel ivjAlphabeticBrowserPanel = null;
    private JTextArea ivjAlphabeticBrowserTextArea = null;
    private JPanel ivjBrowserResultPanel = null;
    private JSplitPane ivjBrowserStatsSplitPane = null;
    private JLabel ivjFrequencyBrowserLabel = null;
    private JPanel ivjFrequencyBrowserPanel = null;
    private JTextArea ivjFrequencyBrowserTextArea = null;
    private JScrollPane ivjJScrollPane2 = null;
    private JScrollPane ivjJScrollPane3 = null;
    private JPanel ivjClientIpResultPanel = null;
    private JTextArea ivjClientIpResultTextArea = null;
    private JScrollPane ivjClientIpScrollPane = null;
    private JPanel ivjDateResultPanel = null;
    private JTextArea ivjDateResultTextArea = null;
    private JScrollPane ivjDateScrollPane = null;
    private JScrollPane ivjResultScrollPane = null;

    public LogParser() {
        this.initialize();
    }

    public LogParser(String title) {
        super(title);
    }

    private void connEtoC1() {
        try {
            this.setSelectedFile();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(FHDetailHttpLogParser result) {
        try {
            this.startParser(result);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.setSelectedFile();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(ActionEvent arg1) {
        try {
            this.getFileOpenDialog().show();
            this.connEtoC1();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3(ActionEvent arg1) {
        try {
            this.getFileOpenDialog().show();
            this.connEtoC3();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM4(ActionEvent arg1) {
        try {
            this.getFileSaveDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM5(ActionEvent arg1) {
        try {
            this.getInfoDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private FHDetailHttpLogParser connEtoM6(ActionEvent arg1) {
        FHDetailHttpLogParser connEtoM6Result = null;
        try {
            connEtoM6Result = new FHDetailHttpLogParser();
            this.setlogParserEngine(connEtoM6Result);
            this.connEtoC2(connEtoM6Result);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return connEtoM6Result;
    }

    private JMenuItem getAbout_BoxMenuItem() {
        if (this.ivjAbout_BoxMenuItem == null) {
            try {
                this.ivjAbout_BoxMenuItem = new JMenuItem();
                this.ivjAbout_BoxMenuItem.setName("About_BoxMenuItem");
                this.ivjAbout_BoxMenuItem.setText(reslogparsergui.getString("GUI_Help_About_Menuitem"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAbout_BoxMenuItem;
    }

    private JLabel getAlphabeticBrowserLabel() {
        if (this.ivjAlphabeticBrowserLabel == null) {
            try {
                this.ivjAlphabeticBrowserLabel = new JLabel();
                this.ivjAlphabeticBrowserLabel.setName("AlphabeticBrowserLabel");
                this.ivjAlphabeticBrowserLabel.setFont(new Font("sansserif", 0, 12));
                this.ivjAlphabeticBrowserLabel.setText(reslogparsergui.getString("GUI_alphabetic"));
                this.ivjAlphabeticBrowserLabel.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAlphabeticBrowserLabel;
    }

    private JPanel getAlphabeticBrowserPanel() {
        if (this.ivjAlphabeticBrowserPanel == null) {
            try {
                this.ivjAlphabeticBrowserPanel = new JPanel();
                this.ivjAlphabeticBrowserPanel.setName("AlphabeticBrowserPanel");
                this.ivjAlphabeticBrowserPanel.setPreferredSize(new Dimension(350, 231));
                this.ivjAlphabeticBrowserPanel.setLayout(new GridBagLayout());
                this.ivjAlphabeticBrowserPanel.setMinimumSize(new Dimension(1, 1));
                GridBagConstraints constraintsAlphabeticBrowserLabel = new GridBagConstraints();
                constraintsAlphabeticBrowserLabel.gridx = 0;
                constraintsAlphabeticBrowserLabel.gridy = 0;
                constraintsAlphabeticBrowserLabel.weightx = 0.01;
                constraintsAlphabeticBrowserLabel.weighty = 0.01;
                constraintsAlphabeticBrowserLabel.insets = new Insets(4, 4, 4, 4);
                this.getAlphabeticBrowserPanel().add((Component)this.getAlphabeticBrowserLabel(), constraintsAlphabeticBrowserLabel);
                GridBagConstraints constraintsJScrollPane2 = new GridBagConstraints();
                constraintsJScrollPane2.gridx = 0;
                constraintsJScrollPane2.gridy = 1;
                constraintsJScrollPane2.fill = 1;
                constraintsJScrollPane2.weightx = 1.0;
                constraintsJScrollPane2.weighty = 1.0;
                constraintsJScrollPane2.insets = new Insets(4, 4, 4, 4);
                this.getAlphabeticBrowserPanel().add((Component)this.getJScrollPane2(), constraintsJScrollPane2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAlphabeticBrowserPanel;
    }

    private JTextArea getAlphabeticBrowserTextArea() {
        if (this.ivjAlphabeticBrowserTextArea == null) {
            try {
                this.ivjAlphabeticBrowserTextArea = new JTextArea();
                this.ivjAlphabeticBrowserTextArea.setName("AlphabeticBrowserTextArea");
                this.ivjAlphabeticBrowserTextArea.setBounds(0, 0, 444, 186);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAlphabeticBrowserTextArea;
    }

    private JPanel getBrowserResultPanel() {
        if (this.ivjBrowserResultPanel == null) {
            try {
                this.ivjBrowserResultPanel = new JPanel();
                this.ivjBrowserResultPanel.setName("BrowserResultPanel");
                this.ivjBrowserResultPanel.setPreferredSize(new Dimension(420, 231));
                this.ivjBrowserResultPanel.setLayout(new BorderLayout());
                this.getBrowserResultPanel().add((Component)this.getBrowserStatsSplitPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBrowserResultPanel;
    }

    private JSplitPane getBrowserStatsSplitPane() {
        if (this.ivjBrowserStatsSplitPane == null) {
            try {
                this.ivjBrowserStatsSplitPane = new JSplitPane(1);
                this.ivjBrowserStatsSplitPane.setName("BrowserStatsSplitPane");
                this.ivjBrowserStatsSplitPane.setPreferredSize(new Dimension(420, 231));
                this.ivjBrowserStatsSplitPane.setDividerLocation(350);
                this.getBrowserStatsSplitPane().add((Component)this.getAlphabeticBrowserPanel(), "left");
                this.getBrowserStatsSplitPane().add((Component)this.getFrequencyBrowserPanel(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBrowserStatsSplitPane;
    }

    private JPanel getClientIpResultPanel() {
        if (this.ivjClientIpResultPanel == null) {
            try {
                this.ivjClientIpResultPanel = new JPanel();
                this.ivjClientIpResultPanel.setName("ClientIpResultPanel");
                this.ivjClientIpResultPanel.setLayout(new BorderLayout());
                this.getClientIpResultPanel().add((Component)this.getClientIpScrollPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClientIpResultPanel;
    }

    private JTextArea getClientIpResultTextArea() {
        if (this.ivjClientIpResultTextArea == null) {
            try {
                this.ivjClientIpResultTextArea = new JTextArea();
                this.ivjClientIpResultTextArea.setName("ClientIpResultTextArea");
                this.ivjClientIpResultTextArea.setBounds(0, 0, 160, 120);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClientIpResultTextArea;
    }

    private JScrollPane getClientIpScrollPane() {
        if (this.ivjClientIpScrollPane == null) {
            try {
                this.ivjClientIpScrollPane = new JScrollPane();
                this.ivjClientIpScrollPane.setName("ClientIpScrollPane");
                this.getClientIpScrollPane().setViewportView(this.getClientIpResultTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClientIpScrollPane;
    }

    private JPanel getDateResultPanel() {
        if (this.ivjDateResultPanel == null) {
            try {
                this.ivjDateResultPanel = new JPanel();
                this.ivjDateResultPanel.setName("DateResultPanel");
                this.ivjDateResultPanel.setLayout(new BorderLayout());
                this.getDateResultPanel().add((Component)this.getDateScrollPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDateResultPanel;
    }

    private JTextArea getDateResultTextArea() {
        if (this.ivjDateResultTextArea == null) {
            try {
                this.ivjDateResultTextArea = new JTextArea();
                this.ivjDateResultTextArea.setName("DateResultTextArea");
                this.ivjDateResultTextArea.setBounds(0, 0, 160, 120);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDateResultTextArea;
    }

    private JScrollPane getDateScrollPane() {
        if (this.ivjDateScrollPane == null) {
            try {
                this.ivjDateScrollPane = new JScrollPane();
                this.ivjDateScrollPane.setName("DateScrollPane");
                this.getDateScrollPane().setViewportView(this.getDateResultTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDateScrollPane;
    }

    private JMenuItem getExitMenuItem() {
        if (this.ivjExitMenuItem == null) {
            try {
                this.ivjExitMenuItem = new JMenuItem();
                this.ivjExitMenuItem.setName("ExitMenuItem");
                this.ivjExitMenuItem.setText(reslogparsergui.getString("GUI_File_Exit_MenuItem"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExitMenuItem;
    }

    private File getFile() {
        String filename = this.getLogFileEntry().getText();
        File file = new File(filename);
        if (file == null || !file.exists() || !file.canRead()) {
            this.getStatusMsg2().setText(String.valueOf(reslogparsergui.getString("GUI_Error_File_Access")) + filename);
            return null;
        }
        return file;
    }

    private JMenu getFileMenu() {
        if (this.ivjFileMenu == null) {
            try {
                this.ivjFileMenu = new JMenu();
                this.ivjFileMenu.setName("FileMenu");
                this.ivjFileMenu.setText(reslogparsergui.getString("GUI_File_Menu"));
                this.ivjFileMenu.add(this.getOpenMenuItem());
                this.ivjFileMenu.add(this.getSaveMenuItem());
                this.ivjFileMenu.add(this.getJSeparator1());
                this.ivjFileMenu.add(this.getExitMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileMenu;
    }

    private FileDialog getFileOpenDialog() {
        if (this.ivjFileOpenDialog == null) {
            try {
                this.ivjFileOpenDialog = new FileDialog(this);
                this.ivjFileOpenDialog.setName("FileOpenDialog");
                this.ivjFileOpenDialog.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileOpenDialog;
    }

    private FileDialog getFileSaveDialog() {
        if (this.ivjFileSaveDialog == null) {
            try {
                this.ivjFileSaveDialog = new FileDialog(this);
                this.ivjFileSaveDialog.setName("FileSaveDialog");
                this.ivjFileSaveDialog.setLayout(null);
                this.ivjFileSaveDialog.setMode(1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileSaveDialog;
    }

    private JRadioButton getFilterAllRadioButton() {
        if (this.ivjFilterAllRadioButton == null) {
            try {
                this.ivjFilterAllRadioButton = new JRadioButton();
                this.ivjFilterAllRadioButton.setName("FilterAllRadioButton");
                this.ivjFilterAllRadioButton.setFont(new Font("sansserif", 0, 12));
                this.ivjFilterAllRadioButton.setText(reslogparsergui.getString("GUI_FilterAllRadioButton"));
                this.ivjFilterAllRadioButton.setActionCommand("ALL");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFilterAllRadioButton;
    }

    private JRadioButton getFilterHtmlMainRadioButton() {
        if (this.ivjFilterHtmlMainRadioButton == null) {
            try {
                this.ivjFilterHtmlMainRadioButton = new JRadioButton();
                this.ivjFilterHtmlMainRadioButton.setName("FilterHtmlMainRadioButton");
                this.ivjFilterHtmlMainRadioButton.setFont(new Font("sansserif", 0, 12));
                this.ivjFilterHtmlMainRadioButton.setText(reslogparsergui.getString("GUI_FilterMainRadioButton"));
                this.ivjFilterHtmlMainRadioButton.setActionCommand("MAIN");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFilterHtmlMainRadioButton;
    }

    private JRadioButton getFilterHtmlRadioButton() {
        if (this.ivjFilterHtmlRadioButton == null) {
            try {
                this.ivjFilterHtmlRadioButton = new JRadioButton();
                this.ivjFilterHtmlRadioButton.setName("FilterHtmlRadioButton");
                this.ivjFilterHtmlRadioButton.setFont(new Font("sansserif", 0, 12));
                this.ivjFilterHtmlRadioButton.setText(reslogparsergui.getString("GUI_FilterHtmlRadioButton"));
                this.ivjFilterHtmlRadioButton.setActionCommand("HTML");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFilterHtmlRadioButton;
    }

    private JRadioButton getFilterImagesRadioButton() {
        if (this.ivjFilterImagesRadioButton == null) {
            try {
                this.ivjFilterImagesRadioButton = new JRadioButton();
                this.ivjFilterImagesRadioButton.setName("FilterImagesRadioButton");
                this.ivjFilterImagesRadioButton.setFont(new Font("sansserif", 0, 12));
                this.ivjFilterImagesRadioButton.setText(reslogparsergui.getString("GUI_FilterImagesRadioButton"));
                this.ivjFilterImagesRadioButton.setActionCommand("IMG");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFilterImagesRadioButton;
    }

    private JPanel getFilterPanel() {
        if (this.ivjFilterPanel == null) {
            try {
                this.ivjFilterPanel = new JPanel();
                this.ivjFilterPanel.setName("FilterPanel");
                this.ivjFilterPanel.setLayout(new GridBagLayout());
                GridBagConstraints constraintsFilterAllRadioButton = new GridBagConstraints();
                constraintsFilterAllRadioButton.gridx = 0;
                constraintsFilterAllRadioButton.gridy = 0;
                constraintsFilterAllRadioButton.anchor = 17;
                constraintsFilterAllRadioButton.insets = new Insets(4, 4, 0, 4);
                this.getFilterPanel().add((Component)this.getFilterAllRadioButton(), constraintsFilterAllRadioButton);
                GridBagConstraints constraintsFilterHtmlRadioButton = new GridBagConstraints();
                constraintsFilterHtmlRadioButton.gridx = 0;
                constraintsFilterHtmlRadioButton.gridy = 1;
                constraintsFilterHtmlRadioButton.anchor = 17;
                constraintsFilterHtmlRadioButton.insets = new Insets(4, 4, 0, 4);
                this.getFilterPanel().add((Component)this.getFilterHtmlRadioButton(), constraintsFilterHtmlRadioButton);
                GridBagConstraints constraintsFilterHtmlMainRadioButton = new GridBagConstraints();
                constraintsFilterHtmlMainRadioButton.gridx = 1;
                constraintsFilterHtmlMainRadioButton.gridy = 1;
                constraintsFilterHtmlMainRadioButton.anchor = 17;
                constraintsFilterHtmlMainRadioButton.insets = new Insets(4, 4, 0, 4);
                this.getFilterPanel().add((Component)this.getFilterHtmlMainRadioButton(), constraintsFilterHtmlMainRadioButton);
                GridBagConstraints constraintsFilterImagesRadioButton = new GridBagConstraints();
                constraintsFilterImagesRadioButton.gridx = 0;
                constraintsFilterImagesRadioButton.gridy = 2;
                constraintsFilterImagesRadioButton.anchor = 17;
                constraintsFilterImagesRadioButton.insets = new Insets(4, 4, 0, 4);
                this.getFilterPanel().add((Component)this.getFilterImagesRadioButton(), constraintsFilterImagesRadioButton);
                GridBagConstraints constraintsFilterReferrerRadioButton = new GridBagConstraints();
                constraintsFilterReferrerRadioButton.gridx = 0;
                constraintsFilterReferrerRadioButton.gridy = 3;
                constraintsFilterReferrerRadioButton.gridwidth = 2;
                constraintsFilterReferrerRadioButton.anchor = 17;
                constraintsFilterReferrerRadioButton.insets = new Insets(4, 4, 0, 4);
                this.getFilterPanel().add((Component)this.getFilterReferrerRadioButton(), constraintsFilterReferrerRadioButton);
                GridBagConstraints constraintsKeyWordsLabel = new GridBagConstraints();
                constraintsKeyWordsLabel.gridx = 0;
                constraintsKeyWordsLabel.gridy = 4;
                constraintsKeyWordsLabel.anchor = 17;
                constraintsKeyWordsLabel.insets = new Insets(15, 5, 5, 5);
                this.getFilterPanel().add((Component)this.getKeyWordsLabel(), constraintsKeyWordsLabel);
                GridBagConstraints constraintsKeyWordsEntry = new GridBagConstraints();
                constraintsKeyWordsEntry.gridx = 1;
                constraintsKeyWordsEntry.gridy = 4;
                constraintsKeyWordsEntry.fill = 2;
                constraintsKeyWordsEntry.weightx = 1.0;
                constraintsKeyWordsEntry.insets = new Insets(15, 4, 4, 4);
                this.getFilterPanel().add((Component)this.getKeyWordsEntry(), constraintsKeyWordsEntry);
                this.ivjFilterPanel.setBorder(BorderFactory.createTitledBorder(null, reslogparsergui.getString("GUI_Filter"), 0, 2, new Font("Dialog", 0, 13)));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFilterPanel;
    }

    private JRadioButton getFilterReferrerRadioButton() {
        if (this.ivjFilterReferrerRadioButton == null) {
            try {
                this.ivjFilterReferrerRadioButton = new JRadioButton();
                this.ivjFilterReferrerRadioButton.setName("FilterReferrerRadioButton");
                this.ivjFilterReferrerRadioButton.setFont(new Font("sansserif", 0, 12));
                this.ivjFilterReferrerRadioButton.setText(reslogparsergui.getString("GUI_FilterReferrerRadioButton"));
                this.ivjFilterReferrerRadioButton.setActionCommand("REF");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFilterReferrerRadioButton;
    }

    private String getFilterType() {
        ButtonModel bm = this.filterButtonGroup.getSelection();
        return bm.getActionCommand();
    }

    private JLabel getFrequencyBrowserLabel() {
        if (this.ivjFrequencyBrowserLabel == null) {
            try {
                this.ivjFrequencyBrowserLabel = new JLabel();
                this.ivjFrequencyBrowserLabel.setName("FrequencyBrowserLabel");
                this.ivjFrequencyBrowserLabel.setFont(new Font("sansserif", 0, 12));
                this.ivjFrequencyBrowserLabel.setText(reslogparsergui.getString("GUI_frequency"));
                this.ivjFrequencyBrowserLabel.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFrequencyBrowserLabel;
    }

    private JPanel getFrequencyBrowserPanel() {
        if (this.ivjFrequencyBrowserPanel == null) {
            try {
                this.ivjFrequencyBrowserPanel = new JPanel();
                this.ivjFrequencyBrowserPanel.setName("FrequencyBrowserPanel");
                this.ivjFrequencyBrowserPanel.setPreferredSize(new Dimension(350, 231));
                this.ivjFrequencyBrowserPanel.setLayout(new GridBagLayout());
                this.ivjFrequencyBrowserPanel.setMinimumSize(new Dimension(1, 1));
                GridBagConstraints constraintsFrequencyBrowserLabel = new GridBagConstraints();
                constraintsFrequencyBrowserLabel.gridx = 0;
                constraintsFrequencyBrowserLabel.gridy = 0;
                constraintsFrequencyBrowserLabel.weightx = 0.01;
                constraintsFrequencyBrowserLabel.weighty = 0.01;
                constraintsFrequencyBrowserLabel.insets = new Insets(4, 4, 4, 4);
                this.getFrequencyBrowserPanel().add((Component)this.getFrequencyBrowserLabel(), constraintsFrequencyBrowserLabel);
                GridBagConstraints constraintsJScrollPane3 = new GridBagConstraints();
                constraintsJScrollPane3.gridx = 0;
                constraintsJScrollPane3.gridy = 1;
                constraintsJScrollPane3.fill = 1;
                constraintsJScrollPane3.weightx = 1.0;
                constraintsJScrollPane3.weighty = 1.0;
                constraintsJScrollPane3.insets = new Insets(4, 4, 4, 4);
                this.getFrequencyBrowserPanel().add((Component)this.getJScrollPane3(), constraintsJScrollPane3);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFrequencyBrowserPanel;
    }

    private JTextArea getFrequencyBrowserTextArea() {
        if (this.ivjFrequencyBrowserTextArea == null) {
            try {
                this.ivjFrequencyBrowserTextArea = new JTextArea();
                this.ivjFrequencyBrowserTextArea.setName("FrequencyBrowserTextArea");
                this.ivjFrequencyBrowserTextArea.setBounds(0, 0, 444, 186);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFrequencyBrowserTextArea;
    }

    private JMenuItem getHelp_TopicsMenuItem() {
        if (this.ivjHelp_TopicsMenuItem == null) {
            try {
                this.ivjHelp_TopicsMenuItem = new JMenuItem();
                this.ivjHelp_TopicsMenuItem.setName("Help_TopicsMenuItem");
                this.ivjHelp_TopicsMenuItem.setText(reslogparsergui.getString("GUI_Help_Topis_MenuItem"));
                this.ivjHelp_TopicsMenuItem.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHelp_TopicsMenuItem;
    }

    private JMenu getHelpMenu() {
        if (this.ivjHelpMenu == null) {
            try {
                this.ivjHelpMenu = new JMenu();
                this.ivjHelpMenu.setName("HelpMenu");
                this.ivjHelpMenu.setText(reslogparsergui.getString("GUI_File_Help"));
                this.ivjHelpMenu.add(this.getHelp_TopicsMenuItem());
                this.ivjHelpMenu.add(this.getAbout_BoxMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHelpMenu;
    }

    private InfoDialog getInfoDialog() {
        return this.ivjInfoDialog;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getStatusBarPane(), "South");
                this.getJFrameContentPane().add((Component)this.getLogParserPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JScrollPane getJScrollPane2() {
        if (this.ivjJScrollPane2 == null) {
            try {
                this.ivjJScrollPane2 = new JScrollPane();
                this.ivjJScrollPane2.setName("JScrollPane2");
                this.ivjJScrollPane2.setPreferredSize(new Dimension(1000, 1000));
                this.getJScrollPane2().setViewportView(this.getAlphabeticBrowserTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane2;
    }

    private JScrollPane getJScrollPane3() {
        if (this.ivjJScrollPane3 == null) {
            try {
                this.ivjJScrollPane3 = new JScrollPane();
                this.ivjJScrollPane3.setName("JScrollPane3");
                this.ivjJScrollPane3.setPreferredSize(new Dimension(1000, 1000));
                this.getJScrollPane3().setViewportView(this.getFrequencyBrowserTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane3;
    }

    private JSeparator getJSeparator1() {
        if (this.ivjJSeparator1 == null) {
            try {
                this.ivjJSeparator1 = new JSeparator();
                this.ivjJSeparator1.setName("JSeparator1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator1;
    }

    private JTextField getKeyWordsEntry() {
        if (this.ivjKeyWordsEntry == null) {
            try {
                this.ivjKeyWordsEntry = new JTextField();
                this.ivjKeyWordsEntry.setName("KeyWordsEntry");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjKeyWordsEntry;
    }

    private JLabel getKeyWordsLabel() {
        if (this.ivjKeyWordsLabel == null) {
            try {
                this.ivjKeyWordsLabel = new JLabel();
                this.ivjKeyWordsLabel.setName("KeyWordsLabel");
                this.ivjKeyWordsLabel.setFont(new Font("sansserif", 0, 12));
                this.ivjKeyWordsLabel.setText(reslogparsergui.getString("GUI_KeyWordsLabel"));
                this.ivjKeyWordsLabel.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjKeyWordsLabel;
    }

    private JButton getLogFileBrowseButton() {
        if (this.ivjLogFileBrowseButton == null) {
            try {
                this.ivjLogFileBrowseButton = new JButton();
                this.ivjLogFileBrowseButton.setName("LogFileBrowseButton");
                this.ivjLogFileBrowseButton.setText(reslogparsergui.getString("GUI_LogFileBrowseButton"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogFileBrowseButton;
    }

    private JTextField getLogFileEntry() {
        if (this.ivjLogFileEntry == null) {
            try {
                this.ivjLogFileEntry = new JTextField();
                this.ivjLogFileEntry.setName("LogFileEntry");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogFileEntry;
    }

    private JLabel getLogFileLabel() {
        if (this.ivjLogFileLabel == null) {
            try {
                this.ivjLogFileLabel = new JLabel();
                this.ivjLogFileLabel.setName("LogFileLabel");
                this.ivjLogFileLabel.setFont(new Font("sansserif", 0, 12));
                this.ivjLogFileLabel.setText(reslogparsergui.getString("GUI_log_file"));
                this.ivjLogFileLabel.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogFileLabel;
    }

    private FHDetailHttpLogParser getlogParserEngine() {
        return this.ivjlogParserEngine;
    }

    private JMenuBar getLogParserJMenuBar() {
        if (this.ivjLogParserJMenuBar == null) {
            try {
                this.ivjLogParserJMenuBar = new JMenuBar();
                this.ivjLogParserJMenuBar.setName("LogParserJMenuBar");
                this.ivjLogParserJMenuBar.add(this.getFileMenu());
                this.ivjLogParserJMenuBar.add(this.getHelpMenu());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogParserJMenuBar;
    }

    private JPanel getLogParserPane() {
        if (this.ivjLogParserPane == null) {
            try {
                this.ivjLogParserPane = new JPanel();
                this.ivjLogParserPane.setName("LogParserPane");
                this.ivjLogParserPane.setPreferredSize(new Dimension(730, 480));
                this.ivjLogParserPane.setLayout(new BorderLayout());
                this.getLogParserPane().add((Component)this.getNotebookPanel(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogParserPane;
    }

    private JTabbedPane getNotebookPanel() {
        if (this.ivjNotebookPanel == null) {
            try {
                this.ivjNotebookPanel = new JTabbedPane();
                this.ivjNotebookPanel.setName("NotebookPanel");
                this.ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_Settings"), null, this.getSettingPanel(), null, 0);
                this.ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_BrowserResult"), null, this.getBrowserResultPanel(), null, 1);
                this.ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_Results"), null, this.getResultPanel(), null, 2);
                this.ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_IP_Results"), null, this.getClientIpResultPanel(), null, 3);
                this.ivjNotebookPanel.insertTab(reslogparsergui.getString("GUI_Date_Results"), null, this.getDateResultPanel(), null, 4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNotebookPanel;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.ivjOpenMenuItem == null) {
            try {
                this.ivjOpenMenuItem = new JMenuItem();
                this.ivjOpenMenuItem.setName("OpenMenuItem");
                this.ivjOpenMenuItem.setText(reslogparsergui.getString("GUI_File_Open_Menuitem"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOpenMenuItem;
    }

    private JButton getParseButton() {
        if (this.ivjParseButton == null) {
            try {
                this.ivjParseButton = new JButton();
                this.ivjParseButton.setName("ParseButton");
                this.ivjParseButton.setText(reslogparsergui.getString("GUI_ParseButton"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjParseButton;
    }

    private JPanel getResultPanel() {
        if (this.ivjResultPanel == null) {
            try {
                this.ivjResultPanel = new JPanel();
                this.ivjResultPanel.setName("ResultPanel");
                this.ivjResultPanel.setLayout(new BorderLayout());
                this.getResultPanel().add((Component)this.getResultScrollPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResultPanel;
    }

    private JScrollPane getResultScrollPane() {
        if (this.ivjResultScrollPane == null) {
            try {
                this.ivjResultScrollPane = new JScrollPane();
                this.ivjResultScrollPane.setName("ResultScrollPane");
                this.getResultScrollPane().setViewportView(this.getResultTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResultScrollPane;
    }

    private JTextArea getResultTextArea() {
        if (this.ivjResultTextArea == null) {
            try {
                this.ivjResultTextArea = new JTextArea();
                this.ivjResultTextArea.setName("ResultTextArea");
                this.ivjResultTextArea.setBounds(0, 0, 160, 120);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResultTextArea;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.ivjSaveMenuItem == null) {
            try {
                this.ivjSaveMenuItem = new JMenuItem();
                this.ivjSaveMenuItem.setName("SaveMenuItem");
                this.ivjSaveMenuItem.setText(reslogparsergui.getString("GUI_File_Save_Menuitem"));
                this.ivjSaveMenuItem.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSaveMenuItem;
    }

    private JPanel getSettingPanel() {
        if (this.ivjSettingPanel == null) {
            try {
                this.ivjSettingPanel = new JPanel();
                this.ivjSettingPanel.setName("SettingPanel");
                this.ivjSettingPanel.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLogFileLabel = new GridBagConstraints();
                constraintsLogFileLabel.gridx = 0;
                constraintsLogFileLabel.gridy = 0;
                constraintsLogFileLabel.anchor = 17;
                constraintsLogFileLabel.insets = new Insets(10, 5, 5, 5);
                this.getSettingPanel().add((Component)this.getLogFileLabel(), constraintsLogFileLabel);
                GridBagConstraints constraintsLogFileEntry = new GridBagConstraints();
                constraintsLogFileEntry.gridx = 1;
                constraintsLogFileEntry.gridy = 0;
                constraintsLogFileEntry.fill = 2;
                constraintsLogFileEntry.anchor = 17;
                constraintsLogFileEntry.weightx = 1.0;
                constraintsLogFileEntry.insets = new Insets(10, 4, 4, 4);
                this.getSettingPanel().add((Component)this.getLogFileEntry(), constraintsLogFileEntry);
                GridBagConstraints constraintsLogFileBrowseButton = new GridBagConstraints();
                constraintsLogFileBrowseButton.gridx = 2;
                constraintsLogFileBrowseButton.gridy = 0;
                constraintsLogFileBrowseButton.insets = new Insets(10, 4, 4, 4);
                this.getSettingPanel().add((Component)this.getLogFileBrowseButton(), constraintsLogFileBrowseButton);
                GridBagConstraints constraintsFilterPanel = new GridBagConstraints();
                constraintsFilterPanel.gridx = 0;
                constraintsFilterPanel.gridy = 1;
                constraintsFilterPanel.gridwidth = 3;
                constraintsFilterPanel.fill = 1;
                constraintsFilterPanel.weightx = 1.0;
                constraintsFilterPanel.weighty = 0.01;
                constraintsFilterPanel.insets = new Insets(4, 4, 4, 4);
                this.getSettingPanel().add((Component)this.getFilterPanel(), constraintsFilterPanel);
                GridBagConstraints constraintsParseButton = new GridBagConstraints();
                constraintsParseButton.gridx = 0;
                constraintsParseButton.gridy = 2;
                constraintsParseButton.gridwidth = 2;
                constraintsParseButton.anchor = 18;
                constraintsParseButton.weighty = 1.0;
                constraintsParseButton.insets = new Insets(4, 4, 4, 4);
                this.getSettingPanel().add((Component)this.getParseButton(), constraintsParseButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSettingPanel;
    }

    private JPanel getStatusBarPane() {
        if (this.ivjStatusBarPane == null) {
            try {
                this.ivjStatusBarPane = new JPanel();
                this.ivjStatusBarPane.setName("StatusBarPane");
                this.ivjStatusBarPane.setLayout(new BorderLayout());
                this.getStatusBarPane().add((Component)this.getStatusMsg2(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusBarPane;
    }

    private JLabel getStatusMsg2() {
        if (this.ivjStatusMsg2 == null) {
            try {
                this.ivjStatusMsg2 = new JLabel();
                this.ivjStatusMsg2.setName("StatusMsg2");
                this.ivjStatusMsg2.setBorder(new EtchedBorder());
                this.ivjStatusMsg2.setText(" ");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusMsg2;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.setInfoDialog(new InfoDialog((Frame)this, "1.2.1"));
        this.filterButtonGroup.add(this.getFilterAllRadioButton());
        this.filterButtonGroup.add(this.getFilterHtmlMainRadioButton());
        this.filterButtonGroup.add(this.getFilterHtmlRadioButton());
        this.filterButtonGroup.add(this.getFilterImagesRadioButton());
        this.filterButtonGroup.add(this.getFilterReferrerRadioButton());
        this.getFilterAllRadioButton().setSelected(true);
        this.getExitMenuItem().addActionListener(this.ivjEventHandler);
        this.getLogFileBrowseButton().addActionListener(this.ivjEventHandler);
        this.getOpenMenuItem().addActionListener(this.ivjEventHandler);
        this.getSaveMenuItem().addActionListener(this.ivjEventHandler);
        this.getAbout_BoxMenuItem().addActionListener(this.ivjEventHandler);
        this.getParseButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("LogParser");
            this.setDefaultCloseOperation(2);
            this.setJMenuBar(this.getLogParserJMenuBar());
            ((Component)this).setSize(750, 500);
            this.setTitle("LogParser");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            LogParser aLogParser = new LogParser();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            aLogParser.pack();
            Dimension frameSize = aLogParser.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            ((Component)aLogParser).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            aLogParser.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)aLogParser).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of LogParser");
            exception.printStackTrace(System.out);
        }
    }

    private void setInfoDialog(InfoDialog newValue) {
        if (this.ivjInfoDialog != newValue) {
            try {
                this.ivjInfoDialog = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    private void setlogParserEngine(FHDetailHttpLogParser newValue) {
        if (this.ivjlogParserEngine != newValue) {
            try {
                this.ivjlogParserEngine = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    public void setSelectedFile() {
        String file;
        String dir = this.getFileOpenDialog().getDirectory();
        if (dir != null && (file = this.getFileOpenDialog().getFile()) != null) {
            file = String.valueOf(dir) + file;
            this.getLogFileEntry().setText(file);
        }
    }

    public void startParser(FHDetailHttpLogParser parser) {
        this.getStatusMsg2().setText("Parsing...");
        Thread parserThread = new Thread(new ParserThread());
        parserThread.start();
    }

    public void viewStatusBar() {
        this.getStatusBarPane().setVisible(!this.getStatusBarPane().isVisible());
    }

    class ParserThread
    implements Runnable {
        ParserThread() {
        }

        public void run() {
            try {
                File file;
                FHDetailHttpLogParser parser = LogParser.this.getlogParserEngine();
                if (parser != null && (file = LogParser.this.getFile()) != null) {
                    parser.readFile(file, LogParser.this.getFilterType(), StringDecoder.seperate(LogParser.this.getKeyWordsEntry().getText()));
                    if (FHDetailHttpLogParser.isSearchEngineStats(LogParser.this.getFilterType())) {
                        LogParser.this.getResultTextArea().setText(parser.getSearchEngineStats());
                        LogParser.this.getNotebookPanel().setTitleAt(2, reslogparsergui.getString("GUI_Search_Engine_Results"));
                    } else {
                        LogParser.this.getResultTextArea().setText(parser.getPageStats());
                        LogParser.this.getNotebookPanel().setTitleAt(2, reslogparsergui.getString("GUI_Page_Results"));
                    }
                    LogParser.this.getAlphabeticBrowserTextArea().setText(parser.getBrowserStats(true));
                    LogParser.this.getFrequencyBrowserTextArea().setText(parser.getBrowserStats(false));
                    LogParser.this.getStatusMsg2().setText("Total access count: " + parser.getTotalOccurences() + ", filtered: " + parser.getFilteredOccurences());
                    LogParser.this.getNotebookPanel().setSelectedIndex(1);
                    LogParser.this.getClientIpResultTextArea().setText(parser.getIPStats());
                    LogParser.this.getDateResultTextArea().setText(parser.getDateStats());
                }
            }
            catch (Exception e) {
                LogParser.this.getStatusMsg2().setText(e.getMessage());
            }
        }
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LogParser.this.getExitMenuItem()) {
                LogParser.this.connEtoM1(e);
            }
            if (e.getSource() == LogParser.this.getLogFileBrowseButton()) {
                LogParser.this.connEtoM2(e);
            }
            if (e.getSource() == LogParser.this.getOpenMenuItem()) {
                LogParser.this.connEtoM3(e);
            }
            if (e.getSource() == LogParser.this.getSaveMenuItem()) {
                LogParser.this.connEtoM4(e);
            }
            if (e.getSource() == LogParser.this.getAbout_BoxMenuItem()) {
                LogParser.this.connEtoM5(e);
            }
            if (e.getSource() == LogParser.this.getParseButton()) {
                LogParser.this.connEtoM6(e);
            }
        }
    }
}

