/*
 * Decompiled with CFR 0.152.
 */
package de.hawlitzek.logparser;

import de.hawlitzek.logparser.BrowserEntry;
import de.hawlitzek.logparser.InvalidLogEntryException;
import de.hawlitzek.util.text.StringDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class LogEntry {
    private String clientIP;
    private Date date;
    private String httpMethod;
    private String page;
    private String returncode;
    private String bytecount;
    private String browser;
    private String referrer;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss z", Locale.US);

    public boolean isHtml() {
        return this.page.endsWith("html") || this.page.endsWith("htm") || this.page.endsWith("HTML") || this.page.endsWith("HTM") || this.page.endsWith("/");
    }

    public boolean isImage() {
        try {
            String suffix = this.page.substring(this.page.length() - 3).toLowerCase();
            return suffix.endsWith("gif") || suffix.endsWith("jpg") || suffix.endsWith("png");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isMainPage() {
        return this.isHtml() && this.page.indexOf("/left_") == -1 && this.page.indexOf("/body_") == -1 && this.page.indexOf("/header_") == -1;
    }

    public boolean matches(String type, String[] filter) {
        boolean result;
        block14: {
            result = true;
            boolean referrerSearch = false;
            if (type != null) {
                if (type.equals("HTML")) {
                    result = this.isHtml();
                } else if (type.equals("MAIN")) {
                    result = this.isMainPage();
                } else if (type.equals("IMG")) {
                    result = this.isImage();
                } else if (type.equals("REF")) {
                    referrerSearch = true;
                }
            }
            if (filter == null) break block14;
            if (referrerSearch) {
                int i = 0;
                while (result && i < filter.length) {
                    if (this.referrer.indexOf(filter[i]) == -1) {
                        result = false;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (result && i < filter.length) {
                    if (this.page.indexOf(filter[i]) == -1) {
                        result = false;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public boolean isGet() {
        return this.httpMethod.equals("GET");
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public Date getDate() {
        return this.date;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPage() {
        return this.page;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String getReturncode() {
        return this.returncode;
    }

    public boolean isOk() {
        return this.returncode.equals("200") || this.returncode.equals("304");
    }

    public static String parseLine(String line) throws InvalidLogEntryException {
        return LogEntry.parseLine(line, null);
    }

    public static String parseLine(String line, LogEntry logEntry) throws InvalidLogEntryException {
        try {
            StringTokenizer tok = new StringTokenizer(line, "\"");
            String header = tok.nextToken();
            String method = tok.nextToken();
            String result = tok.nextToken();
            String referrer = tok.nextToken();
            if (referrer.endsWith("%")) {
                referrer = referrer.substring(0, referrer.length() - 2);
            }
            String dummy = tok.nextToken();
            String browser = tok.nextToken().trim();
            browser = BrowserEntry.getBrowserType(browser);
            if (logEntry != null) {
                logEntry.init(header, method, result, referrer, browser);
            }
            return browser;
        }
        catch (Exception e) {
            throw new InvalidLogEntryException();
        }
    }

    private void init(String header, String method, String result, String referrer, String browser) {
        int index1 = header.indexOf(32);
        this.clientIP = header.substring(0, index1);
        index1 = header.indexOf(91);
        int index2 = header.indexOf(93);
        String tempDat = header.substring(index1 + 1, index2);
        try {
            this.date = dateFormat.parse(tempDat);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        index1 = method.indexOf(32);
        index2 = method.indexOf("HTTP/");
        this.httpMethod = method.substring(0, index1);
        this.page = method.substring(index1 + 1, index2 - 1);
        this.returncode = result.substring(1, result.indexOf(32) + 4);
        this.referrer = referrer;
        this.browser = browser;
    }

    public String[] parseGoogleKeywords() {
        boolean isGoogleTranslation;
        boolean isGoogleImageSearch;
        int index1 = this.referrer.indexOf("google");
        if (index1 < 0) {
            return null;
        }
        int index2 = this.referrer.indexOf("imgrefurl");
        boolean bl = isGoogleImageSearch = index2 >= 0;
        if (isGoogleImageSearch) {
            this.referrer = this.referrer.substring(index2 + 10);
        }
        boolean bl2 = isGoogleTranslation = (index2 = this.referrer.indexOf("translate")) >= 0;
        if (isGoogleTranslation && (index2 = this.referrer.indexOf("&u=", index2)) >= 0) {
            this.referrer = this.referrer.substring(index2 + 3);
        }
        this.referrer = StringDecoder.decodeUrl(this.referrer);
        if (isGoogleImageSearch || isGoogleTranslation) {
            try {
                this.referrer = StringDecoder.decodeUrl(this.referrer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.baseParseKeywords(this.referrer, index1);
    }

    public String[] parseFireballKeywords() {
        int index1 = this.referrer.indexOf("fireball");
        if (index1 < 0) {
            return null;
        }
        this.referrer = StringDecoder.decodeUrl(this.referrer);
        return this.baseParseKeywords(this.referrer, index1);
    }

    public String[] parseAltavistaKeywords() {
        int index1 = this.referrer.indexOf("altavista");
        if (index1 < 0) {
            return null;
        }
        this.referrer = StringDecoder.decodeUrl(this.referrer);
        return this.baseParseKeywords(this.referrer, index1);
    }

    private String[] baseParseKeywords(String referrer, int startIndex) {
        int index2 = referrer.indexOf("q=", startIndex);
        if (index2 < 0 && (index2 = referrer.indexOf("?p=", startIndex)) < 0) {
            return null;
        }
        int index3 = referrer.indexOf("&", index2);
        String searchString = referrer.substring(index2 + 2, index3 >= 0 ? index3 : referrer.length());
        return StringDecoder.seperate(searchString);
    }
}

