/*
 * Decompiled with CFR 0.152.
 */
package de.hawlitzek.logparser;

import de.hawlitzek.logparser.BrowserEntry;
import de.hawlitzek.logparser.InvalidLogEntryException;
import de.hawlitzek.logparser.LogEntry;
import de.hawlitzek.util.text.CountedEntry;
import de.hawlitzek.util.text.CountedEntryComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;

public class FHDetailHttpLogParser {
    public static final String VERSION = "1.2.1";
    private SortedMap browserStats = new TreeMap();
    private SortedMap pageStats = new TreeMap();
    Properties searchengines = new Properties();
    private SortedMap searchEngineStats = new TreeMap();
    private SortedMap googleStats = new TreeMap();
    private int nrOcc = 0;
    private int nrRealPageOcc = 0;
    private SortedMap hostIPs = new TreeMap();
    private SortedMap dateMap = new TreeMap();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy", Locale.US);

    public FHDetailHttpLogParser() {
        InputStream is = this.getClass().getResourceAsStream("searchengines.properties");
        if (is != null) {
            try {
                this.searchengines.load(is);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Could not find search engine configuration file (searchengines.properties).");
        }
    }

    protected void adjustBrowserStats(String browser) {
        if (this.browserStats.containsKey(browser)) {
            BrowserEntry entry = (BrowserEntry)this.browserStats.get(browser);
            entry.addAnzVorkommen();
        } else {
            BrowserEntry be = new BrowserEntry(browser);
            this.browserStats.put(browser, be);
        }
    }

    protected void adjustPageStats(LogEntry logEntry) {
        String page = logEntry.getPage();
        if (this.pageStats.containsKey(page)) {
            BrowserEntry entry = (BrowserEntry)this.pageStats.get(page);
            entry.addAnzVorkommen();
        } else {
            BrowserEntry be = new BrowserEntry(page);
            this.pageStats.put(page, be);
        }
    }

    protected void adjustForSingleIP(LogEntry logEntry) {
        String hostIP = logEntry.getClientIP();
        if (this.hostIPs.containsKey(hostIP)) {
            CountedEntry entry = (CountedEntry)this.hostIPs.get(hostIP);
            entry.addAnzVorkommen();
        } else {
            CountedEntry he = new CountedEntry(hostIP);
            this.hostIPs.put(hostIP, he);
        }
    }

    protected void adjustDate(LogEntry logEntry) {
        String date = dateFormat.format(logEntry.getDate());
        if (this.dateMap.containsKey(date)) {
            CountedEntry entry = (CountedEntry)this.dateMap.get(date);
            entry.addAnzVorkommen();
        } else {
            CountedEntry de = new CountedEntry(date);
            this.dateMap.put(date, de);
        }
    }

    protected void adjustSearchEngineStats(LogEntry logEntry) {
        String[] keywords = null;
        String referrer = logEntry.getReferrer();
        if (referrer == null || referrer.equals("-")) {
            return;
        }
        Iterator keys = ((Hashtable)this.searchengines).keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (referrer.indexOf(key) < 0) continue;
            if (this.searchEngineStats.containsKey(key)) {
                CountedEntry entry = (CountedEntry)this.searchEngineStats.get(key);
                entry.addAnzVorkommen();
                break;
            }
            CountedEntry be = new CountedEntry(key);
            this.searchEngineStats.put(key, be);
            break;
        }
        if (referrer.indexOf("google") >= 0) {
            keywords = logEntry.parseGoogleKeywords();
        } else if (referrer.indexOf("fireball") >= 0) {
            keywords = logEntry.parseFireballKeywords();
        } else if (referrer.indexOf("altavista") >= 0) {
            keywords = logEntry.parseAltavistaKeywords();
        }
        if (keywords != null) {
            int i = 0;
            while (i < keywords.length) {
                CountedEntry hit;
                if (this.googleStats.containsKey(keywords[i])) {
                    hit = (CountedEntry)this.googleStats.get(keywords[i]);
                    hit.addAnzVorkommen();
                } else {
                    hit = new CountedEntry(keywords[i]);
                    this.googleStats.put(keywords[i], hit);
                }
                ++i;
            }
        }
    }

    public void displayStats(String filterType) {
        StringBuffer result = new StringBuffer();
        result.append("All access count: " + this.getTotalOccurences() + "\n\n");
        result.append("browser statistics (in alphabetic order):\n\n");
        result.append(this.getBrowserStats(true));
        result.append("\nbrowser statistics (per frequency):\n\n");
        result.append(this.getBrowserStats(false));
        result.append("\n");
        if (FHDetailHttpLogParser.isSearchEngineStats(filterType)) {
            result.append(this.getSearchEngineStats());
        } else {
            result.append(this.getPageStats());
        }
        result.append("\n");
        result.append(this.getIPStats());
        result.append("\n");
        result.append(this.getDateStats());
        System.out.println(result.toString());
    }

    public String getBrowserStats(boolean alphabetic) {
        StringBuffer result = new StringBuffer();
        if (alphabetic) {
            Iterator it = this.browserStats.values().iterator();
            while (it.hasNext()) {
                BrowserEntry be = (BrowserEntry)it.next();
                be.calcNrOccurencesRelative(this.nrRealPageOcc);
                result.append(be);
                result.append("\n");
            }
        } else {
            BrowserEntry[] hs = this.browserStats.values().toArray(new BrowserEntry[0]);
            Arrays.sort(hs, new CountedEntryComparator());
            int i = 0;
            while (i < hs.length) {
                BrowserEntry be = hs[i];
                result.append(be);
                result.append("\n");
                ++i;
            }
        }
        return result.toString();
    }

    public String getFilteredOccurences() {
        return String.valueOf(this.nrRealPageOcc);
    }

    public String getPageStats() {
        StringBuffer result = new StringBuffer();
        result.append("Filtered page counts: " + this.getFilteredOccurences() + "\n");
        if (this.nrRealPageOcc > 0) {
            result.append("\npage statistics (per frequency):\n\n");
            BrowserEntry[] ps = this.pageStats.values().toArray(new BrowserEntry[0]);
            Arrays.sort(ps, new CountedEntryComparator());
            int i = 0;
            while (i < ps.length) {
                BrowserEntry be = ps[i];
                result.append(be);
                result.append("\n");
                ++i;
            }
        }
        return result.toString();
    }

    public String getIPStats() {
        StringBuffer result = new StringBuffer();
        result.append("IP statistics (per frequency):\n\n");
        CountedEntry[] hips = this.hostIPs.values().toArray(new CountedEntry[0]);
        Arrays.sort(hips, new CountedEntryComparator());
        result.append("Total number of unique IPs: " + hips.length + "\n\n");
        int i = 0;
        while (i < hips.length) {
            CountedEntry he = hips[i];
            result.append(he);
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    public String getDateStats() {
        StringBuffer result = new StringBuffer();
        result.append("Date statistics:\n\n");
        CountedEntry[] dates = this.dateMap.values().toArray(new CountedEntry[0]);
        int i = 0;
        while (i < dates.length) {
            CountedEntry de = dates[i];
            result.append(de);
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    public String getSearchEngineStats() {
        int i;
        StringBuffer result = new StringBuffer();
        if (!this.searchEngineStats.isEmpty()) {
            CountedEntry[] se = this.searchEngineStats.values().toArray(new CountedEntry[0]);
            Arrays.sort(se, new CountedEntryComparator());
            i = 0;
            while (i < se.length) {
                CountedEntry be = se[i];
                result.append(((Hashtable)this.searchengines).get(be.getId()));
                result.append(" search hits: ");
                result.append(be.getNrOccurencesAbsolute());
                result.append("\n");
                ++i;
            }
        }
        result.append("\n");
        if (!this.googleStats.isEmpty()) {
            result.append("\nkeywords used in Google/Fireball/Altavista searches (per frequency):\n\n");
            CountedEntry[] ps = this.googleStats.values().toArray(new CountedEntry[0]);
            Arrays.sort(ps, new CountedEntryComparator());
            i = 0;
            while (i < ps.length) {
                CountedEntry ce = ps[i];
                result.append(ce);
                result.append("\n");
                ++i;
            }
        }
        return result.toString();
    }

    public String getTotalOccurences() {
        return String.valueOf(this.nrOcc);
    }

    public static boolean isSearchEngineStats(String filterType) {
        return filterType.equals("REF");
    }

    public static void main(String[] args) {
        try {
            File file;
            int nrArgs = args.length;
            if (nrArgs == 0 || args[0] == null) {
                FHDetailHttpLogParser.showUsage();
            }
            if ((file = new File(args[0])) == null || !file.exists() || !file.canRead()) {
                FHDetailHttpLogParser.showUsage();
            }
            String filterType = null;
            String[] filterArgs = null;
            if (nrArgs > 1) {
                filterType = args[1].toUpperCase();
                filterArgs = new String[nrArgs - 2];
                int i = 0;
                while (i < nrArgs - 2) {
                    filterArgs[i] = args[i + 2];
                    ++i;
                }
            }
            FHDetailHttpLogParser runner = new FHDetailHttpLogParser();
            runner.readFile(file, filterType, filterArgs);
            runner.displayStats(filterType);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null) {
                System.err.println(e.getMessage());
            }
            e.printStackTrace();
        }
    }

    public void readFile(File file, String filterType, String[] filter) throws InvalidLogEntryException {
        Reader rd = null;
        try {
            try {
                if (file.getName().endsWith(".gz")) {
                    FileInputStream fis = new FileInputStream(file);
                    GZIPInputStream zis = new GZIPInputStream(fis);
                    rd = new InputStreamReader(zis);
                } else {
                    rd = new FileReader(file);
                }
                BufferedReader br = new BufferedReader(rd);
                int counter = 0;
                boolean finished = false;
                String line = null;
                String browser = null;
                boolean isSearchEngineStats = filterType.equals("REF");
                while (!finished) {
                    line = br.readLine();
                    if (line == null) {
                        finished = true;
                        continue;
                    }
                    ++counter;
                    LogEntry logEntry = new LogEntry();
                    browser = LogEntry.parseLine(line, logEntry);
                    if (!logEntry.matches(filterType, filter)) continue;
                    ++this.nrRealPageOcc;
                    this.adjustBrowserStats(browser);
                    if (isSearchEngineStats) {
                        this.adjustSearchEngineStats(logEntry);
                    } else {
                        this.adjustPageStats(logEntry);
                    }
                    this.adjustForSingleIP(logEntry);
                    this.adjustDate(logEntry);
                }
                this.nrOcc = counter;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                if (e instanceof InvalidLogEntryException) {
                    throw (InvalidLogEntryException)e;
                }
                throw new InvalidLogEntryException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                rd.close();
            }
            catch (Exception e) {
                System.err.println("Couldn't close file: " + e.toString());
            }
            throw throwable;
        }
        Object var12_17 = null;
        try {
            rd.close();
        }
        catch (Exception e) {
            System.err.println("Couldn't close file: " + e.toString());
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java de.hawlitzek.logparser.FHDetailHttpLogParser <file> [<filter>]");
        System.out.println("<filter>: [ALL | MAIN | HTML | IMG | REF] (filterString)*");
        System.out.println("version 1.2.1");
        System.exit(1);
    }
}

