/*
 * Decompiled with CFR 0.152.
 */
package de.hawlitzek.logparser;

import de.hawlitzek.logparser.BrowserEntry;
import de.hawlitzek.logparser.InvalidLogEntryException;
import de.hawlitzek.logparser.LogEntry;
import de.hawlitzek.util.text.CountedEntryComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class FHBrowserAnalyzingHttpLogParser {
    public static final String VERSION = "1.0.3";
    private SortedMap stats = new TreeMap();
    private int nrOcc = 0;

    private void displayStats() {
        System.out.println("All access count: " + this.nrOcc + "\n");
        System.out.println("browser statistics (in alphabetic order):\n");
        Iterator it = this.stats.values().iterator();
        while (it.hasNext()) {
            BrowserEntry be = (BrowserEntry)it.next();
            be.calcNrOccurencesRelative(this.nrOcc);
            System.out.println(be);
        }
        System.out.println("\nbrowser statistics (per frequency):\n");
        BrowserEntry[] hs = this.stats.values().toArray(new BrowserEntry[0]);
        Arrays.sort(hs, new CountedEntryComparator());
        int i = 0;
        while (i < hs.length) {
            BrowserEntry be = hs[i];
            System.out.println(be);
            ++i;
        }
    }

    public static void main(String[] args) {
        File file;
        if (args.length == 0 || args[0] == null) {
            FHBrowserAnalyzingHttpLogParser.showUsage();
        }
        if ((file = new File(args[0])) == null || !file.exists() || !file.canRead()) {
            FHBrowserAnalyzingHttpLogParser.showUsage();
        }
        FHBrowserAnalyzingHttpLogParser runner = new FHBrowserAnalyzingHttpLogParser();
        runner.readFile(file);
        runner.displayStats();
    }

    public void readFile(File file) {
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            int counter = 0;
            boolean finished = false;
            String line = null;
            String browser = null;
            while (!finished) {
                line = br.readLine();
                if (line == null) {
                    finished = true;
                    continue;
                }
                ++counter;
                browser = LogEntry.parseLine(line);
                if (this.stats.containsKey(browser)) {
                    BrowserEntry entry = (BrowserEntry)this.stats.get(browser);
                    entry.addAnzVorkommen();
                    continue;
                }
                BrowserEntry be = new BrowserEntry(browser);
                this.stats.put(browser, be);
            }
            this.nrOcc = counter;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidLogEntryException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java de.hawlitzek.logparser.FHBrowserAnalyzingHttpLogParser <file>");
        System.out.println("version 1.0.3");
        System.exit(1);
    }
}

