/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ui.CommProgressWindow;
import net.ibm.malamut.newsmail.ui.GroupsListener;
import net.ibm.malamut.newsmail.ui.Shell;

public final class CommThread
extends Thread {
    private static final int CcontactAllServers1 = 0;
    private static final int CcontactAllServers3 = 1;
    private static final int CcontactServer1 = 2;
    private static final int CcontactServer3 = 3;
    private static final int CgetGroupList = 4;
    private static final int CupdateGroupList = 5;
    private static final int CstartServer = 6;
    private static final int CstopServer = 7;
    private static final int CeditGroups = 8;
    private Shell argShell;
    private CommProgressWindow argProgress;
    private String argServer;
    private int argServerType;
    private Basis argBasis;
    private GroupsListener argGl;
    private boolean ready = false;
    private boolean startup = true;
    private Object readyMonitor = new Object();
    private int command;

    public void contactAllServers(Shell shell) {
        this.argShell = shell;
        this.execute(0);
    }

    public void contactAllServers(Shell shell, int n, CommProgressWindow commProgressWindow) {
        this.argShell = shell;
        this.argServerType = n;
        this.argProgress = commProgressWindow;
        this.execute(1);
    }

    public void contactServer(Shell shell) {
        this.argShell = shell;
        this.execute(2);
    }

    public void contactServer(Shell shell, int n, CommProgressWindow commProgressWindow) {
        this.argShell = shell;
        this.argServerType = n;
        this.argProgress = commProgressWindow;
        this.execute(3);
    }

    public void editGroups(Shell shell) {
        this.argShell = shell;
        this.execute(8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(int n) {
        Object object = this.readyMonitor;
        synchronized (object) {
            block7: {
                while (true) {
                    if (!this.startup) {
                        if (!this.ready) break;
                        this.command = n;
                        this.ready = false;
                        this.readyMonitor.notifyAll();
                        break block7;
                    }
                    try {
                        this.readyMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                Throwable throwable = new Throwable();
                Shell.error("Internal Error", "CommThread: attempted to queue tasks", throwable);
            }
            return;
        }
    }

    public void getGroupList(GroupsListener groupsListener, Shell shell, String string) {
        this.argGl = groupsListener;
        this.argShell = shell;
        this.argBasis = shell.basis();
        this.argServer = string;
        this.execute(4);
    }

    public boolean ready() {
        Object object = this.readyMonitor;
        synchronized (object) {
            boolean bl = this.startup || this.ready;
            Object var2_3 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object = this.readyMonitor;
        synchronized (object) {
            this.startup = false;
            this.ready = true;
            this.readyMonitor.notifyAll();
        }
        while (true) {
            object = this.readyMonitor;
            synchronized (object) {
                while (this.ready) {
                    try {
                        this.readyMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            switch (this.command) {
                case 8: {
                    this.argShell.editGroups();
                    break;
                }
                case 6: {
                    this.argShell.startServer(this.argServerType, true);
                    break;
                }
                case 7: {
                    this.argShell.stopServer(this.argServerType);
                    break;
                }
                case 0: {
                    this.argShell.contactAllServers();
                    break;
                }
                case 1: {
                    this.argShell.contactAllServers(this.argServerType, this.argProgress);
                    break;
                }
                case 2: {
                    this.argShell.contactServer();
                    break;
                }
                case 3: {
                    this.argShell.contactServer(this.argServerType, this.argProgress);
                    break;
                }
                case 4: {
                    try {
                        this.argBasis.getGroupList(this.argShell, this.argServer);
                    }
                    catch (IOException iOException) {
                        Shell.error("Retrieving Newsgroup List", "An error occurred retrieving the newsgroup list", iOException);
                    }
                    this.argGl.actionPerformed(new ActionEvent(this, 1001, "ListRetrieved"));
                    break;
                }
                case 5: {
                    try {
                        this.argBasis.updateGroupList(this.argShell, this.argServer);
                    }
                    catch (IOException iOException) {
                        Shell.error("Updating Newsgroup List", "An error occurred retrieving list of new newsgroups", iOException);
                    }
                    this.argGl.actionPerformed(new ActionEvent(this, 1001, "ListRetrieved"));
                    break;
                }
            }
            object = this.readyMonitor;
            synchronized (object) {
                this.ready = true;
            }
        }
    }

    public void startServer(Shell shell, int n) {
        this.argShell = shell;
        this.argServerType = n;
        this.execute(6);
    }

    public void stopServer(Shell shell, int n) {
        this.argShell = shell;
        this.argServerType = n;
        this.execute(7);
    }

    public void updateGroupList(GroupsListener groupsListener, Shell shell, String string) {
        this.argGl = groupsListener;
        this.argShell = shell;
        this.argBasis = shell.basis();
        this.argServer = string;
        this.execute(5);
    }

    public CommThread() {
        this.start();
    }
}

