/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.ConnectionInterruptor;
import net.ibm.malamut.newsmail.TidyUpData;
import net.ibm.malamut.newsmail.WindowData;
import net.ibm.malamut.newsmail.ui.CleanUpStatisticsListener;
import net.ibm.malamut.newsmail.ui.ProgressBarPanel;
import net.ibm.malamut.newsmail.ui.ProgressCancelListener;
import net.ibm.malamut.newsmail.ui.Shell;
import net.ibm.malamut.newsmail.ui.WindowDataDefaultInterface;
import net.ibm.malamut.newsmail.ui.WindowDataDialog;

public final class CleanUpStatistics
implements ConnectionInterruptor {
    public static final int STATISTICS = 0;
    public static final int EXPIRE = 1;
    public static final int REORGANIZE = 2;
    private JPanel statisticsPanel;
    private JDialog statisticsDialog;
    private JLabel sizeBefore;
    private JLabel sizeSlash;
    private JLabel sizeAfter;
    private JLabel validBefore;
    private JLabel validSlash;
    private JLabel validAfter;
    private JLabel received;
    private JLabel smtpBefore;
    private JLabel smtpSlash;
    private JLabel smtpAfter;
    private JLabel popBefore;
    private JLabel popSlash;
    private JLabel popAfter;
    private JLabel groupsBefore;
    private JLabel groupsSlash;
    private JLabel groupsAfter;
    private JLabel expired;
    private JLabel orphans;
    private JLabel unavailable;
    private JLabel errors;
    private JLabel ppSizeBefore;
    private JLabel ppSizeSlash;
    private JLabel ppSizeAfter;
    private JLabel ppValidBefore;
    private JLabel ppValidSlash;
    private JLabel ppValidAfter;
    private JLabel ppOrphans;
    private JLabel ppUnavailable;
    private ProgressBarPanel progress;
    private JButton close;
    private Basis basis;
    private Frame frame;
    private boolean abort = false;
    private Object abortLock = new Object();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void action(int n, Vector vector, Date date, File file) {
        Object object;
        int n2 = 1;
        switch (n) {
            case 0: {
                n2 = 17;
                break;
            }
            case 1: {
                n2 = 19;
                break;
            }
            case 2: {
                n2 = 22;
                break;
            }
        }
        this.progress.setArea(0, n2 + 1);
        this.progress.setValue(1);
        this.progress.setText("Scanning database...");
        this.progress.enableButton(true);
        Object object2 = this.abortLock;
        synchronized (object2) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l = this.basis.repository().databaseSize();
        this.setSize(l, false);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        Object object3 = this.abortLock;
        synchronized (object3) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l2 = this.basis.prepack().databaseSize();
        this.setppSize(l2, false);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        Object object4 = this.abortLock;
        synchronized (object4) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l3 = this.basis.repository().numberOfMails();
        this.setValid(l3, false);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        Object object5 = this.abortLock;
        synchronized (object5) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l4 = this.basis.prepack().numberOfMails();
        this.setppValid(l4, false);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        Object object6 = this.abortLock;
        synchronized (object6) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        this.setReceived(this.basis.getLastArticleFile());
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        object6 = this.abortLock;
        synchronized (object6) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l5 = this.basis.getNumberOfSMTPMails();
        this.setSMTP(l5, false);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        Object object7 = this.abortLock;
        synchronized (object7) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l6 = this.basis.getNumberOfPOPMails();
        this.setPOP(l6, false);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        Object object8 = this.abortLock;
        synchronized (object8) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l7 = this.basis.getNumberOfArticles();
        this.setGroups(l7, false);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        this.progress.setText("Scanning expired articles...");
        Object object9 = this.abortLock;
        synchronized (object9) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        object9 = this.basis.getExpired(vector, date);
        this.setExpired(((Vector)object9).size());
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        this.progress.setText("Preparing new Packets...");
        Object object10 = this.abortLock;
        synchronized (object10) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        this.basis.gates().prepack();
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        this.progress.setText("Examining database consistence...");
        object10 = this.abortLock;
        synchronized (object10) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        object10 = this.basis.tidyUp(file);
        this.setOrphans(((TidyUpData)object10).orphaned);
        this.setUnavailable(((TidyUpData)object10).unavailable);
        this.setErrors(((TidyUpData)object10).errors);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        Object object11 = this.abortLock;
        synchronized (object11) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        object10 = this.basis.tidyUpPrepack(file);
        this.setppOrphans(((TidyUpData)object10).orphaned);
        this.setppUnavailable(((TidyUpData)object10).unavailable);
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        this.progress.setText("Updating statistics...");
        object11 = this.abortLock;
        synchronized (object11) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        long l8 = this.basis.repository().numberOfMails();
        if (l8 < l3) {
            l3 = l8;
            this.setValid(l8, true);
        }
        if ((l8 = this.basis.prepack().databaseSize()) < l2) {
            l2 = l8;
            this.setppSize(l8, true);
        }
        if ((l8 = (long)this.basis.prepack().numberOfMails()) < l4) {
            l4 = l8;
            this.setppValid(l8, true);
        }
        if ((l8 = (long)this.basis.getNumberOfSMTPMails()) < l5) {
            l5 = l8;
            this.setSMTP(l8, true);
        }
        if ((l8 = (long)this.basis.getNumberOfPOPMails()) < l6) {
            l6 = l8;
            this.setPOP(l8, true);
        }
        if ((l8 = (long)this.basis.getNumberOfArticles()) < l7) {
            l7 = l8;
            this.setGroups(l8, true);
        }
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        if (n > 0) {
            this.progress.setText("Deleting expired articles...");
            int n3 = 0;
            while (n3 < ((Vector)object9).size()) {
                Object object12 = this.abortLock;
                synchronized (object12) {
                    if (this.abort) {
                        this.statisticsDialog.dispose();
                        return;
                    }
                }
                object12 = (String)((Vector)object9).elementAt(n3);
                this.basis.repository().backup(this.basis.getFileFromMsgid((String)object12), file);
                this.basis.removeArticle((String)object12);
                ++n3;
            }
            this.progress.increase();
            ((Component)this.statisticsDialog).setVisible(true);
            this.progress.setText("Updating statistics...");
            object = this.abortLock;
            synchronized (object) {
                if (this.abort) {
                    this.statisticsDialog.dispose();
                    return;
                }
            }
            l8 = this.basis.repository().numberOfMails();
            if (l8 < l3) {
                l3 = l8;
                this.setValid(l8, true);
            }
            if ((l8 = (long)this.basis.getNumberOfArticles()) < l7) {
                l7 = l8;
                this.setGroups(l8, true);
            }
            this.progress.increase();
            ((Component)this.statisticsDialog).setVisible(true);
            if (n > 1) {
                this.progress.setText("Compressing database...");
                object = this.abortLock;
                synchronized (object) {
                    if (this.abort) {
                        this.statisticsDialog.dispose();
                        return;
                    }
                }
                this.basis.repository().compress();
                this.progress.increase();
                ((Component)this.statisticsDialog).setVisible(true);
                object = this.abortLock;
                synchronized (object) {
                    if (this.abort) {
                        this.statisticsDialog.dispose();
                        return;
                    }
                }
                this.basis.prepack().compress();
                this.progress.increase();
                ((Component)this.statisticsDialog).setVisible(true);
                this.progress.setText("Updating statistics...");
                object = this.abortLock;
                synchronized (object) {
                    if (this.abort) {
                        this.statisticsDialog.dispose();
                        return;
                    }
                }
                l8 = this.basis.repository().databaseSize();
                if (l8 < l) {
                    l = l8;
                    this.setSize(l8, true);
                }
                if ((l8 = this.basis.prepack().databaseSize()) < l2) {
                    l2 = l8;
                    this.setppSize(l8, true);
                }
                this.progress.increase();
                ((Component)this.statisticsDialog).setVisible(true);
            }
        }
        this.progress.setText("Updating statistics...");
        object = this.abortLock;
        synchronized (object) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        l8 = this.basis.prepack().databaseSize();
        if (l8 != l2) {
            l2 = l8;
            this.setppSize(l8, true);
        }
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        this.progress.setText("Adjust newsgroup pointers...");
        object = this.abortLock;
        synchronized (object) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        this.basis.groups().adjustPointers();
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        this.progress.setText("Saving database...");
        object = this.abortLock;
        synchronized (object) {
            if (this.abort) {
                this.statisticsDialog.dispose();
                return;
            }
        }
        try {
            this.basis.relax(true, true);
        }
        catch (IOException iOException) {
            Shell.error("Internal error", "An error occurred trying to save the database", iOException);
        }
        this.progress.increase();
        ((Component)this.statisticsDialog).setVisible(true);
        this.progress.setText("Finished!");
        this.progress.enableButton(false);
        this.progress.increase();
        this.statisticsDialog.setDefaultCloseOperation(2);
        this.close.setEnabled(true);
        ((Component)this.statisticsDialog).setVisible(true);
    }

    public void interruptTransfer(int n) {
        this.progress.setCancelText();
        Object object = this.abortLock;
        synchronized (object) {
            this.abort = true;
        }
    }

    private final JPanel makeBeforeAfter(JLabel jLabel, JLabel jLabel2, JLabel jLabel3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jLabel.setAlignmentX(1.0f);
        jPanel.add(jLabel);
        jLabel2.setAlignmentX(0.5f);
        jPanel.add(jLabel2);
        jLabel3.setAlignmentX(0.0f);
        jPanel.add(jLabel3);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private final JPanel makeSingle(JLabel jLabel) {
        return this.makeBeforeAfter(jLabel, new JLabel(" "), new JLabel(" "));
    }

    private final void setErrors(long l) {
        this.errors.setText(Long.toString(l));
        this.errors.invalidate();
        this.errors.validate();
        this.errors.repaint();
    }

    private final void setExpired(long l) {
        this.expired.setText(Long.toString(l));
        this.expired.invalidate();
        this.expired.validate();
        this.expired.repaint();
    }

    private final void setGroups(long l, boolean bl) {
        this.setThree(this.groupsBefore, this.groupsSlash, this.groupsAfter, l, bl);
    }

    private final void setOrphans(long l) {
        this.orphans.setText(Long.toString(l));
        this.orphans.invalidate();
        this.orphans.validate();
        this.orphans.repaint();
    }

    private final void setPOP(long l, boolean bl) {
        this.setThree(this.popBefore, this.popSlash, this.popAfter, l, bl);
    }

    private final void setppOrphans(long l) {
        this.ppOrphans.setText(Long.toString(l));
        this.ppOrphans.invalidate();
        this.ppOrphans.validate();
        this.ppOrphans.repaint();
    }

    private final void setppSize(long l, boolean bl) {
        this.setThree(this.ppSizeBefore, this.ppSizeSlash, this.ppSizeAfter, Long.toString(l / 1024L) + "k", bl);
    }

    private final void setppUnavailable(long l) {
        this.ppUnavailable.setText(Long.toString(l));
        this.ppUnavailable.invalidate();
        this.ppUnavailable.validate();
        this.ppUnavailable.repaint();
    }

    private final void setppValid(long l, boolean bl) {
        this.setThree(this.ppValidBefore, this.ppValidSlash, this.ppValidAfter, l, bl);
    }

    private final void setReceived(long l) {
        this.received.setText(Long.toString(l));
        this.received.invalidate();
        this.received.validate();
        this.received.repaint();
    }

    private final void setSize(long l, boolean bl) {
        this.setThree(this.sizeBefore, this.sizeSlash, this.sizeAfter, Long.toString(l / 1024L) + "k", bl);
    }

    private final void setSMTP(long l, boolean bl) {
        this.setThree(this.smtpBefore, this.smtpSlash, this.smtpAfter, l, bl);
    }

    private final void setThree(JLabel jLabel, JLabel jLabel2, JLabel jLabel3, long l, boolean bl) {
        this.setThree(jLabel, jLabel2, jLabel3, Long.toString(l), bl);
    }

    private final void setThree(JLabel jLabel, JLabel jLabel2, JLabel jLabel3, String string, boolean bl) {
        if (bl) {
            if (!jLabel2.getText().equals("/")) {
                jLabel2.setText("/");
                jLabel2.invalidate();
                jLabel2.validate();
                jLabel2.repaint();
            }
            jLabel3.setText(string);
            jLabel3.invalidate();
            jLabel3.validate();
            jLabel3.repaint();
        } else {
            jLabel.setText(string);
            jLabel.invalidate();
            jLabel.validate();
            jLabel.repaint();
        }
    }

    private final void setUnavailable(long l) {
        this.unavailable.setText(Long.toString(l));
        this.unavailable.invalidate();
        this.unavailable.validate();
        this.unavailable.repaint();
    }

    private final void setValid(long l, boolean bl) {
        this.setThree(this.validBefore, this.validSlash, this.validAfter, l, bl);
    }

    public CleanUpStatistics(Frame frame, Basis basis) {
        this.frame = frame;
        this.basis = basis;
        this.statisticsPanel = new JPanel();
        this.statisticsPanel.setLayout(new BoxLayout(this.statisticsPanel, 1));
        WindowData windowData = basis.getWindowData("CLEANUPSTATISTICS");
        this.statisticsDialog = new WindowDataDialog(frame, "Database Statistics", windowData, new WindowDataDefaultInterface());
        this.statisticsDialog.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new GridLayout(14, 2, 4, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder("Statistics"));
        this.progress = new ProgressBarPanel("Progress", "Starting Scan...", new ProgressCancelListener(this), 0);
        jPanel.add(new JLabel("Main Database Size"));
        this.sizeBefore = new JLabel(" ");
        this.sizeSlash = new JLabel(" ");
        this.sizeAfter = new JLabel(" ");
        jPanel.add(this.makeBeforeAfter(this.sizeBefore, this.sizeSlash, this.sizeAfter));
        jPanel.add(new JLabel("Packet Database Size"));
        this.ppSizeBefore = new JLabel(" ");
        this.ppSizeSlash = new JLabel(" ");
        this.ppSizeAfter = new JLabel(" ");
        jPanel.add(this.makeBeforeAfter(this.ppSizeBefore, this.ppSizeSlash, this.ppSizeAfter));
        jPanel.add(new JLabel("Valid Mails"));
        this.validBefore = new JLabel(" ");
        this.validSlash = new JLabel(" ");
        this.validAfter = new JLabel(" ");
        jPanel.add(this.makeBeforeAfter(this.validBefore, this.validSlash, this.validAfter));
        jPanel.add(new JLabel("Valid Packets"));
        this.ppValidBefore = new JLabel(" ");
        this.ppValidSlash = new JLabel(" ");
        this.ppValidAfter = new JLabel(" ");
        jPanel.add(this.makeBeforeAfter(this.ppValidBefore, this.ppValidSlash, this.ppValidAfter));
        jPanel.add(new JLabel("Processed Mails"));
        this.received = new JLabel(" ");
        jPanel.add(this.makeSingle(this.received));
        jPanel.add(new JLabel("Emails waiting in SMTP Server"));
        this.smtpBefore = new JLabel(" ");
        this.smtpSlash = new JLabel(" ");
        this.smtpAfter = new JLabel(" ");
        jPanel.add(this.makeBeforeAfter(this.smtpBefore, this.smtpSlash, this.smtpAfter));
        jPanel.add(new JLabel("Emails waiting in POP Server"));
        this.popBefore = new JLabel(" ");
        this.popSlash = new JLabel(" ");
        this.popAfter = new JLabel(" ");
        jPanel.add(this.makeBeforeAfter(this.popBefore, this.popSlash, this.popAfter));
        jPanel.add(new JLabel("Articles in Newsgroups"));
        this.groupsBefore = new JLabel(" ");
        this.groupsSlash = new JLabel(" ");
        this.groupsAfter = new JLabel(" ");
        jPanel.add(this.makeBeforeAfter(this.groupsBefore, this.groupsSlash, this.groupsAfter));
        jPanel.add(new JLabel("Expired Articles"));
        this.expired = new JLabel(" ");
        jPanel.add(this.makeSingle(this.expired));
        jPanel.add(new JLabel("Orphaned Mails"));
        this.orphans = new JLabel(" ");
        jPanel.add(this.makeSingle(this.orphans));
        jPanel.add(new JLabel("Orphaned Packets"));
        this.ppOrphans = new JLabel(" ");
        jPanel.add(this.makeSingle(this.ppOrphans));
        jPanel.add(new JLabel("Unavailable Mails"));
        this.unavailable = new JLabel(" ");
        jPanel.add(this.makeSingle(this.unavailable));
        jPanel.add(new JLabel("Unavailable Packets"));
        this.ppUnavailable = new JLabel(" ");
        jPanel.add(this.makeSingle(this.ppUnavailable));
        jPanel.add(new JLabel("Database Errors"));
        this.errors = new JLabel(" ");
        jPanel.add(this.makeSingle(this.errors));
        JPanel jPanel2 = new JPanel();
        this.close = new JButton("Close");
        jPanel2.add(this.close);
        this.close.setEnabled(false);
        CleanUpStatisticsListener cleanUpStatisticsListener = new CleanUpStatisticsListener(this.statisticsDialog);
        this.close.addActionListener(cleanUpStatisticsListener);
        this.statisticsPanel.add(jPanel);
        this.statisticsPanel.add(Box.createVerticalStrut(3));
        this.statisticsPanel.add(this.progress);
        this.statisticsPanel.add(Box.createVerticalStrut(3));
        this.statisticsPanel.add(jPanel2);
        this.statisticsDialog.getContentPane().add(this.statisticsPanel);
        this.statisticsDialog.getRootPane().setDefaultButton(this.close);
        if (windowData.size.width == 0) {
            this.statisticsDialog.pack();
        }
        this.statisticsDialog.show();
    }
}

