/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import net.ibm.malamut.newsmail.WindowData;
import net.ibm.malamut.newsmail.ui.CleanUpChoiceListener;
import net.ibm.malamut.newsmail.ui.CleanUpStatistics;
import net.ibm.malamut.newsmail.ui.CleanUpStatisticsThread;
import net.ibm.malamut.newsmail.ui.Shell;
import net.ibm.malamut.newsmail.ui.SortedListModel;
import net.ibm.malamut.newsmail.ui.WindowDataDialog;
import net.ibm.malamut.newsmail.ui.WindowDataInterface;

public final class CleanUpChoicePanel
extends JPanel
implements WindowDataInterface {
    private JRadioButton actionStatistics;
    private JRadioButton actionExpire;
    private JRadioButton actionComplete;
    private JRadioButton expireAll;
    private JRadioButton expireSome;
    private ButtonGroup action;
    private ButtonGroup expire;
    private Shell shell;
    private JTextField backupLocation;
    private JTextField expireTime;
    private JCheckBox backup;
    private JButton ok;
    private JButton cancel;
    private JList groups;
    private JDialog dialog;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void action() {
        File file = null;
        if (this.backup.isSelected()) {
            file = new File(this.backupLocation.getText());
            if (!file.isAbsolute()) {
                file = new File(this.shell.basis().dataDir() + this.backupLocation.getText());
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!file.isDirectory()) {
                Shell.info("Clean up", file.getAbsolutePath() + " is not a valid directory.");
                return;
            }
        }
        CleanUpStatistics cleanUpStatistics = new CleanUpStatistics(this.shell.frame(), this.shell.basis());
        Object[] objectArray = this.groups.getSelectedValues();
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        n = 0;
        if (this.actionStatistics.isSelected()) {
            n = 0;
        } else if (this.actionExpire.isSelected()) {
            n = 1;
        } else if (this.actionComplete.isSelected()) {
            n = 2;
        }
        Date date = null;
        if (this.expireSome.isSelected()) {
            Calendar calendar = Calendar.getInstance();
            int n2 = 0;
            try {
                n2 = Integer.parseInt(this.expireTime.getText());
            }
            catch (NumberFormatException numberFormatException) {
                vector = new Vector();
            }
            calendar.add(5, -n2);
            date = calendar.getTime();
        }
        new CleanUpStatisticsThread(cleanUpStatistics, n, vector, date, file);
        this.dialog.dispose();
    }

    public void close() {
        this.dialog.dispose();
    }

    public Hashtable windowExtraData() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ButtonModel buttonModel = this.action.getSelection();
        if (buttonModel == this.actionStatistics.getModel()) {
            hashtable.put("action", "statistics");
        } else if (buttonModel == this.actionExpire.getModel()) {
            hashtable.put("action", "expire");
        } else {
            hashtable.put("action", "complete");
        }
        buttonModel = this.expire.getSelection();
        if (buttonModel == this.actionStatistics.getModel()) {
            hashtable.put("expire", "all");
        } else {
            hashtable.put("expire", this.expireTime.getText());
        }
        if (this.backup.isSelected()) {
            hashtable.put("backup", this.backupLocation.getText());
        }
        hashtable.put("selected", this.groups.getSelectedValues());
        return hashtable;
    }

    public CleanUpChoicePanel(Shell shell) {
        WindowData windowData = shell.basis().getWindowData("CLEANUP");
        this.dialog = new WindowDataDialog((Frame)shell.frame(), "Clean up Database", windowData, this);
        this.shell = shell;
        this.setLayout(new BoxLayout(this, 1));
        CleanUpChoiceListener cleanUpChoiceListener = new CleanUpChoiceListener(this);
        this.ok = new JButton("Ok");
        JPanel jPanel = Shell.getOkCancelPanel(cleanUpChoiceListener, this.ok);
        jPanel.setAlignmentX(0.5f);
        this.action = new ButtonGroup();
        this.actionStatistics = new JRadioButton("Statistics only");
        this.action.add(this.actionStatistics);
        this.actionExpire = new JRadioButton("Remove expired mails");
        this.action.add(this.actionExpire);
        this.actionComplete = new JRadioButton("Full database reorganization");
        this.action.add(this.actionComplete);
        this.actionStatistics.setSelected(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Action"));
        jPanel2.add(this.actionStatistics);
        jPanel2.add(this.actionExpire);
        jPanel2.add(this.actionComplete);
        jPanel2.setAlignmentX(0.5f);
        Dimension dimension = jPanel2.getMaximumSize();
        dimension.width = Short.MAX_VALUE;
        jPanel2.setMaximumSize(dimension);
        this.expire = new ButtonGroup();
        this.expireAll = new JRadioButton("Remove all articles");
        this.expire.add(this.expireAll);
        this.expireSome = new JRadioButton("Remove Articles older than ");
        this.expire.add(this.expireSome);
        this.expireSome.setSelected(true);
        this.expireAll.setAlignmentX(0.0f);
        this.expireTime = new JTextField(3);
        this.expireTime.setText("14");
        dimension = this.expireTime.getMaximumSize();
        Dimension dimension2 = this.expireTime.getPreferredSize();
        dimension.height = dimension2.height;
        this.expireTime.setMaximumSize(dimension);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.expireSome);
        this.expireSome.setAlignmentY(0.5f);
        jPanel3.add(this.expireTime);
        jPanel3.add(new JLabel(" days"));
        jPanel3.setAlignmentX(0.0f);
        SortedListModel sortedListModel = new SortedListModel();
        sortedListModel.setContents(shell.basis().groups().groups());
        this.groups = new JList(sortedListModel.listModel());
        this.groups.setAlignmentX(0.0f);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setAlignmentX(0.5f);
        jPanel4.setBorder(BorderFactory.createTitledBorder("Expire"));
        JScrollPane jScrollPane = new JScrollPane(this.groups);
        jScrollPane.setAlignmentX(0.0f);
        jPanel4.add(jScrollPane);
        jPanel4.add(this.expireAll);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setBorder(BorderFactory.createTitledBorder("Backup"));
        this.backup = new JCheckBox("Copy removed messages to ");
        this.backup.setAlignmentY(0.5f);
        this.backup.setSelected(true);
        this.backupLocation = new JTextField(15);
        this.backupLocation.setText("old");
        dimension = this.backupLocation.getMaximumSize();
        dimension2 = this.backupLocation.getPreferredSize();
        dimension.height = dimension2.height;
        this.backupLocation.setMaximumSize(dimension);
        jPanel5.add(this.backup);
        jPanel5.add(this.backupLocation);
        this.add(jPanel2);
        this.add(Box.createVerticalStrut(3));
        this.add(jPanel4);
        this.add(Box.createVerticalStrut(3));
        this.add(jPanel5);
        this.add(Box.createVerticalStrut(3));
        this.add(jPanel);
        this.dialog.getRootPane().setDefaultButton(this.ok);
        if (windowData.data != null) {
            String string = (String)windowData.data.get("action");
            if ("statistics".equals(string)) {
                this.actionStatistics.setSelected(true);
            } else if ("expire".equals(string)) {
                this.actionExpire.setSelected(true);
            } else if ("complete".equals(string)) {
                this.actionComplete.setSelected(true);
            }
            string = (String)windowData.data.get("expire");
            if ("all".equals(string)) {
                this.expireAll.setSelected(true);
            } else if (string != null) {
                this.expireSome.setSelected(true);
                this.expireTime.setText(string);
            }
            string = (String)windowData.data.get("backup");
            if (string == null) {
                this.backup.setSelected(false);
            } else {
                this.backupLocation.setText(string);
                this.backup.setSelected(true);
            }
            Object[] objectArray = (Object[])windowData.data.get("selected");
            if (objectArray != null) {
                ListModel listModel = this.groups.getModel();
                int n = 0;
                while (n < listModel.getSize()) {
                    Object e = listModel.getElementAt(n);
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        if (e.equals(objectArray[n2])) {
                            this.groups.addSelectionInterval(n, n);
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        this.dialog.getContentPane().add(this);
        if (windowData.size.width == 0) {
            this.dialog.pack();
        }
        this.dialog.show();
    }
}

