/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.ibm.malamut.newsmail.ui.ServerPanel;
import net.ibm.malamut.newsmail.ui.Shell;

public final class AddServerListener
implements ActionListener {
    private JDialog dialog;
    private JTextField title;
    private JTextField name;
    private JTextField className;
    private JRadioButton zConnect;
    private Shell shell;
    private ServerPanel serverPanel;
    private boolean gateway = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            String string2;
            String string3;
            String string4;
            block20: {
                string4 = this.name.getText();
                string3 = this.title.getText();
                if (!this.gateway && "".equals(string4)) {
                    Shell.info("Add Server", "Please enter a server name");
                    return;
                }
                string2 = null;
                if (this.gateway) {
                    string2 = this.zConnect.isSelected() ? "net.ibm.malamut.newsmail.gateways.JanusGate" : this.className.getText();
                    if (string3.equals("")) {
                        Shell.info("Add Server", "Please enter a gateway title");
                        return;
                    }
                    Class<?> clazz = null;
                    Class<?> clazz2 = null;
                    try {
                        clazz2 = Class.forName("net.ibm.malamut.newsmail.gateways.Gateway");
                        clazz = Class.forName(string2);
                        if (!clazz2.isAssignableFrom(clazz) && !Shell.question("Gateway unimplemented", "The Class '" + string2 + "' does not implement the Gateway interface.\nAre you sure you want to define a gateway by this Class?")) {
                            return;
                        }
                        break block20;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!Shell.question("Class unknown", "The Class '" + string2 + "' is unknown to the system.\nAre you sure you want to define a gateway by this Class?")) {
                            return;
                        }
                        break block20;
                    }
                }
                if (string3.equals("")) {
                    string3 = string4;
                }
            }
            try {
                switch (this.serverPanel.type()) {
                    case 1: {
                        this.shell.basis().createNewsserver(string4, string3);
                        break;
                    }
                    case 2: {
                        this.shell.basis().createPOPServer(string4, string3);
                        break;
                    }
                    case 3: {
                        this.shell.basis().createSMTPServer(string4, string3);
                        break;
                    }
                    case 4: {
                        this.shell.basis().createGateway(string3, string2);
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                Shell.error("Add Server", "Couldn't create server", iOException);
            }
            this.dialog.dispose();
            this.serverPanel.updateList();
            return;
        }
        if (string.equals("Cancel")) {
            this.dialog.dispose();
            return;
        }
        if (!string.startsWith("ZConnect")) {
            if (!string.startsWith("Other")) return;
        }
        if (this.zConnect.isSelected()) {
            this.className.setEnabled(false);
            return;
        }
        this.className.setEnabled(true);
    }

    public void init(Shell shell, JDialog jDialog, JTextField jTextField, JTextField jTextField2, ServerPanel serverPanel) {
        this.shell = shell;
        this.dialog = jDialog;
        this.title = jTextField;
        this.name = jTextField2;
        this.serverPanel = serverPanel;
    }

    public void init(Shell shell, JDialog jDialog, JTextField jTextField, JTextField jTextField2, ServerPanel serverPanel, JTextField jTextField3, JRadioButton jRadioButton) {
        this.shell = shell;
        this.dialog = jDialog;
        this.title = jTextField;
        this.name = jTextField2;
        this.serverPanel = serverPanel;
        this.className = jTextField3;
        this.zConnect = jRadioButton;
        this.gateway = true;
    }
}

