/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.ibm.malamut.newsmail.POPUserData;
import net.ibm.malamut.newsmail.database.PopUserBase;
import net.ibm.malamut.newsmail.ui.AddPOPUserListener;
import net.ibm.malamut.newsmail.ui.AdminPOPUserPanel;
import net.ibm.malamut.newsmail.ui.LabeledField;
import net.ibm.malamut.newsmail.ui.Shell;

public final class AddPOPUserPanel
extends JPanel {
    private JTextField localUser;
    private JTextField remoteUser;
    private JTextField email;
    private JPasswordField localPass;
    private JPasswordField remotePass;
    private JCheckBox remove;
    private JDialog dialog;
    private AdminPOPUserPanel parent;
    private boolean edit = false;
    private String oldName;

    public void add() {
        POPUserData pOPUserData = new POPUserData();
        String string = this.localUser.getText();
        pOPUserData.localPass = new String(this.localPass.getPassword());
        pOPUserData.remoteName = this.remoteUser.getText();
        pOPUserData.remotePass = new String(this.remotePass.getPassword());
        pOPUserData.removeFromServer = this.remove.isSelected();
        if (string.equals("") || pOPUserData.remoteName.equals("")) {
            Shell.info("Add a New User", "Please specify both user names!");
            return;
        }
        if (string.toLowerCase().equals("postmaster")) {
            Shell.info("Add a New User", "The postmaster user always exists and can't be added.");
            return;
        }
        pOPUserData.email = this.email.getText();
        if (pOPUserData.email.equals("")) {
            pOPUserData.email = null;
        }
        this.parent.add(string, pOPUserData);
        this.dialog.dispose();
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public void edit() {
        POPUserData pOPUserData = new POPUserData();
        String string = this.localUser.getText();
        pOPUserData.localPass = new String(this.localPass.getPassword());
        pOPUserData.remoteName = this.remoteUser.getText();
        pOPUserData.remotePass = new String(this.remotePass.getPassword());
        pOPUserData.removeFromServer = this.remove.isSelected();
        if (string.equals("") || pOPUserData.remoteName.equals("")) {
            Shell.info("Edit POP User", "Please specify both user names!");
            return;
        }
        if (string.toLowerCase().equals("postmaster")) {
            Shell.info("Add a New User", "The postmaster user can't be edited.");
            return;
        }
        pOPUserData.email = this.email.getText();
        if (pOPUserData.email.equals("")) {
            pOPUserData.email = null;
        }
        this.parent.edit(this.oldName, string, pOPUserData);
        this.dialog.dispose();
    }

    public JPanel innerPanel(String string, JTextField jTextField, JPasswordField jPasswordField) {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(new LabeledField("User Name:", jTextField));
        jPanel.add(new LabeledField("Password:", jPasswordField));
        return jPanel;
    }

    public AddPOPUserPanel(AdminPOPUserPanel adminPOPUserPanel, JDialog jDialog, JButton jButton) {
        this(adminPOPUserPanel, jDialog, jButton, null, null);
    }

    public AddPOPUserPanel(AdminPOPUserPanel adminPOPUserPanel, JDialog jDialog, JButton jButton, String string, PopUserBase popUserBase) {
        this.parent = adminPOPUserPanel;
        this.dialog = jDialog;
        this.localUser = new JTextField(20);
        this.localPass = new JPasswordField(20);
        this.remoteUser = new JTextField(20);
        this.remotePass = new JPasswordField(20);
        this.email = new JTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Email Address"));
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(this.email);
        jPanel.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(this.innerPanel("Local Server", this.localUser, this.localPass));
        this.add(Box.createVerticalGlue());
        this.add(this.innerPanel("Remote Server", this.remoteUser, this.remotePass));
        this.add(Box.createVerticalGlue());
        this.remove = new JCheckBox("Remove received mail from remote server");
        if (string != null) {
            this.edit = true;
            this.remove.setSelected(popUserBase.removeFromRemoteFor(string));
            this.oldName = string;
            this.localUser.setText(string);
            popUserBase.fillTextFields(string, this.remoteUser, this.localPass, this.remotePass, this.email);
        } else {
            this.remove.setSelected(true);
        }
        AddPOPUserListener addPOPUserListener = new AddPOPUserListener(this, this.edit);
        this.remove.setAlignmentX(0.0f);
        this.remove.addActionListener(addPOPUserListener);
        this.add(this.remove);
        this.add(Box.createVerticalGlue());
        this.add(jPanel);
        this.add(Box.createVerticalGlue());
        this.add(Shell.getOkCancelPanel(addPOPUserListener, jButton));
        this.add(Box.createVerticalGlue());
        jDialog.getRootPane().setDefaultButton(jButton);
    }
}

