/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.SMTPServerData;
import net.ibm.malamut.newsmail.database.GenericDatabase;

public final class SmtpServerBase
extends GenericDatabase {
    public void create(String string, String string2) {
        SMTPServerData sMTPServerData = new SMTPServerData();
        sMTPServerData.domains = null;
        sMTPServerData.title = string2;
        super.put(string, sMTPServerData);
    }

    public boolean exists(String string) {
        return this.containsKey(string);
    }

    private final SMTPServerData get(String string) {
        Object object = super.get(string);
        if (object instanceof SMTPServerData) {
            return (SMTPServerData)object;
        }
        this.error();
        return null;
    }

    public Vector getDomains(String string) {
        SMTPServerData sMTPServerData = this.get(string);
        if (sMTPServerData == null) {
            return null;
        }
        return sMTPServerData.domains;
    }

    public void newTitle(String string, String string2) {
        SMTPServerData sMTPServerData = this.get(string);
        if (sMTPServerData == null) {
            Basis.log("Internal error: Can't rename unknown server '" + string + "'.");
            return;
        }
        this.sync.startWrite();
        sMTPServerData.title = string2;
        this.sync.endWrite();
    }

    public void remove(String string) {
        super.remove(string);
    }

    public Vector servers() {
        Vector vector = new Vector();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof String) {
                vector.addElement(k);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    public void setDomains(String string, Vector vector) {
        SMTPServerData sMTPServerData = this.get(string);
        if (sMTPServerData == null) {
            Basis.log("Internal error: Can't set domains for unknown server '" + string + "'.");
            return;
        }
        this.sync.startWrite();
        sMTPServerData.domains = vector;
        this.sync.endWrite();
    }

    public String title(String string) {
        Object object = super.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof SMTPServerData) {
            return ((SMTPServerData)object).title;
        }
        this.error();
        return null;
    }

    public Vector titles() {
        Vector<String> vector = new Vector<String>();
        this.sync.startRead();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof SMTPServerData) {
                vector.addElement(((SMTPServerData)v).title);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    public SmtpServerBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

