/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.POPServerData;
import net.ibm.malamut.newsmail.database.GenericDatabase;
import net.ibm.malamut.newsmail.database.PopUserBase;

public final class PopServerBase
extends GenericDatabase {
    public void create(String string, String string2) {
        POPServerData pOPServerData = new POPServerData();
        pOPServerData.title = string2;
        super.put(string, pOPServerData);
    }

    public boolean exists(String string) {
        return this.containsKey(string);
    }

    public boolean existsUser(String string) {
        this.sync.startRead();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof POPServerData) {
                if (!((POPServerData)v).users.containsKey(string)) continue;
                this.sync.endRead();
                return true;
            }
            this.error();
        }
        this.sync.endRead();
        return false;
    }

    private final POPServerData get(String string) {
        Object object = super.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof POPServerData) {
            return (POPServerData)object;
        }
        this.error();
        return null;
    }

    public void newTitle(String string, String string2) {
        POPServerData pOPServerData = this.get(string);
        if (pOPServerData == null) {
            Basis.log("Internal error: Can't rename unknown server '" + string + "'.");
            return;
        }
        this.sync.startWrite();
        pOPServerData.title = string2;
        this.sync.endWrite();
    }

    public String password(String string) {
        Vector vector = this.servers();
        String string2 = null;
        this.sync.startRead();
        int n = 0;
        while (n < vector.size()) {
            PopUserBase popUserBase = this.users((String)vector.elementAt(n));
            if (popUserBase.exists(string)) {
                string2 = popUserBase.localPassword(string);
            }
            ++n;
        }
        this.sync.endRead();
        return string2;
    }

    public void remove(String string) {
        super.remove(string);
    }

    public Vector servers() {
        Vector vector = new Vector();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof String) {
                vector.addElement(k);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    public String title(String string) {
        Object object = super.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof POPServerData) {
            return ((POPServerData)object).title;
        }
        this.error();
        return null;
    }

    public Vector titles() {
        Vector<String> vector = new Vector<String>();
        this.sync.startRead();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof POPServerData) {
                vector.addElement(((POPServerData)v).title);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return vector;
    }

    public PopUserBase users(String string) {
        POPServerData pOPServerData = this.get(string);
        if (pOPServerData == null) {
            return null;
        }
        return new PopUserBase(this.basis, pOPServerData.users, "PopUsers-" + string, this.sync);
    }

    public PopServerBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

