/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.Connection;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.OutmailData;
import net.ibm.malamut.newsmail.TidyUpData;
import net.ibm.malamut.newsmail.database.GenericDatabase;
import net.ibm.malamut.newsmail.database.SmtpServerBase;
import net.ibm.malamut.newsmail.ui.CommProgressWindow;

public final class OutmailBase
extends GenericDatabase {
    public void add(OutmailData outmailData, long l) {
        super.put(outmailData, new Long(l));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putMails(CommProgressWindow commProgressWindow, Connection connection, String string) throws IOException {
        int n = 1;
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof OutmailData)) {
                this.error();
                continue;
            }
            OutmailData outmailData = (OutmailData)k;
            if (outmailData.server.equals(string)) {
                try {
                    Long l = (Long)this.data.get(outmailData);
                    this.basis.putMail(commProgressWindow, connection, outmailData, l, n);
                    this.remove(outmailData);
                    boolean bl = false;
                    Enumeration enumeration2 = this.data.elements();
                    while (enumeration2.hasMoreElements()) {
                        if (!l.equals(enumeration2.nextElement())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.basis.repository().delete(l);
                    }
                }
                catch (IOException iOException) {
                    this.sync.endRead();
                    throw new IOException("A problem occurred sending mail to server '" + string + "': " + ErrorTools.redirect(iOException));
                }
                commProgressWindow.server().setValue(++n);
            }
            if (connection.good()) continue;
            this.sync.endRead();
            throw new IOException("SMTP connection to server '" + string + "' broke down while sending mail.");
        }
        this.sync.endRead();
    }

    public void removeAllForServer(String string) {
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof OutmailData) {
                OutmailData outmailData = (OutmailData)k;
                if (!outmailData.server.equals(string)) continue;
                this.remove(outmailData);
                continue;
            }
            this.error();
        }
        this.sync.endRead();
    }

    public void tidyUp(SmtpServerBase smtpServerBase, Hashtable hashtable, TidyUpData tidyUpData) {
        Object object = new Object();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof OutmailData)) {
                this.remove(k);
                ++tidyUpData.errors;
                this.error();
                continue;
            }
            OutmailData outmailData = (OutmailData)k;
            if (smtpServerBase.exists(outmailData.server)) {
                Object v = this.data.get(outmailData);
                if (!(v instanceof Long)) {
                    this.remove(k);
                    ++tidyUpData.errors;
                    this.error();
                    continue;
                }
                Long l = (Long)v;
                if (this.basis.repository().exists(l)) {
                    hashtable.put(l, object);
                    continue;
                }
                this.remove(outmailData);
                ++tidyUpData.unavailable;
                continue;
            }
            this.remove(outmailData);
        }
        this.sync.endRead();
    }

    public OutmailBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

